package csbase.server.services.openbusservice;

import java.util.Date;

public class OpenbusStatus {

  public enum ConnectionState {
    NOT_INITIALIZED,
    CONNECTED,
    ACS_UNAVAILABLE,
    ACS_LOGIN_FAILURE,
    CERTIFICATE_INVALID,
    CREDENTIAL_ERROR,
    BASIC_SERVICE_UNAVAILABLE,
    UNKNOWN_ERROR,
    CORBA_ERROR,
    OPENBUS_ERROR,
    RS_UNAVAILABLE
  }

  private ConnectionState state;
  private Exception exception;
  private Date lastConnectionDate;

  public OpenbusStatus(ConnectionState state, Date lastConnectionDate) {
    this(state, null, lastConnectionDate);
  }

  public OpenbusStatus(ConnectionState state, Exception exception,
    Date lastConnectionDate) {
    this.state = state;
    this.exception = exception;
    this.lastConnectionDate = lastConnectionDate;
  }

  public ConnectionState getState() {
    return this.state;
  }

  public Exception getException() {
    return this.exception;
  }

  public Date getConnectionDate() {
    return this.lastConnectionDate;
  }
}
