package csbase.server.services.diagnosticservice.monitors.openbus;

import java.util.Locale;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Validao do estado da conexo com o barramento.
 */
public class ConnectionValidation implements Validation {
  /** Nome que identifica a validao */
  public static final String NAME = "ConnectionValidation";

  /**
   * {@inheritDoc}
   * 
   * Verifica se existe uma conexo com o barramento.
   */
  @Override
  public ValidationStatus check(Locale locale) {
    if (OpenBusService.getInstance().isConnected()) {
      return new ValidationStatus(StatusCode.OK, MessageTranslator.getString(
        "server.openbusmonitor.connection.success", locale));
    }
    return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString(
      "server.openbusmonitor.connection.error", locale), MessageTranslator
      .getDetailMessage(OpenBusService.getInstance().getOpenbusStatus()
        .getException(), locale));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String id() {
    return NAME;
  }

  /**
   * {@inheritDoc}
   * 
   * Depende do resultado da validao de {@link OpenbusServiceValidation}.
   */
  @Override
  public String[] requires() {
    return new String[] { OpenbusServiceValidation.NAME };
  }
}
