package csbase.server.services.diagnosticservice.monitors.openbus;

import java.util.Locale;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Validao do estado da execuo do servio CSBase OpenbusService.
 */
public class OpenbusServiceValidation implements Validation {
  /** Nome que identifica a validao */
  public static final String NAME = "OpenbusServiceAvailable";

  /**
   * {@inheritDoc}.
   * 
   * Verifica se o servio OpenBusService est habilitado.
   */
  @Override
  public ValidationStatus check(Locale locale) {
    if (OpenBusService.getInstance() != null
      && OpenBusService.getInstance().isEnabled()) {
      return new ValidationStatus(StatusCode.OK, MessageTranslator.getString(
        "server.openbusmonitor.openbusservice.enable", locale));
    }
    return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString(
      "server.openbusmonitor.openbusservice.disable", locale));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String id() {
    return NAME;
  }

  /**
   * {@inheritDoc}
   * 
   * Essa validao no possui dependncias.
   */
  @Override
  public String[] requires() {
    return null;
  }
}
