package csbase.server.services.sgaservice;

import csbase.exception.CSBaseException;

/**
 * Representa uma falha durante um procedimento de acesso a rea de dados do
 * projeto usado para submisso de um comando. Esse erro pode ocorrer se, entre
 * a submisso de comando e o escalonamento desse comando, o projeto houver sido
 * removido.
 * 
 * @author Tecgraf
 */
public class ProjectNotFoundException extends CSBaseException {
  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public ProjectNotFoundException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param message a descrio do erro
   */
  public ProjectNotFoundException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public ProjectNotFoundException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public ProjectNotFoundException(String message, Throwable exception) {
    super(message, exception);
  }
}
