package csbase.server.services.openbusservice;

import org.omg.PortableServer.Servant;

import scs.core.ComponentContext;

/**
 * Representa a faceta de uma oferta de servio para o OpenBus.
 * 
 * @author Tecgraf
 */
public class OpenBusServiceFacet {

  /**
   * Nome da faceta
   */
  String name;
  /**
   * Identificador da interface da faceta
   */
  String interfaceName;
  /**
   * Servant que implementa a interface da faceta
   */
  Servant servant;
  /**
   * Contexto do componente que publicou essa faceta. Somente  preechido aps o
   * componente ser registrado.
   */
  ComponentContext context;

  /**
   * Cria uma faceta com as informaes necessrias para o servio
   * OpenBusService registrar.
   * 
   * @param name nome da faceta
   * @param interfaceName identificador da interface da faceta
   * @param servant servant que implementa a interface da faceta
   */
  public OpenBusServiceFacet(String name, String interfaceName, Servant servant) {
    this.name = name;
    this.interfaceName = interfaceName;
    this.servant = servant;
  }

  /**
   * Atribui o contexto do componente que publicou a faceta.
   * 
   * @param context contexto do componente.
   */
  public void setComponentContext(ComponentContext context) {
    this.context = context;
  }
}
