/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.httpservice;

import csbase.exception.HttpServiceException;
import csbase.exception.InvalidRequestException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import csbase.remote.HttpServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.httpservice.UploadHandler;
import csbase.server.services.httpservice.UploadResult;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.projectservice.ProjectService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.URLEncoder;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.TreeMap;

public class HttpService
extends Service
implements HttpServiceInterface {
    private static final String UPLOAD = "upload";
    private static final String DOWNLOAD = "download";
    private static final String INVALID_REQUEST_MSG = "invalid_request_msg";
    private Map<String, RequestInfo> requestList = null;
    private String httpServiceURL = null;
    private Random numberGenerator;
    private Cleaner cleaner;
    private boolean shutdown;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public static void createService() throws ServerException {
        new HttpService();
    }

    protected HttpService() throws ServerException {
        super("HttpService");
        int port = Server.getInstance().getRMIExportPort();
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)this), port);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BindException) {
                throw new ServerException("Porta RMI " + port + " j\u00e1 em uso", e);
            }
        }
        catch (Exception e) {
            throw new ServerException("Falha na constru\u00e7\u00e3o de: HttpService", e);
        }
    }

    public String getDownloadURL(Object userId, String password, Object projectId, String[] filePath) throws RemoteException {
        User user = LoginService.getInstance().checkLogin((String)userId, password);
        if (user == null) {
            throw new RemoteException("Falha na autentica\u00e7\u00e3o do usu\u00e1rio.\nVerifique se a chave e a senha s\u00e3o v\u00e1lidos.");
        }
        return this.getURL(userId, projectId, filePath, null, DOWNLOAD, 1);
    }

    public String getUploadURL(Object userId, String password, Object projectId, String[] filePath, String fileType) throws RemoteException {
        User user = LoginService.getInstance().checkLogin((String)userId, password);
        if (user == null) {
            throw new RemoteException("Falha na autentica\u00e7\u00e3o do usu\u00e1rio.\nVerifique se a chave e a senha s\u00e3o v\u00e1lidos.");
        }
        try {
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(projectId, filePath)) {
                String pathStr = Arrays.toString(filePath);
                throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "Caminho " + pathStr + " n\u00e3o encontrado na \u00e1rvore do projeto.");
            }
            String[] dirPath = new String[filePath.length - 1];
            for (int i = 0; i < filePath.length - 1; ++i) {
                dirPath[i] = filePath[i];
            }
            String fileName = filePath[filePath.length - 1];
            ClientProjectFile cpf = projectService.getChild(projectId, dirPath, fileName);
            projectService.setUnderConstruction(projectId, filePath, true);
        }
        catch (InvalidRequestException e) {
            Server.logSevereMessage("Argumentos inv\u00e1lidos do cliente: (projectId=" + projectId + "), " + "(filePath=" + filePath + ")");
        }
        return this.getURL(userId, projectId, filePath, fileType, UPLOAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL(Object userId, Object projectId, String[] filePath, String fileType, String type, int downloadType) throws RemoteException {
        String path = this.filePathtoString(filePath);
        if (path == null) {
            String msg = "Path do arquivo invalido";
            Server.logSevereMessage(msg);
            throw new RemoteException(msg);
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.userId = userId;
        requestInfo.projectId = projectId;
        requestInfo.filePath = path;
        requestInfo.fileType = fileType;
        requestInfo.downloadType = downloadType;
        String accessCode = null;
        if (type.equals(DOWNLOAD)) {
            accessCode = this.findCode(userId, projectId, null);
        } else {
            accessCode = this.findCode(userId, projectId, path);
            requestInfo.uploadPresentationPath = this.getStringProperty("uploadPresentation");
            requestInfo.uploadResultPath = this.getStringProperty("uploadResult");
        }
        if (accessCode == null) {
            accessCode = "" + Math.abs(this.numberGenerator.nextLong());
            accessCode = accessCode + Math.abs(this.numberGenerator.nextLong());
        }
        requestInfo.whenDone = System.currentTimeMillis();
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            this.requestList.put(accessCode, requestInfo);
        }
        String url = type.equals(DOWNLOAD) ? this.httpServiceURL + "/" + type + "/" + accessCode + "/" + type + "/" + path : this.httpServiceURL + "/" + type + "/" + accessCode + "/" + type;
        Server.logInfoMessage("URL: " + url + " - filePath: " + requestInfo.filePath + " - user: " + userId);
        return url;
    }

    private String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (Exception e) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel codificar o texto: " + text);
            return null;
        }
    }

    private String getURL(Object userId, Object projectId, String[] filePath, String fileType, String type) throws RemoteException {
        return this.getURL(userId, projectId, filePath, fileType, type, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findCode(Object userId, Object projectId, String filePath) {
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            for (Map.Entry<String, RequestInfo> entry : this.requestList.entrySet()) {
                String accessCode = entry.getKey();
                RequestInfo requestInfo = entry.getValue();
                if (!userId.equals(requestInfo.userId) || !projectId.equals(requestInfo.projectId) || filePath != null && (filePath == null || !filePath.equals(requestInfo.filePath))) continue;
                return accessCode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileType(String accessCode, String filePath) throws RemoteException {
        Object[] path;
        RequestInfo requestInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            requestInfo = this.requestList.get(accessCode);
        }
        if (requestInfo == null) {
            return null;
        }
        String mimeType = "application/octet-stream";
        if (filePath == null) {
            path = requestInfo.filePath.split("/");
        } else {
            String auxPath = this.expandPath(filePath);
            if (auxPath == null) {
                return null;
            }
            path = auxPath.split("/");
        }
        if (requestInfo.projectId == null) {
            mimeType = this.getMimeTypeFromName(path[path.length - 1]);
        } else {
            try {
                ProjectService projectService = ProjectService.getInstance();
                if (!projectService.existsFile(requestInfo.projectId, (String[])path)) {
                    String pathStr = Arrays.toString(path);
                    throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "Caminho " + pathStr + " n\u00e3o encontrado na \u00e1rvore do servidor");
                }
                String[] dirPath = new String[path.length - 1];
                for (int i = 0; i < path.length - 1; ++i) {
                    dirPath[i] = path[i];
                }
                Object fileName = path[path.length - 1];
                ClientProjectFile cpf = projectService.getChild(requestInfo.projectId, dirPath, (String)fileName);
                String fileType = cpf.getType();
                mimeType = projectService.getMimeType(fileType);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha ao obter tipo do arquivo: " + requestInfo.filePath, e);
            }
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadType(String accessCode) throws RemoteException {
        RequestInfo requestInfo;
        if (accessCode == null) {
            return 0;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            requestInfo = this.requestList.get(accessCode);
        }
        if (requestInfo == null) {
            return 0;
        }
        return requestInfo.downloadType;
    }

    private String getMimeTypeFromName(String fileName) {
        int index = fileName.lastIndexOf(".");
        String fileExtention = null;
        if (index != -1) {
            fileExtention = fileName.substring(index + 1);
        }
        if (fileExtention == null) {
            return "application/zip";
        }
        if ((fileExtention = fileExtention.toLowerCase()).equals("doc")) {
            return "application/msword";
        }
        if (fileExtention.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        if (fileExtention.equals("pdf")) {
            return "application/pdf";
        }
        if (fileExtention.equals("txt")) {
            return "text/plain";
        }
        if (fileExtention.equals("log")) {
            return "text/plain";
        }
        if (fileExtention.equals("jpg")) {
            return "image/jpeg";
        }
        if (fileExtention.equals("gif")) {
            return "image/gif";
        }
        if (fileExtention.equals("tif")) {
            return "image/tiff";
        }
        if (fileExtention.equals("rob")) {
            return "text/plain";
        }
        if (fileExtention.equals("html")) {
            return "text/html";
        }
        return "application/zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFile(String accessCode, String fileName) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return false;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return false;
        }
        if (reqInfo.projectId == null) {
            if (this.createFileOutProject(reqInfo.filePath, fileName)) {
                reqInfo.filePath = reqInfo.filePath + File.separator + fileName;
                return true;
            }
            return false;
        }
        String[] dirPath = reqInfo.filePath.split("/");
        try {
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(reqInfo.projectId, dirPath)) {
                return false;
            }
            projectService.createFile(reqInfo.projectId, dirPath, fileName, reqInfo.fileType);
            String fPath = "";
            String[] filePath = new String[dirPath.length + 1];
            for (int i = 0; i < dirPath.length; ++i) {
                fPath = fPath + dirPath[i] + "/";
                filePath[i] = dirPath[i];
            }
            fPath = fPath + fileName;
            filePath[filePath.length - 1] = fileName;
            reqInfo.filePath = fPath;
            projectService.setUnderConstruction(reqInfo.projectId, filePath, true);
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha ao criar o arquivo para upload: " + fileName, e);
            return false;
        }
        return true;
    }

    private boolean createFileOutProject(String filePath, String fileName) {
        try {
            File file = new File(filePath + File.separator + fileName);
            if (file.exists()) {
                return true;
            }
            return file.createNewFile();
        }
        catch (Exception e) {
            Server.logSevereMessage("createFileOutProject: " + e.getMessage());
            return false;
        }
    }

    public String getFilePath(String accessCode) throws RemoteException {
        return this.getFilePath(accessCode, null);
    }

    private static String unixPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilePath(String accessCode, String filePath) throws RemoteException {
        Object[] path;
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        if (reqInfo.projectId == null) {
            return reqInfo.filePath;
        }
        if (filePath == null) {
            path = reqInfo.filePath.split("/");
        } else {
            String auxPath = this.expandPath(filePath);
            if (auxPath == null) {
                return null;
            }
            path = auxPath.split("/");
        }
        try {
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(reqInfo.projectId, (String[])path)) {
                String pathStr = Arrays.toString(path);
                throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "Caminho " + pathStr + " n\u00e3o encontrado na \u00e1rvore do servidor");
            }
            return HttpService.unixPath(projectService.getAbsolutePath(reqInfo.projectId, (String[])path));
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha obtencao do caminho do arquivo! (" + reqInfo.filePath + ") " + e);
            return null;
        }
    }

    private String expandPath(String path) {
        String newPath = path.replaceAll("//", "/");
        do {
            path = newPath;
            if ((newPath = newPath.replaceFirst("^/", "")).startsWith("../")) {
                return null;
            }
            newPath = newPath.replaceFirst("[^/]+/\\.\\.", "");
        } while (!(newPath = newPath.replaceFirst("//", "/")).equals(path));
        if (newPath.equals("..")) {
            return null;
        }
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPresentationPath(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        try {
            File presentationFile = new File(reqInfo.uploadPresentationPath);
            return HttpService.unixPath(presentationFile.getCanonicalPath());
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na obten\u00e7\u00e3o do caminho do arquivo: " + reqInfo.uploadPresentationPath);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultPath(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        try {
            File resultFile = new File(reqInfo.uploadResultPath);
            return HttpService.unixPath(resultFile.getCanonicalPath());
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na obten\u00e7\u00e3o do caminho do arquivo: " + reqInfo.uploadResultPath);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return false;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return false;
        }
        try {
            if (reqInfo.projectId == null) {
                File f = new File(reqInfo.filePath);
                return f.isDirectory();
            }
            Object[] path = reqInfo.filePath.split("/");
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(reqInfo.projectId, (String[])path)) {
                String pathStr = Arrays.toString(path);
                throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "Caminho " + pathStr + " n\u00e3o encontrado na \u00e1rvore do projeto.");
            }
            String[] dirPath = new String[path.length - 1];
            for (int i = 0; i < path.length - 1; ++i) {
                dirPath[i] = path[i];
            }
            Object fileName = path[path.length - 1];
            ClientProjectFile cpf = projectService.getChild(reqInfo.projectId, dirPath, (String)fileName);
            return cpf.isDirectory();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no metodo isDirectory do upload! (" + reqInfo.filePath + ") ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishUpload(String accessCode, String fileName) throws HttpServiceException {
        Object result;
        RequestInfo reqInfo;
        if (accessCode == null) {
            return false;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return false;
        }
        if (reqInfo.observer != null) {
            result = new UploadResult(accessCode, fileName, reqInfo.filePath);
            reqInfo.observer.update(observable, result);
        } else if (reqInfo.fileHandler != null) {
            reqInfo.fileHandler.execute(reqInfo.filePath);
        }
        if (reqInfo.projectId == null) {
            result = this.requestList;
            synchronized (result) {
                this.requestList.remove(accessCode);
            }
            return true;
        }
        Object[] path = reqInfo.filePath.split("/");
        try {
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(reqInfo.projectId, (String[])path)) {
                String pathStr = Arrays.toString(path);
                throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "Caminho " + pathStr + " n\u00e3o encontrado na \u00e1rvore do servidor");
            }
            String[] dirPath = new String[path.length - 1];
            for (int i = 0; i < path.length - 1; ++i) {
                dirPath[i] = path[i];
            }
            Object name = path[path.length - 1];
            ClientProjectFile cpf = projectService.getChild(reqInfo.projectId, dirPath, (String)name);
            projectService.setUnderConstruction(cpf.getProjectId(), cpf.getPath(), false);
            Map<String, RequestInfo> map2 = this.requestList;
            synchronized (map2) {
                this.requestList.remove(accessCode);
            }
            return true;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na finalizacao do upload! (" + path + ") ", e);
            return false;
        }
    }

    private String filePathtoString(String[] filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.length == 0) {
            return null;
        }
        String result = "";
        try {
            String pathEncoded;
            for (int i = 0; i < filePath.length - 1; ++i) {
                pathEncoded = URLEncoder.encode(filePath[i], "UTF-8");
                result = result + pathEncoded + "/";
            }
            pathEncoded = URLEncoder.encode(filePath[filePath.length - 1], "UTF-8");
            result = result + pathEncoded;
        }
        catch (UnsupportedEncodingException e) {
            Server.logSevereMessage("O caminho do arquivo nao pode ser codificado.");
            return null;
        }
        return result;
    }

    public String getFileDownloadURL(String filePath) throws RemoteException {
        return this.getURL(filePath, DOWNLOAD, null, null, 1, null, null, null, null, null, null, null);
    }

    public String getDownloadPDFReportURL(String filePath, Map parameters, String jdbcDriverClassName, String jdbcURL, String jdbcUser, String jdbcPassword) throws RemoteException {
        return this.getURL(filePath, DOWNLOAD, null, null, 4, null, parameters, jdbcDriverClassName, jdbcURL, jdbcUser, jdbcPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameters(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcDriverClassName(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.jdbcDriverClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcURL(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.jdbcURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcUser(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.jdbcUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcPassword(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.jdbcPassword;
    }

    public String getUploadURL(String filePath, String presentationPath, String resultPath) throws RemoteException {
        return this.getURL(filePath, UPLOAD, presentationPath, resultPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUploadURL(String filePath, String presentationPath, String resultPath, UploadHandler fileHandler) {
        if (filePath == null) {
            throw new IllegalArgumentException("O par\u00e2metro filePath est\u00e1 nulo.");
        }
        if (presentationPath == null) {
            throw new IllegalArgumentException("O par\u00e2metro presentationPath est\u00e1 nulo.");
        }
        if (resultPath == null) {
            throw new IllegalArgumentException("O par\u00e2metro resultPath est\u00e1 nulo.");
        }
        if (fileHandler == null) {
            throw new IllegalArgumentException("O par\u00e2metro fileHandler est\u00e1 nulo.");
        }
        if (this.httpServiceURL == null) {
            throw new IllegalStateException("O par\u00e2metro httpServiceURL est\u00e1 nulo.");
        }
        String accessCode = this.getAccessCode(filePath);
        if (accessCode == null) {
            accessCode = "" + Math.abs(this.numberGenerator.nextLong());
            accessCode = accessCode + Math.abs(this.numberGenerator.nextLong());
        }
        RequestInfo req = new RequestInfo();
        req.userId = Service.getUser();
        req.downloadType = 2;
        req.filePath = filePath;
        req.removeFile = true;
        req.uploadPresentationPath = presentationPath;
        req.uploadResultPath = resultPath;
        req.fileHandler = fileHandler;
        req.whenDone = System.currentTimeMillis();
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            this.requestList.put(accessCode, req);
        }
        String url = this.httpServiceURL + "/" + UPLOAD + "/" + accessCode + "/" + UPLOAD;
        return url;
    }

    public String getUploadURL(String filePath, String presentationPath, String resultPath, Observer obs) {
        return this.getURL(filePath, UPLOAD, presentationPath, resultPath, obs);
    }

    public String getDownloadURL(String filePath) throws RemoteException {
        return this.getURL(filePath, DOWNLOAD, (String)null, (String)null, null);
    }

    public String getDownloadURL(String filePath, Map<String, String> parameters) throws RemoteException {
        return this.getURL(filePath, DOWNLOAD, null, null, null, parameters);
    }

    public String getDownloadTextURL(Object userId, String password, String text) throws RemoteException {
        User user = LoginService.getInstance().checkLogin((String)userId, password);
        if (user == null) {
            throw new RemoteException("Falha na autentica\u00e7\u00e3o do usu\u00e1rio. \nVerifique se o login e a senha s\u00e3o v\u00e1lidos");
        }
        return this.getDownloadTextURL(text);
    }

    public String getDownloadTextURL(String text) throws RemoteException {
        String filePath = "/" + Math.abs(this.numberGenerator.nextLong()) + "/" + "TEXT.txt";
        return this.getURL(filePath, DOWNLOAD, null, null, 3, text, null, null, null, null, null, null);
    }

    public String getDownloadTextURL(Object userId, String password, String text, String fileName) throws RemoteException {
        User user = LoginService.getInstance().checkLogin((String)userId, password);
        if (user == null) {
            throw new RemoteException("Falha na autentica\u00e7\u00e3o do usu\u00e1rio. \nVerifique se o login e a senha s\u00e3o v\u00e1lidos");
        }
        return this.getDownloadTextURL(text, fileName);
    }

    private String getDownloadTextURL(String text, String fileName) throws RemoteException {
        String filePath = "/" + Math.abs(this.numberGenerator.nextLong()) + "/" + fileName;
        return this.getURL(filePath, DOWNLOAD, null, null, 3, text, null, null, null, null, null, null);
    }

    public String getDownloadCSVURL(Object userId, String password, String text) throws RemoteException {
        return this.getDownloadCSVURL(userId, password, text, "TEXT");
    }

    public String getDownloadCSVURL(String text) throws RemoteException {
        return this.getDownloadCSVURL(text, "TEXT");
    }

    public String getDownloadCSVURL(String text, String fileName) throws RemoteException {
        String filePath = "/" + Math.abs(this.numberGenerator.nextLong()) + "/" + fileName + ".csv";
        return this.getURL(filePath, DOWNLOAD, null, null, 5, text, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String accessCode) throws RemoteException {
        RequestInfo reqInfo;
        if (accessCode == null) {
            return null;
        }
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            reqInfo = this.requestList.get(accessCode);
        }
        if (reqInfo == null) {
            return null;
        }
        return reqInfo.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL(String filePath, String type, String presentationPath, String resultPath, int downloadType, String text, Map parameters, String jdbcDriverClassName, String jdbcURL, String jdbcUser, String jdbcPassword, Observer observer) {
        Object path;
        if (filePath == null || type == null) {
            return null;
        }
        if (this.httpServiceURL == null) {
            return null;
        }
        String accessCode = this.getAccessCode(filePath);
        if (accessCode == null) {
            accessCode = "" + Math.abs(this.numberGenerator.nextLong());
            accessCode = accessCode + Math.abs(this.numberGenerator.nextLong());
        }
        RequestInfo req = new RequestInfo();
        req.userId = Service.getUser();
        req.downloadType = downloadType;
        req.text = text;
        req.filePath = filePath;
        String fileName = null;
        if (type.equals(UPLOAD)) {
            req.removeFile = true;
            req.uploadPresentationPath = presentationPath;
            req.uploadResultPath = resultPath;
            req.observer = observer;
        } else {
            path = filePath.split("/");
            fileName = path == null ? filePath : path[((String[])path).length - 1];
            fileName = this.encode(fileName);
            req.parameters = parameters;
            req.jdbcDriverClassName = jdbcDriverClassName;
            req.jdbcURL = jdbcURL;
            req.jdbcUser = jdbcUser;
            req.jdbcPassword = jdbcPassword;
        }
        req.whenDone = System.currentTimeMillis();
        path = this.requestList;
        synchronized (path) {
            this.requestList.put(accessCode, req);
        }
        String url = fileName == null ? this.httpServiceURL + "/" + type + "/" + accessCode + "/" + type : this.httpServiceURL + "/" + type + "/" + accessCode + "/" + type + "/" + fileName;
        Server.logInfoMessage("URL: " + url + " - filePath: " + req.filePath + " - user: " + Service.getUser().getLogin());
        return url;
    }

    private String getURL(String filePath, String type, String presentationPath, String resultPath, Observer obs) {
        return this.getURL(filePath, type, presentationPath, resultPath, 2, null, null, null, null, null, null, obs);
    }

    private String getURL(String filePath, String type, String presentationPath, String resultPath, Observer obs, Map<String, String> parameters) throws RemoteException {
        return this.getURL(filePath, type, presentationPath, resultPath, 2, null, parameters, null, null, null, null, obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessCode(String filePath) {
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            for (Map.Entry<String, RequestInfo> entry : this.requestList.entrySet()) {
                String fileTemp = entry.getValue().filePath;
                if (!filePath.equals(fileTemp)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public void shutdownService() throws ServerException {
        this.shutdown = true;
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
        this.requestList = null;
    }

    @Override
    public void initService() throws ServerException {
        this.requestList = new TreeMap<String, RequestInfo>();
        this.httpServiceURL = this.getStringProperty("webapp");
        double seed = Math.random();
        long longSeed = (long)(seed * 9.223372036854776E18);
        this.numberGenerator = new Random(longSeed);
        this.shutdown = false;
        float maxSaveTime = (float)this.getDoubleProperty("maxSaveTime");
        float cleanTime = (float)this.getDoubleProperty("cleanTime");
        this.cleaner = new Cleaner(maxSaveTime, cleanTime);
    }

    public static HttpService getInstance() {
        return (HttpService)HttpService.getInstance("HttpService");
    }

    public String getDownloadCSVURL(Object userId, String password, String text, String fileName) throws RemoteException {
        User user = LoginService.getInstance().checkLogin((String)userId, password);
        if (user == null) {
            throw new RemoteException("Falha na autentica\u00e7\u00e3o do usu\u00e1rio. \nVerifique se o login e a senha s\u00e3o v\u00e1lidos");
        }
        return this.getDownloadCSVURL(text, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestListSize() throws RemoteException {
        Map<String, RequestInfo> map = this.requestList;
        synchronized (map) {
            return this.requestList.size();
        }
    }

    private class Cleaner
    extends Thread {
        private static final long DAY_IN_MS = 86400000L;
        private final float maxSaveTime;
        private final float cleanTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!HttpService.this.shutdown) {
                try {
                    Cleaner.sleep((long)(this.cleanTime * 8.64E7f));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (HttpService.this.shutdown) break;
                Server.logFineMessage("Thread iniciada: cleaner");
                long now = System.currentTimeMillis();
                Map map = HttpService.this.requestList;
                synchronized (map) {
                    LinkedList<String> toDelete = new LinkedList<String>();
                    for (Map.Entry entry : HttpService.this.requestList.entrySet()) {
                        String key = (String)entry.getKey();
                        RequestInfo reqInfo = (RequestInfo)entry.getValue();
                        if (reqInfo.whenDone <= 0L || !((float)reqInfo.whenDone < (float)now - this.maxSaveTime * 8.64E7f)) continue;
                        toDelete.add(key);
                        if (!reqInfo.removeFile) continue;
                        new File(reqInfo.filePath).delete();
                    }
                    for (String toDelKey : toDelete) {
                        HttpService.this.requestList.remove(toDelKey);
                    }
                }
                Server.logFineMessage("Thread terminada: cleaner");
            }
        }

        public Cleaner(float maxSaveTime, float cleanTime) {
            this.maxSaveTime = maxSaveTime;
            this.cleanTime = cleanTime;
            this.setDaemon(true);
            this.start();
        }
    }

    private class RequestInfo {
        Object userId;
        Object projectId;
        String filePath;
        String fileType;
        int downloadType;
        public long whenDone = 0L;
        boolean removeFile = false;
        String uploadPresentationPath;
        String uploadResultPath;
        String text;
        Map parameters;
        String jdbcDriverClassName;
        String jdbcURL;
        String jdbcUser;
        String jdbcPassword;
        Observer observer;
        public UploadHandler fileHandler;

        private RequestInfo() {
        }
    }
}

