/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.server.Server;
import csbase.server.ServerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import tecgraf.javautils.core.externalcommand.ExternalCommand;

public class FileSystem {
    private static final String CP_COMMAND = "cp";
    public static final String PROPERTIES_DIR = "properties";

    public static long getFreeSpace(String path) {
        try {
            FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
            return store.getUsableSpace();
        }
        catch (Exception e) {
            String fmt = "Erro obtendo espa\u00e7o livre de disco em: %s";
            String err = String.format("Erro obtendo espa\u00e7o livre de disco em: %s", path);
            Server.logSevereMessage(err, e);
            return -1L;
        }
    }

    public static long getTotalSpace(String path) {
        try {
            FileStore store = Files.getFileStore(Paths.get(path, new String[0]));
            return store.getTotalSpace();
        }
        catch (Exception e) {
            String fmt = "Erro obtendo espa\u00e7o total de disco em: %s";
            String err = String.format("Erro obtendo espa\u00e7o total de disco em: %s", path);
            Server.logSevereMessage(err, e);
            return -1L;
        }
    }

    public static boolean moveRegularFile(File from, File to) {
        Server.logInfoMessage("FileSystem.moveRegularFile:  de: " + from.getAbsolutePath() + "  para: " + to.getAbsolutePath());
        if (!from.exists()) {
            Server.logSevereMessage("FileSystem.moveRegularFile: arquivo origem n\u00e3o existe: " + from.getAbsolutePath());
            return false;
        }
        if (!FileSystem.copyFile(from, to)) {
            return false;
        }
        if (from.delete()) {
            return true;
        }
        Server.logSevereMessage("FileSystem.moveRegularFile: Erro removendo arquivo origem: " + from.getAbsolutePath());
        return false;
    }

    public static boolean move(File from, File to) {
        File newChildFile;
        if (!from.isDirectory()) {
            return FileSystem.moveRegularFile(from, to);
        }
        if (!to.mkdirs()) {
            Server.logSevereMessage("FileSystem.move: Erro na criando diret\u00f3rio(s) : " + to.getAbsolutePath());
            return false;
        }
        File[] children = from.listFiles();
        boolean success = true;
        for (int i = 0; i < children.length && (success = FileSystem.move(children[i], newChildFile = new File(to, children[i].getName()))); ++i) {
        }
        if (success) {
            if (from.delete()) {
                return true;
            }
            Server.logSevereMessage("FileSystem.move: Erro removendo diret\u00f3rio origem: " + from.getAbsolutePath());
        }
        return success;
    }

    public static boolean copyFile(File from, File to) {
        Server.logInfoMessage(String.format("FileSystem.copyFile: de '%s' para '%s'", from.getAbsolutePath(), to.getAbsolutePath()));
        String[] cmdArray = FileSystem.createCommandArray(CP_COMMAND, from.getAbsolutePath(), to.getAbsolutePath());
        String cmd = String.format("FileSystem:copyFile: Erro copiando arquivo (%s '%s' '%s')", cmdArray[0], cmdArray[1], cmdArray[2]);
        try {
            ExternalCommand command = new ExternalCommand(cmdArray);
            if (command.waitFor() != 0) {
                String errorOutput = command.getErrorOutput();
                Server.logSevereMessage(cmd + " :\n" + (errorOutput != null ? errorOutput : "---"));
                return false;
            }
        }
        catch (InterruptedException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        catch (IOException e) {
            Server.logSevereMessage(cmd, e);
            return false;
        }
        return true;
    }

    public static void removeFile(File file, boolean removeRoot) throws Exception {
        File[] children;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                FileSystem.removeFile(children[i], true);
            }
        }
        if (removeRoot && !file.delete()) {
            throw new Exception("Falha na remo\u00e7\u00e3o de " + file.getPath());
        }
    }

    public static final boolean enableExecutionPermission(String filePath) throws ServerException {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath == null");
        }
        if (filePath.equals("")) {
            throw new IllegalArgumentException("filePath est\u00e1 vazia");
        }
        try {
            return new File(filePath).setExecutable(true, false);
        }
        catch (Exception e) {
            throw new ServerException("Erro ao mudar execu\u00e7\u00e3o do arquivo '" + filePath + "'", e);
        }
    }

    private static String[] createCommandArray(String cmd, String ... args) {
        StringTokenizer cmdTokenizer = new StringTokenizer(cmd);
        int numTokens = cmdTokenizer.countTokens();
        String[] cmdArray = new String[args.length + numTokens];
        int i = 0;
        while (i < numTokens) {
            cmdArray[i++] = cmdTokenizer.nextToken();
        }
        System.arraycopy(args, 0, cmdArray, i, args.length);
        return cmdArray;
    }
}

