/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.AttributesPermission;
import csbase.logic.ChoicePermission;
import csbase.logic.IdFactory;
import csbase.logic.Permission;
import csbase.logic.UserPasswordPermission;
import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.administrationservice.FileCrypto;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PermissionIO {
    private IdFactory idFactory;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String CLASS_NAME = "class";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String ATTRIBUTES = "attributes";
    private static String FILENAME_PROPERTY = "PermissionIO.filename";
    private static String FILENAME;
    private static String fileName;

    public PermissionIO() {
        Server server = Server.getInstance();
        AdministrationService admSrv = AdministrationService.getInstance();
        fileName = server.getPersistencyRootDirectoryName() + File.separator + admSrv.getStringProperty(FILENAME_PROPERTY);
        Server.logInfoMessage("Arquivo de permiss\u00f5es: " + fileName);
    }

    public synchronized Permission writeNew(Permission permission) throws Exception {
        Vector<Permission> permissions = new Vector<Permission>(Permission.getAllPermissions());
        if (this.idFactory == null) {
            this.idFactory = new IdFactory(permissions);
        }
        Object id = this.idFactory.next();
        permission.setId(id);
        if (permission instanceof UserPasswordPermission) {
            this.ajustPassword((UserPasswordPermission)permission);
        }
        permissions.add(permission);
        this.writeAll(permissions);
        return permission;
    }

    public synchronized Permission write(Object id, Permission permission) throws Exception {
        try {
            Permission oldPermission = Permission.getPermission((Object)id);
            Vector<Permission> permissions = new Vector<Permission>(Permission.getAllPermissions());
            if (!permissions.remove(oldPermission)) {
                throw new Exception("Permission n\u00e3o existe");
            }
            permission.setId(id);
            if (permission instanceof UserPasswordPermission) {
                String password = ((UserPasswordPermission)permission).getPassword();
                if (password == null || password.equals("")) {
                    ((UserPasswordPermission)permission).setLocalPassword(((UserPasswordPermission)oldPermission).getLocalPassword());
                } else {
                    this.ajustPassword((UserPasswordPermission)permission);
                }
            }
            permissions.add(permission);
            this.writeAll(permissions);
            return permission;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public synchronized Permission write(Permission permission) throws Exception {
        Vector<Permission> permissions = new Vector<Permission>(Permission.getAllPermissions());
        Object id = permission.getId();
        if (Permission.getPermission((Object)id) != null) {
            throw new Exception("Permiss\u00e3o j\u00e1 existe");
        }
        permissions.add(permission);
        this.writeAll(permissions);
        return permission;
    }

    private void ajustPassword(UserPasswordPermission permission) {
        permission.setLocalPassword(permission.getPassword());
        permission.setPassword(null);
    }

    public synchronized void delete(Object id) throws Exception {
        Vector<Permission> permissions;
        Permission permission;
        try {
            permission = Permission.getPermission((Object)id);
            permissions = new Vector<Permission>(Permission.getAllPermissions());
            if (this.idFactory == null) {
                this.idFactory = new IdFactory(permissions);
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
        if (!permissions.remove(permission)) {
            throw new Exception("Permission n\u00e3o existe");
        }
        this.writeAll(permissions);
        this.idFactory.free(permission.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeAll(List<Permission> permissions) throws Exception {
        Hashtable permissionsHash = new Hashtable();
        for (Permission permission : permissions) {
            Hashtable<String, Object> permissionHash = new Hashtable<String, Object>();
            permissionHash.put(NAME, permission.getName());
            permissionHash.put(DESCRIPTION, permission.getDescription());
            permissionHash.put(CLASS_NAME, permission.getClass().getName());
            if (permission instanceof AttributesPermission) {
                permissionHash.put(ATTRIBUTES, ((AttributesPermission)permission).getAttributes());
            } else if (permission instanceof UserPasswordPermission) {
                permissionHash.put(USER, ((UserPasswordPermission)permission).getUser());
                String key = Server.getInstance().getAdminPassword();
                byte[] crypted = FileCrypto.encrypt(key, ((UserPasswordPermission)permission).getLocalPassword());
                permissionHash.put(PASSWORD, crypted);
            } else if (permission instanceof ChoicePermission) {
                permissionHash.put(ATTRIBUTES, ((ChoicePermission)permission).getAttributes());
            }
            permissionsHash.put(permission.getId(), permissionHash);
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName))));){
            out.writeObject(permissionsHash);
        }
    }

    public synchronized Permission read(Object id) throws Exception {
        for (Permission permission : Permission.getAllPermissions()) {
            if (!permission.getId().equals(id)) continue;
            return permission;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Permission> readAll() {
        AdministrationService srv = AdministrationService.getInstance();
        Vector<Permission> permissions = new Vector<Permission>();
        File permissionsFile = new File(fileName);
        if (!permissionsFile.exists()) {
            Server.logInfoMessage("Criando novo arquivo de permiss\u00f5es " + fileName);
            return permissions;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(permissionsFile))));
            Hashtable permissionsHash = (Hashtable)in.readObject();
            boolean allRead = true;
            for (Map.Entry permEntry : permissionsHash.entrySet()) {
                Hashtable permissionHash;
                Object id = permEntry.getKey();
                Permission permission = this.makePermission(id, permissionHash = (Hashtable)permEntry.getValue());
                if (permission != null) {
                    permissions.add(permission);
                    continue;
                }
                allRead = false;
            }
            if (!allRead) {
                try {
                    Server.logInfoMessage("Persistindo apenas as permiss\u00f5es v\u00e1lidas.");
                    this.writeAll(permissions);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Falha na persistencia de apenas as permiss\u00f5es v\u00e1lidas.", e);
                }
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro durante a leitura e descriptografia das permiss\u00e3o de usu\u00e1rios", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro fechando arquivo de permiss\u00f5es");
                }
            }
        }
        return permissions;
    }

    private Permission makePermission(Object id, Hashtable<String, Object> permissionHash) {
        try {
            String name = (String)permissionHash.get(NAME);
            String desc = (String)permissionHash.get(DESCRIPTION);
            String className = (String)permissionHash.get(CLASS_NAME);
            Class<?> permissionClass = Class.forName(className);
            Permission permission = (Permission)permissionClass.newInstance();
            permission.setId(id);
            permission.setName(name);
            permission.setDescription(desc);
            if (permission instanceof AttributesPermission) {
                String[] attributes = (String[])permissionHash.get(ATTRIBUTES);
                ((AttributesPermission)permission).setAttributes(attributes);
            } else if (permission instanceof UserPasswordPermission) {
                String user = (String)permissionHash.get(USER);
                byte[] pass = (byte[])permissionHash.get(PASSWORD);
                String key = Server.getInstance().getAdminPassword();
                String decrypted = FileCrypto.decrypt(key, pass);
                ((UserPasswordPermission)permission).setUser(user);
                ((UserPasswordPermission)permission).setLocalPassword(decrypted);
            } else if (permission instanceof ChoicePermission) {
                ((ChoicePermission)permission).setAttributes((Map)permissionHash.get(ATTRIBUTES));
            }
            return permission;
        }
        catch (Exception e) {
            AdministrationService srv = AdministrationService.getInstance();
            if (srv != null) {
                Server.logSevereMessage("Falha na leitura da Permission: " + id + " Message: " + e.getMessage());
            }
            return null;
        }
    }

    static {
        fileName = FILENAME = "permission.dat";
    }
}

