/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice;

import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.Server;
import csbase.server.services.filetransferservice.FileTransferRequestQueue;
import csbase.server.services.filetransferservice.FileTransferService;

public final class FileTransferServiceMonitorThread
extends Thread {
    private final FileTransferService service;

    @Override
    public final void run() {
        int maxParallel = this.service.getIntProperty("max.parallel.transfers");
        Server.logInfoMessage("Configura\u00e7\u00e3o de paralelismo: " + maxParallel);
        int checkTimeSec = 5000;
        while (!this.isInterrupted()) {
            try {
                FileTransferRequest pck;
                Thread.sleep(5000L);
                FileTransferRequestQueue queue = this.service.getRequestQueue();
                int nRuns = queue.getNumRunningRequests();
                while (nRuns < maxParallel && (pck = queue.pickWaitingRequest()) != null) {
                    this.service.startRequest(pck);
                    int ONE_SEC = 1000;
                    Thread.sleep(1000L);
                    nRuns = queue.getNumRunningRequests();
                }
            }
            catch (InterruptedException e) {
                String msg = "Detectada interrup\u00e7\u00e3o da thread de monitora\u00e7\u00e3o";
                Server.logInfoMessage("Detectada interrup\u00e7\u00e3o da thread de monitora\u00e7\u00e3o");
            }
            catch (Exception e) {
                String msg = "Exce\u00e7\u00e3o no servi\u00e7o (thread de monitora\u00e7\u00e3o)";
                Server.logSevereMessage("Exce\u00e7\u00e3o no servi\u00e7o (thread de monitora\u00e7\u00e3o)", e);
            }
        }
        Server.logInfoMessage("Fim da thread de monitora\u00e7\u00e3o");
    }

    @Override
    public final void interrupt() {
        Server.logInfoMessage("Interrompendo thread de monitora\u00e7\u00e3o");
        super.interrupt();
    }

    @Override
    public final synchronized void start() {
        Server.logInfoMessage("Lan\u00e7ando thread de monitora\u00e7\u00e3o");
        super.start();
    }

    FileTransferServiceMonitorThread(FileTransferService service) {
        this.service = service;
        this.setName(service.getName() + "::MonitorThread");
    }
}

