/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.logic.ProjectFileInfo;
import csbase.server.services.projectservice.BasicProjectTemplate;
import csbase.server.services.projectservice.ServerProjectFile;
import java.util.Arrays;

public class DefaultProjectTemplate
extends BasicProjectTemplate {
    public DefaultProjectTemplate(ProjectFileInfo baseDir, String ... params) {
        super(baseDir, params);
    }

    @Override
    public boolean canRename(ServerProjectFile file, String newName) {
        return !this.isRestricted(file);
    }

    @Override
    public boolean canDelete(ServerProjectFile file) {
        return !this.isRestricted(file);
    }

    @Override
    public boolean canCreate(ServerProjectFile parentDir, String name, String type) {
        return true;
    }

    @Override
    public boolean canChangeType(ServerProjectFile file, String newType) {
        return !this.isRestricted(file);
    }

    private boolean isRestricted(ServerProjectFile file) {
        boolean isTemplateDir = Arrays.equals(file.getPath(), this.getBaseDir().getPath());
        boolean isAncestor = DefaultProjectTemplate.isAncestor(file.getPath(), this.getBaseDir().getPath());
        return isTemplateDir || isAncestor;
    }

    public static boolean isAncestor(String[] ancestorPath, String[] descendantPath) {
        if (ancestorPath == null || descendantPath == null) {
            return false;
        }
        if (ancestorPath.length >= descendantPath.length) {
            return false;
        }
        for (int i = 0; i < ancestorPath.length; ++i) {
            if (ancestorPath[i].equals(descendantPath[i])) continue;
            return false;
        }
        return true;
    }
}

