/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectAllocationState;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerProject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import tecgraf.javautils.core.io.FileUtils;

class ProjectAdministrator {
    static final String LOCKED_PROJECTS_FILE_NAME = "locked_projects.csbase";
    private static final String SEPARATOR = ";";
    private static ProjectService service;
    private Hashtable<Object, Hashtable<Object, ProjectAdminInfo>> lockedProjects = new Hashtable();

    void finish() {
        this.saveLockedProjects(true);
    }

    ProjectAdminInfo[] getAllProjectAdminInfo() {
        ArrayList<ProjectAdminInfo> projs = new ArrayList<ProjectAdminInfo>();
        for (Map map : this.lockedProjects.values()) {
            Collection projects = map.values();
            for (ProjectAdminInfo projectAdminInfo : projects) {
                if (!ProjectAdministrator.isValidProject(projectAdminInfo)) continue;
                projs.add(projectAdminInfo);
            }
        }
        return projs.toArray(new ProjectAdminInfo[0]);
    }

    ProjectAdminInfo getProjectAdminInfo(Object projectId) {
        Object ownerId = ServerProject.getOwnerId(projectId);
        Hashtable<Object, ProjectAdminInfo> userProjects = this.lockedProjects.get(ownerId);
        if (userProjects == null) {
            return null;
        }
        ProjectAdminInfo info = userProjects.get(projectId);
        return info;
    }

    synchronized ProjectAdminInfo removeProjectAdminInfo(Object projectId) {
        Object ownerId = ServerProject.getOwnerId(projectId);
        Hashtable<Object, ProjectAdminInfo> userProjects = this.lockedProjects.get(ownerId);
        if (userProjects == null) {
            return null;
        }
        ProjectAdminInfo info = userProjects.remove(projectId);
        this.saveLockedProjects(false);
        return info;
    }

    synchronized ProjectAdminInfo lockProject(Object projectId, long size) {
        String projectName = ServerProject.getProjectName(projectId);
        Object ownerId = ServerProject.getOwnerId(projectId);
        ProjectAdminInfo info = new ProjectAdminInfo(projectId, projectName, ownerId, service.getRoot(projectId).getAbsolutePath(), ProjectAllocationState.WAITING_AREA_ALLOCATION);
        info.setAreaRequestSize(size);
        info.setAreaRequestDate(Calendar.getInstance().getTime());
        Hashtable<Object, Object> userProjects = this.lockedProjects.get(ownerId);
        if (userProjects == null) {
            userProjects = new Hashtable();
            this.lockedProjects.put(ownerId, userProjects);
        }
        userProjects.put(projectId, info);
        this.saveLockedProjects(false);
        return info;
    }

    synchronized ProjectAdminInfo unlockProject(Object projectId, long size) {
        ProjectAdminInfo info = this.getProjectAdminInfo(projectId);
        if (info == null) {
            throw new ServiceFailureException("ProjectAdministrator:unlockProject: n\u00e3o existe informa\u00e7\u00e3o administrativa do projeto " + projectId);
        }
        info.setState(ProjectAllocationState.UNLOCKED_WITH_AREA_ALLOCATED);
        info.setAreaLockedSize(size);
        this.saveLockedProjects(false);
        return info;
    }

    ProjectAdminInfo freeProjectArea(Object projectId) {
        ProjectAdminInfo info = this.removeProjectAdminInfo(projectId);
        if (info == null) {
            throw new ServiceFailureException("ProjectAdministrator:freeProject: n\u00e3o existe informa\u00e7\u00e3o administrativa do projeto " + projectId);
        }
        this.saveLockedProjects(false);
        return info;
    }

    synchronized ProjectAdminInfo setAllocatedProjectRemoved(Object projectId) {
        ProjectAdminInfo info = this.getProjectAdminInfo(projectId);
        if (info == null) {
            throw new ServiceFailureException("ProjectAdministrator:removedProject: n\u00e3o existe informa\u00e7\u00e3o administrativa do projeto " + projectId);
        }
        info.setState(ProjectAllocationState.WAITING_AREA_FREE);
        this.saveLockedProjects(false);
        return info;
    }

    boolean isLocked(Object projectId) {
        ProjectAdminInfo info = this.getProjectAdminInfo(projectId);
        if (info == null) {
            return false;
        }
        return info.isLocked();
    }

    boolean isUnlockedWithAreaAllocated(Object projectId) {
        ProjectAdminInfo info = this.getProjectAdminInfo(projectId);
        if (info == null) {
            return false;
        }
        return info.isUnlockedWithAreaAllocated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void loadLockedProjects() {
        String lockFileName = this.getLockFileName();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(lockFileName));
            String nextLine = null;
            String[] tokens = null;
            while ((nextLine = in.readLine()) != null) {
                String absolutePath;
                tokens = nextLine.split(SEPARATOR);
                String projectId = tokens[0];
                int stateInt = Integer.parseInt(tokens[1]);
                ProjectAllocationState state = ProjectAllocationState.getProjectAllocationStateFromCode((int)stateInt);
                long reqSize = Long.parseLong(tokens[2]);
                long reqDate = Long.parseLong(tokens[3]);
                long lockSize = Long.parseLong(tokens[4]);
                if (state != ProjectAllocationState.WAITING_AREA_FREE) {
                    try {
                        String path = ServerProject.getAbsolutePath(projectId);
                        File pathFile = new File(path);
                        File configFile = ServerProject.getConfigFile(pathFile);
                        Object ownerId = ServerProject.getOwnerId(projectId);
                        CommonProjectInfo info = ServerProject.readProjectInfoFromConfigFile(configFile, ownerId);
                        if (info == null) continue;
                        File root = service.getRoot(projectId);
                        absolutePath = root.getAbsolutePath();
                    }
                    catch (Exception e) {
                        Server.logWarningMessage("ProjectAdministrator: n\u00e3o foi poss\u00edvel encontrar o projeto " + projectId);
                        absolutePath = null;
                    }
                } else {
                    absolutePath = null;
                }
                String projectName = ServerProject.getProjectName(projectId);
                Object userId = ServerProject.getOwnerId(projectId);
                ProjectAdminInfo info = new ProjectAdminInfo((Object)projectId, projectName, userId, absolutePath, state);
                info.setAreaRequestSize(reqSize);
                info.setAreaRequestDate(new Date(reqDate));
                info.setAreaLockedSize(lockSize);
                Hashtable<Object, Object> userProjects = this.lockedProjects.get(userId);
                if (userProjects == null) {
                    userProjects = new Hashtable();
                    this.lockedProjects.put(userId, userProjects);
                }
                userProjects.put(projectId, info);
            }
        }
        catch (FileNotFoundException e) {
            Server.logWarningMessage("ProjectAdministrator: arquivo " + lockFileName + " n\u00e3o existe");
            FileUtils.close((Closeable)in);
        }
        catch (IOException e2) {
            Server.logSevereMessage("ProjectAdministrator: erro de leitura no arquivo " + lockFileName, e2);
            {
                catch (Throwable throwable) {
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close((Closeable)in);
        }
        FileUtils.close((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveLockedProjects(boolean cleanInvalidProjects) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.getLockFileName()));
            Enumeration<Object> keys = this.lockedProjects.keys();
            while (keys.hasMoreElements()) {
                Object userId = keys.nextElement();
                Hashtable<Object, ProjectAdminInfo> projects = this.lockedProjects.get(userId);
                if (projects == null) continue;
                Enumeration<Object> ids = projects.keys();
                while (ids.hasMoreElements()) {
                    Object projectId = ids.nextElement();
                    ProjectAdminInfo info = projects.get(projectId);
                    if (info == null || cleanInvalidProjects && !ProjectAdministrator.isValidProject(info)) continue;
                    Date date = info.getAreaRequestDate();
                    String dateText = date == null ? "" : String.valueOf(date.getTime());
                    out.write(projectId.toString());
                    out.write(SEPARATOR);
                    out.write(String.valueOf(info.getState().getCode()));
                    out.write(SEPARATOR);
                    out.write(String.valueOf(info.getAreaRequestSize()));
                    out.write(SEPARATOR);
                    out.write(dateText);
                    out.write(SEPARATOR);
                    out.write(String.valueOf(info.getAreaLockedSize()));
                    out.write(SEPARATOR);
                    out.newLine();
                }
            }
            FileUtils.close((Closeable)out);
        }
        catch (IOException e) {
            Server.logSevereMessage("Erro ao gravar dados de administra\u00e7\u00e3o dos projetos.", e);
        }
        finally {
            FileUtils.close(out);
        }
    }

    private static boolean isValidProject(ProjectAdminInfo info) {
        return service.existsProject(info.getProjectId()) || info.isWaitingAreaFree();
    }

    private String getLockFileName() {
        return ProjectService.getInstance().getProjectRepositoryPath() + File.separator + LOCKED_PROJECTS_FILE_NAME;
    }

    ProjectAdministrator(ProjectService service) {
        ProjectAdministrator.service = service;
        this.loadLockedProjects();
    }
}

