/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.projectservice.v1_02.ProjectDataService;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.project.v1_02.IProjectNavigationDataServicePOA;
import tecgraf.openbus.data_service.project.v1_02.InvalidOwner;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataView;

public class IProjectNavigationDataServiceServant
extends IProjectNavigationDataServicePOA {
    public ProjectDataView[] getProject(String fOwner) throws DataAccessDenied, ServiceFailure, InvalidOwner {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            ProjectDataView[] projectDataViewArray = service.getProject(fOwner);
            return projectDataViewArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure, DataNotFound, DataAccessDenied, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getChildren(fKey);
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure(e.getMessage());
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription getParent(byte[] fKey) throws ServiceFailure, DataNotFound, DataAccessDenied, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription dataDescription = service.getParent(fKey);
            return dataDescription;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getRoots();
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

