/*
 * Detalhes da ltima alterao:
 * 
 * $Author$
 * $Date$
 * $Revision$
 */
package csbase.server.services.httpservice;

/**
 * Contem o resultado de um upload.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class UploadResult {
  /**
   * O codigo de acesso.
   */
  private String accessCode;
  /**
   * O nome original do arquivo que sofreu upload.
   */
  private String fileName;
  /**
   * O caminho onde o arquivo foi salvo.
   */
  private String filePath;

  /**
   * Cria um resultado de um upload.
   * 
   * @param accessCode O codigo de acesso.
   * @param fileName O nome do arquivo original que sofreu upload.
   * @param filePath O caminho onde o arquivo foi salvo.
   */
  public UploadResult(String accessCode, String fileName, String filePath) {
    this.accessCode = accessCode;
    this.fileName = fileName;
    this.filePath = filePath;
  }

  /**
   * Obtem o codigo de acesso.
   * 
   * @return O codigo de acesso.
   */
  public String getAccessCode() {
    return this.accessCode;
  }

  /**
   * Obtem o nome original do arquivo que sofreu upload.
   * 
   * @return O nome original do arquivo que sofreu upload.
   */
  public String getFileName() {
    return this.fileName;
  }

  /**
   * Obtem o caminho onde o arquivo foi salvo.
   * 
   * @return O caminho onde o arquivo foi salvo.
   */
  public String getFilePath() {
    return this.filePath;
  }
}