/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.commandpersistenceservice;

import csbase.exception.ParseException;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.algorithms.ExecutionType;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class CommandPropertyParser {
    private static final String ENCODING = "ISO-8859-1";
    private static final String PROPERTY_KEY_OF_EXECUTION_COUNT_FOR_MULTIPLE_EXECUTION = "execution_count_for_multiple_execution";
    private static final String PROPERTY_KEY_OF_EXECUTION_COUNT_PER_SGA_FOR_MULTIPLE_EXECUTION = "execution_count_per_sga_for_multiple_execution";
    private static final String PROPERTY_KEY_OF_DESCRIPTION = "description";
    private static final String PROPERTY_KEY_OF_EXECUTION_TYPE = "execution_type";
    private static final String PROPERTY_KEY_OF_TIP = "tip";
    private static final String PROPERTY_KEY_OF_GLOBAL_POSITION = "global_position";
    private static final int PROPERTY_DEFAULT_VALUE_OF_GLOBAL_POSITION = -1;
    private static final String PROPERTY_KEY_OF_ID = "id";
    private static final String PROPERTY_KEY_OF_IS_AUTOMATIC = "is_automatic";
    private static final String PROPERTY_KEY_OF_MAIL_AT_END = "mail_at_end";
    private static final String PROPERTY_KEY_OF_PLATFORM_FILTER = "platform_filter";
    private static final String PROPERTY_KEY_OF_PRIORITY = "priority";
    private static final String PROPERTY_KEY_OF_SELECTED_SGAS_NAMES = "selected_sgas_names";
    private static final String SGAS_NAMES_SEPARATOR = ",";
    private static final String PROPERTY_KEY_OF_SGA_NAME = "sgaName";
    private static final String PROPERTY_KEY_OF_STATUS = "status";
    private static final String PROPERTY_KEY_OF_FINALIZATION_TYPE = "finalization_type";
    private static final String PROPERTY_KEY_OF_FINALIZATION_FAILURE_TYPE = "finalization_failure_cause";
    private static final String PROPERTY_KEY_OF_WARNING_FLAG = "hasWarnings";
    private static final String PROPERTY_KEY_OF_SUBMITTED_DATE = "startDate";
    private static final String PROPERTY_KEY_OF_WALL_TIME_SEC = "wallTimeSec";
    private static final String PROPERTY_KEY_OF_USER_ID = "userId";
    private static final String PROPERTY_KEY_OF_EXIT_CODE = "command_exit_code";
    private static final String PROPERTY_KEY_OF_EXTENDED_FINALIZATION_INFO = "extended_finalization_info";
    private static final String PROPERTY_KEY_OF_GUILTY_NODE_ID = "guilty_node_id";
    private static final String PROPERTY_KEY_OF_FINALIZATION_INFO_TYPE = "finalization_info_type";
    private static final String FINALIZATION_INFO_SEPARATOR = ",";
    private static final String FINALIZATION_INFO_FIELD_SEPARATOR = ":";
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_COMMENT = "comment";
    private Properties properties;
    private List<Map<String, String>> propertiesValues = new LinkedList<Map<String, String>>();

    private String getMessage(String keySuffix) {
        return CommandPersistenceService.getInstance().getString(this.getClass().getSimpleName() + "." + keySuffix);
    }

    private Map<String, String> createProperty(String propertyKey, String propertyValue, String propertyComment) {
        HashMap<String, String> property = new HashMap<String, String>();
        property.put(PROPERTY_KEY, propertyKey);
        property.put(PROPERTY_VALUE, propertyValue);
        property.put(PROPERTY_COMMENT, propertyComment);
        return property;
    }

    private Integer readIntegerProperty(String propertyName, Integer defaultValue, boolean isMandatory) throws ParseException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            if (defaultValue == null && isMandatory) {
                throw new ParseException(String.format(this.getMessage("error_property_not_found"), propertyName));
            }
            return defaultValue;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format(this.getMessage("error_must_be_integer_property"), propertyName, property);
            throw new ParseException(errorMessage);
        }
    }

    private Integer readIntegerProperty(String propertyName, Integer defaultValue) throws ParseException {
        return this.readIntegerProperty(propertyName, defaultValue, true);
    }

    private Boolean readBooleanProperty(String propertyName, Boolean defaultValue, boolean isMandatory) throws ParseException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            if (defaultValue == null && isMandatory) {
                throw new ParseException(String.format(this.getMessage("error_property_not_found"), propertyName));
            }
            return defaultValue;
        }
        return Boolean.parseBoolean(property);
    }

    private Boolean readBooleanProperty(String propertyName, Boolean defaultValue) throws ParseException {
        return this.readBooleanProperty(propertyName, defaultValue, true);
    }

    private <E extends Enum<E>> E readEnumProperty(String propertyName, Class<E> enumClass, E defaultValue) throws ParseException {
        return this.readEnumProperty(propertyName, enumClass, defaultValue, false);
    }

    private <E extends Enum<E>> E readEnumProperty(String propertyName, Class<E> enumClass, E defaultValue, boolean isMandatory) throws ParseException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            if (defaultValue == null && isMandatory) {
                throw new ParseException(String.format(this.getMessage("error_property_not_found"), propertyName));
            }
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, property.trim());
        }
        catch (NullPointerException e) {
            String errorMessage = String.format(this.getMessage("error_must_be_enum_property"), propertyName, enumClass, property);
            throw new ParseException(errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format(this.getMessage("error_must_be_enum_property"), propertyName, enumClass, property);
            throw new ParseException(errorMessage);
        }
    }

    public void setExecutionCountForMultipleExecution(Integer executionCount) {
        Map<String, String> executionCountProperty = this.createProperty(PROPERTY_KEY_OF_EXECUTION_COUNT_FOR_MULTIPLE_EXECUTION, Integer.toString(executionCount), this.getMessage("msg_execution_count_for_multiple_execution_commentary"));
        this.propertiesValues.add(executionCountProperty);
    }

    public int getExecutionCountForMultipleExecution() throws ParseException {
        return this.readIntegerProperty(PROPERTY_KEY_OF_EXECUTION_COUNT_FOR_MULTIPLE_EXECUTION, null);
    }

    public void setExecutionCountPerSGAForMultipleExecution(Integer executionCount) {
        Map<String, String> executionCountProperty = this.createProperty(PROPERTY_KEY_OF_EXECUTION_COUNT_PER_SGA_FOR_MULTIPLE_EXECUTION, Integer.toString(executionCount), this.getMessage("msg_execution_count_per_sga_for_multiple_execution_commentary"));
        this.propertiesValues.add(executionCountProperty);
    }

    public int getExecutionCountPerSGAForMultipleExecution() throws ParseException {
        return this.readIntegerProperty(PROPERTY_KEY_OF_EXECUTION_COUNT_PER_SGA_FOR_MULTIPLE_EXECUTION, null);
    }

    public void setDescription(String description) {
        if (description != null) {
            Map<String, String> descriptionProperty = this.createProperty(PROPERTY_KEY_OF_DESCRIPTION, description, this.getMessage("msg_description_commentary"));
            this.propertiesValues.add(descriptionProperty);
        }
    }

    public String getDescription() {
        return this.properties.getProperty(PROPERTY_KEY_OF_DESCRIPTION);
    }

    public void setExecutionType(ExecutionType executionType) {
        Map<String, String> executionTypeProperty = this.createProperty(PROPERTY_KEY_OF_EXECUTION_TYPE, executionType.name(), this.getMessage("msg_execution_type_commentary"));
        this.propertiesValues.add(executionTypeProperty);
    }

    public ExecutionType getExecutionType() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_EXECUTION_TYPE, ExecutionType.class, ExecutionType.SIMPLE);
    }

    public void setGlobalPosition(Integer globalPosition) {
        Map<String, String> globalPositionProperty = this.createProperty(PROPERTY_KEY_OF_GLOBAL_POSITION, Integer.toString(globalPosition), this.getMessage("msg_global_position_commentary"));
        this.propertiesValues.add(globalPositionProperty);
    }

    public Integer getGlobalPosition() throws ParseException {
        return this.readIntegerProperty(PROPERTY_KEY_OF_GLOBAL_POSITION, -1);
    }

    public void setId(String id) {
        Map<String, String> idProperty = this.createProperty(PROPERTY_KEY_OF_ID, id, this.getMessage("msg_id_commentary"));
        this.propertiesValues.add(idProperty);
    }

    public String getId() throws ParseException {
        String id = this.properties.getProperty(PROPERTY_KEY_OF_ID);
        if (id == null) {
            String errorMessage = String.format(this.getMessage("error_property_not_found"), PROPERTY_KEY_OF_ID);
            throw new ParseException(errorMessage);
        }
        return id;
    }

    public void setIsAutomatic(boolean isAutomatic) {
        Map<String, String> isAutomaticProperty = this.createProperty(PROPERTY_KEY_OF_IS_AUTOMATIC, Boolean.toString(isAutomatic), this.getMessage("msg_is_automatic_commentary"));
        this.propertiesValues.add(isAutomaticProperty);
    }

    public boolean getIsAutomatic() throws ParseException {
        return this.readBooleanProperty(PROPERTY_KEY_OF_IS_AUTOMATIC, true);
    }

    public void setMailAtEnd(boolean mailAtEnd) {
        Map<String, String> mailAtEndProperty = this.createProperty(PROPERTY_KEY_OF_MAIL_AT_END, Boolean.toString(mailAtEnd), this.getMessage("msg_mail_at_end_commentary"));
        this.propertiesValues.add(mailAtEndProperty);
    }

    public boolean getMailAtEnd() throws ParseException {
        return this.readBooleanProperty(PROPERTY_KEY_OF_MAIL_AT_END, false);
    }

    public void setPlatformFilter(String platformFilter) {
        if (platformFilter != null) {
            Map<String, String> platformFilterProperty = this.createProperty(PROPERTY_KEY_OF_PLATFORM_FILTER, platformFilter, this.getMessage("msg_platform_filter_commentary"));
            this.propertiesValues.add(platformFilterProperty);
        }
    }

    public String getPlatformFilter() {
        return this.properties.getProperty(PROPERTY_KEY_OF_PLATFORM_FILTER);
    }

    public void setPriority(Priority priority) {
        if (null == priority) {
            return;
        }
        Map<String, String> priorityProperty = this.createProperty(PROPERTY_KEY_OF_PRIORITY, priority.name(), this.getMessage("msg_priority_commentary"));
        this.propertiesValues.add(priorityProperty);
    }

    public Priority getPriority() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_PRIORITY, Priority.class, null, false);
    }

    public void setSelectedSGAsNames(List<String> sgasNames) {
        String sgasNamesString = "";
        String sep = "";
        for (String sgaName : sgasNames) {
            sgasNamesString = sgasNamesString + sep + sgaName;
            sep = ",";
        }
        Map<String, String> sgasNamesProperty = this.createProperty(PROPERTY_KEY_OF_SELECTED_SGAS_NAMES, sgasNamesString, this.getMessage("msg_selected_sgas_names_commentary"));
        this.propertiesValues.add(sgasNamesProperty);
    }

    public String getSelectedSGAName() throws ParseException {
        List<String> selectedSGAsNames = this.getSelectedSGAsNames();
        if (selectedSGAsNames.size() != 1) {
            String errorMessage = String.format(this.getMessage("error_wrong_selected_sganame_format"), PROPERTY_KEY_OF_SELECTED_SGAS_NAMES, ",");
            throw new ParseException(errorMessage);
        }
        return selectedSGAsNames.get(0);
    }

    public List<String> getSelectedSGAsNames() throws ParseException {
        String property = this.properties.getProperty(PROPERTY_KEY_OF_SELECTED_SGAS_NAMES);
        if (property == null) {
            throw new ParseException(String.format(this.getMessage("error_property_not_found"), PROPERTY_KEY_OF_SELECTED_SGAS_NAMES));
        }
        ArrayList<String> selectedSGAsNames = new ArrayList<String>();
        for (String sgaName : property.split(",")) {
            selectedSGAsNames.add(sgaName);
        }
        return selectedSGAsNames;
    }

    public void setSGAName(String sgaName) {
        if (sgaName != null) {
            Map<String, String> sgaNameProperty = this.createProperty(PROPERTY_KEY_OF_SGA_NAME, sgaName, this.getMessage("msg_sga_name_commentary"));
            this.propertiesValues.add(sgaNameProperty);
        }
    }

    public String getSGAName() {
        return this.properties.getProperty(PROPERTY_KEY_OF_SGA_NAME);
    }

    public void setStatus(CommandStatus status) {
        Map<String, String> statusProperty = this.createProperty(PROPERTY_KEY_OF_STATUS, status.name(), this.getMessage("msg_status_commentary"));
        this.propertiesValues.add(statusProperty);
    }

    public CommandStatus getStatus() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_STATUS, CommandStatus.class, CommandStatus.FINISHED);
    }

    protected void setExitCode(Integer exitCode) {
        if (exitCode != null) {
            Map<String, String> exitCodeProperty = this.createProperty(PROPERTY_KEY_OF_EXIT_CODE, String.valueOf(exitCode), this.getMessage("msg_exit_code_commentary"));
            this.propertiesValues.add(exitCodeProperty);
        }
    }

    public void setFinalizationInfo(CommandFinalizationInfo finalizationInfo) {
        if (finalizationInfo != null) {
            CommandFinalizationInfo.FinalizationInfoType infoType = finalizationInfo.getInfoType();
            if (infoType == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
                this.setExtendedFinalizationInfo((ExtendedCommandFinalizationInfo)finalizationInfo);
            } else {
                this.setSimpleFinalizationInfo(finalizationInfo);
            }
        }
    }

    protected void setSimpleFinalizationInfo(CommandFinalizationInfo finalizationInfo) {
        this.setFinalizationInfoType(finalizationInfo.getInfoType());
        this.setExitCode(finalizationInfo.getExitCode());
        this.setFinalizationType(finalizationInfo.getFinalizationType());
        this.setFailureCause(finalizationInfo.getFailureCause());
        this.setWarningFlag(finalizationInfo.hasWarnings());
    }

    protected void setExtendedFinalizationInfo(ExtendedCommandFinalizationInfo finalizationInfo) {
        this.setSimpleFinalizationInfo((CommandFinalizationInfo)finalizationInfo);
        this.setGuiltyNodeId(finalizationInfo.getGuiltyNodeId());
        Map infos = finalizationInfo.getFinalizationInfos();
        if (infos != null && !infos.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry entry : infos.entrySet()) {
                CommandFinalizationInfo info = (CommandFinalizationInfo)entry.getValue();
                buffer.append(entry.getKey());
                buffer.append(FINALIZATION_INFO_FIELD_SEPARATOR);
                Integer exitCode = info.getExitCode();
                if (exitCode != null) {
                    buffer.append(exitCode);
                }
                buffer.append(FINALIZATION_INFO_FIELD_SEPARATOR);
                buffer.append(info.getFinalizationType());
                buffer.append(FINALIZATION_INFO_FIELD_SEPARATOR);
                buffer.append(info.hasWarnings());
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
                Map<String, String> exitCodeProperty = this.createProperty(PROPERTY_KEY_OF_EXTENDED_FINALIZATION_INFO, buffer.toString(), this.getMessage("msg_extended_finalization_info"));
                this.propertiesValues.add(exitCodeProperty);
            }
        }
    }

    protected void setFinalizationInfoType(CommandFinalizationInfo.FinalizationInfoType infoType) {
        if (infoType != null) {
            Map<String, String> infoTypeProperty = this.createProperty(PROPERTY_KEY_OF_FINALIZATION_INFO_TYPE, infoType.name(), this.getMessage("msg_finalization_info_type_commentary"));
            this.propertiesValues.add(infoTypeProperty);
        }
    }

    public CommandFinalizationInfo.FinalizationInfoType getFinalizationInfoType() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_FINALIZATION_INFO_TYPE, CommandFinalizationInfo.FinalizationInfoType.class, CommandFinalizationInfo.FinalizationInfoType.SIMPLE);
    }

    protected void setGuiltyNodeId(Integer nodeId) {
        if (nodeId != null) {
            Map<String, String> errorNodeIdProperty = this.createProperty(PROPERTY_KEY_OF_GUILTY_NODE_ID, String.valueOf(nodeId), this.getMessage("msg_guilty_node_id"));
            this.propertiesValues.add(errorNodeIdProperty);
        }
    }

    protected Integer getExitCode() throws ParseException {
        return this.readIntegerProperty(PROPERTY_KEY_OF_EXIT_CODE, null, false);
    }

    protected Integer getGuiltyNodeId() throws ParseException {
        return this.readIntegerProperty(PROPERTY_KEY_OF_GUILTY_NODE_ID, null, false);
    }

    public CommandFinalizationInfo getFinalizationInfo() throws ParseException {
        CommandFinalizationInfo.FinalizationInfoType finalizationInfoType = this.getFinalizationInfoType();
        if (finalizationInfoType == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
            return this.getExtendedFinalizationInfo();
        }
        return this.getSimpleFinalizationInfo();
    }

    protected CommandFinalizationInfo getSimpleFinalizationInfo() throws ParseException {
        return new SimpleCommandFinalizationInfo(this.getFinalizationType(), this.hasWarnings(), this.getFailureCause(), this.getExitCode());
    }

    protected ExtendedCommandFinalizationInfo getExtendedFinalizationInfo() throws ParseException {
        CommandFinalizationInfo simpleFinalizationInfo = this.getSimpleFinalizationInfo();
        ExtendedCommandFinalizationInfo extendedInfo = new ExtendedCommandFinalizationInfo(simpleFinalizationInfo);
        extendedInfo.setGuiltyNodeId(this.getGuiltyNodeId());
        String extendedInfoProperty = this.properties.getProperty(PROPERTY_KEY_OF_EXTENDED_FINALIZATION_INFO);
        if (extendedInfoProperty != null) {
            try {
                String[] exitCodes;
                for (String entry : exitCodes = extendedInfoProperty.split(",")) {
                    boolean hasWarnings;
                    CommandFinalizationType type;
                    Integer exitCode;
                    Integer id;
                    String[] splittedEntry = entry.split(FINALIZATION_INFO_FIELD_SEPARATOR);
                    if (splittedEntry.length >= 3) {
                        id = Integer.parseInt(splittedEntry[0]);
                        exitCode = null;
                        if (!splittedEntry[1].trim().isEmpty()) {
                            exitCode = Integer.parseInt(splittedEntry[1]);
                        }
                        type = CommandFinalizationType.UNKNOWN;
                        if (!splittedEntry[2].trim().isEmpty()) {
                            type = Enum.valueOf(CommandFinalizationType.class, splittedEntry[2].trim());
                        }
                        hasWarnings = false;
                        if (splittedEntry.length == 4 && !splittedEntry[3].trim().isEmpty()) {
                            hasWarnings = Boolean.parseBoolean(splittedEntry[3].trim());
                        }
                    } else {
                        String errorMessage = String.format(this.getMessage("error_must_be_extended_finalization_info_property"), PROPERTY_KEY_OF_EXTENDED_FINALIZATION_INFO, extendedInfoProperty);
                        throw new ParseException(errorMessage);
                    }
                    SimpleCommandFinalizationInfo info = new SimpleCommandFinalizationInfo(type, hasWarnings, exitCode);
                    extendedInfo.setFinalizationInfoForNode((CommandFinalizationInfo)info, id.intValue());
                }
            }
            catch (NullPointerException exitCodes) {
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format(this.getMessage("error_must_be_extended_finalization_info_property"), PROPERTY_KEY_OF_EXTENDED_FINALIZATION_INFO, extendedInfoProperty);
                throw new ParseException(errorMessage);
            }
        }
        return extendedInfo;
    }

    public void setFailureCause(FailureFinalizationType failureCause) {
        if (failureCause != null) {
            Map<String, String> descriptionProperty = this.createProperty(PROPERTY_KEY_OF_FINALIZATION_FAILURE_TYPE, failureCause.name(), this.getMessage("msg_finalization_failure_commentary"));
            this.propertiesValues.add(descriptionProperty);
        }
    }

    public void setWarningFlag(boolean hasWarnings) {
        Map<String, String> warningsProperty = this.createProperty(PROPERTY_KEY_OF_WARNING_FLAG, String.valueOf(hasWarnings), this.getMessage("msg_warning_flag_commentary"));
        this.propertiesValues.add(warningsProperty);
    }

    public void setFinalizationType(CommandFinalizationType finalizationType) {
        Map<String, String> statusProperty = this.createProperty(PROPERTY_KEY_OF_FINALIZATION_TYPE, finalizationType.name(), this.getMessage("msg_finalization_type_commentary"));
        this.propertiesValues.add(statusProperty);
    }

    protected CommandFinalizationType getFinalizationType() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_FINALIZATION_TYPE, CommandFinalizationType.class, CommandFinalizationType.UNKNOWN);
    }

    protected FailureFinalizationType getFailureCause() throws ParseException {
        return this.readEnumProperty(PROPERTY_KEY_OF_FINALIZATION_FAILURE_TYPE, FailureFinalizationType.class, null);
    }

    protected boolean hasWarnings() throws ParseException {
        return this.readBooleanProperty(PROPERTY_KEY_OF_WARNING_FLAG, false);
    }

    public void setSubmittedDate(Date submittedDate) {
        if (submittedDate != null) {
            long startTime = submittedDate.getTime();
            Map<String, String> submittedDateProperty = this.createProperty(PROPERTY_KEY_OF_SUBMITTED_DATE, Long.toString(submittedDate.getTime()), String.format(this.getMessage("msg_submitted_date_commentary"), startTime));
            this.propertiesValues.add(submittedDateProperty);
        }
    }

    public Date getSubmittedDate() throws ParseException {
        String startDateProperty = this.properties.getProperty(PROPERTY_KEY_OF_SUBMITTED_DATE);
        if (startDateProperty != null) {
            try {
                return new Date(Long.parseLong(startDateProperty));
            }
            catch (NumberFormatException e) {
                String errorMessage = String.format(this.getMessage("error_must_be_integer_property"), PROPERTY_KEY_OF_SUBMITTED_DATE, startDateProperty);
                throw new ParseException(errorMessage);
            }
        }
        return null;
    }

    public void setWallTimeSec(Integer wallTimeSec) {
        if (wallTimeSec != null) {
            Map<String, String> wallTimeSecProperty = this.createProperty(PROPERTY_KEY_OF_WALL_TIME_SEC, Integer.toString(wallTimeSec), this.getMessage("msg_wall_time_commentary"));
            this.propertiesValues.add(wallTimeSecProperty);
        }
    }

    public Integer getWallTimeSec() throws ParseException {
        String wallTimeSecProperty = this.properties.getProperty(PROPERTY_KEY_OF_WALL_TIME_SEC);
        if (wallTimeSecProperty != null) {
            try {
                return Integer.valueOf(wallTimeSecProperty);
            }
            catch (NumberFormatException e) {
                String errorMessage = String.format(this.getMessage("error_must_be_integer_property"), PROPERTY_KEY_OF_WALL_TIME_SEC, wallTimeSecProperty);
                throw new ParseException(errorMessage);
            }
        }
        return null;
    }

    public void setTip(String tip) {
        if (tip != null) {
            Map<String, String> tipProperty = this.createProperty(PROPERTY_KEY_OF_TIP, tip, this.getMessage("msg_tip_commentary"));
            this.propertiesValues.add(tipProperty);
        }
    }

    public String getTip() {
        return this.properties.getProperty(PROPERTY_KEY_OF_TIP);
    }

    public void setUserId(Object userId) {
        Map<String, String> userIdProperty = this.createProperty(PROPERTY_KEY_OF_USER_ID, (String)userId, this.getMessage("msg_user_id_commentary"));
        this.propertiesValues.add(userIdProperty);
    }

    public String getUserId() {
        return this.properties.getProperty(PROPERTY_KEY_OF_USER_ID);
    }

    public void saveProperties(OutputStream outputStream) throws IOException {
        for (Map<String, String> property : this.propertiesValues) {
            String[] propertyCommentLines;
            String propertyComment = property.get(PROPERTY_COMMENT);
            String propertyKey = property.get(PROPERTY_KEY);
            String propertyValue = property.get(PROPERTY_VALUE);
            for (String propertyCommentLine : propertyCommentLines = propertyComment.split("\n")) {
                this.saveText(outputStream, String.format("# %s\n", propertyCommentLine));
            }
            this.saveText(outputStream, String.format("%s = %s\n", propertyKey, propertyValue));
        }
        outputStream.flush();
    }

    public void loadProperties(InputStream inputStream) throws IOException {
        this.properties = new Properties();
        this.properties.load(inputStream);
    }

    private void saveText(OutputStream outputStream, String text) throws IOException {
        byte[] bytes = text.getBytes(ENCODING);
        outputStream.write(bytes);
    }
}

