/**
 * $Id$
 */
package csbase.server.services.diagnosticservice.monitors.csfs;

import java.util.Locale;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.remote.DiagnosticServiceInterface;
import csbase.server.services.csfsservice.CSFSService;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.AbstractMonitor;

/**
 * Monitor que verifica o estado do servidor CSFS.
 * 
 * @author Tecgraf PUC-Rio
 */
public class CSFSMonitor extends AbstractMonitor {
  /**
   * Construtor
   * 
   * @throws ResourceException se algum dos parmetros informados estiver
   *         invlido
   */
  public CSFSMonitor() throws ResourceException {
    super(DiagnosticServiceInterface.CSFS_RESOURCE);
    this.addValidation(new CSFSServiceValidation());
    this.addValidation(new CSFSConnectionValidation());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public synchronized Status checkResource(Locale locale)
    throws ResourceException {
    this.cleanProperties();
    String host = CSFSService.getInstance().getHost();
    int port = CSFSService.getInstance().getPort();
    String corbalocPattern = CSFSService.getInstance().getCorbalocPattern();
    this.addProperty(
      MessageTranslator.getString("server.csfsmonitor.host.label", locale),
      String.valueOf(host), "CSFSService.CSFS_HOST");
    this.addProperty(
      MessageTranslator.getString("server.csfsmonitor.port.label", locale),
      String.valueOf(port), "CSFSService.CSFS_PORT");
    this.addProperty(
      MessageTranslator.getString("server.csfsmonitor.corbaloc.label", locale),
      String.valueOf(corbalocPattern), "CSFSService.CSFS_CORBALOC_PATTERN");
    return super.checkResource(locale);
  }
}
