package csbase.server.services.ftcservice;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

import csbase.server.Server;

/**
 * Representao padro para um fornecedor de arquivo. Funciona para arquivos do
 * file system local que no usem nenhum mecanismo de lock.
 * 
 * @author Tecgraf
 */
public class FTCRequesterImpl implements FTCRequester {
  /**
   * RandomAccessFile de acesso ao arquivo.
   */
  private RandomAccessFile raf = null;

  /**
   * {@inheritDoc}
   */
  @Override
  public FileChannel createFileChannel(File file, boolean readOnly)
    throws Exception {
    raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
    return raf.getChannel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isLocked(File file) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void fileChannelClosed(File file) throws Exception {
    raf.close();
    Server.logInfoMessage(String.format(
      "fileChannelClosed: FTCRequesterImpl, path=%s", file.getAbsolutePath()));
    raf = null;
  }
}