/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CapacityType;
import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SGASetCPUAndIOComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.sgaservice.SGAService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CPUIOCapacityPolicy
implements SchedulerPolicyInterface {
    private long minWritingCap;
    private long maxWritingCap;
    private long minSendCap;
    private long maxSendCap;
    private double minProcCap;
    private double maxProcCap;
    private SGAService sgaService = SGAService.getInstance();

    private void initializeExtremes(List<String> serversNames) {
        long transferCap;
        long cpuCap;
        long writeCap;
        SGASet sga;
        if (serversNames.size() > 0) {
            String sgaName = serversNames.get(0);
            sga = this.sgaService.getSGASet(sgaName);
            writeCap = sga.getCapacity(CapacityType.DISK_WRITE);
            if (writeCap == -1L) {
                writeCap = 1L;
            }
            this.minWritingCap = writeCap;
            this.maxWritingCap = writeCap;
            cpuCap = sga.getCapacity(CapacityType.CPU);
            if (cpuCap == -1L) {
                cpuCap = 1L;
            }
            this.minProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            this.maxProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            transferCap = sga.getCapacity(CapacityType.NET);
            if (transferCap == -1L) {
                transferCap = 1L;
            } else if (transferCap == -2L) {
                transferCap = Long.MAX_VALUE;
            }
            this.minSendCap = transferCap;
            this.maxSendCap = transferCap;
        }
        for (int i = 1; i < serversNames.size(); ++i) {
            sga = this.sgaService.getSGASet(serversNames.get(i));
            writeCap = sga.getCapacity(CapacityType.DISK_WRITE);
            if (writeCap == -1L) {
                writeCap = 1L;
            }
            if (writeCap < this.minWritingCap) {
                this.minWritingCap = writeCap;
            } else if (writeCap > this.maxWritingCap) {
                this.maxWritingCap = writeCap;
            }
            cpuCap = sga.getCapacity(CapacityType.CPU);
            if (cpuCap == -1L) {
                cpuCap = 1L;
            }
            if (1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap < this.minProcCap) {
                this.minProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            } else if (1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap > this.maxProcCap) {
                this.maxProcCap = 1.0 / (sga.getCPULoad1() + 1.0) * (double)cpuCap;
            }
            transferCap = sga.getCapacity(CapacityType.NET);
            if (transferCap == -1L) {
                transferCap = 1L;
            } else if (transferCap == -2L) {
                transferCap = Long.MAX_VALUE;
            }
            if (transferCap < this.minSendCap) {
                this.minSendCap = transferCap;
                continue;
            }
            if (transferCap <= this.maxSendCap) continue;
            this.maxSendCap = transferCap;
        }
    }

    @Override
    public String chooseServer(CommandInfo command, List<String> serversNames) {
        this.initializeExtremes(serversNames);
        List<String> sgasNames = this.getSortedSGAByCPUAndIOCapacity(serversNames);
        if (sgasNames.size() != 0) {
            return sgasNames.get(0);
        }
        return null;
    }

    @Override
    public List<String> chooseServers(CommandInfo command, List<String> serversNames, int numServers) {
        this.initializeExtremes(serversNames);
        List<String> sgasNames = this.getSortedSGAByCPUAndIOCapacity(serversNames);
        if (sgasNames.size() >= numServers) {
            return sgasNames.subList(0, numServers);
        }
        return null;
    }

    private List<String> getSortedSGAByCPUAndIOCapacity(List<String> serversNames) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        ArrayList<String> sgasNames = new ArrayList<String>();
        SGAService sgaService = SGAService.getInstance();
        for (int i = 0; i < serversNames.size(); ++i) {
            SGASet sgaSet = sgaService.getSGASet(serversNames.get(i));
            if (sgaSet == null) continue;
            sgasSets.add(sgaSet);
        }
        Collections.sort(sgasSets, new SGASetCPUAndIOComparator(serversNames, this.minWritingCap, this.maxWritingCap, this.minProcCap, this.maxProcCap, this.minSendCap, this.maxSendCap));
        for (SGASet sga : sgasSets) {
            sgasNames.add(sga.getName());
        }
        return sgasNames;
    }
}

