package csbase.server.services.repositoryservice;

/**
 * Classe base para as implementaes de repositrio onde a URI define o
 * identificador nico do repositrio.
 * 
 * NOTA: Essa classe  de visibilidade restrita ao pacote, pois s o
 * {@link RepositoryService} pode manipular instncias de suas subclasses.
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract class AbstractRepository implements IRepository {

  /** Identificador nico do repositrio. */
  protected final String uri;

  /**
   * Construtor.
   * 
   * @param uri identificador nico do repositrio.
   */
  protected AbstractRepository(String uri) {
    if (uri == null) {
      throw new IllegalArgumentException("uri no pode ser nulo.");
    }
    this.uri = uri;
  }

  /** {@inheritDoc} */
  @Override
  public String getURI() {
    return uri;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return uri;
  }
}
