/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.algorithmservice;

import com.fasterxml.jackson.databind.ObjectMapper;
import csbase.exception.BugException;
import csbase.exception.ConfigurationException;
import csbase.exception.HttpServiceException;
import csbase.exception.InfoException;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.exception.algorithms.CategoriesFileNotSavedException;
import csbase.logic.AlgoEvent;
import csbase.logic.AlgorithmAdminPermission;
import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.AlgorithmsReloadNotification;
import csbase.logic.AttributesPermission;
import csbase.logic.CategoryAlgorithmsExecutionPermission;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.User;
import csbase.logic.UserNotification;
import csbase.logic.Utilities;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmOutline;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.AlgorithmsPack;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.ConfigurationPathFactory;
import csbase.logic.algorithms.DocumentationPathFactory;
import csbase.logic.algorithms.ExecutablePathFactory;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.HistoryRecord;
import csbase.logic.algorithms.ImportAlgorithmsPackTransferInfo;
import csbase.logic.algorithms.MonitoredFile;
import csbase.logic.algorithms.PAImportOperation;
import csbase.logic.algorithms.ReleaseNotesPathFactory;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.SimpleAlgorithmParser;
import csbase.logic.algorithms.xml.category.XmlCategoriesWriter;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.TransactionCallbackInterface;
import csbase.server.FileSystem;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.TransactionManager;
import csbase.server.plugin.service.algorithmservice.IAlgorithmService;
import csbase.server.services.algorithmservice.Algorithm;
import csbase.server.services.algorithmservice.AlgorithmObserver;
import csbase.server.services.algorithmservice.ImportAlgorithmsPackDataInfo;
import csbase.server.services.ftcservice.FTCRequester;
import csbase.server.services.ftcservice.FTCService;
import csbase.server.services.httpservice.HttpService;
import csbase.server.services.httpservice.UploadHandler;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.util.Unzip;
import csbase.util.ZipUtils;
import csbase.util.messages.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.timestamp.TStamp64;

public class AlgorithmService
extends Service
implements AlgorithmServiceInterface,
IAlgorithmService {
    private final String algorithmRepositoryPath = this.getStringProperty("base.algorithm.dir");
    private static final String DIR_HISTORY_KEY = "_DIR_HISTORY_KEY";
    private static final String ERROR_PARAMETER_NULL = "AlgoService.error.parameter.null";
    private static final String ERROR_PARAMETER_INVALID = "AlgoService.error.parameter.invalid";
    private static final String CATEGORIES_FILE_NAME = "categories.xml";
    private static final String DTD_ALGORITHMS_PACK_FILE_NAME = "DTD_PacoteAlgoritmos.dtd";
    private String ERROR_ALGO_ADMIN_PERMISSION = "AlgoService.error.algo.admin.no_permission";
    private String ERROR_ALGO_EXECUTE_PERMISSION = "AlgoService.error.algo.execute.no_permission";
    private String ERROR_IMPORT_PA_USER_PERMISSION = "AlgoService.error.import.pa.user.no_permission";
    private String ERROR_ALGO_ADMIN_SERVER_PERMISSION = "AlgoService.error.algo.admin.server.no_permission";
    private static final String ERROR_ALGO_NOT_FOUND = "AlgoService.error.algo.not_found";
    private static final String ERROR_CONF_VERSION_NOT_FOUND = "server.algoservice.error.conf_version_not_found";
    private static final String ERROR_RENAME = "server.algoservice.error.rename";
    private static final String ERROR_COPY = "server.algoservice.error.copy";
    private static final String ERROR_DOC_VERSION_NOT_FOUND = "server.algoservice.error.doc_version_not_found";
    private static final String ERROR_RELEASE_NOTES_VERSION_NOT_FOUND = "server.algoservice.error.release_notes_version_not_found";
    private static final String ERROR_PLAT_VERSION_NOT_FOUND = "server.algoservice.error.plat_version_not_found";
    private static final String ERROR_VERSION_NOT_FOUND = "AlgoService.error.version.not_found";
    private static final String HISTORY_COPY_FILE = "server.algoservice.history.copy_file";
    private static final String HISTORY_COPY_DIRECTORY = "server.algoservice.history.copy_directory";
    private static final String HISTORY_CREATE_ALGORITHM = "server.algoservice.history.create_algorithm";
    private static final String HISTORY_CREATE_VERSION = "server.algoservice.history.create_version";
    private static final String HISTORY_DUPLICATE_VERSION = "server.algoservice.history.duplicate_version";
    private static final String HISTORY_INCLUDE_PLATFORM = "server.algoservice.history.include_platform";
    private static final String HISTORY_REMOVE_ALGORITHM = "server.algoservice.history.remove_algorithm";
    private static final String HISTORY_RENAME_ALGORITHM = "server.algoservice.history.rename_algorithm";
    private static final String HISTORY_REMOVE_FILE = "server.algoservice.history.remove_file";
    private static final String HISTORY_REMOVE_PLATFORM = "server.algoservice.history.remove_platform";
    private static final String HISTORY_REMOVE_VERSION = "server.algoservice.history.remove_version";
    private static final String HISTORY_TABLE_FILE_NAME = ".algorithms.csbase_history";
    private static final String HISTORY_UPDATE_CONFIGURATOR = "server.algoservice.history.update_configurator";
    private static final String HISTORY_UPDATE_DOC = "server.algoservice.history.update_doc";
    private static final String HISTORY_UPDATE_RELEASE_NOTES = "server.algoservice.history.update_release_notes";
    private static final String HISTORY_UPDATE_EXECUTABLE = "server.algoservice.history.update_executable";
    private static final String ZIP_EXTENSION = "zip";
    private static final String ALGO_ID_KEY = "algoId";
    private static final String USER_ID_KEY = "userId";
    private static final String ALGO_FILE_TYPE_KEY = "type";
    private static final String VERSION_ID_KEY = "versionId";
    private static final String PLATFORM_NAME_KEY = "platformName";
    private static final String PROP_RELOAD_ALGS_INTERVAL_IN_MIN = "reloadAlgsIntervalInMinutes";
    private static final String PROP_CLEANUP_TEMP_DIR_INTERVAL_IN_SEC = "temporary.dir.cleanupIntervalInSeconds";
    private static final String PROP_PA_TEMP_DIR = "algorithms.temporary.dir";
    private static final String PROP_PARAMETER_REGISTRY_CLASS = "parameters.registry.class";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String FILE_PATH_KEY = "filePath";
    private static final String EXPAND_IF_ZIP = "expandIfZip";
    private static final String EXCLUDE_TMP_ZIP = "excludeTmpZip";
    private static final String ALGO_PACK_FILE_NAME = "algoritmos.pa";
    private static final String ALGO_PACK_METADATA_FILE_NAME = "pacote_algoritmos.xml";
    private static final String VALID_ALGORITHMS_PACK_MSG = ">> Pacote de Algoritmo v\u00e1lido.\n";
    private static final String INVALID_ALGORITHMS_PACK_MSG = ">> Pacote de Algoritmo inv\u00e1lido.\n";
    private final ParameterRegistry parameterRegistry;
    private boolean shutdown;
    private Hashtable<String, Algorithm> registeredAlgorithms;
    private Properties parametersConfiguration;
    private TransactionManager transaction;
    private ReloadAlgsThread reloadAlgsThread;
    private final String tempDirAlgorithmPath;
    private boolean exitCleanupThread = false;
    private Thread cleanupTempDirThread = null;
    private CategorySet categorySet;
    private boolean isFirstCategoryLoad;
    private ExecutionLocation defaultAlgorithmExecutionLocation;
    private Hashtable<String, ImportAlgorithmsPackDataInfo> algoPackTokenMap;

    protected AlgorithmService() throws ServerException {
        super("AlgorithmService");
        Server.logInfoMessage("Diret\u00f3rio base de algoritmos: " + this.algorithmRepositoryPath);
        if (this.getAndCheckAlgoRootDir() == null) {
            File algorithDir = new File(this.algorithmRepositoryPath);
            try {
                System.out.println(MessageFormat.format("\nVerifique a propriedade AlgorithmService.base.algorithm.dir que define o diret\u00f3rio base de algoritmos, pois o diret\u00f3rio {0} n\u00e3o existe.\n", algorithDir.getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ServerException(this.getMessageFormatted("AlgoService.error.algo.dir_not_found", this.algorithmRepositoryPath));
        }
        this.tempDirAlgorithmPath = this.getStringProperty(PROP_PA_TEMP_DIR);
        Server.logInfoMessage("Diret\u00f3rio tempor\u00e1rio para importa\u00e7\u00e3o/exporta\u00e7\u00e3o de algoritmos a partir de um PA: " + this.tempDirAlgorithmPath);
        String registryClass = this.getStringProperty(PROP_PARAMETER_REGISTRY_CLASS);
        try {
            this.parameterRegistry = this.createParameterRegistry(registryClass);
        }
        catch (OperationFailureException e) {
            throw new ServerException(e);
        }
        this.categorySet = new CategorySet();
        this.algoPackTokenMap = new Hashtable();
        ClientRemoteLocator.algorithmService = this;
    }

    private ParameterRegistry createParameterRegistry(String registryClassName) throws OperationFailureException {
        ParameterRegistry registry;
        Constructor<?> registryConstructor;
        Class<?> registryClass;
        try {
            registryClass = Class.forName(registryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailureException("A classe {0} n\u00e3o foi encontrada.", new Object[]{registryClassName});
        }
        if (!ParameterRegistry.class.isAssignableFrom(registryClass)) {
            throw new OperationFailureException("A classe {0} n\u00e3o implementa a interface necess\u00e1ria {1}.", new Object[]{registryClassName, ParameterFactory.class.getName()});
        }
        try {
            registryConstructor = registryClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OperationFailureException("N\u00e3o existe um construtor vazio em {0}.", new Object[]{registryClassName});
        }
        try {
            registry = (ParameterRegistry)registryConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new OperationFailureException(MessageFormat.format("N\u00e3o foi poss\u00edvel construir o registro {0}.", registryClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OperationFailureException(MessageFormat.format("Construtor do registro {0} n\u00e3o aceita os par\u00e2metros usados.", registryClassName), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OperationFailureException(MessageFormat.format("Erro ao construir o registro de par\u00e2metros {0}.", registryClassName), e.getTargetException());
        }
        return registry;
    }

    public static void createService() throws ServerException {
        new AlgorithmService();
    }

    public static AlgorithmService getInstance() {
        return (AlgorithmService)AlgorithmService.getInstance("AlgorithmService");
    }

    public boolean algorithmIdRegistered(Object id) {
        return this.registeredAlgorithms.get(id) != null;
    }

    public ParameterRegistry getParameterRegistry() {
        return this.parameterRegistry;
    }

    public synchronized AlgorithmInfo changeAlgorithmProperties(String algoName, Hashtable<String, String> newValues) throws AlgorithmNotFoundException {
        User user = Service.getUser();
        if (!user.isAdmin() && !this.isAlgorithmOwnerUser(algoName)) {
            this.checkAlgorithmAdminPermission(algoName);
        }
        Algorithm algorithm = this.getAlgorithm(algoName);
        algorithm.setAlgorithmFieldValuesList(newValues);
        AlgorithmInfo algoInfo = algorithm.getInfo();
        Server.logInfoMessage("Algoritmo " + algoName + " modificado em " + algoInfo.getDirectory() + " (apenas propriedades)");
        this.fireModifyEvent(algoInfo);
        return algoInfo;
    }

    public synchronized AlgorithmInfo renameAlgorithm(Object algoId, String name) throws RemoteException {
        AlgorithmInfo info;
        this.checkAlgorithmAdminPermission(algoId);
        if (name == null || name.trim().length() == 0) {
            String msg = this.getMessageFormatted("AlgoService.error.algo.invalid_name", new Object[0]);
            throw new ServiceFailureException(msg);
        }
        String newName = name.trim();
        for (Algorithm algorithm : this.registeredAlgorithms.values()) {
            info = algorithm.getInfo();
            String algoName = info.getName().trim();
            if (!algoName.equals(newName)) continue;
            String msg = this.getMessageFormatted("AlgoService.error.algo.existing_name", newName);
            throw new ServiceFailureException(msg);
        }
        Algorithm algorithm = this.registeredAlgorithms.get(algoId);
        String currentName = algorithm.getInfo().getName();
        try {
            algorithm.rename(newName);
        }
        catch (ServerException e) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.rename_failed", currentName, newName), e);
            return null;
        }
        info = algorithm.getInfo();
        Map historyTable = this.readHistoryTable();
        if (historyTable != null) {
            Object algoHistory = historyTable.remove(currentName);
            historyTable.put(newName, algoHistory);
            this.writeHistoryTable(historyTable);
            String[] path = new String[]{this.getSymbolicRootName(), newName};
            String description = this.getMessageFormatted(HISTORY_RENAME_ALGORITHM, currentName, newName);
            this.appendHistory(path, description);
        }
        Server.logInfoMessage("Algoritmo " + currentName + " renomeado para " + newName);
        this.fireModifyEvent(info);
        return info;
    }

    public synchronized AlgorithmInfo changeVersionProperties(String algoName, AlgorithmVersionId versionId, Hashtable<String, String> newValues) throws AlgorithmNotFoundException {
        User user = Service.getUser();
        if (!user.isAdmin() && !this.isAlgorithmOwnerUser(algoName)) {
            this.checkAlgorithmAdminPermission(algoName);
        }
        Algorithm algorithm = this.getAlgorithm(algoName);
        algorithm.setVersionFieldValuesList(versionId, newValues);
        AlgorithmInfo algoInfo = this.getInfo(algoName);
        Server.logInfoMessage("Vers\u00e3o " + versionId + " do algoritmo " + algoName + " modificada (apenas propriedades)");
        this.fireModifyEvent(algoInfo);
        return algoInfo;
    }

    private String getSymbolicRootName() {
        return "algorithms";
    }

    public synchronized void copyFiles(AlgorithmVersionInfo sourceVersion, List<FileInfo> files, IPathFactory sourcePathFactory, AlgorithmVersionInfo targetVersion, FileInfo targetDir, IPathFactory targetPathFactory, boolean setExecutables) {
        if (null == sourceVersion) {
            throw new IllegalArgumentException(this.getParameterNullMessage("sourceVersion"));
        }
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException(this.getParameterNullMessage("files"));
        }
        if (null == sourcePathFactory) {
            throw new IllegalArgumentException(this.getParameterNullMessage("sourcePathFactory"));
        }
        if (null == targetVersion) {
            throw new IllegalArgumentException(this.getParameterNullMessage("targetVersion"));
        }
        if (null == targetPathFactory) {
            throw new IllegalArgumentException(this.getParameterNullMessage("targetPathFactory"));
        }
        String sourceAlgorithmId = sourceVersion.getInfo().getId();
        Algorithm sourceAlgorithm = this.registeredAlgorithms.get(sourceAlgorithmId);
        if (null == sourceAlgorithm) {
            throw new ServiceFailureException(this.getAlgoNotFoundMessage(sourceAlgorithmId));
        }
        String targetAlgorithmId = targetVersion.getInfo().getId();
        this.checkAlgorithmAdminPermission((Object)targetAlgorithmId);
        Algorithm targetAlgorithm = this.registeredAlgorithms.get(targetAlgorithmId);
        ArrayList<Algorithm.ICopyRecord> records = new ArrayList<Algorithm.ICopyRecord>();
        try {
            targetAlgorithm.copyFiles(files, sourcePathFactory, targetDir, targetPathFactory, setExecutables, records);
        }
        catch (InfoException ex) {
            throw ex;
        }
        catch (Exception e) {
            StringBuilder fileName = new StringBuilder();
            for (int inx = 0; inx < files.size(); ++inx) {
                if (inx > 0) {
                    fileName.append(", ");
                }
                fileName.append(files.get(inx).getPath());
            }
            throw new ServiceFailureException(this.getMessageFormatted(ERROR_COPY, fileName, targetVersion.getId(), targetAlgorithmId), (Throwable)e);
        }
        for (Algorithm.ICopyRecord record : records) {
            if (record.isDirectory()) {
                Algorithm.CopyDirectoryRecord directoryRecord = (Algorithm.CopyDirectoryRecord)record;
                String path = this.getHistoryPath(sourceVersion, targetPathFactory, directoryRecord.getDirectory());
                String description = this.getMessageFormatted(HISTORY_COPY_DIRECTORY, directoryRecord.getDirectory().getPath());
                this.appendHistory(Utilities.splitProjectPath((String)path), description);
                continue;
            }
            Algorithm.CopyFileRecord fileRecord = (Algorithm.CopyFileRecord)record;
            String sourcePath = this.getHistoryPath(sourceVersion, sourcePathFactory, fileRecord.getSourceFile());
            String targetPath = this.getHistoryPath(targetVersion, targetPathFactory, fileRecord.getTargetFile());
            String description = this.getMessageFormatted(HISTORY_COPY_FILE, fileRecord.getTargetFile().getPath(), sourcePath);
            this.appendHistory(Utilities.splitProjectPath((String)targetPath), description);
        }
        for (Algorithm.ICopyRecord record : records) {
            if (!record.wasCreated()) continue;
            this.fireModifyEvent(targetAlgorithm.getInfo());
            break;
        }
    }

    public synchronized AlgorithmInfo createAlgorithm(String algoName, String algoId, Hashtable<String, String> atributeValues) throws PermissionException {
        User user = Service.getUser();
        if (!user.isAdmin()) {
            this.checkAlgorithmAdminPermission(algoName);
        }
        Algorithm algo = null;
        try {
            algo = Algorithm.createAlgorithm(algoId, algoName, atributeValues);
        }
        catch (Exception e) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.create_failed", algoName), e);
            return null;
        }
        AlgorithmInfo algoInfo = algo.getInfo();
        this.registeredAlgorithms.put(algoInfo.getId(), algo);
        Server.logInfoMessage("Algoritmo " + algoName + " criado em " + algoInfo.getDirectory());
        String[] path = new String[]{this.getSymbolicRootName()};
        String description = this.getMessageFormatted(HISTORY_CREATE_ALGORITHM, algoName);
        this.appendHistory(path, description);
        AlgoEvent action = new AlgoEvent(1, (Object)algoInfo);
        this.sendEvent(action);
        return algoInfo;
    }

    public synchronized AlgorithmConfigurator createAlgorithmConfigurator(String algorithmName, AlgorithmVersionId algorithmVersionId) throws AlgorithmNotFoundException {
        if (algorithmName == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("algorithmName"));
        }
        if (algorithmVersionId == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("algorithmVersionId"));
        }
        Algorithm algorithm = this.getAlgorithm(algorithmName);
        AlgorithmInfo algorithmInfo = algorithm.getInfo();
        AlgorithmVersionInfo version = algorithmInfo.getVersionInfo((Object)algorithmVersionId);
        if (version == null) {
            throw new AlgorithmNotFoundException(this.getVersionNotFoundMessage(algorithmInfo.getId(), algorithmVersionId));
        }
        try {
            SimpleAlgorithmConfigurator simpleConfigurator = this.createSimpleAlgorithmConfigurator(version);
            if (simpleConfigurator != null) {
                return simpleConfigurator;
            }
            FlowAlgorithmConfigurator flowConfigurator = this.createFlowAlgorithmConfigurator(version);
            if (flowConfigurator != null) {
                return flowConfigurator;
            }
        }
        catch (ParseException e) {
            throw new ServiceFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        throw new ServiceFailureException(this.getMessageFormatted("error_no_component", version.getInfo(), version, "config.xml", "config.flx"));
    }

    public synchronized AlgorithmInfo createVersion(Object algoId, int major, int minor, int patch, Hashtable<String, String> properties) {
        Object versionId;
        this.checkAlgorithmAdminPermission(algoId);
        Server.logInfoMessage("Tentando criar uma vers\u00e3o para o algoritmo: " + algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            versionId = algo.createVersion(major, minor, patch, properties);
        }
        catch (ServerException se) {
            String versionStr = String.format("%d.%d.%d", major, minor, patch);
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.version.create_failed", versionStr, algo.getInfo().getName()), se);
            return null;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName()};
        String description = this.getMessageFormatted(HISTORY_CREATE_VERSION, versionId);
        this.appendHistory(path, description);
        Server.logInfoMessage("Vers\u00e3o " + versionId + " criada para algoritmo " + algo.getInfo().getName());
        this.fireModifyEvent(algo.getInfo());
        return algo.getInfo();
    }

    public synchronized void duplicateVersion(Object algorithmId, Object sourceVersionId, int majorTo, int minorTo, int patchTo) {
        this.checkAlgorithmAdminPermission(algorithmId);
        Server.logInfoMessage("Tentando duplicar uma vers\u00e3o para o algoritmo: " + algorithmId);
        Algorithm algorithm = this.registeredAlgorithms.get(algorithmId);
        AlgorithmInfo algorithmInfo = algorithm.getInfo();
        AlgorithmVersionInfo sourceVersion = algorithmInfo.getVersionInfo(sourceVersionId);
        if (sourceVersion == null) {
            throw new ServiceFailureException(this.getVersionNotFoundMessage(algorithmId, sourceVersion));
        }
        Map properties = sourceVersion.getPropertyValues();
        try {
            Map platforms;
            List configs;
            List docs;
            Object versionIdTo = algorithm.createVersion(majorTo, minorTo, patchTo, properties);
            AlgorithmVersionInfo targetVersion = algorithmInfo.getVersionInfo(versionIdTo);
            FileInfo releaseNotes = sourceVersion.getReleaseNotes();
            if (releaseNotes != null) {
                ReleaseNotesPathFactory sourcePathFactory = new ReleaseNotesPathFactory(sourceVersion);
                ReleaseNotesPathFactory targetPathFactory = new ReleaseNotesPathFactory(targetVersion);
                FileInfo targetDir = null;
                List<Algorithm.ICopyRecord> records = null;
                ArrayList<FileInfo> releaseNotesFiles = new ArrayList<FileInfo>();
                releaseNotesFiles.add(releaseNotes);
                algorithm.copyFilesWithoutReloading(releaseNotesFiles, (IPathFactory)sourcePathFactory, targetDir, (IPathFactory)targetPathFactory, false, records);
            }
            if ((docs = sourceVersion.getDocumentation()) != null) {
                DocumentationPathFactory sourcePathFactory = new DocumentationPathFactory(sourceVersion);
                DocumentationPathFactory targetPathFactory = new DocumentationPathFactory(targetVersion);
                FileInfo targetDir = null;
                List<Algorithm.ICopyRecord> records = null;
                algorithm.copyFilesWithoutReloading(docs, (IPathFactory)sourcePathFactory, targetDir, (IPathFactory)targetPathFactory, false, records);
            }
            if ((configs = sourceVersion.getConfigurators()) != null) {
                ConfigurationPathFactory sourcePathFactory = new ConfigurationPathFactory(sourceVersion);
                ConfigurationPathFactory targetPathFactory = new ConfigurationPathFactory(targetVersion);
                FileInfo targetDir = null;
                List<Algorithm.ICopyRecord> records = null;
                algorithm.copyFilesWithoutReloading(configs, (IPathFactory)sourcePathFactory, targetDir, (IPathFactory)targetPathFactory, false, records);
            }
            if ((platforms = sourceVersion.getPlatforms()) != null) {
                for (String platform : platforms.keySet()) {
                    algorithm.includePlatform(targetVersion.getId(), platform);
                    List execs = (List)platforms.get(platform);
                    ExecutablePathFactory sourcePathFactory = new ExecutablePathFactory(sourceVersion, platform);
                    ExecutablePathFactory targetPathFactory = new ExecutablePathFactory(targetVersion, platform);
                    FileInfo targetDir = null;
                    List<Algorithm.ICopyRecord> records = null;
                    algorithm.copyFilesWithoutReloading(execs, (IPathFactory)sourcePathFactory, targetDir, (IPathFactory)targetPathFactory, true, records);
                }
            }
            algorithm.reload();
            String[] path = new String[]{this.getSymbolicRootName(), algorithm.getInfo().getName()};
            String description = this.getMessageFormatted(HISTORY_DUPLICATE_VERSION, sourceVersion, versionIdTo);
            this.appendHistory(path, description);
            this.fireModifyEvent(algorithmInfo);
        }
        catch (Exception e) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.version.duplicate_failed", algorithmInfo.getName()), e);
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algo.version.create_failed", sourceVersionId, algorithm.getInfo().getName()), (Throwable)e);
        }
    }

    public List<AlgorithmProperty> getAlgorithmProperties() {
        return Algorithm.getAlgorithmProperties();
    }

    public CategorySet getAllCategories() {
        return this.categorySet;
    }

    public Object[] getAllIds() {
        Vector<String> sendList = new Vector<String>();
        for (String id : this.registeredAlgorithms.keySet()) {
            sendList.add(id);
        }
        return sendList.toArray(new Object[sendList.size()]);
    }

    public AlgorithmInfo[] getAllInfo() {
        Enumeration<Algorithm> elements = this.registeredAlgorithms.elements();
        Vector<AlgorithmInfo> sendList = new Vector<AlgorithmInfo>();
        while (elements.hasMoreElements()) {
            Algorithm algo = elements.nextElement();
            sendList.add(algo.getInfo());
        }
        return sendList.toArray(new AlgorithmInfo[sendList.size()]);
    }

    public AlgorithmOutline[] getAllOutlines() {
        if (this.registeredAlgorithms == null) {
            return null;
        }
        Enumeration<Algorithm> elements = this.registeredAlgorithms.elements();
        Vector<AlgorithmOutline> sendList = new Vector<AlgorithmOutline>();
        while (elements.hasMoreElements()) {
            Algorithm algo = elements.nextElement();
            sendList.add(algo.getOutline());
        }
        return sendList.toArray(new AlgorithmOutline[sendList.size()]);
    }

    public AlgorithmInfo getInfo(Object id) throws PermissionException {
        if (id == null) {
            return null;
        }
        Algorithm algo = this.registeredAlgorithms.get(id);
        if (algo == null) {
            return null;
        }
        return algo.getInfo();
    }

    public AlgorithmInfo getInfo(String name) throws PermissionException {
        Collection<Algorithm> algorithmCollection = this.registeredAlgorithms.values();
        for (Algorithm algo : algorithmCollection) {
            AlgorithmInfo info = algo.getInfo();
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public List<AlgorithmProperty> getVersionProperties() {
        return Algorithm.getVersionProperties();
    }

    public synchronized AlgorithmInfo includePlatform(Object algoId, Object versionId, String platform) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.includePlatform(versionId, platform);
        }
        catch (ServerException se) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.platform.create_failed", platform, versionId, algo.getInfo().getName()), se);
            return null;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), AlgorithmVersionInfo.BIN_DIR};
        String description = this.getMessageFormatted(HISTORY_INCLUDE_PLATFORM, platform);
        this.appendHistory(path, description);
        Server.logInfoMessage("Plataforma " + platform + " inserida para vers\u00e3o " + versionId + " do algoritmo " + algo.getInfo().getName());
        this.fireModifyEvent(algo.getInfo());
        return algo.getInfo();
    }

    @Override
    public void initService() throws ServerException {
        this.transaction = new TransactionManager();
        int reloadAlgsIntervalInMinutes = this.getIntProperty(PROP_RELOAD_ALGS_INTERVAL_IN_MIN);
        Server.logInfoMessage("Intervalo de recarga de algoritmos (em min): " + reloadAlgsIntervalInMinutes);
        if (reloadAlgsIntervalInMinutes != 0) {
            this.reloadAlgsThread = new ReloadAlgsThread(reloadAlgsIntervalInMinutes);
            Server.logFineMessage("Thread de recarga de algoritmos criada.");
        }
        this.loadInvalidsAlgoPacksTokens();
        this.createCleanupTempDirThread();
        this.readExecutionLocationConfiguration();
        this.loadParameters();
        this.loadAlgorithms();
        this.isFirstCategoryLoad = true;
        this.loadCategories();
        this.initHistoryTable();
    }

    private void loadInvalidsAlgoPacksTokens() {
        try {
            File[] tokensDirs;
            File tempDir = new File(this.tempDirAlgorithmPath);
            Server.checkDirectory(this.tempDirAlgorithmPath);
            this.algoPackTokenMap = new Hashtable();
            for (File tokenDir : tokensDirs = tempDir.listFiles()) {
                if (!tokenDir.isDirectory() || tokenDir.isHidden()) continue;
                String tokenStr = tokenDir.getName().trim();
                this.algoPackTokenMap.put(tokenStr, new ImportAlgorithmsPackDataInfo());
                Server.logFineMessage("Carregando token inv\u00e1lido:" + tokenStr);
            }
        }
        catch (Exception e) {
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algorithm_pack.tokens.load", this.tempDirAlgorithmPath), (Throwable)e);
        }
    }

    private void createCleanupTempDirThread() {
        int cleanupIntervalInSec = this.getIntProperty(PROP_CLEANUP_TEMP_DIR_INTERVAL_IN_SEC);
        final long sleepTimeMs = cleanupIntervalInSec * 1000;
        Server.logInfoMessage("Intervalo de limpeza de um diret\u00f3rio que representa um token de um PA: " + cleanupIntervalInSec + " segundos.");
        this.cleanupTempDirThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!AlgorithmService.this.exitCleanupThread) {
                        try {
                            AlgorithmService.this.cleanupPATempDir();
                            Thread.sleep(sleepTimeMs);
                        }
                        catch (InterruptedException ie) {
                            Server.logWarningMessage("Grava\u00e7\u00e3o de dados do SGA interrompido!");
                        }
                    }
                    Server.logWarningMessage("Finalizando thread de grava\u00e7\u00e3o de dados...");
                }
                catch (Throwable t) {
                    String msg = new Date() + " - Erro na limpeza do diret\u00f3rio tempor\u00e1rio: " + AlgorithmService.this.tempDirAlgorithmPath;
                    System.err.println(msg);
                    t.printStackTrace(System.err);
                    Server.logSevereMessage(msg, t);
                }
            }
        });
        this.exitCleanupThread = false;
        this.cleanupTempDirThread.setName(((Object)((Object)this)).getClass().getSimpleName() + "::CleanupTempDirThread");
        this.cleanupTempDirThread.start();
        Server.logFineMessage("Cria\u00e7\u00e3o da thread para limpeza do diret\u00f3rio tempor\u00e1rio usado para opera\u00e7\u00f5es de importa\u00e7\u00e3o e exporta\u00e7\u00e3o sobre um PA.");
    }

    protected void cleanupPATempDir() throws RemoteException {
        Enumeration<String> tokens = this.algoPackTokenMap.keys();
        while (tokens.hasMoreElements()) {
            String token = tokens.nextElement();
            this.removeAlgoPackTokensDirs(token);
        }
        this.algoPackTokenMap.clear();
    }

    private void readExecutionLocationConfiguration() throws ServerException {
        String algorithmExecutionLocationString = this.getStringProperty("algorithmExecutionLocation");
        ExecutionLocation.ExecutionLocationConverter converter = new ExecutionLocation.ExecutionLocationConverter();
        try {
            this.defaultAlgorithmExecutionLocation = converter.valueOf(algorithmExecutionLocationString);
        }
        catch (ParseException e) {
            String acceptedValues = "";
            for (ExecutionLocation value : ExecutionLocation.values()) {
                String[] possibleMatches = converter.getPossibleMatches(value);
                for (int i = 0; i < possibleMatches.length; ++i) {
                    String execValue = possibleMatches[i];
                    acceptedValues = acceptedValues + execValue;
                    acceptedValues = acceptedValues + (i == possibleMatches.length - 1 ? "\n" : ", ");
                }
            }
            acceptedValues = acceptedValues.substring(0, acceptedValues.length() - 1);
            throw new ServerException(this.getMessageFormatted("AlgoService.error.algo.execution_location", "algorithmExecutionLocation", this.getName(), algorithmExecutionLocationString, acceptedValues));
        }
    }

    public boolean isLocked() {
        return this.transaction.isLocked();
    }

    public boolean lock(TransactionCallbackInterface cb) {
        this.checkAlgorithmServerAdminPermission();
        return this.transaction.lock(cb);
    }

    public synchronized boolean reloadAlgorithms() {
        return this.reloadAlgorithms(true);
    }

    public synchronized boolean reloadAlgorithms(boolean notifyAllUsers) {
        this.checkAlgorithmServerAdminPermission();
        TransactionCallbackInterface cb = new TransactionCallbackInterface(){

            public boolean isAlive() {
                return true;
            }
        };
        String uName = AlgorithmService.getUser().getName();
        Server.logInfoMessage("Pedido de recarga de algoritmos vinda de " + uName);
        try {
            if (!this.lock(cb)) {
                Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.block_reload_failed", new Object[0]));
                return false;
            }
            this.loadParameters();
            this.loadAlgorithms();
            this.loadCategories();
            this.unlock(cb);
            Server.logInfoMessage("Recarga de algoritmos efetuada!");
            AlgorithmsReloadNotification data = new AlgorithmsReloadNotification(this.getSenderName());
            if (notifyAllUsers) {
                MessageService.getInstance().sendToAll(new Message((Serializable)data));
            } else {
                String[] ids = new String[]{(String)AlgorithmService.getUser().getId()};
                try {
                    MessageService.getInstance().send(new Message((Serializable)data), ids);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Erro ao enviar evento de recarregar lista de algoritmos.", e);
                }
            }
            AlgoEvent action = new AlgoEvent(4, null);
            this.sendEvent(action);
            return true;
        }
        catch (ServerException se) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.reload_failed", new Object[0]), se);
            return false;
        }
    }

    public synchronized boolean removeAlgorithm(Object algoId) {
        this.checkAlgorithmAdminPermission(algoId);
        Server.logInfoMessage("Tentando remover o algoritmo: " + algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.remove();
        }
        catch (ServerException se) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.remove_failed", algoId), se);
            return false;
        }
        this.registeredAlgorithms.remove(algoId);
        AlgorithmInfo info = algo.getInfo();
        String[] path = new String[]{this.getSymbolicRootName()};
        String description = this.getMessageFormatted(HISTORY_REMOVE_ALGORITHM, algoId);
        this.appendHistory(path, description);
        Server.logInfoMessage("Algoritmo " + algoId + " removido");
        AlgoEvent action = new AlgoEvent(3, (Object)info);
        this.sendEvent(action);
        return true;
    }

    public synchronized void removeExecutableFiles(AlgorithmVersionInfo version, String platform, FileInfo[] files) {
        if (null == version) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        if (null == platform) {
            throw new IllegalArgumentException(this.getParameterNullMessage("platform"));
        }
        if (null == files) {
            throw new IllegalArgumentException(this.getParameterNullMessage("files"));
        }
        if (0 == files.length) {
            throw new IllegalArgumentException(this.getParameterInvalidMessage("files.length == 0"));
        }
        String algorithmId = version.getInfo().getId();
        this.checkAlgorithmAdminPermission((Object)algorithmId);
        Algorithm algorithm = this.registeredAlgorithms.get(algorithmId);
        try {
            algorithm.removeExecutableFiles(version, platform, files);
            String[] basePath = new String[]{this.getSymbolicRootName(), algorithm.getInfo().getName(), version.getId().toString(), version.getBinDirName(), platform};
            for (FileInfo file : files) {
                String description = this.getMessageFormatted(HISTORY_REMOVE_FILE, file.getPath());
                this.appendHistory(basePath, description);
            }
            this.fireModifyEvent(algorithm.getInfo());
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void removeConfigurationFiles(AlgorithmVersionInfo version, FileInfo[] files) {
        if (null == version) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        if (null == files) {
            throw new IllegalArgumentException(this.getParameterNullMessage("files"));
        }
        if (0 == files.length) {
            throw new IllegalArgumentException(this.getParameterInvalidMessage("files.length == 0"));
        }
        String algorithmId = version.getInfo().getId();
        this.checkAlgorithmAdminPermission((Object)algorithmId);
        Algorithm algorithm = this.registeredAlgorithms.get(algorithmId);
        try {
            algorithm.removeConfigurationFiles(version, files);
            String[] basePath = new String[]{this.getSymbolicRootName(), algorithm.getInfo().getName(), version.getId().toString(), version.getConfiguratorDirName()};
            for (FileInfo file : files) {
                String description = this.getMessageFormatted(HISTORY_REMOVE_FILE, file.getPath());
                this.appendHistory(basePath, description);
            }
            this.fireModifyEvent(algorithm.getInfo());
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void removeDocumentationFiles(AlgorithmVersionInfo version, FileInfo[] files) {
        if (null == version) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        if (null == files) {
            throw new IllegalArgumentException(this.getParameterNullMessage("files"));
        }
        if (0 == files.length) {
            throw new IllegalArgumentException(this.getParameterInvalidMessage("files.length == 0"));
        }
        String algorithmId = version.getInfo().getId();
        this.checkAlgorithmAdminPermission((Object)algorithmId);
        Algorithm algorithm = this.registeredAlgorithms.get(algorithmId);
        try {
            algorithm.removeDocumentationFiles(version, files);
            String[] basePath = new String[]{this.getSymbolicRootName(), algorithm.getInfo().getName(), version.getId().toString(), version.getDocumentationDirName()};
            for (FileInfo file : files) {
                String description = this.getMessageFormatted(HISTORY_REMOVE_FILE, file.getPath());
                this.appendHistory(basePath, description);
            }
            this.fireModifyEvent(algorithm.getInfo());
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void removeReleaseNotesFiles(AlgorithmVersionInfo version, FileInfo[] files) {
        if (null == version) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        if (null == files) {
            throw new IllegalArgumentException(this.getParameterNullMessage("files"));
        }
        if (0 == files.length) {
            throw new IllegalArgumentException(this.getParameterInvalidMessage("files.length == 0"));
        }
        String algorithmId = version.getInfo().getId();
        this.checkAlgorithmAdminPermission((Object)algorithmId);
        Algorithm algorithm = this.registeredAlgorithms.get(algorithmId);
        try {
            algorithm.removeReleaseNotesFiles(version, files);
            String[] basePath = new String[]{this.getSymbolicRootName(), algorithm.getInfo().getName(), version.getId().toString(), version.getDocumentationDirName()};
            for (FileInfo file : files) {
                String description = this.getMessageFormatted(HISTORY_REMOVE_FILE, file.getPath());
                this.appendHistory(basePath, description);
            }
            this.fireModifyEvent(algorithm.getInfo());
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized AlgorithmInfo removePlatform(Object algoId, Object versionId, String platform) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.removePlatform(versionId, platform);
        }
        catch (ServerException se) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.platform.remove_failed", platform, versionId, algo.getInfo().getName()), se);
            return null;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), AlgorithmVersionInfo.BIN_DIR};
        String description = this.getMessageFormatted(HISTORY_REMOVE_PLATFORM, platform);
        this.appendHistory(path, description);
        Server.logInfoMessage("Plataforma " + platform + " removida da vers\u00e3o " + versionId + " do algoritmo " + algo.getInfo().getName());
        this.fireModifyEvent(algo.getInfo());
        return algo.getInfo();
    }

    public synchronized AlgorithmInfo removeVersion(Object algoId, Object versionId) {
        boolean toNotify = true;
        return this.removeVersion(algoId, versionId, toNotify);
    }

    private AlgorithmInfo removeVersion(Object algoId, Object versionId, boolean toNotify) {
        this.checkAlgorithmAdminPermission(algoId);
        Server.logInfoMessage("Tentando remover vers\u00e3o " + versionId + " do algoritmo: " + algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.removeVersion(versionId);
        }
        catch (ServerException se) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.version.remove_failed", versionId, algo.getInfo().getName()), se);
            return null;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName()};
        String description = this.getMessageFormatted(HISTORY_REMOVE_VERSION, versionId);
        this.appendHistory(path, description);
        Server.logInfoMessage("Vers\u00e3o " + versionId + " removida do algoritmo " + algo.getInfo().getName());
        if (toNotify) {
            this.fireModifyEvent(algo.getInfo());
        }
        return algo.getInfo();
    }

    public String retrieveConfigUploadURL(Object algoId, Object versionId) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo versionInfo = info.getVersionInfo(versionId);
        String algoPath = versionInfo.getConfiguratorDirPath();
        try {
            File file = new File(algoPath);
            if (!file.exists()) {
                throw new ServiceFailureException(this.getMessageFormatted(ERROR_CONF_VERSION_NOT_FOUND, algoId, versionId));
            }
            String canonicalPath = file.getCanonicalPath();
            AlgorithmObserver obs = new AlgorithmObserver(algoId, versionId, 1, Service.getUser().getId());
            String uploadPresentation = this.getStringProperty("uploadConfigPresentation");
            String uploadResult = this.getStringProperty("uploadResult");
            HttpService httpService = this.getHttpService();
            return httpService.getUploadURL(canonicalPath, uploadPresentation, uploadResult, obs);
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex.getMessage(), (Throwable)ex);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public String retrieveDocUploadURL(Object algoId, Object versionId) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo versionInfo = info.getVersionInfo(versionId);
        String docPath = versionInfo.getDocDirPath();
        try {
            File file = new File(docPath);
            if (!file.exists()) {
                throw new ServiceFailureException(this.getMessageFormatted(ERROR_DOC_VERSION_NOT_FOUND, algoId, versionId));
            }
            String canonicalPath = file.getCanonicalPath();
            AlgorithmObserver obs = new AlgorithmObserver(algoId, versionId, 3, Service.getUser().getId());
            String uploadPresentation = this.getStringProperty("uploadHtmlPresentation");
            String uploadResult = this.getStringProperty("uploadResult");
            HttpService httpService = this.getHttpService();
            return httpService.getUploadURL(canonicalPath, uploadPresentation, uploadResult, obs);
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex.getMessage(), (Throwable)ex);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public String retrieveReleaseNotesUploadURL(Object algoId, Object versionId) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo versionInfo = info.getVersionInfo(versionId);
        String docPath = versionInfo.getDocDirPath();
        try {
            File file = new File(docPath);
            if (!file.exists()) {
                throw new ServiceFailureException(this.getMessageFormatted(ERROR_RELEASE_NOTES_VERSION_NOT_FOUND, algoId, versionId));
            }
            String canonicalPath = file.getCanonicalPath();
            AlgorithmObserver obs = new AlgorithmObserver(algoId, versionId, 4, Service.getUser().getId());
            String uploadPresentation = this.getStringProperty("uploadReleaseNotes");
            String uploadResult = this.getStringProperty("uploadResult");
            HttpService httpService = this.getHttpService();
            return httpService.getUploadURL(canonicalPath, uploadPresentation, uploadResult, obs);
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex.getMessage(), (Throwable)ex);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public String retrieveDownloadURL(Object algoId, String[] filePath) {
        this.checkAlgorithmExecutePermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        String filePathText = FileUtils.joinPath((String[])filePath);
        String baseDir = FileUtils.joinPath((String)algo.getInfo().getDirectory(), (char)File.separatorChar, (String[])new String[]{this.algorithmRepositoryPath});
        File file = new File(baseDir, filePathText);
        String absFilePath = file.getAbsolutePath();
        try {
            HttpService httpService = this.getHttpService();
            return httpService.getFileDownloadURL(absFilePath);
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public String retrieveExecUploadURL(Object algoId, Object versionId, String platform) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo versionInfo = info.getVersionInfo(versionId);
        String platPath = versionInfo.getPlatformPath(platform);
        try {
            File file = new File(platPath);
            if (!file.exists()) {
                throw new ServiceFailureException(this.getMessageFormatted(ERROR_PLAT_VERSION_NOT_FOUND, algoId, versionId, platform));
            }
            String canonicalPath = file.getCanonicalPath();
            AlgorithmObserver obs = new AlgorithmObserver(algoId, versionId, platform, Service.getUser().getId());
            String uploadPresentation = this.getStringProperty("uploadExecPresentation");
            String uploadResult = this.getStringProperty("uploadResult");
            HttpService httpService = this.getHttpService();
            return httpService.getUploadURL(canonicalPath, uploadPresentation, uploadResult, obs);
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex.getMessage(), (Throwable)ex);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public String retrieveVersionUploadURL(final Object algoId) {
        String directoryPath;
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo info = algo.getInfo();
        File repositoryDirectory = new File(this.algorithmRepositoryPath);
        File algorithmDirectory = new File(repositoryDirectory, info.getDirectory());
        File file = new File(algorithmDirectory, "versions");
        if (!file.exists()) {
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.version_upload.dir.invalid", info.getName());
            String logDetails = this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.dir.invalid", file.getAbsolutePath());
            Server.logSevereMessage(userMessage + logDetails);
            throw new ServiceFailureException(userMessage);
        }
        try {
            directoryPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.version_upload.io_error", info.getName());
            Server.logSevereMessage(userMessage, e);
            throw new ServiceFailureException(userMessage);
        }
        User user = Service.getUser();
        final Object userId = user.getId();
        String uploadPresentation = this.getStringProperty("uploadVersionPresentation");
        String uploadResult = this.getStringProperty("uploadResult");
        try {
            return this.getHttpService().getUploadURL(directoryPath, uploadPresentation, uploadResult, new UploadHandler(){

                @Override
                public void execute(String filePath) throws HttpServiceException {
                    try {
                        File[] platformDirectories;
                        File versionDirectory;
                        File binaryDirectory;
                        String detailedMessage;
                        String userMessage;
                        Algorithm algorithm = (Algorithm)AlgorithmService.this.registeredAlgorithms.get(algoId);
                        if (algorithm == null) {
                            String detailedMessage2 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.algo.not_found", new Object[]{algoId, filePath});
                            Server.logSevereMessage(detailedMessage2);
                            throw new HttpServiceException(AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.algo.not_found", new Object[]{algoId}));
                        }
                        Unzip unzip = new Unzip(new File(filePath));
                        List zipEntries = unzip.listZipEntries();
                        if (zipEntries.isEmpty()) {
                            String userMessage2 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                            String detailedMessage3 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.empty_zip", new Object[]{filePath, algoId, userId});
                            Server.logSevereMessage(userMessage2 + detailedMessage3);
                            throw new HttpServiceException(userMessage2);
                        }
                        ZipEntry rootZipEntry = null;
                        String rootDirectoryName = null;
                        for (ZipEntry zipEntry : zipEntries) {
                            String[] path = FileUtils.splitPath((String)zipEntry.getName(), (String)"/");
                            if (path.length != 1) continue;
                            if (rootZipEntry != null) {
                                String userMessage3 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                                String detailedMessage4 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.invalid_root_zip", new Object[]{filePath, algoId, userId});
                                Server.logSevereMessage(userMessage3 + "\n" + detailedMessage4);
                                throw new HttpServiceException(userMessage3);
                            }
                            rootZipEntry = zipEntry;
                            rootDirectoryName = zipEntry.getName();
                            rootDirectoryName = rootDirectoryName.replace("/", "");
                        }
                        if (rootZipEntry == null) {
                            userMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                            detailedMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.no_root_name_zip", new Object[]{filePath, algoId, userId});
                            Server.logSevereMessage(userMessage + "\n" + detailedMessage);
                            throw new HttpServiceException(userMessage);
                        }
                        if (!rootZipEntry.isDirectory()) {
                            userMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                            detailedMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.no_root_zip", new Object[]{filePath, algoId, userId, rootZipEntry});
                            Server.logSevereMessage(userMessage + "\n" + detailedMessage);
                            throw new HttpServiceException(userMessage);
                        }
                        String regex = "v_([0-9]{3})_([0-9]{3})_([0-9]{3})";
                        Pattern versionPattern = Pattern.compile(regex);
                        Matcher versionMatcher = versionPattern.matcher(rootDirectoryName);
                        if (!versionMatcher.matches()) {
                            String userMessage4 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                            String detailedMessage5 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.invalid_root_zip_format", new Object[]{filePath, algoId, userId, rootDirectoryName, regex});
                            Server.logSevereMessage(userMessage4 + "\n" + detailedMessage5);
                            throw new HttpServiceException(userMessage4);
                        }
                        int major = Integer.parseInt(versionMatcher.group(1));
                        int minor = Integer.parseInt(versionMatcher.group(2));
                        int patch = Integer.parseInt(versionMatcher.group(3));
                        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(major, minor, patch);
                        AlgorithmInfo algorithmInfo = algorithm.getInfo();
                        String algorithmName = algorithmInfo.getName();
                        if (algorithmInfo.getVersionInfo((Object)algorithmVersionId) != null) {
                            String versionStr = String.format("%d.%d.%d", major, minor, patch);
                            String userMessage5 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version.already_exists", new Object[]{versionStr, algorithmName});
                            String detailedMessage6 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.more_info", new Object[]{filePath, algoId, userId});
                            Server.logSevereMessage(userMessage5 + "\n" + detailedMessage6);
                            throw new HttpServiceException(userMessage5);
                        }
                        File repositoryDirectory = new File(AlgorithmService.this.algorithmRepositoryPath);
                        File algorithmDirectory = new File(repositoryDirectory, algorithmInfo.getDirectory());
                        File versionsDirectory = new File(algorithmDirectory, "versions");
                        unzip.decompress(versionsDirectory);
                        if (!new File(filePath).delete()) {
                            String detailedMessage7 = String.format("Erro ao tentar excluir o arquivo %s.\nPor favor, tente exclu\u00ed-lo manualmente.\n", filePath);
                            Server.logWarningMessage(detailedMessage7);
                        }
                        if (!(binaryDirectory = new File(versionDirectory = new File(versionsDirectory, rootDirectoryName), AlgorithmVersionInfo.BIN_DIR)).isDirectory()) {
                            String userMessage6 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                            String detailedMessage8 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.no_bin_dir", new Object[]{filePath, algoId, userId});
                            Server.logSevereMessage(userMessage6 + "\n" + detailedMessage8);
                            if (!FileUtils.delete((File)versionDirectory)) {
                                detailedMessage8 = AlgorithmService.this.getMessageFormatted("AlgoService.error.version_upload.version_dir.delete_failed", new Object[]{versionDirectory.getAbsolutePath()});
                                Server.logWarningMessage(detailedMessage8);
                            }
                            throw new HttpServiceException(userMessage6);
                        }
                        for (File platformDirectory : platformDirectories = binaryDirectory.listFiles()) {
                            File[] binaryFiles;
                            if (!platformDirectory.isDirectory()) {
                                String userMessage7 = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.invalid_zip", new Object[0]);
                                String detailedMessage9 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.file.not_dir", new Object[]{userMessage7, platformDirectory, filePath, algoId, userId});
                                Server.logSevereMessage(userMessage7 + "\n" + detailedMessage9);
                                if (!FileUtils.delete((File)versionDirectory)) {
                                    detailedMessage9 = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version.delete_failed", new Object[]{versionDirectory.getAbsolutePath()});
                                    Server.logWarningMessage(detailedMessage9);
                                }
                                throw new HttpServiceException(userMessage7);
                            }
                            for (File binaryFile : binaryFiles = platformDirectory.listFiles()) {
                                FileSystem.enableExecutionPermission(binaryFile.getAbsolutePath());
                            }
                        }
                        algorithm.readVersion(versionsDirectory.getAbsolutePath(), versionDirectory);
                        AlgorithmService.this.fireModifyEvent(algorithmInfo);
                    }
                    catch (IOException e) {
                        String userMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version_upload.io_failed", new Object[0]);
                        String detailedMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.more_info", new Object[]{filePath, algoId, userId});
                        Server.logSevereMessage(userMessage + "\n" + detailedMessage, e);
                        throw new HttpServiceException(userMessage);
                    }
                    catch (ServerException e) {
                        String userMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.version.read_failed", new Object[0]);
                        String detailedMessage = AlgorithmService.this.getMessageFormatted("AlgoService.error.detailed.algo.version_upload.more_info", new Object[]{filePath, algoId, userId});
                        Server.logSevereMessage(userMessage + "\n" + detailedMessage, e);
                        throw new HttpServiceException(userMessage);
                    }
                }
            });
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public List<HistoryRecord> retrieveHistory(String[] viewPath) {
        if (viewPath == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("viewPath"));
        }
        Map historyTable = this.readHistoryTable();
        if (historyTable == null) {
            historyTable = this.resetHistoryTable();
        }
        Map dirTable = this.getDirTable(viewPath, historyTable);
        List rawList = this.getDirHistory(dirTable);
        List<HistoryRecord> recordList = this.getRecordList(viewPath, rawList);
        return recordList;
    }

    @Override
    public void shutdownService() {
        if (this.reloadAlgsThread != null) {
            this.reloadAlgsThread.interrupt();
        }
        this.exitCleanupThread = true;
        if (this.cleanupTempDirThread != null) {
            this.cleanupTempDirThread.interrupt();
        }
        if (this.categorySet != null && !this.categorySet.isCategorySetSaved()) {
            this.saveCategoriesBeforeShutdown();
        }
    }

    private void saveCategoriesBeforeShutdown() {
        Server.logInfoMessage("Tentando salvar o arquivo de categorias categories.xmlcom problema na \u00faltima persist\u00eancia...");
        try {
            if (this.writeCategoriesFile(this.categorySet)) {
                Server.logInfoMessage("Shutdown do servi\u00e7o - o arquivo de categorias categories.xml foi salvo com sucesso.");
            }
        }
        catch (CategoriesFileNotSavedException ex) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.category.file.not_saved", CATEGORIES_FILE_NAME));
        }
    }

    public void unlock(TransactionCallbackInterface cb) {
        this.checkAlgorithmServerAdminPermission();
        this.transaction.unlock(cb);
    }

    protected void fireModifyEvent(AlgorithmInfo info) {
        AlgoEvent event = new AlgoEvent(2, (Object)info);
        this.sendEvent(event);
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    void updateConfigurator(Object algoId, Object versionId, String filePath, Object userId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        if (algo == null) {
            return;
        }
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo vInfo = info.getVersionInfo(versionId);
        FileInfo from = new FileInfo(new File(filePath));
        vInfo.addConfigurator(from);
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), "configurator"};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_CONFIGURATOR), from.getName());
        this.appendHistory(userId, path, description);
        this.fireModifyEvent(info);
    }

    void updateDoc(Object algoId, Object versionId, String filePath, Object userId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        if (algo == null) {
            return;
        }
        AlgorithmInfo info = algo.getInfo();
        AlgorithmVersionInfo versionInfo = info.getVersionInfo(versionId);
        FileInfo from = new FileInfo(new File(filePath));
        versionInfo.addDocumentation(from);
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), "html"};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_DOC), from.getName());
        this.appendHistory(userId, path, description);
        this.fireModifyEvent(info);
    }

    void updateExecutable(Object algoId, Object versionId, String platform, String filePath, Object userId) {
        UpdateExecutableThread t = new UpdateExecutableThread(algoId, versionId, platform, filePath, userId);
        t.start();
    }

    private void appendHistory(Object userId, String[] path, String description) {
        User user = null;
        try {
            user = User.getUser((Object)userId);
        }
        catch (Exception e) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.user.not_found", userId));
        }
        if (user == null) {
            return;
        }
        this.appendHistory(user, path, description);
    }

    private void appendHistory(String[] path, String description) {
        User user = Service.getUser();
        if (user == null) {
            return;
        }
        this.appendHistory(user, path, description);
    }

    private void appendHistory(User user, String[] path, String description) {
        ArrayList<Object> record = new ArrayList<Object>();
        record.add(0, new Date());
        record.add(1, path);
        record.add(2, user.getLogin());
        record.add(3, user.getName());
        record.add(4, description);
        this.insertRecord(path, record);
    }

    private void checkAlgorithmServerAdminPermission() {
        User user = Service.getUser();
        if (user.isAdmin()) {
            return;
        }
        Server server = Server.getInstance();
        String serverName = "local=" + server.getSystemName();
        AttributesPermission p = null;
        try {
            p = user.getMatchAttributesPermission(AlgorithmAdminPermission.class, serverName);
        }
        catch (Exception e) {
            String errorMsg = this.getMessageFormatted("AlgoService.error.algo.admin.permission_failed", user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        if (p == null) {
            throw new PermissionException(this.getAlgoAdminServerPermissionErrorMessage(serverName));
        }
    }

    private void checkAlgorithmAdminPermission(Object algoId) throws PermissionException {
        if (algoId == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(ALGO_ID_KEY));
        }
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        if (algo == null) {
            throw new ServiceFailureException(this.getAlgoNotFoundMessage(algoId));
        }
        String algoName = algo.getInfo().getName();
        User user = Service.getUser();
        if (!user.isAdmin() && !this.isAlgorithmOwnerUser(algoName)) {
            this.checkAlgorithmAdminPermission(algoName);
        }
    }

    private void checkAlgorithmExecutePermission(Object algoId) throws PermissionException {
        if (algoId == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(ALGO_ID_KEY));
        }
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        if (algo == null) {
            throw new ServiceFailureException(this.getAlgoNotFoundMessage(algoId));
        }
        String algoName = algo.getInfo().getName();
        User user = Service.getUser();
        if (user.isAdmin() || this.isAlgorithmOwnerUser(algoName)) {
            return;
        }
        List categoriesFullNames = this.categorySet.getAlgorithmCategoriesFullNames(algo.getInfo());
        String systemId = Service.getSystemId();
        try {
            if (AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)user, (String)systemId, (String)algoName)) {
                return;
            }
            if (CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)user, (String)systemId, (List)categoriesFullNames)) {
                return;
            }
        }
        catch (Exception e) {
            String errorMsg = this.getMessageFormatted("AlgoService.error.algo.admin.permission_failed", user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        throw new PermissionException(this.getAlgoExecutePermissionErrorMessage(algoName));
    }

    private String getAlgoExecutePermissionErrorMessage(String algoName) {
        String msg = this.getString(this.ERROR_ALGO_EXECUTE_PERMISSION);
        Object[] args = new Object[]{algoName};
        return MessageFormat.format(msg, args);
    }

    private void checkAlgorithmAdminPermission(String algoName) throws PermissionException {
        User user = Service.getUser();
        String algoAttribute = "algoritmo=" + algoName;
        AlgorithmAdminPermission ap = null;
        try {
            ap = (AlgorithmAdminPermission)user.getMatchAttributesPermission(AlgorithmAdminPermission.class, algoAttribute);
        }
        catch (Exception e) {
            String errorMsg = this.getMessageFormatted("AlgoService.error.algo.execute.permission_failed", user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        if (ap == null) {
            throw new PermissionException(this.getAlgoAdminPermissionErrorMessage(algoName));
        }
        String serverName = Server.getInstance().getSystemName();
        String name = "local=" + serverName;
        if (ap.getMatchAttribute(name) == null) {
            throw new PermissionException(this.getAlgoAdminServerPermissionErrorMessage(serverName));
        }
    }

    private boolean isAlgorithmOwnerUser(String algoName) {
        AlgorithmInfo algoInfo = this.getInfo(algoName);
        if (algoInfo == null) {
            throw new ServiceFailureException(this.getAlgoNotFoundMessage(algoName));
        }
        String algorithmOwner = algoInfo.getOwner();
        User user = Service.getUser();
        return algorithmOwner != null && algorithmOwner.equals(user.getLogin());
    }

    private FlowAlgorithmConfigurator createFlowAlgorithmConfigurator(AlgorithmVersionInfo version) throws OperationFailureException {
        Flow flow;
        if (version == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        String configText = this.readConfiguratorFile(version, "config.flx");
        if (configText == null) {
            return null;
        }
        try {
            flow = new FlowAlgorithmParser().decode(configText);
        }
        catch (ConfigurationException e) {
            throw new OperationFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new OperationFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
        return new FlowAlgorithmConfigurator(version, flow);
    }

    private String getServiceCommandLinePattern() {
        return this.getStringProperty("default.command.line.pattern");
    }

    private SimpleAlgorithmConfigurator createSimpleAlgorithmConfigurator(AlgorithmVersionInfo version) throws ParseException {
        if (version == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("version"));
        }
        String configText = this.readConfiguratorFile(version, "config.xml");
        String configPropertiesText = this.readConfiguratorFile(version, "config.properties");
        String paramPropertiesText = this.readConfiguratorFile(version, "parameters.properties");
        if (configText != null) {
            StringReader configXmlReader = new StringReader(configText);
            HashMap config = new HashMap();
            HashMap params = new HashMap();
            Properties configProperties = this.getProperties(configPropertiesText);
            Properties paramProperties = this.getProperties(paramPropertiesText);
            this.addPropertiesToMap(this.parametersConfiguration, config);
            this.addPropertiesToMap(configProperties, config);
            this.addPropertiesToMap(paramProperties, params);
            SimpleAlgorithmParser parser = new SimpleAlgorithmParser();
            String srvCmdPattern = this.getServiceCommandLinePattern();
            return parser.load((Reader)configXmlReader, config, this.getParameterRegistry(), version, this.defaultAlgorithmExecutionLocation, srvCmdPattern);
        }
        return null;
    }

    public List<MonitoredFile> getMonitoredFiles(String algorithmName, AlgorithmVersionId algorithmVersionId) throws AlgorithmNotFoundException {
        if (algorithmName == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("algorithmName"));
        }
        if (algorithmVersionId == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage("algorithmVersionId"));
        }
        Algorithm algorithm = this.getAlgorithm(algorithmName);
        AlgorithmInfo algorithmInfo = algorithm.getInfo();
        AlgorithmVersionInfo version = algorithmInfo.getVersionInfo((Object)algorithmVersionId);
        if (version == null) {
            throw new AlgorithmNotFoundException(this.getVersionNotFoundMessage(algorithmInfo.getId(), algorithmVersionId));
        }
        List<MonitoredFile> files = Collections.EMPTY_LIST;
        String monitorText = this.readConfiguratorFile(version, "monitor.json");
        try {
            if (monitorText != null) {
                ObjectMapper mapper = new ObjectMapper();
                MonitoredFile[] monitoredFiles = (MonitoredFile[])mapper.readValue(monitorText, MonitoredFile[].class);
                files = Arrays.asList(monitoredFiles);
            }
        }
        catch (Exception e) {
            Server.logWarningMessage(MessageFormat.format("Erro ao ler configura\u00e7\u00e3o de arquivos monitorados do algoritmo {0}:{1}", algorithmName, algorithmVersionId.toString()));
        }
        return files;
    }

    private <K, V> void addPropertiesToMap(Properties properties, Map<K, V> map) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    private Properties getProperties(String configPropertiesText) {
        if (configPropertiesText == null) {
            return new Properties();
        }
        ByteArrayInputStream configPropertiesInputStream = new ByteArrayInputStream(configPropertiesText.getBytes());
        Properties properties = new Properties();
        try {
            properties.load(configPropertiesInputStream);
        }
        catch (IOException e) {
            IllegalStateException re = new IllegalStateException(e.getLocalizedMessage());
            re.initCause(e);
            throw re;
        }
        return properties;
    }

    private String getMessageFormatted(String key, Object ... args) {
        String msg = this.getString(key);
        return MessageFormat.format(msg, args);
    }

    private String getAlgoNotFoundMessage(Object algoId) {
        String msg = this.getString(ERROR_ALGO_NOT_FOUND);
        Object[] args = new Object[]{algoId};
        return MessageFormat.format(msg, args);
    }

    private String getParameterNullMessage(String parameter) {
        String msg = this.getString(ERROR_PARAMETER_NULL);
        Object[] args = new Object[]{parameter};
        return MessageFormat.format(msg, args);
    }

    private String getParameterInvalidMessage(String parameter) {
        String msg = this.getString(ERROR_PARAMETER_INVALID);
        Object[] args = new Object[]{parameter};
        return MessageFormat.format(msg, args);
    }

    private String getAlgoAdminPermissionErrorMessage(String algoName) {
        String msg = this.getString(this.ERROR_ALGO_ADMIN_PERMISSION);
        Object[] args = new Object[]{algoName};
        return MessageFormat.format(msg, args);
    }

    private String getAlgoAdminServerPermissionErrorMessage(String serverName) {
        String msg = this.getString(this.ERROR_ALGO_ADMIN_SERVER_PERMISSION);
        Object[] args = new Object[]{serverName};
        return MessageFormat.format(msg, args);
    }

    private Algorithm getAlgorithm(String name) throws AlgorithmNotFoundException {
        Collection<Algorithm> algorithmCollection = this.registeredAlgorithms.values();
        for (Algorithm algo : algorithmCollection) {
            AlgorithmInfo info = algo.getInfo();
            if (!info.getName().equals(name) && !info.getId().equals(name)) continue;
            return algo;
        }
        Server.logWarningMessage("Algoritmo inexistente: " + name);
        throw new AlgorithmNotFoundException(this.getAlgoNotFoundMessage(name));
    }

    private List getDirHistory(Map table) {
        ArrayList allHistory = new ArrayList();
        for (Object key : table.keySet()) {
            if (DIR_HISTORY_KEY.equals(key)) {
                List dirHistory = (List)table.get(DIR_HISTORY_KEY);
                if (dirHistory == null) continue;
                allHistory.addAll(dirHistory);
                continue;
            }
            Map subTable = (Map)table.get(key);
            if (subTable == null) {
                Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.history.dir_failed", new Object[0]), new IllegalStateException("subTable == null"));
                continue;
            }
            List subDirsHistory = this.getDirHistory(subTable);
            if (subDirsHistory == null) continue;
            allHistory.addAll(subDirsHistory);
        }
        return allHistory;
    }

    private Map getDirTable(String[] viewPath, Map historyTable) {
        Map table = historyTable;
        for (int i = 1; i < viewPath.length; ++i) {
            String key = viewPath[i];
            HashMap swap = (HashMap)table.get(key);
            if (swap == null) {
                swap = new HashMap();
                table.put(key, swap);
            }
            table = swap;
        }
        return table;
    }

    private String getHistoryTablePath() {
        return this.algorithmRepositoryPath + File.separator + HISTORY_TABLE_FILE_NAME;
    }

    private List<HistoryRecord> getRecordList(String[] viewPath, List rawList) {
        ArrayList<HistoryRecord> recordList = new ArrayList<HistoryRecord>();
        for (List l : rawList) {
            String[] relLogPath;
            Date date = (Date)l.get(0);
            String[] absLogPath = (String[])l.get(1);
            String login = (String)l.get(2);
            String name = (String)l.get(3);
            String description = (String)l.get(4);
            if (viewPath.length == absLogPath.length) {
                relLogPath = new String[]{"."};
            } else {
                int len = absLogPath.length - viewPath.length;
                relLogPath = new String[len];
                System.arraycopy(absLogPath, viewPath.length, relLogPath, 0, len);
            }
            HistoryRecord record = new HistoryRecord(date, relLogPath, login, name, description);
            recordList.add(record);
        }
        return recordList;
    }

    private String getVersionNotFoundMessage(Object algoId, Object versionId) {
        String msg = this.getString(ERROR_VERSION_NOT_FOUND);
        Object[] args = new Object[]{versionId, algoId};
        return MessageFormat.format(msg, args);
    }

    private void initHistoryTable() {
        Map table;
        File historyFile = new File(this.getHistoryTablePath());
        if (!historyFile.exists()) {
            Server.logInfoMessage("Tabela de hist\u00f3rico n\u00e3o encontrada. Criando...");
            this.writeHistoryTable(new HashMap());
        }
        if ((table = this.readHistoryTable()) == null) {
            this.resetHistoryTable();
        }
    }

    public Map resetHistoryTable() {
        Server.logSevereMessage("Tabela de hist\u00f3rico corrompida. Recriando...");
        this.writeHistoryTable(new HashMap());
        StringBuilder content = new StringBuilder();
        content.append("# Servi\u00e7o de Algoritmos");
        content.append("\n\n");
        content.append("A tabela de hist\u00f3rico de algoritmos foi corrompida. ");
        content.append("Uma nova tabela foi recriada em ");
        content.append(this.getHistoryTablePath());
        this.notifyAdminByMail(content.toString());
        return new HashMap();
    }

    private void notifyAdminByMail(String message) {
        MailService mailService = MailService.getInstance();
        Vector ids = new Vector();
        try {
            ids.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        Object[] address = ids.toArray(new Object[0]);
        mailService.mailSomeUsersFromService(this, address, message);
    }

    @Override
    protected Service[] getInitializationDependencies() {
        return new Service[]{MailService.getInstance()};
    }

    private void insertRecord(String[] path, List record) {
        Map table;
        ArrayList<List> dirHistory;
        Map historyTable = this.readHistoryTable();
        if (historyTable == null) {
            historyTable = this.resetHistoryTable();
        }
        if ((dirHistory = (ArrayList<List>)(table = this.getDirTable(path, historyTable)).get(DIR_HISTORY_KEY)) == null) {
            dirHistory = new ArrayList<List>();
            table.put(DIR_HISTORY_KEY, dirHistory);
        }
        dirHistory.add(record);
        this.writeHistoryTable(historyTable);
    }

    private void loadAlgorithms() throws ServerException {
        this.searchIds(this.algorithmRepositoryPath);
    }

    private void loadCategories() throws ServerException {
        this.categorySet.removeAllCategories();
        if (!this.readCategoriesFile(this.categorySet)) {
            return;
        }
        Server.logInfoMessage("As categorias de algoritmos foram carregadas com sucesso.");
        this.isFirstCategoryLoad = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readConfiguratorFile(AlgorithmVersionInfo version, String configFileName) {
        String string;
        BufferedReader bufferedReader;
        block13: {
            String line;
            String configuratorPath = version.getConfiguratorDirPath() + "/" + configFileName;
            File configuratorFile = new File(configuratorPath = configuratorPath.replace('/', File.separatorChar));
            if (!configuratorFile.exists()) {
                String algorithmName = version.getInfo().getName();
                AlgorithmVersionId versionId = version.getId();
                String message = MessageFormat.format("Foi solicitado o arquivo {0} do algoritmo {1} vers\u00e3o {2}, por\u00e9m o arquivo n\u00e3o existe.", configuratorPath, algorithmName, versionId);
                Server.logFineMessage(message);
                return null;
            }
            bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(configuratorFile));
            StringBuffer buffer = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            string = buffer.toString();
            if (bufferedReader == null) break block13;
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                String algorithmName = version.getInfo().getName();
                AlgorithmVersionId versionId = version.getId();
                String errorMessage = MessageFormat.format("Foi solicitado o '{2}' do algoritmo {0} vers\u00e3o {1}, por\u00e9m ocorreu uma exce\u00e7\u00e3o de IO, quando o stream estava sendo fechado.", algorithmName, versionId, configFileName);
                Server.logSevereMessage(errorMessage, e);
            }
            bufferedReader = null;
        }
        return string;
        catch (IOException e) {
            String string2;
            block14: {
                try {
                    String algorithmName = version.getInfo().getName();
                    AlgorithmVersionId versionId = version.getId();
                    String errorMessage = MessageFormat.format("Foi solicitado o '{2}' do algoritmo {0} vers\u00e3o {1}, por\u00e9m ocorreu uma exce\u00e7\u00e3o de IO.", algorithmName, versionId, configFileName);
                    Server.logSevereMessage(errorMessage, e);
                    string2 = null;
                    if (bufferedReader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e2) {
                            String algorithmName = version.getInfo().getName();
                            AlgorithmVersionId versionId = version.getId();
                            String errorMessage = MessageFormat.format("Foi solicitado o '{2}' do algoritmo {0} vers\u00e3o {1}, por\u00e9m ocorreu uma exce\u00e7\u00e3o de IO, quando o stream estava sendo fechado.", algorithmName, versionId, configFileName);
                            Server.logSevereMessage(errorMessage, e2);
                        }
                        bufferedReader = null;
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException e3) {
                    String algorithmName = version.getInfo().getName();
                    AlgorithmVersionId versionId = version.getId();
                    String errorMessage = MessageFormat.format("Foi solicitado o '{2}' do algoritmo {0} vers\u00e3o {1}, por\u00e9m ocorreu uma exce\u00e7\u00e3o de IO, quando o stream estava sendo fechado.", algorithmName, versionId, configFileName);
                    Server.logSevereMessage(errorMessage, e3);
                }
                bufferedReader = null;
            }
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map readHistoryTable() {
        Map table = null;
        try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getHistoryTablePath())));){
            Map map = table = (Map)input.readObject();
            return map;
        }
        catch (Exception ex) {
            Server.logSevereMessage("Erro ao ler a tabela de hist\u00f3rico.", ex);
            return null;
        }
    }

    private void searchIds(String path) throws ServerException {
        try {
            File repDir = new File(path);
            Server.checkDirectory(path);
            this.registeredAlgorithms = new Hashtable();
            File[] algoDirs = repDir.listFiles();
            for (int i = 0; i < algoDirs.length; ++i) {
                String dirName;
                File dir = algoDirs[i];
                if (!dir.isDirectory() || dir.isHidden() || (dirName = dir.getName().trim()).equalsIgnoreCase(".svn")) continue;
                Server.logFineMessage("Identificando algoritmo em :" + dirName);
                try {
                    Algorithm algo = Algorithm.includeAlgorithm(dirName);
                    String newId = algo.getInfo().getId();
                    this.registeredAlgorithms.put(newId, algo);
                    Server.logFineMessage("Algoritmo registrado: " + newId);
                    Server.logFineMessage("Propriedades:" + algo.getInfo().getPropertyValues());
                    continue;
                }
                catch (ServerException se) {
                    Server.logSevereMessage("Falha na obten\u00e7\u00e3o de um algoritmo no reposit\u00f3rio do SSI - Exce\u00e7\u00e3o: " + se + "\n", se);
                }
            }
        }
        catch (Exception e) {
            throw new ServerException(this.getMessageFormatted("AlgoService.error.algo.search", path), e);
        }
    }

    private void writeHistoryTable(Map table) {
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getHistoryTablePath())));){
            output.writeObject(table);
        }
        catch (IOException ex) {
            Server.logSevereMessage("Erro ao gravar a tabela de hist\u00f3rico.", ex);
        }
    }

    private HttpService getHttpService() throws OperationFailureException {
        HttpService service = HttpService.getInstance();
        if (service == null) {
            throw new OperationFailureException(this.getMessageFormatted("AlgoService.error.http_service.not_found", new Object[0]));
        }
        return service;
    }

    private RemoteFileChannelInfo createChannel(String targetPath, Map<String, Object> notifyArgs, FileChannelOp op) {
        try {
            boolean ro = op == FileChannelOp.DOWNLOAD || op == FileChannelOp.READ;
            Requester r = new Requester(notifyArgs, ro);
            File f = new File(targetPath);
            return FTCService.getInstance().createFileChannelInfo((FTCRequester)r, f, ro);
        }
        catch (Exception e) {
            String clientMsg = "";
            switch (op) {
                case UPLOAD: {
                    clientMsg = this.getString("server.algoservice.error.upload_fatal");
                    break;
                }
                case DOWNLOAD: {
                    clientMsg = this.getString("server.algoservice.error.download_fatal");
                    break;
                }
                case READ: {
                    clientMsg = this.getString("server.algoservice.error.read_fatal");
                    break;
                }
                case WRITE: {
                    clientMsg = this.getString("server.algoservice.error.write_fatal");
                }
            }
            throw new ServiceFailureException(clientMsg, (Throwable)e);
        }
    }

    public synchronized RemoteFileChannelInfo prepareUploadVersionPack(Object algoId, String fileName) {
        String targetPath;
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo algoInfo = algo.getInfo();
        File repositoryDirectory = new File(this.algorithmRepositoryPath);
        File algorithmDirectory = new File(repositoryDirectory, algoInfo.getDirectory());
        File versionsDir = new File(algorithmDirectory, "versions");
        if (!versionsDir.exists()) {
            String userMessage = this.getMessageFormatted("server.algoservice.error.illegal_algo_dir_state", algoInfo.getName());
            String logDetails = String.format("\nDetalhes: o diret\u00f3rio %s n\u00e3o foi encontrado.\n", versionsDir.getAbsolutePath());
            Server.logSevereMessage(userMessage + logDetails);
            throw new ServiceFailureException(userMessage);
        }
        try {
            targetPath = versionsDir.getCanonicalPath() + File.separator + fileName;
        }
        catch (IOException e) {
            String userMessage = this.getMessageFormatted("AlgoService.error.upload_algo_pack.create_file", algoInfo.getName());
            Server.logSevereMessage(userMessage, e);
            throw new ServiceFailureException(userMessage);
        }
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.VERSION_PACK);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(FILE_PATH_KEY, targetPath);
        notifyArgs.put(EXPAND_IF_ZIP, Boolean.TRUE);
        return this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
    }

    public synchronized RemoteFileChannelInfo prepareUploadExecFile(Object algoId, Object versionId, String platformName, String fileName, boolean expandIfZip) {
        this.checkAlgorithmAdminPermission(algoId);
        String platformPath = this.getPlatformPath(algoId, versionId, platformName);
        String targetPath = platformPath + File.separator + fileName;
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.EXECUTABLE);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(VERSION_ID_KEY, versionId);
        notifyArgs.put(PLATFORM_NAME_KEY, platformName);
        notifyArgs.put(FILE_NAME_KEY, fileName);
        notifyArgs.put(EXPAND_IF_ZIP, expandIfZip);
        return this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
    }

    public synchronized RemoteFileChannelInfo prepareUploadConfigFile(Object algoId, Object versionId, String fileName, boolean expandIfZip) {
        this.checkAlgorithmAdminPermission(algoId);
        String configDirPath = this.getConfiguratorDirPath(algoId, versionId);
        String targetPath = configDirPath + File.separator + fileName;
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.CONFIGURATION);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(VERSION_ID_KEY, versionId);
        notifyArgs.put(FILE_NAME_KEY, fileName);
        notifyArgs.put(EXPAND_IF_ZIP, expandIfZip);
        return this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
    }

    public synchronized RemoteFileChannelInfo prepareUploadDocFile(Object algoId, Object versionId, String fileName, boolean expandIfZip) {
        this.checkAlgorithmAdminPermission(algoId);
        String docDirPath = this.getDocumentationDirPath(algoId, versionId);
        String targetPath = docDirPath + File.separator + fileName;
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.DOCUMENTATION);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(VERSION_ID_KEY, versionId);
        notifyArgs.put(FILE_NAME_KEY, fileName);
        notifyArgs.put(EXPAND_IF_ZIP, expandIfZip);
        return this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
    }

    public synchronized RemoteFileChannelInfo prepareUploadReleaseNotesFile(Object algoId, Object versionId, String fileName, boolean expandIfZip) {
        this.checkAlgorithmAdminPermission(algoId);
        String docDirPath = this.getReleaseNotesDirPath(algoId, versionId);
        Path releaseFolder = Paths.get(docDirPath, new String[0]);
        if (!Files.exists(releaseFolder, new LinkOption[0])) {
            new File(docDirPath).mkdirs();
        }
        String targetPath = docDirPath + File.separator + "releasenotes.txt";
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.RELEASE_NOTES);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(VERSION_ID_KEY, versionId);
        notifyArgs.put(FILE_NAME_KEY, "releasenotes.txt");
        notifyArgs.put(EXPAND_IF_ZIP, expandIfZip);
        return this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
    }

    public boolean configFileExists(Object algoId, Object versionId, String fileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String configDirPath = this.getConfiguratorDirPath(algoId, versionId);
        String targetPath = configDirPath + File.separator + fileName;
        return new File(targetPath).exists();
    }

    public boolean docFileExists(Object algoId, Object versionId, String fileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String docDirPath = this.getDocumentationDirPath(algoId, versionId);
        String targetPath = docDirPath + File.separator + fileName;
        return new File(targetPath).exists();
    }

    public boolean releaseNotesFileExists(Object algoId, Object versionId, String fileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String docDirPath = this.getReleaseNotesDirPath(algoId, versionId);
        String targetPath = docDirPath + File.separator + fileName;
        return new File(targetPath).exists();
    }

    public boolean execFileExists(Object algoId, Object versionId, String platformName, String fileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String platformPath = this.getPlatformPath(algoId, versionId, platformName);
        String targetPath = platformPath + File.separator + fileName;
        return new File(targetPath).exists();
    }

    public boolean renameConfigFile(Object algoId, Object versionId, String[] filePath, String fileName) throws RemoteException {
        this.checkAlgorithmAdminPermission(algoId);
        String configDirPath = this.getConfiguratorDirPath(algoId, versionId);
        String joinedSourceFilePath = FileUtils.joinPath((String[])filePath);
        String sourcePath = configDirPath + File.separator + joinedSourceFilePath;
        File file = new File(sourcePath);
        String[] targetFilePath = filePath;
        String targetPath = configDirPath + File.separator;
        if (targetFilePath.length > 1) {
            targetFilePath[targetFilePath.length - 1] = fileName;
            String joinedTargetFilePath = FileUtils.joinPath((String[])targetFilePath);
            targetPath = targetPath + joinedTargetFilePath;
        } else {
            targetPath = targetPath + fileName;
        }
        File newFile = new File(targetPath);
        if (newFile.exists()) {
            String infoMsg = this.getMessageFormatted("AlgoService.error.file.rename.existing_name", fileName);
            throw new InfoException(infoMsg);
        }
        boolean renamed = file.renameTo(newFile);
        if (!renamed) {
            renamed = FileSystem.move(file, newFile);
        }
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.reload();
            this.fireModifyEvent(algo.getInfo());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return renamed;
    }

    public boolean renameDocFile(Object algoId, Object versionId, String[] filePath, String fileName) throws RemoteException {
        this.checkAlgorithmAdminPermission(algoId);
        String docDirPath = this.getDocumentationDirPath(algoId, versionId);
        String joinedSourceFilePath = FileUtils.joinPath((String[])filePath);
        String sourcePath = docDirPath + File.separator + joinedSourceFilePath;
        File file = new File(sourcePath);
        String[] targetFilePath = filePath;
        String targetPath = docDirPath + File.separator;
        if (targetFilePath.length > 1) {
            targetFilePath[targetFilePath.length - 1] = fileName;
            String joinedTargetFilePath = FileUtils.joinPath((String[])targetFilePath);
            targetPath = targetPath + joinedTargetFilePath;
        } else {
            targetPath = targetPath + fileName;
        }
        File newFile = new File(targetPath);
        if (newFile.exists()) {
            String infoMsg = this.getMessageFormatted("AlgoService.error.file.rename.existing_name", fileName);
            throw new InfoException(infoMsg);
        }
        boolean renamed = file.renameTo(newFile);
        if (!renamed) {
            renamed = FileSystem.move(file, newFile);
        }
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.reload();
            this.fireModifyEvent(algo.getInfo());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return renamed;
    }

    public boolean renameExecFile(Object algoId, Object versionId, String[] filePath, String platformName, String fileName) throws RemoteException {
        this.checkAlgorithmAdminPermission(algoId);
        String execDirPath = this.getPlatformPath(algoId, versionId, platformName);
        String joinedSourceFilePath = FileUtils.joinPath((String[])filePath);
        String sourcePath = execDirPath + File.separator + joinedSourceFilePath;
        File file = new File(sourcePath);
        String[] targetFilePath = filePath;
        String targetPath = execDirPath + File.separator;
        if (targetFilePath.length > 1) {
            targetFilePath[targetFilePath.length - 1] = fileName;
            String joinedTargetFilePath = FileUtils.joinPath((String[])targetFilePath);
            targetPath = targetPath + joinedTargetFilePath;
        } else {
            targetPath = targetPath + fileName;
        }
        File newFile = new File(targetPath);
        if (newFile.exists()) {
            String infoMsg = this.getMessageFormatted("AlgoService.error.file.rename.existing_name", fileName);
            throw new InfoException(infoMsg);
        }
        boolean renamed = file.renameTo(newFile);
        if (!renamed) {
            renamed = FileSystem.move(file, newFile);
        }
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        try {
            algo.reload();
            this.fireModifyEvent(algo.getInfo());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return renamed;
    }

    private void loadParameters() throws ServerException {
        this.parametersConfiguration = new Properties();
        this.loadParameterPropertiesFromFilePath(this.parametersConfiguration, "AlgorithmParametersConfiguration.properties");
        this.loadParameterPropertiesFromTag(this.parametersConfiguration, "parameters.configuration.property.file");
    }

    private void loadParameterPropertiesFromFilePath(Properties properties, String path) {
        try {
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            this.loadPropertiesFromStream(properties, inStream);
        }
        catch (FileNotFoundException e) {
            Server.logWarningMessage("N\u00e3o foi poss\u00edvel encontrar arquivo de propriedades: " + path + ".");
        }
        catch (IOException e) {
            Server.logWarningMessage("N\u00e3o foi poss\u00edvel ler o arquivo de propriedades: " + path + ".");
        }
    }

    private void loadParameterPropertiesFromTag(Properties properties, String tag) throws ServerException {
        if (!this.isPropertyNull(tag)) {
            String propertiesFile = this.getStringProperty(tag);
            String path = this.getOSPropertyPath(propertiesFile);
            try {
                FileInputStream inStream = new FileInputStream(path);
                this.loadPropertiesFromStream(properties, inStream);
            }
            catch (FileNotFoundException e) {
                throw new ServerException(this.getMessageFormatted("AlgoService.error.property.file.not_found", path, tag), e);
            }
            catch (IOException e) {
                throw new ServerException(this.getMessageFormatted("AlgoService.error.property.file.io_error", path, tag), e);
            }
        }
    }

    private void loadPropertiesFromStream(Properties properties, InputStream inStream) throws IOException {
        try {
            if (inStream != null) {
                properties.load(inStream);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public synchronized RemoteFileChannelInfo prepareDownloadExecFile(Object algoId, Object versionId, String platformName, String fileName, boolean isDirectory) {
        this.checkAlgorithmAdminPermission(algoId);
        String platformPath = this.getPlatformPath(algoId, versionId, platformName);
        String sourcePath = platformPath + File.separator + fileName;
        File newFile = this.createTmpZipFile(sourcePath, isDirectory);
        String newFilePath = newFile.getAbsolutePath();
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.EXECUTABLE);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(FILE_PATH_KEY, newFilePath);
        notifyArgs.put(EXCLUDE_TMP_ZIP, isDirectory);
        return this.createChannel(newFilePath, notifyArgs, FileChannelOp.DOWNLOAD);
    }

    private synchronized File createTmpZipFile(String file, boolean isDirectory) {
        if (!isDirectory) {
            return new File(file);
        }
        String zipFileName = String.format("%s.zip", file);
        File sourceDirectoryFile = new File(file);
        File directoryTmpZipFile = new File(zipFileName);
        try {
            this.zipFiles(sourceDirectoryFile, directoryTmpZipFile);
        }
        catch (IOException e) {
            String msg = String.format(this.getString("server.algoservice.error.invalid_zip_file"), zipFileName);
            Server.logSevereMessage(msg, e);
            try {
                String[] ids = new String[]{zipFileName};
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(AlgorithmService.getUser().getLogin(), msg, false, false)), ids);
            }
            catch (RemoteException re) {
                Server.logSevereMessage("Erro ao enviar evento de arquivo inv\u00e1lido.", re);
            }
        }
        return directoryTmpZipFile;
    }

    public synchronized RemoteFileChannelInfo prepareDownloadConfigFile(Object algoId, Object versionId, String fileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String configDirPath = this.getConfiguratorDirPath(algoId, versionId);
        String sourcePath = configDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, FileChannelOp.DOWNLOAD);
    }

    public synchronized RemoteFileChannelInfo prepareDownloadDocFile(Object algoId, Object versionId, String fileName) {
        this.checkAlgorithmExecutePermission(algoId);
        String docDirPath = this.getDocumentationDirPath(algoId, versionId);
        String sourcePath = docDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, FileChannelOp.DOWNLOAD);
    }

    public RemoteFileChannelInfo prepareDownloadNotesFile(Object algoId, Object versionId, String fileName) throws RemoteException {
        this.checkAlgorithmExecutePermission(algoId);
        String notesDirPath = this.getReleaseNotesDirPath(algoId, versionId);
        String sourcePath = notesDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, FileChannelOp.DOWNLOAD);
    }

    public String getAlgorithmDirPath(Object algoId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo algoInfo = algo.getInfo();
        String algoDirPath = algoInfo.getAlgorithmRepositoryPath() + "/" + algoInfo.getDirectory();
        return algoDirPath;
    }

    public synchronized RemoteFileChannelInfo prepareDownloadVersionPackFile(Object algoId, AlgorithmVersionId versionId, String versionPackFileName) {
        this.checkAlgorithmAdminPermission(algoId);
        String algorithmDirPath = this.getAlgorithmDirPath(algoId);
        String sourcePath = algorithmDirPath + File.separator + versionPackFileName;
        this.createVersionPack(algoId, versionId, versionPackFileName);
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.VERSION_PACK);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(FILE_PATH_KEY, sourcePath);
        notifyArgs.put(EXPAND_IF_ZIP, Boolean.FALSE);
        return this.createChannel(sourcePath, notifyArgs, FileChannelOp.DOWNLOAD);
    }

    private synchronized File createVersionPack(Object algoId, AlgorithmVersionId algoVersionId, String versionPackFileName) {
        this.checkAlgorithmAdminPermission(algoId);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmInfo algoInfo = algo.getInfo();
        File repositoryDirectory = new File(this.algorithmRepositoryPath);
        File algorithmDirectory = new File(repositoryDirectory, algoInfo.getDirectory());
        File versionsDir = new File(algorithmDirectory, "versions");
        if (!versionsDir.exists()) {
            String userMessage = this.getMessageFormatted("server.algoservice.error.illegal_algo_dir_state", algoInfo.getName());
            String logDetails = String.format("\nDetalhes: o diret\u00f3rio %s n\u00e3o foi encontrado.\n", versionsDir.getAbsolutePath());
            Server.logSevereMessage(userMessage + logDetails);
            throw new ServiceFailureException(userMessage);
        }
        AlgorithmVersionInfo versionInfo = algo.getInfo().getVersionInfo((Object)algoVersionId);
        String algoVersionPath = versionInfo.getDirPath();
        File algoVersionDir = new File(algoVersionPath);
        File versionPackFile = new File(algorithmDirectory, versionPackFileName);
        try {
            this.zipFiles(algoVersionDir, versionPackFile);
        }
        catch (IOException e) {
            Server.logSevereMessage("Erro ao criar o pacote de vers\u00e3o do algoritmo " + algoInfo.getName() + " vers\u00e3o " + algoVersionId + ".", e);
        }
        return versionPackFile;
    }

    public boolean zipFiles(File algoVersionDir, File versionPackFile) throws IOException {
        if (algoVersionDir == null || versionPackFile == null) {
            return false;
        }
        FileOutputStream zipFile = new FileOutputStream(versionPackFile);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(zipFile));
        ZipUtils.addFile((ZipOutputStream)zos, (File)algoVersionDir, (int)0);
        zos.flush();
        zipFile.flush();
        zos.close();
        zipFile.close();
        return true;
    }

    private String getPlatformPath(Object algoId, Object versionId, String platformName) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmVersionInfo versionInfo = algo.getInfo().getVersionInfo(versionId);
        return versionInfo.getPlatformPath(platformName);
    }

    private String getConfiguratorDirPath(Object algoId, Object versionId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmVersionInfo versionInfo = algo.getInfo().getVersionInfo(versionId);
        return versionInfo.getConfiguratorDirPath();
    }

    private String getDocumentationDirPath(Object algoId, Object versionId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmVersionInfo versionInfo = algo.getInfo().getVersionInfo(versionId);
        return versionInfo.getDocDirPath();
    }

    private String getReleaseNotesDirPath(Object algoId, Object versionId) {
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        AlgorithmVersionInfo versionInfo = algo.getInfo().getVersionInfo(versionId);
        return versionInfo.getReleaseNotesDirPath();
    }

    private boolean isZip(String path) {
        return ZIP_EXTENSION.equalsIgnoreCase(FileUtils.getFileExtension((String)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractZipFile(IPathFactory pathFactory, FileInfo file, Object userId) throws RemoteException {
        String zipPath = pathFactory.getPath(file);
        File zipFile = new File(zipPath);
        String login = User.getUser((Object)userId).getLogin();
        try {
            Unzip unzip = new Unzip(zipFile);
            if (unzip.listZipEntries().isEmpty()) {
                String msg = String.format(this.getString("server.algoservice.error.invalid_zip_file"), zipFile.getName());
                Server.logSevereMessage(msg);
                String[] ids = new String[]{(String)userId};
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, msg, false, false)), ids);
                boolean bl = false;
                return bl;
            }
            unzip.decompress(zipFile.getParentFile(), true);
        }
        catch (IOException e) {
            String msg = String.format(this.getString("server.algoservice.error.unzip_io"), zipFile.getName());
            Server.logSevereMessage(msg, e);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, msg, false, false)), ids);
            }
            catch (RemoteException e1) {
                Server.logSevereMessage("Erro ao enviar evento de erro na extra\u00e7\u00e3o do arquivo de algoritmo.", e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.delete((File)zipFile);
        }
        return true;
    }

    private void configurationUploaded(Map args) throws RemoteException {
        IPathFactory pathFactory;
        Object userId = args.get(USER_ID_KEY);
        String login = User.getUser(userId).getLogin();
        final Object algoId = args.get(ALGO_ID_KEY);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        final Object versionId = args.get(VERSION_ID_KEY);
        String configName = (String)args.get(FILE_NAME_KEY);
        FileInfo file = new FileInfo(configName, false);
        if (((Boolean)args.get(EXPAND_IF_ZIP)).booleanValue() && this.isZip(file.getName()) && !this.extractZipFile(pathFactory = new IPathFactory(){

            public String getPath(FileInfo fileInfo) {
                return AlgorithmService.this.getConfiguratorDirPath(algoId, versionId) + File.separator + fileInfo.getPath();
            }
        }, file, userId)) {
            return;
        }
        try {
            algo.updateConfigurations(versionId);
        }
        catch (OperationFailureException e) {
            String clientMsg = this.getString("server.algoservice.error.refresh");
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel atualizar os arquivos de configura\u00e7\u00e3o da vers\u00e3o " + versionId + " do algoritmo " + algoId, e);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, clientMsg, false, false)), ids);
            }
            catch (RemoteException e1) {
                Server.logSevereMessage("Erro ao enviar evento de erro na carga do arquivo de configora\u00e7\u00e3o de algoritmo.", e1);
            }
            return;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), "configurator"};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_CONFIGURATOR), configName);
        this.appendHistory(userId, path, description);
    }

    private void documentationUploaded(Map args) throws RemoteException {
        IPathFactory pathFactory;
        Object userId = args.get(USER_ID_KEY);
        String login = User.getUser(userId).getLogin();
        final Object algoId = args.get(ALGO_ID_KEY);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        final Object versionId = args.get(VERSION_ID_KEY);
        String docName = (String)args.get(FILE_NAME_KEY);
        FileInfo file = new FileInfo(docName, false);
        if (((Boolean)args.get(EXPAND_IF_ZIP)).booleanValue() && this.isZip(file.getName()) && !this.extractZipFile(pathFactory = new IPathFactory(){

            public String getPath(FileInfo fileInfo) {
                return AlgorithmService.this.getDocumentationDirPath(algoId, versionId) + File.separator + fileInfo.getPath();
            }
        }, file, userId)) {
            return;
        }
        try {
            algo.updateDocumentations(versionId);
        }
        catch (OperationFailureException e) {
            String clientMsg = this.getString("server.algoservice.error.refresh");
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel atualizar o arquivo de release notes da vers\u00e3o " + versionId + " do algoritmo " + algoId, e);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, clientMsg, false, false)), ids);
            }
            catch (RemoteException e1) {
                Server.logSevereMessage("Erro ao enviar evento de erro na atualiza\u00e7\u00e3o de arquivo de release notes de algoritmo.", e);
            }
            return;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), "html"};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_DOC), docName);
        this.appendHistory(userId, path, description);
    }

    private void releaseNotesUploaded(Map args) throws RemoteException {
        IPathFactory pathFactory;
        Object userId = args.get(USER_ID_KEY);
        String login = User.getUser(userId).getLogin();
        final Object algoId = args.get(ALGO_ID_KEY);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        final Object versionId = args.get(VERSION_ID_KEY);
        String fileName = (String)args.get(FILE_NAME_KEY);
        String targetName = (String)args.get(FILE_NAME_KEY);
        FileInfo file = new FileInfo(fileName, false);
        if (((Boolean)args.get(EXPAND_IF_ZIP)).booleanValue() && this.isZip(file.getName()) && !this.extractZipFile(pathFactory = new IPathFactory(){

            public String getPath(FileInfo fileInfo) {
                return AlgorithmService.this.getReleaseNotesDirPath(algoId, versionId) + File.separator + fileInfo.getPath();
            }
        }, file, userId)) {
            return;
        }
        try {
            algo.updateReleaseNotes(versionId, fileName);
        }
        catch (OperationFailureException e) {
            String clientMsg = this.getString("server.algoservice.error.refresh");
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel atualizar os arquivos de documenta\u00e7\u00e3o da vers\u00e3o " + versionId + " do algoritmo " + algoId, e);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, clientMsg, false, false)), ids);
            }
            catch (RemoteException e1) {
                Server.logSevereMessage("Erro ao enviar evento de erro na atualiza\u00e7\u00e3o de arquivo de documenta\u00e7\u00e3o de algoritmo.", e);
            }
            return;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString()};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_RELEASE_NOTES), fileName);
        this.appendHistory(userId, path, description);
    }

    private void executableUploaded(Map args) throws RemoteException {
        IPathFactory pathFactory;
        Object userId = args.get(USER_ID_KEY);
        String login = User.getUser(userId).getLogin();
        final Object algoId = args.get(ALGO_ID_KEY);
        Algorithm algo = this.registeredAlgorithms.get(algoId);
        final Object versionId = args.get(VERSION_ID_KEY);
        final String platform = (String)args.get(PLATFORM_NAME_KEY);
        String exeName = (String)args.get(FILE_NAME_KEY);
        FileInfo file = new FileInfo(exeName, false);
        if (args.containsKey(EXPAND_IF_ZIP) && ((Boolean)args.get(EXPAND_IF_ZIP)).booleanValue() && this.isZip(file.getName()) && !this.extractZipFile(pathFactory = new IPathFactory(){

            public String getPath(FileInfo fileInfo) {
                return AlgorithmService.this.getPlatformPath(algoId, versionId, platform) + File.separator + fileInfo.getPath();
            }
        }, file, userId)) {
            return;
        }
        try {
            algo.updateExecutables(versionId, platform);
        }
        catch (OperationFailureException e) {
            String clientMsg = this.getString("server.algoservice.error.refresh");
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel atualizar a plataforma " + platform + " da vers\u00e3o " + versionId + " do algoritmo " + algoId, e);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, clientMsg, false, false)), ids);
            }
            catch (RemoteException e1) {
                Server.logSevereMessage("Erro ao enviar evento de erro na atualiza\u00e7\u00e3o da plataforma de algoritmo.", e1);
            }
            return;
        }
        String[] path = new String[]{this.getSymbolicRootName(), algo.getInfo().getName(), versionId.toString(), AlgorithmVersionInfo.BIN_DIR, platform};
        String description = MessageFormat.format(this.getString(HISTORY_UPDATE_EXECUTABLE), exeName);
        this.appendHistory(userId, path, description);
    }

    private void executableDownloaded(Map args) {
        String filePath = (String)args.get(FILE_PATH_KEY);
        File file = new File(filePath);
        if (args.containsKey(EXCLUDE_TMP_ZIP) && ((Boolean)args.get(EXCLUDE_TMP_ZIP)).booleanValue() && this.isZip(file.getName())) {
            FileUtils.delete((File)file);
        }
    }

    /*
     * Exception decompiling
     */
    private void versionPackUploaded(Map args) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void versionPackDownloaded(Map args) {
        String filePath = (String)args.get(FILE_PATH_KEY);
        File zipFile = new File(filePath);
        FileUtils.delete((File)zipFile);
    }

    private String getHistoryPath(AlgorithmVersionInfo version, IPathFactory pathFactory, FileInfo file) {
        String fileSystemPath = pathFactory.getPath(file);
        String regex = "^.*/" + version.getInfo().getName() + "/[^/]+/[^/]+/(.+)/[^/]+/?$";
        String replacement = this.getSymbolicRootName() + "/" + version.getInfo().getName() + "/" + version.getId() + "/$1";
        return fileSystemPath.replaceAll(regex, replacement);
    }

    final String getVersionPropertyNamesPath() {
        String tag = "version.property.names.file";
        String path = this.getStringProperty("version.property.names.file");
        return path;
    }

    public final String getAlgorithmPropertyNamesPath() {
        String tag = "algorithm.property.names.file";
        String path = this.getStringProperty("algorithm.property.names.file");
        return path;
    }

    public String getAlgorithmRepositoryPath() {
        return this.algorithmRepositoryPath;
    }

    public synchronized Category createCategory(String parentCategoryId, String name) throws RemoteException, CategoriesFileNotSavedException {
        boolean savexml = true;
        boolean toNotify = true;
        return this.createCategory(parentCategoryId, name, savexml, toNotify);
    }

    private Category createCategory(String parentCategoryId, String name, boolean savexml, boolean toNotify) {
        Category parentCategory = null;
        if (parentCategoryId != null && (parentCategory = this.categorySet.getCategory(parentCategoryId)) == null) {
            Server.logSevereMessage("Falha na cria\u00e7\u00e3o da categoria [" + name + "]: categoria pai inexistente.");
            return null;
        }
        Category category = this.categorySet.createCategory(parentCategory, name);
        if (savexml) {
            String errorMsg = "Falha na cria\u00e7\u00e3o da categoria [" + name + "]: arquivo xml n\u00e3o foi salvo.";
            this.saveCategoriesFile(errorMsg);
        }
        if (toNotify) {
            AlgoEvent action = new AlgoEvent(1, (Object)category);
            this.sendEvent(action);
        }
        return category;
    }

    private void setCategorySetSavedFlag(boolean state) {
        this.categorySet.setCategorySetSavedFlag(state);
    }

    private boolean writeCategoriesFile(CategorySet categorySet) throws CategoriesFileNotSavedException {
        String algoRootDir = this.getAndCheckAlgoRootDir();
        if (algoRootDir == null) {
            String message = this.getMessageFormatted("AlgoService.error.category.file.not_found", CATEGORIES_FILE_NAME) + this.getMessageFormatted("AlgoService.error.category.root_dir.invalid", new Object[0]);
            throw new CategoriesFileNotSavedException(message);
        }
        return this.writeCategoriesFile(algoRootDir, categorySet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeCategoriesFile(String algoRootDir, CategorySet categorySet) throws CategoriesFileNotSavedException {
        File categoriesFile = new File(algoRootDir, CATEGORIES_FILE_NAME);
        FileWriter catFileWriter = null;
        try {
            catFileWriter = new FileWriter(categoriesFile);
            XmlCategoriesWriter xmlWriter = new XmlCategoriesWriter(categorySet);
            xmlWriter.write((Writer)catFileWriter);
            if (catFileWriter == null) return true;
        }
        catch (IOException e) {
            try {
                String message = String.format("Erro ao ler/escrever o arquivo de categorias (%s).", categoriesFile.getAbsolutePath());
                Server.logSevereMessage(message, e);
                throw new CategoriesFileNotSavedException(this.getMessageFormatted("AlgoService.error.categories.file.not_saved", new Object[0]));
            }
            catch (Throwable throwable) {
                if (catFileWriter == null) throw throwable;
                try {
                    catFileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    String message = String.format("Erro ao tentar fechar o stream de escrita para o arquivo de categorias (%s).", categoriesFile.getAbsolutePath());
                    Server.logSevereMessage(message, e2);
                    throw new CategoriesFileNotSavedException(this.getMessageFormatted("AlgoService.error.categories.file.not_saved", new Object[0]));
                }
            }
        }
        try {
            catFileWriter.close();
            return true;
        }
        catch (IOException e) {
            String message = String.format("Erro ao tentar fechar o stream de escrita para o arquivo de categorias (%s).", categoriesFile.getAbsolutePath());
            Server.logSevereMessage(message, e);
            throw new CategoriesFileNotSavedException(this.getMessageFormatted("AlgoService.error.categories.file.not_saved", new Object[0]));
        }
    }

    public synchronized CategorySet bindAlgorithmsToCategories(List<Object> algoIds, List<String> categoryIds) throws RemoteException, CategoriesFileNotSavedException {
        boolean toNotify = true;
        return this.bindAlgorithmsToCategories(algoIds, categoryIds, toNotify);
    }

    private CategorySet bindAlgorithmsToCategories(List<Object> algoIds, List<String> categoryIds, boolean toNotify) {
        CategorySet modifiedCategories = this.getModifiedCategorySet(categoryIds);
        List<AlgorithmInfo> algoInfoList = this.getAlgorithmInfoList(algoIds);
        this.categorySet.addAlgorithmsToCategories(modifiedCategories.getCategories(), algoInfoList);
        String errorMsg = "Falha na associa\u00e7\u00e3o de algoritmos \u00e0s categorias: arquivo xml n\u00e3o foi salvo.";
        this.saveCategoriesFile(errorMsg);
        if (toNotify) {
            AlgoEvent action = new AlgoEvent(2, (Object)modifiedCategories);
            this.sendEvent(action);
        }
        return modifiedCategories;
    }

    public synchronized CategorySet unbindAlgorithmsFromCategories(List<Object> algoIds, List<String> categoryIds) throws RemoteException, CategoriesFileNotSavedException {
        CategorySet modifiedCategories = this.getModifiedCategorySet(categoryIds);
        List<AlgorithmInfo> algoInfoList = this.getAlgorithmInfoList(algoIds);
        this.categorySet.removeAlgorithmsFromCategories(modifiedCategories.getCategories(), algoInfoList);
        try {
            if (this.writeCategoriesFile(this.categorySet)) {
                this.setCategorySetSavedFlag(true);
            }
        }
        catch (CategoriesFileNotSavedException ex) {
            Server.logSevereMessage("Falha na desassocia\u00e7\u00e3o de algoritmos \u00e0s categorias: arquivo xml n\u00e3o foi salvo.");
            this.setCategorySetSavedFlag(false);
            throw ex;
        }
        finally {
            AlgoEvent action = new AlgoEvent(2, (Object)modifiedCategories);
            this.sendEvent(action);
        }
        return modifiedCategories;
    }

    private CategorySet getModifiedCategorySet(List<String> categoryIds) {
        CategorySet modifiedCategorySet = new CategorySet();
        for (String categoryId : categoryIds) {
            Category category = this.categorySet.getCategory(categoryId);
            if (category == null) {
                Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.category.not_found", categoryId));
                continue;
            }
            modifiedCategorySet.addCategory(category);
        }
        return modifiedCategorySet;
    }

    private List<AlgorithmInfo> getAlgorithmInfoList(List<Object> algoIds) {
        Vector<AlgorithmInfo> algoInfoList = new Vector<AlgorithmInfo>();
        for (Object algoId : algoIds) {
            try {
                this.checkAlgorithmAdminPermission(algoId);
            }
            catch (PermissionException pe) {
                Server.logSevereMessage(pe.getMessage());
                continue;
            }
            AlgorithmInfo algoInfo = this.getInfo(algoId);
            if (algoInfo == null) {
                Server.logSevereMessage(this.getAlgoNotFoundMessage(algoId));
            }
            algoInfoList.add(algoInfo);
        }
        return algoInfoList;
    }

    public synchronized Category removeCategory(String categoryId) throws RemoteException, CategoriesFileNotSavedException {
        Category removedCategory = this.categorySet.removeCategory(categoryId);
        if (removedCategory == null) {
            String catMsgError = this.getMessageFormatted("AlgoService.error.category.remove_failed", categoryId) + "\n" + this.getMessageFormatted("AlgoService.error.category.not_found", categoryId);
            Server.logSevereMessage(catMsgError);
            throw new ServiceFailureException(catMsgError);
        }
        try {
            if (this.writeCategoriesFile(this.categorySet)) {
                this.setCategorySetSavedFlag(true);
            }
        }
        catch (CategoriesFileNotSavedException ex) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.category.remove_failed", categoryId) + "\n" + this.getMessageFormatted("AlgoService.error.category.file.not_saved", CATEGORIES_FILE_NAME));
            this.setCategorySetSavedFlag(true);
            throw ex;
        }
        finally {
            AlgoEvent action = new AlgoEvent(3, (Object)removedCategory);
            this.sendEvent(action);
        }
        return removedCategory;
    }

    public Category getCategory(String id) throws RemoteException {
        Category category = this.categorySet.getCategory(id);
        return category;
    }

    private String getAndCheckAlgoRootDir() {
        File algoDir = new File(this.algorithmRepositoryPath);
        if (!algoDir.exists() || !algoDir.isDirectory()) {
            return null;
        }
        return this.algorithmRepositoryPath;
    }

    public synchronized CategorySet setAlgorithmsToCategories(List<Object> algoIds, List<String> categoryIds) throws RemoteException, CategoriesFileNotSavedException {
        CategorySet modifiedCategories = this.getModifiedCategorySet(categoryIds);
        List<AlgorithmInfo> algoInfoList = this.getAlgorithmInfoList(algoIds);
        this.categorySet.removeAllAlgorithmsFromCategories(modifiedCategories.getCategories());
        this.categorySet.addAlgorithmsToCategories(modifiedCategories.getCategories(), algoInfoList);
        try {
            if (this.writeCategoriesFile(this.categorySet)) {
                this.setCategorySetSavedFlag(true);
            }
        }
        catch (CategoriesFileNotSavedException ex) {
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.category.bind_algorithms_failed", new Object[0]) + "\n" + this.getMessageFormatted("AlgoService.error.category.file.not_saved", CATEGORIES_FILE_NAME));
            this.setCategorySetSavedFlag(false);
            throw ex;
        }
        finally {
            AlgoEvent action = new AlgoEvent(2, (Object)modifiedCategories);
            this.sendEvent(action);
        }
        return modifiedCategories;
    }

    private boolean readCategoriesFile(CategorySet categorySet) {
        String algoRootDir = this.getAndCheckAlgoRootDir();
        if (algoRootDir == null) {
            String message = this.getMessageFormatted("AlgoService.error.category.file.read_failed", CATEGORIES_FILE_NAME) + "\n" + this.getMessageFormatted("AlgoService.error.category.root_dir.invalid", new Object[0]);
            Server.logSevereMessage(message);
            return false;
        }
        return this.readCategoriesFile(algoRootDir, categorySet);
    }

    /*
     * Exception decompiling
     */
    private boolean readCategoriesFile(String algoRootDir, CategorySet categorySet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logCategorySet(CategorySet categorySet) {
        if (categorySet == null) {
            return;
        }
        SortedSet allCategories = categorySet.getAllCategories();
        for (Category category : allCategories) {
            String msg = "Id da categoria pai: " + category.getParentId() + " - Cria\u00e7\u00e3o da categoria com id = " + category.getId() + " : " + category.getName();
            Server.logInfoMessage(msg);
        }
        Server.logInfoMessage("N\u00famero de categorias da raiz: " + categorySet.getSize());
        Server.logInfoMessage("N\u00famero total de categorias criadas: " + allCategories.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream sourceFile, FileOutputStream targetFile) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int bytesLidos = 0;
            while ((bytesLidos = sourceFile.read(buffer)) > 0) {
                targetFile.write(buffer, 0, bytesLidos);
            }
        }
        finally {
            if (sourceFile != null) {
                sourceFile.close();
            }
            if (targetFile != null) {
                targetFile.close();
            }
        }
    }

    private File getAndCheckTempPackRootDir(String timestamp) {
        String tempPackPath = this.tempDirAlgorithmPath + File.separator + timestamp;
        File tempPackDir = new File(tempPackPath);
        try {
            Server.checkDirectory(tempPackPath);
        }
        catch (ServerException e) {
            Server.logSevereMessage(e.getMessage());
            throw new ServiceFailureException(e.getMessage());
        }
        return tempPackDir;
    }

    private String getAlgorithmsPackDTDPath() {
        File dtdFile = new File(DTD_ALGORITHMS_PACK_FILE_NAME);
        String dtdName = dtdFile.getName();
        String message = "Obtendo o caminho absoluto do arquivo de DTD do Pacote de Algoritmos: " + dtdName;
        Server.logInfoMessage(message);
        return dtdName;
    }

    /*
     * Exception decompiling
     */
    private AlgorithmsPack readXMLAlgoPackageFile(File algorithmsPackFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logPackAlgorithms(AlgorithmsPack algorithmsPack) {
        for (AlgorithmInfo info : algorithmsPack.getAlgorithms()) {
            String msg = "PA - Id do algoritmo: " + info.getId() + "\nPA- Nome do algoritmo" + info.getName();
            Server.logInfoMessage(msg);
        }
        Server.logInfoMessage("PA - N\u00famero de algoritmos lidos: " + algorithmsPack.getSize());
    }

    public synchronized ImportAlgorithmsPackTransferInfo prepareImportAlgorithmsPack() throws RemoteException {
        String targetPath;
        this.checkAlgorithmServerAdminPermission();
        User user = Service.getUser();
        TStamp64 timestamp = new TStamp64();
        ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = new ImportAlgorithmsPackDataInfo(user, timestamp);
        this.algoPackTokenMap.put(timestamp.toString(), importAlgoPackDataInfo);
        try {
            targetPath = this.getAndCheckTempPackRootDir(timestamp.toString()).getCanonicalPath() + File.separator + ALGO_PACK_FILE_NAME;
            File f = new File(targetPath);
            f.createNewFile();
        }
        catch (IOException e) {
            String userMessage = this.getMessageFormatted("AlgoService.error.upload_algo_pack.read_file", ALGO_PACK_FILE_NAME);
            Server.logSevereMessage(userMessage, e);
            throw new ServiceFailureException(userMessage);
        }
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.ALGORITHMS_PACK);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(FILE_PATH_KEY, targetPath);
        notifyArgs.put(EXPAND_IF_ZIP, Boolean.TRUE);
        RemoteFileChannelInfo channel = this.createChannel(targetPath, notifyArgs, FileChannelOp.UPLOAD);
        ImportAlgorithmsPackTransferInfo importInfo = new ImportAlgorithmsPackTransferInfo(channel, timestamp.toString());
        return importInfo;
    }

    public synchronized AlgorithmsPack getAlgorithmsPackInfo(String importDataToken) {
        if (importDataToken == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(importDataToken));
        }
        ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = this.algoPackTokenMap.get(importDataToken);
        if (importAlgoPackDataInfo == null) {
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algorithm_pack.invalid_token", importDataToken));
        }
        this.checkUserImportAlgorithmsPackPermission(importAlgoPackDataInfo);
        AlgorithmsPack algorithmsPack = importAlgoPackDataInfo.getAlgoPackage();
        if (algorithmsPack != null) {
            return algorithmsPack;
        }
        try {
            return this.readAlgorithmsPackMetadata(importAlgoPackDataInfo);
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized boolean importAlgorithmsPack(String importDataToken, PAImportOperation ... operations) throws RemoteException {
        if (importDataToken == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(importDataToken));
        }
        ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = this.algoPackTokenMap.get(importDataToken);
        if (importAlgoPackDataInfo == null) {
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algorithm_pack.invalid_token", importDataToken));
        }
        this.checkUserImportAlgorithmsPackPermission(importAlgoPackDataInfo);
        if (!this.isValidAlgorithmsPack(importDataToken)) {
            return false;
        }
        int nOperations = operations.length;
        if (nOperations >= 1 || nOperations <= 3) {
            PAImportOperation paImportOperation = operations[0];
            boolean toReplace = false;
            switch (paImportOperation) {
                case REPLACE_ALGORITHMS: {
                    toReplace = true;
                    return this.addAlgorithmsFromAlgoPackInRepository(importAlgoPackDataInfo, toReplace);
                }
                case KEEP_ALGORITHMS: {
                    toReplace = false;
                    return this.addAlgorithmsFromAlgoPackInRepository(importAlgoPackDataInfo, toReplace);
                }
                case MERGE_ALGORITHMS: {
                    PAImportOperation versionsOp = operations[1];
                    PAImportOperation categoriesOp = operations[2];
                    return this.mergeAlgorithmsFromAlgoPackInRepository(importAlgoPackDataInfo, versionsOp, categoriesOp);
                }
            }
        }
        return true;
    }

    private boolean mergeAlgorithmsFromAlgoPackInRepository(ImportAlgorithmsPackDataInfo importAlgoPackDataInfo, PAImportOperation versionsOp, PAImportOperation categoriesOp) throws RemoteException {
        String token = importAlgoPackDataInfo.getToken().toString();
        if (!importAlgoPackDataInfo.isDescompressed() && !this.isValidAlgorithmsPack(token)) {
            return false;
        }
        System.out.println(String.format("\nEfetuando a importa\u00e7\u00e3o dos algoritmos do Pacote de Algoritmos.", new Object[0]));
        System.out.println(String.format("A opera\u00e7\u00e3o solicitada requer a combina\u00e7\u00e3o (merge) dos algoritmos j\u00e1 existentes no reposit\u00f3rio.\n", new Object[0]));
        AlgorithmsPack algoPackage = importAlgoPackDataInfo.getAlgoPackage();
        List paAlgorithms = algoPackage.getAlgorithms();
        for (AlgorithmInfo paAlgoInfo : paAlgorithms) {
            String paAlgoId = paAlgoInfo.getId();
            Algorithm repAlgo = this.registeredAlgorithms.get(paAlgoId);
            if (repAlgo != null) {
                try {
                    this.importVersionsFromPackToMergeAlgorithms(token, versionsOp, paAlgoInfo, repAlgo);
                    this.importCategoriesFromPackToMergeAlgorithms(token, categoriesOp, paAlgoInfo, repAlgo);
                    continue;
                }
                catch (Exception e) {
                    String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
                    Server.logSevereMessage(clientMsg, e);
                    throw new ServiceFailureException(clientMsg);
                }
            }
            try {
                System.out.println(String.format("Criando o novo algoritmo %s no reposit\u00f3rio.", paAlgoId));
                this.createAlgorithm(token, paAlgoInfo);
            }
            catch (Exception e) {
                String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
                Server.logSevereMessage(clientMsg, e);
                throw new ServiceFailureException(clientMsg);
            }
        }
        return true;
    }

    private boolean importCategoriesFromPackToMergeAlgorithms(String token, PAImportOperation categoriesOp, AlgorithmInfo paAlgoInfo, Algorithm repAlgo) {
        switch (categoriesOp) {
            case REPLACE_CATEGORIES: {
                boolean toReplace = true;
                return this.addCategoriesFromAlgoPackInRepository(token, toReplace, paAlgoInfo, repAlgo);
            }
            case KEEP_CATEGORIES: {
                System.out.println(String.format("Mantendo todas as categorias %s do algoritmo.", paAlgoInfo.getId()));
                return true;
            }
            case MERGE_CATEGORIES: {
                boolean toReplace = false;
                return this.addCategoriesFromAlgoPackInRepository(token, toReplace, paAlgoInfo, repAlgo);
            }
        }
        return false;
    }

    private boolean addCategoriesFromAlgoPackInRepository(String token, boolean toReplace, AlgorithmInfo paAlgoInfo, Algorithm repAlgo) {
        String paAlgoId = paAlgoInfo.getId();
        if (repAlgo == null) {
            return false;
        }
        AlgorithmInfo repAlgoInfo = repAlgo.getInfo();
        System.out.println(String.format("\nRealizando o merge do algoritmo %s do PA no reposit\u00f3rio.", paAlgoId));
        try {
            if (toReplace) {
                System.out.println(String.format("Substituindo o conjunto de categorias associadas ao algoritmo %s.", repAlgoInfo.getId()));
                this.replaceCategoriesToAlgorithmFromPack(paAlgoInfo, repAlgoInfo);
            } else {
                System.out.println(String.format("Associando as categorias do algoritmo %s do PA, e mantendo as categorias j\u00e1 existentes.", repAlgoInfo.getId()));
                this.createAndBindCategoriesToAlgorithmFromPack(paAlgoInfo);
            }
        }
        catch (Exception e) {
            String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
            Server.logSevereMessage(clientMsg, e);
            throw new ServiceFailureException(clientMsg);
        }
        return true;
    }

    private void replaceCategoriesToAlgorithmFromPack(AlgorithmInfo paAlgoInfo, AlgorithmInfo repAlgoInfo) throws CategoriesFileNotSavedException, RemoteException {
        this.unbindAlgorithmsFromCategories(repAlgoInfo);
        this.createAndBindCategoriesToAlgorithmFromPack(paAlgoInfo);
    }

    private void unbindAlgorithmsFromCategories(AlgorithmInfo algoInfo) {
        SortedSet allCategories = this.categorySet.getAllCategories();
        for (Category category : allCategories) {
            Set categoryAlgorithms = category.getAlgorithms();
            if (!categoryAlgorithms.contains(algoInfo)) continue;
            category.removeAlgorithm(algoInfo);
        }
    }

    private void createAndBindCategoriesToAlgorithmFromPack(AlgorithmInfo paAlgoInfo) throws CategoriesFileNotSavedException, RemoteException {
        List paCategoryFullNames = paAlgoInfo.getAlgoPackCategoryFullNames();
        List paCategoriesInRepository = this.categorySet.getCategoriesFromFullNames(paCategoryFullNames);
        List<String> paCategoryIds = null;
        if (paCategoryFullNames.size() != paCategoriesInRepository.size()) {
            Vector<String> paCategoriesToCreate = new Vector<String>(paCategoryFullNames);
            for (Category category : paCategoriesInRepository) {
                paCategoriesToCreate.remove(category.getFullName());
            }
            this.createCategoriesFromAlgoPack(paCategoriesInRepository, paCategoriesToCreate);
            paCategoryIds = this.getCategoryIdsListFromCategories(paCategoriesInRepository);
        } else {
            paCategoryIds = this.getCategoryIdsListFromNames(paCategoryFullNames);
        }
        boolean toNotify = false;
        Vector<Object> algorithmIds = new Vector<Object>();
        algorithmIds.add(paAlgoInfo.getId());
        this.bindAlgorithmsToCategories(algorithmIds, paCategoryIds, toNotify);
    }

    private void createCategoriesFromAlgoPack(List<Category> paCategoriesInRepository, List<String> paCategoryNamesToCreate) throws CategoriesFileNotSavedException, RemoteException {
        Category parentCategory = null;
        Category category = null;
        for (String newCatName : paCategoryNamesToCreate) {
            String[] catLevelNames = newCatName.split(":");
            String parentCategoryFullName = null;
            parentCategory = null;
            System.out.println("teste");
            for (int i = 0; i < catLevelNames.length; ++i) {
                String catName;
                parentCategoryFullName = i == 0 ? null : catLevelNames[i - 1];
                category = this.categorySet.getCategory(parentCategoryFullName, catName = catLevelNames[i]);
                if (category == null) {
                    boolean savexml = false;
                    boolean toNotify = false;
                    String parentCategoryId = parentCategory != null ? parentCategory.getId() : null;
                    category = this.createCategory(parentCategoryId, catName, savexml, toNotify);
                    System.out.println(String.format("Criada a categoria %s de algoritmo do PA.", category.getFullName()));
                }
                parentCategory = category;
            }
            paCategoriesInRepository.add(category);
        }
        String errorMsg = "Falha na cria\u00e7\u00e3o das categorias vindas do Pacote de Algoritmos. Arquivo xml n\u00e3o foi salvo.";
        this.saveCategoriesFile(errorMsg);
    }

    private void saveCategoriesFile(String errorMsg) {
        try {
            if (this.writeCategoriesFile(this.categorySet)) {
                this.setCategorySetSavedFlag(true);
            }
        }
        catch (CategoriesFileNotSavedException ex) {
            Server.logSevereMessage(errorMsg);
            this.setCategorySetSavedFlag(false);
            throw ex;
        }
    }

    private List<String> getCategoryIdsListFromNames(List<String> repCategoryFullNames) {
        Vector<String> categoryIds = new Vector<String>();
        List categories = this.categorySet.getCategoriesFromFullNames(repCategoryFullNames);
        for (Category category : categories) {
            categoryIds.add(category.getId());
        }
        return categoryIds;
    }

    private List<String> getCategoryIdsListFromCategories(List<Category> paCategoriesInRepository) {
        Vector<String> categoryIds = new Vector<String>();
        for (Category category : paCategoriesInRepository) {
            categoryIds.add(category.getId());
        }
        return categoryIds;
    }

    private boolean importVersionsFromPackToMergeAlgorithms(String token, PAImportOperation versionsOp, AlgorithmInfo paAlgoInfo, Algorithm repAlgo) {
        switch (versionsOp) {
            case REPLACE_VERSIONS: {
                boolean toReplace = true;
                return this.addVersionsFromAlgoPackInRepository(token, toReplace, paAlgoInfo, repAlgo);
            }
            case KEEP_VERSIONS: {
                boolean toReplace = false;
                return this.addVersionsFromAlgoPackInRepository(token, toReplace, paAlgoInfo, repAlgo);
            }
        }
        return false;
    }

    private boolean addVersionsFromAlgoPackInRepository(String token, boolean toReplace, AlgorithmInfo paAlgoInfo, Algorithm repAlgo) {
        String paAlgoId = paAlgoInfo.getId();
        if (repAlgo == null) {
            return false;
        }
        AlgorithmInfo repAlgoInfo = repAlgo.getInfo();
        System.out.println(String.format("\nRealizando o merge do algoritmo %s do PA no reposit\u00f3rio.", paAlgoId));
        Vector versions = paAlgoInfo.getVersions();
        for (AlgorithmVersionInfo paVersionInfo : versions) {
            try {
                AlgorithmVersionId versionId = paVersionInfo.getId();
                AlgorithmVersionInfo repVersionInfo = repAlgoInfo.getVersionInfo((Object)versionId);
                if (repVersionInfo == null) {
                    this.createVersion(token, repAlgo, paVersionInfo);
                    System.out.println(String.format("Criando a vers\u00e3o %s do algoritmo.", versionId));
                    continue;
                }
                if (toReplace) {
                    System.out.println(String.format("Substituindo a vers\u00e3o %s do algoritmo.", versionId));
                    boolean toNotify = false;
                    this.removeVersion(paAlgoId, versionId, toNotify);
                    this.createVersion(token, repAlgo, paVersionInfo);
                    continue;
                }
                System.out.println(String.format("Mantendo a vers\u00e3o %s do algoritmo.", versionId));
            }
            catch (Exception e) {
                String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
                Server.logSevereMessage(clientMsg, e);
                throw new ServiceFailureException(clientMsg);
            }
        }
        return true;
    }

    private boolean addAlgorithmsFromAlgoPackInRepository(ImportAlgorithmsPackDataInfo importAlgoPackDataInfo, boolean toReplace) throws RemoteException {
        String token = importAlgoPackDataInfo.getToken().toString();
        if (!importAlgoPackDataInfo.isDescompressed() && !this.isValidAlgorithmsPack(token)) {
            return false;
        }
        System.out.println(String.format("\nEfetuando a importa\u00e7\u00e3o dos algoritmos do Pacote de Algoritmos.", new Object[0]));
        if (toReplace) {
            System.out.println(String.format("A opera\u00e7\u00e3o solicitada requer a substitui\u00e7\u00e3o dos algoritmos j\u00e1 existentes no reposit\u00f3rio.\n", new Object[0]));
        } else {
            System.out.println(String.format("A opera\u00e7\u00e3o solicitada requer a conserva\u00e7\u00e3o dos algoritmos j\u00e1 existentes no reposit\u00f3rio.\n", new Object[0]));
        }
        AlgorithmsPack algoPackage = importAlgoPackDataInfo.getAlgoPackage();
        List paAlgorithms = algoPackage.getAlgorithms();
        for (AlgorithmInfo paAlgoInfo : paAlgorithms) {
            String paAlgoId = paAlgoInfo.getId();
            Algorithm repAlgo = this.registeredAlgorithms.get(paAlgoId);
            if (repAlgo != null) {
                try {
                    if (toReplace) {
                        System.out.println(String.format("Substituindo o algoritmo %s no reposit\u00f3rio.", paAlgoId));
                        this.removeAlgorithm(paAlgoId);
                        this.createAlgorithm(token, paAlgoInfo);
                        continue;
                    }
                    System.out.println(String.format("Mantendo o algoritmo %s j\u00e1 existente no reposit\u00f3rio.", paAlgoId));
                    continue;
                }
                catch (Exception e) {
                    String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
                    Server.logSevereMessage(clientMsg, e);
                    throw new ServiceFailureException(clientMsg);
                }
            }
            try {
                System.out.println(String.format("Criando o novo algoritmo %s no reposit\u00f3rio.", paAlgoId));
                this.createAlgorithm(token, paAlgoInfo);
            }
            catch (Exception e) {
                String clientMsg = this.getMessageFormatted("AlgoService.error.algo.create_failed", paAlgoInfo.getName());
                Server.logSevereMessage(clientMsg, e);
                throw new ServiceFailureException(clientMsg);
            }
        }
        return true;
    }

    private void createAlgorithm(String token, AlgorithmInfo paAlgoInfo) throws ServerException, IOException {
        String paAlgoId = paAlgoInfo.getId();
        String paAlgoName = paAlgoInfo.getName();
        Hashtable paAlgoPropertyValues = paAlgoInfo.getPropertyValues();
        Algorithm newAlgorithm = null;
        newAlgorithm = Algorithm.createAlgorithm(paAlgoId, paAlgoName, paAlgoPropertyValues);
        this.createVersions(token, newAlgorithm, paAlgoInfo.getVersions());
        AlgorithmInfo newAlgoInfo = newAlgorithm.getInfo();
        this.registeredAlgorithms.put(newAlgoInfo.getId(), newAlgorithm);
        this.createAndBindCategoriesToAlgorithmFromPack(paAlgoInfo);
        Server.logInfoMessage("Algoritmo " + paAlgoName + " criado em " + newAlgoInfo.getDirectory());
        String[] path = new String[]{this.getSymbolicRootName()};
        String description = this.getMessageFormatted(HISTORY_CREATE_ALGORITHM, paAlgoName);
        this.appendHistory(path, description);
    }

    private void createVersions(String token, Algorithm newAlgorithm, Vector<AlgorithmVersionInfo> versions) throws IOException {
        for (AlgorithmVersionInfo algoVersionInfo : versions) {
            this.createVersion(token, newAlgorithm, algoVersionInfo);
        }
    }

    private void createVersion(String token, Algorithm repAlgorithm, AlgorithmVersionInfo versionInfo) throws IOException {
        Map versionProperties = versionInfo.getPropertyValues();
        Server.logInfoMessage("Tentando criar uma vers\u00e3o para o algoritmo criado a partir do PA: " + repAlgorithm.getInfo().getId());
        AlgorithmVersionId versionId = versionInfo.getId();
        try {
            repAlgorithm.createVersionStructure(versionId, versionProperties);
            this.copyVersionDocumentationFile(token, repAlgorithm, versionInfo);
            this.copyVersionConfigurationFile(token, repAlgorithm, versionInfo);
            this.copyVersionExecutablesFile(token, repAlgorithm, versionInfo);
        }
        catch (ServerException se) {
            String versionStr = String.format("%d.%d.%d", versionId.getMajor(), versionId.getMinor(), versionId.getPatch());
            Server.logSevereMessage(this.getMessageFormatted("AlgoService.error.algo.version.create_failed", versionStr, repAlgorithm.getInfo().getName()), se);
            throw new ServiceFailureException(versionStr);
        }
        String[] path = new String[]{this.getSymbolicRootName(), repAlgorithm.getInfo().getName()};
        String description = this.getMessageFormatted(HISTORY_CREATE_VERSION, versionId);
        this.appendHistory(path, description);
        Server.logInfoMessage("Vers\u00e3o " + versionId + " criada para algoritmo " + repAlgorithm.getInfo().getName());
    }

    private void copyVersionDocumentationFile(String token, Algorithm newAlgorithm, AlgorithmVersionInfo paVersionInfo) throws IOException {
        AlgorithmInfo repAlgoInfo = newAlgorithm.getInfo();
        String repAlgoId = repAlgoInfo.getId();
        AlgorithmVersionId versionId = paVersionInfo.getId();
        AlgorithmVersionInfo repVersionInfo = repAlgoInfo.getVersionInfo((Object)versionId);
        File paVersionDir = this.getAlgoPackVersionDir(token, repAlgoId, versionId);
        File paDocDir = this.getAlgoPackDocumentationDir(paVersionDir);
        File repDocDir = this.getDocumentationDir(repVersionInfo);
        String[] docHistoryPath = new String[]{this.getSymbolicRootName(), repAlgoInfo.getName(), versionId.toString(), "html"};
        String docHistoryDescPattern = this.getString(HISTORY_UPDATE_DOC);
        this.copyFiles(repVersionInfo, paDocDir, repDocDir, docHistoryPath, docHistoryDescPattern);
        List documentation = FileInfo.createFilesInfo((File)repDocDir);
        repVersionInfo.setDocumentation(documentation);
    }

    private void copyVersionConfigurationFile(String token, Algorithm newAlgorithm, AlgorithmVersionInfo paVersionInfo) throws IOException {
        AlgorithmInfo repAlgoInfo = newAlgorithm.getInfo();
        String repAlgoId = repAlgoInfo.getId();
        AlgorithmVersionId versionId = paVersionInfo.getId();
        AlgorithmVersionInfo repVersionInfo = repAlgoInfo.getVersionInfo((Object)versionId);
        File paVersionDir = this.getAlgoPackVersionDir(token, repAlgoId, versionId);
        File paConfigDir = this.getAlgoPackConfigurationDir(paVersionDir);
        File repConfigDir = this.getConfigurationDir(repVersionInfo);
        String[] configHistoryPath = new String[]{this.getSymbolicRootName(), repAlgoInfo.getName(), versionId.toString(), "configurator"};
        String configHistoryDescPattern = this.getString(HISTORY_UPDATE_CONFIGURATOR);
        this.copyFiles(repVersionInfo, paConfigDir, repConfigDir, configHistoryPath, configHistoryDescPattern);
        List configurators = FileInfo.createFilesInfo((File)repConfigDir);
        repVersionInfo.setConfigurators(configurators);
    }

    private void copyVersionExecutablesFile(String token, Algorithm newAlgorithm, AlgorithmVersionInfo paVersionInfo) throws IOException {
        AlgorithmInfo repAlgoInfo = newAlgorithm.getInfo();
        String repAlgoId = repAlgoInfo.getId();
        AlgorithmVersionId versionId = paVersionInfo.getId();
        AlgorithmVersionInfo repVersionInfo = repAlgoInfo.getVersionInfo((Object)versionId);
        File paVersionDir = this.getAlgoPackVersionDir(token, repAlgoId, versionId);
        File paBinDir = this.getAlgoPackExecutableDir(paVersionDir);
        File repBinDir = this.getExecutableDir(repVersionInfo);
        this.copyPlatformsDirectories(repVersionInfo, paBinDir, repBinDir);
    }

    private void copyFiles(AlgorithmVersionInfo versionInfo, final File paSourceDir, File repTargetDir, String[] historyPath, String historyDescPattern) throws IOException {
        File[] sourceFiles = paSourceDir.listFiles();
        User user = Service.getUser();
        if (sourceFiles == null) {
            return;
        }
        for (File sourceFile : sourceFiles) {
            if (sourceFile.isDirectory()) continue;
            FileInfo file = new FileInfo(sourceFile.getName(), false);
            if (this.isZip(file.getName())) {
                IPathFactory pathFactory = new IPathFactory(){

                    public String getPath(FileInfo fileInfo) {
                        try {
                            return paSourceDir.getCanonicalPath() + File.separator + fileInfo.getPath();
                        }
                        catch (IOException e) {
                            throw new ServiceFailureException(String.format("Falha para identificar o path do diret\u00f3rio %s.", paSourceDir), (Throwable)e);
                        }
                    }
                };
                if (this.extractZipFile(pathFactory, file, user.getId())) continue;
                throw new ServiceFailureException(String.format("Falha ao extrair o conte\u00fado do arquivo compactado %s, localizado em <%s>.", file, pathFactory));
            }
            File targetFile = new File(repTargetDir, sourceFile.getName());
            if (!targetFile.exists()) {
                targetFile.createNewFile();
                this.copyFile(new FileInputStream(sourceFile), new FileOutputStream(targetFile));
            }
            String historyDesc = MessageFormat.format(historyDescPattern, sourceFile.getName());
            this.appendHistory(user.getId(), historyPath, historyDesc);
        }
    }

    private void copyPlatformsDirectories(AlgorithmVersionInfo versionInfo, File paExecutableDir, File repExecutableDir) throws IOException {
        File[] platformDirs = paExecutableDir.listFiles();
        AlgorithmInfo algoInfo = versionInfo.getInfo();
        AlgorithmVersionId versionId = versionInfo.getId();
        if (platformDirs == null) {
            return;
        }
        for (File platformDir : platformDirs) {
            if (!platformDir.isDirectory()) {
                throw new ServiceFailureException(String.format("A plataforma %s n\u00e3o \u00e9 um diret\u00f3rio na vers\u00e3o %s do algoritmo %s do PA.", platformDir, versionId, algoInfo.getId()));
            }
            String[] binHistoryPath = new String[]{this.getSymbolicRootName(), algoInfo.getName(), versionId.toString(), AlgorithmVersionInfo.BIN_DIR};
            String binHistoryDescPattern = this.getString(HISTORY_UPDATE_EXECUTABLE);
            File targetDir = new File(repExecutableDir, platformDir.getName());
            if (!targetDir.exists()) {
                targetDir.mkdirs();
                this.copyFiles(versionInfo, platformDir, targetDir, binHistoryPath, binHistoryDescPattern);
            }
            List executables = FileInfo.createFilesInfo((File)platformDir);
            for (FileInfo file : executables) {
                if (file.isDirectory()) continue;
                String path = null;
                try {
                    path = new File(platformDir, file.getPath()).getAbsolutePath();
                    FileSystem.enableExecutionPermission(path);
                }
                catch (ServerException e) {
                    throw new ServiceFailureException(String.format("Falha ao habilitar permiss\u00e3o de execu\u00e7\u00e3o sobre o arquivo %s.", path), (Throwable)e);
                }
            }
            versionInfo.setPlatformExecutables(platformDir.getName(), executables);
        }
    }

    private File getDocumentationDir(AlgorithmVersionInfo versionInfo) {
        File repDocDir = new File(versionInfo.getDocDirPath());
        if (!repDocDir.exists() || !repDocDir.isDirectory()) {
            String clientMessage = String.format("O diret\u00f3rio de documenta\u00e7\u00e3o n\u00e3o existe para a vers\u00e3o % do algoritmo %s no reposit\u00f3rio.", versionInfo.getId(), versionInfo.getInfo().getId());
            throw new ServiceFailureException(clientMessage);
        }
        return repDocDir;
    }

    private File getConfigurationDir(AlgorithmVersionInfo versionInfo) {
        File repConfigDir = new File(versionInfo.getConfiguratorDirPath());
        if (!repConfigDir.exists() || !repConfigDir.isDirectory()) {
            String clientMessage = String.format("O diret\u00f3rio de configura\u00e7\u00e3o n\u00e3o existe para a vers\u00e3o % do algoritmo %s no reposit\u00f3rio.", versionInfo.getId(), versionInfo.getInfo().getId());
            throw new ServiceFailureException(clientMessage);
        }
        return repConfigDir;
    }

    private File getExecutableDir(AlgorithmVersionInfo versionInfo) {
        File executableDir = new File(versionInfo.getExecutableDirPath());
        if (!executableDir.exists() || !executableDir.isDirectory()) {
            String clientMessage = String.format("O diret\u00f3rio de execut\u00e1veis n\u00e3o existe para a vers\u00e3o % do algoritmo %s no reposit\u00f3rio.", versionInfo.getId(), versionInfo.getInfo().getId());
            throw new ServiceFailureException(clientMessage);
        }
        return executableDir;
    }

    private File getAlgoPackDocumentationDir(File paVersionDir) {
        File paDocDirectory = new File(paVersionDir, "html/");
        if (!paDocDirectory.exists() || !paDocDirectory.isDirectory()) {
            String clientMessage = String.format("O caminho <%s> para o diret\u00f3rio de documenta\u00e7\u00e3o n\u00e3o existe no PA.", paDocDirectory);
            throw new ServiceFailureException(clientMessage);
        }
        return paDocDirectory;
    }

    private File getAlgoPackConfigurationDir(File paVersionDir) {
        File paConfigDir = new File(paVersionDir, "configurator/");
        if (!paConfigDir.exists() || !paConfigDir.isDirectory()) {
            String clientMessage = String.format("O caminho <%s> para o diret\u00f3rio de configura\u00e7\u00e3o n\u00e3o existe no PA.", paConfigDir);
            throw new ServiceFailureException(clientMessage);
        }
        return paConfigDir;
    }

    private File getAlgoPackExecutableDir(File paVersionDir) {
        File paBinDir = new File(paVersionDir, AlgorithmVersionInfo.BIN_DIR + "/");
        if (!paBinDir.exists() || !paBinDir.isDirectory()) {
            String clientMessage = String.format("O caminho <%s> para o diret\u00f3rio de execut\u00e1veis n\u00e3o existe no PA.", paBinDir);
            throw new ServiceFailureException(clientMessage);
        }
        return paBinDir;
    }

    private File getAlgoPackVersionDir(String token, String algoId, AlgorithmVersionId versionId) throws IOException {
        String versionDir = AlgorithmVersionInfo.getDirectoryFor((int)versionId.getMajor(), (int)versionId.getMinor(), (int)versionId.getPatch());
        String paTokenDirPath = this.getAndCheckTempPackRootDir(token).getCanonicalPath();
        File paTokenDirectory = new File(paTokenDirPath);
        String paAlgoDirPath = algoId + "/";
        String paVersionPath = paAlgoDirPath + versionDir + "/";
        File paVersionDir = new File(paTokenDirectory, paVersionPath);
        return paVersionDir;
    }

    private boolean isValidAlgorithmsPack(String importDataToken) throws RemoteException {
        return this.validateAlgorithmsPack(importDataToken).equals(VALID_ALGORITHMS_PACK_MSG);
    }

    private void checkUserImportAlgorithmsPackPermission(ImportAlgorithmsPackDataInfo importAlgoPackDataInfo) {
        if (importAlgoPackDataInfo == null) {
            throw new PermissionException(this.getUserImportAlgoPackPermissionErrorMessage(importAlgoPackDataInfo));
        }
        User user = Service.getUser();
        if (!user.equals((Object)importAlgoPackDataInfo.getUser())) {
            throw new PermissionException(this.getUserImportAlgoPackPermissionErrorMessage(importAlgoPackDataInfo));
        }
    }

    private String getUserImportAlgoPackPermissionErrorMessage(ImportAlgorithmsPackDataInfo importAlgoPackDataInfo) {
        String msg = this.getString(this.ERROR_IMPORT_PA_USER_PERMISSION);
        Object[] args = new Object[]{importAlgoPackDataInfo.getUser().getLogin(), importAlgoPackDataInfo.getToken()};
        return MessageFormat.format(msg, args);
    }

    public synchronized void finishImportAlgorithmsPack(String importDataToken) throws RemoteException {
        if (importDataToken == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(importDataToken));
        }
        ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = this.algoPackTokenMap.get(importDataToken);
        if (importAlgoPackDataInfo == null) {
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algorithm_pack.invalid_token", importDataToken));
        }
        this.checkUserImportAlgorithmsPackPermission(importAlgoPackDataInfo);
        this.removeAlgoPackTokensDirs(importDataToken);
    }

    private void removeAlgoPackTokensDirs(String importDataToken) {
        String paDirPath;
        try {
            paDirPath = this.getAndCheckTempPackRootDir(importDataToken).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        File tempDirFile = new File(paDirPath);
        if (!FileUtils.delete((File)tempDirFile)) {
            String detailedMessage = String.format("Erro ao tentar excluir o diret\u00f3rio %s.\nPor favor, tente exclu\u00ed-lo manualmente.\n", tempDirFile.getAbsolutePath());
            Server.logWarningMessage(detailedMessage);
        }
        this.algoPackTokenMap.remove(importDataToken);
    }

    private AlgorithmsPack readAlgorithmsPackMetadata(ImportAlgorithmsPackDataInfo importAlgoPackDataInfo) throws IOException {
        String importDataToken = importAlgoPackDataInfo.getToken().toString();
        String paFileUserLogin = importAlgoPackDataInfo.getUser().getLogin();
        String filePath = this.getAndCheckTempPackRootDir(importDataToken).getCanonicalPath() + File.separator + ALGO_PACK_FILE_NAME;
        File paFile = new File(filePath);
        ZipFile zipFile = new ZipFile(paFile);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        if (!e.hasMoreElements()) {
            String userMessage = "Formato inv\u00e1lido do Pacote de Algoritmos: arquivo est\u00e1 vazio.";
            String detailedMessage = String.format("%sDetalhes: o arquivo zip est\u00e1 vazio.\nArquivo utilizado: %s.\nIdentificador do usu\u00e1rio: %s.\n", userMessage, filePath, paFileUserLogin);
            Server.logSevereMessage(detailedMessage);
            return null;
        }
        ZipEntry xmlEntry = zipFile.getEntry(ALGO_PACK_METADATA_FILE_NAME);
        if (xmlEntry == null) {
            String clientMessage = String.format("Arquivo de metadados %s n\u00e3o encontrado no Pacote de Algoritmos.", ALGO_PACK_METADATA_FILE_NAME);
            Server.logSevereMessage(clientMessage);
            throw new ServiceFailureException(clientMessage);
        }
        System.out.println("Lendo o arquivo xml de metadados do PA (zip): " + xmlEntry.getName());
        File file = new File(this.getAndCheckTempPackRootDir(importDataToken).getCanonicalPath(), xmlEntry.getName());
        AlgorithmsPack algorithmsPack = null;
        if (!file.exists()) {
            file.createNewFile();
            this.copyFile(zipFile.getInputStream(xmlEntry), new FileOutputStream(file));
            algorithmsPack = this.readXMLAlgoPackageFile(file);
            importAlgoPackDataInfo.setAlgoPackage(algorithmsPack);
        }
        zipFile.close();
        return algorithmsPack;
    }

    public String validateAlgorithmsPack(String importDataToken) throws RemoteException {
        if (importDataToken == null) {
            throw new IllegalArgumentException(this.getParameterNullMessage(importDataToken));
        }
        String errorMessage = INVALID_ALGORITHMS_PACK_MSG;
        ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = this.algoPackTokenMap.get(importDataToken);
        if (importAlgoPackDataInfo == null) {
            throw new ServiceFailureException(this.getMessageFormatted("AlgoService.error.algorithm_pack.invalid_token", importDataToken));
        }
        this.checkUserImportAlgorithmsPackPermission(importAlgoPackDataInfo);
        AlgorithmsPack algorithmsPack = importAlgoPackDataInfo.getAlgoPackage();
        try {
            if (algorithmsPack == null) {
                algorithmsPack = this.readAlgorithmsPackMetadata(importAlgoPackDataInfo);
            }
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        List paAlgorithms = algorithmsPack.getAlgorithms();
        Vector validsAlgorithms = new Vector(paAlgorithms);
        Iterator<Object> validsAlgorithmsIterator = validsAlgorithms.iterator();
        try {
            errorMessage = errorMessage + this.validateAlgoPackAlgorithmsDirs(validsAlgorithmsIterator, importDataToken);
            validsAlgorithmsIterator = validsAlgorithms.iterator();
            errorMessage = errorMessage + this.validateAlgoPackVersionsDirs(validsAlgorithmsIterator, importDataToken);
            validsAlgorithmsIterator = validsAlgorithms.iterator();
            try {
                errorMessage = errorMessage + this.validateAlgoPackVersionsStructure(validsAlgorithmsIterator, importDataToken);
            }
            catch (ServerException e) {
                throw new ServiceFailureException(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        boolean isValid = paAlgorithms.size() == validsAlgorithms.size();
        String resultMessage = isValid ? VALID_ALGORITHMS_PACK_MSG : errorMessage;
        Server.logSevereMessage(resultMessage);
        return resultMessage;
    }

    private String validateAlgoPackVersionsStructure(Iterator<AlgorithmInfo> validsAlgorithmsIterator, String importDataToken) throws RemoteException, IOException, ServerException {
        String algoMessage = "";
        String paTokenDirPath = this.getAndCheckTempPackRootDir(importDataToken).getCanonicalPath();
        String paFilePath = paTokenDirPath + File.separator + ALGO_PACK_FILE_NAME;
        File paFile = new File(paFilePath);
        Unzip unzipFile = new Unzip(paFile);
        while (validsAlgorithmsIterator.hasNext()) {
            AlgorithmInfo algoInfo = validsAlgorithmsIterator.next();
            String algoId = algoInfo.getId();
            Object[] versionIds = algoInfo.getVersionIds();
            String message = "";
            for (Object object : versionIds) {
                AlgorithmVersionId versionId = (AlgorithmVersionId)object;
                int major = versionId.getMajor();
                int minor = versionId.getMinor();
                int patch = versionId.getPatch();
                String versionDir = AlgorithmVersionInfo.getDirectoryFor((int)major, (int)minor, (int)patch);
                String algoDirPath = algoId + "/";
                String paVersionPath = algoDirPath + versionDir + "/";
                File paTokenDirectory = new File(paTokenDirPath);
                ImportAlgorithmsPackDataInfo importAlgoPackDataInfo = this.algoPackTokenMap.get(importDataToken);
                if (!importAlgoPackDataInfo.isDescompressed()) {
                    unzipFile.decompress(paTokenDirectory);
                    importAlgoPackDataInfo.setDescompressed(true);
                }
                File versionDirectory = new File(paTokenDirectory, paVersionPath);
                message = message + this.validateAlgoPackDocumentationDirectory(versionDirectory, versionId);
                message = message + this.validateAlgoPackConfigurationDirectory(versionDirectory, versionId);
                message = message + this.validateAlgoPackBinaryDirectory(versionDirectory, versionId);
            }
            if (message.isEmpty()) continue;
            algoMessage = algoMessage + (message.isEmpty() ? "" : String.format("\n>> Algoritmo com id <%s>:\n", algoId) + message);
            validsAlgorithmsIterator.remove();
        }
        String resultMessage = algoMessage.isEmpty() ? "" : "\n*** Vers\u00f5es com estrutura (bin\u00e1rios, docs e configurador) inv\u00e1lida no PA:\n" + algoMessage;
        return resultMessage;
    }

    private String validateAlgoPackDocumentationDirectory(File versionDirectory, AlgorithmVersionId versionId) {
        String message = "";
        String identation = "   ";
        File docDirectory = new File(versionDirectory, "html/");
        if (!docDirectory.exists() || !docDirectory.isDirectory()) {
            message = message + String.format("%sVers\u00e3o %s: Diret\u00f3rio de documenta\u00e7\u00e3o <%s> ausente.\n", identation, versionId, "html");
        }
        return message;
    }

    private String validateAlgoPackConfigurationDirectory(File versionDirectory, AlgorithmVersionId versionId) {
        String message = "";
        String identation = "   ";
        File configDirectory = new File(versionDirectory, "configurator/");
        if (!configDirectory.exists() || !configDirectory.isDirectory()) {
            message = message + String.format("%sVers\u00e3o %s: Diret\u00f3rio de configura\u00e7\u00e3o <%s> ausente.\n", identation, versionId, "configurator");
        }
        return message;
    }

    private String validateAlgoPackBinaryDirectory(File versionDirectory, AlgorithmVersionId versionId) {
        File[] platformDirectories;
        String message = "";
        String identation = "   ";
        File binaryDirectory = new File(versionDirectory, AlgorithmVersionInfo.BIN_DIR + "/");
        if (!binaryDirectory.exists() || !binaryDirectory.isDirectory()) {
            message = message + String.format("%sVers\u00e3o %s: Diret\u00f3rio de bin\u00e1rios <%s> ausente.\n", identation, versionId, AlgorithmVersionInfo.BIN_DIR);
        }
        if ((platformDirectories = binaryDirectory.listFiles()) != null) {
            for (File platformDirectory : platformDirectories) {
                if (platformDirectory.isDirectory()) continue;
                message = message + String.format("%sVers\u00e3o %s: A plataforma <%s> deveria ser um diret\u00f3rio.\n", identation, versionId, platformDirectory.getName());
            }
        }
        return message;
    }

    private String validateAlgoPackAlgorithmsDirs(Iterator<AlgorithmInfo> validsAlgorithmsIterator, String importDataToken) throws RemoteException, IOException {
        String message = "";
        while (validsAlgorithmsIterator.hasNext()) {
            AlgorithmInfo algoInfo = validsAlgorithmsIterator.next();
            String algoId = algoInfo.getId();
            String algoDirPath = algoId + "/";
            if (this.validateAlgoPackDir(algoDirPath, importDataToken)) continue;
            message = message + String.format(">> Algoritmo com id: %s\n", algoId);
            validsAlgorithmsIterator.remove();
        }
        String resultMessage = message.isEmpty() ? "" : "\n*** N\u00e3o h\u00e1 diret\u00f3rios correspondentes aos identificadores dos algoritmos especificados no metadados do PA:\n" + message;
        return resultMessage;
    }

    private String validateAlgoPackVersionsDirs(Iterator<AlgorithmInfo> validsAlgorithmsIterator, String importDataToken) throws RemoteException, IOException {
        String algoMessage = "";
        String identation = "   ";
        while (validsAlgorithmsIterator.hasNext()) {
            AlgorithmInfo algoInfo = validsAlgorithmsIterator.next();
            String algoId = algoInfo.getId();
            Object[] versionIds = algoInfo.getVersionIds();
            boolean validsVersionsDirs = true;
            String message = "";
            for (Object object : versionIds) {
                AlgorithmVersionId versionId = (AlgorithmVersionId)object;
                int major = versionId.getMajor();
                int minor = versionId.getMinor();
                int patch = versionId.getPatch();
                String versionDir = AlgorithmVersionInfo.getDirectoryFor((int)major, (int)minor, (int)patch);
                String algoDirPath = algoId + "/";
                String paVersionPath = algoDirPath + versionDir + "/";
                if (this.validateAlgoPackDir(paVersionPath, importDataToken)) continue;
                validsVersionsDirs = false;
                message = message + String.format("%sDiret\u00f3rio de vers\u00e3o n\u00e3o encontrado: %s\n", identation, versionDir);
            }
            if (validsVersionsDirs) continue;
            algoMessage = algoMessage + (message.isEmpty() ? "" : String.format("\n>> Algoritmo com id <%s>:\n", algoId) + message);
            validsAlgorithmsIterator.remove();
        }
        String resultMessage = algoMessage.isEmpty() ? "" : "\n*** N\u00e3o h\u00e1 diret\u00f3rios correspondentes aos ids das vers\u00f5es dos algoritmos especificados no metadados do PA:\n" + algoMessage;
        return resultMessage;
    }

    private boolean validateAlgoPackDir(String dirPath, String importDataToken) throws RemoteException, IOException {
        ZipEntry algoEntry = this.getAlgoPathEntry(dirPath, importDataToken);
        if (algoEntry == null) {
            return false;
        }
        return algoEntry.isDirectory();
    }

    private ZipEntry getAlgoPathEntry(String dirPath, String importDataToken) throws RemoteException, IOException {
        String filePath = this.getAndCheckTempPackRootDir(importDataToken).getCanonicalPath() + File.separator + ALGO_PACK_FILE_NAME;
        File paFile = new File(filePath);
        ZipFile zipFile = new ZipFile(paFile);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        if (!e.hasMoreElements()) {
            return null;
        }
        ZipEntry algoEntry = zipFile.getEntry(dirPath);
        if (algoEntry == null) {
            return null;
        }
        return algoEntry;
    }

    private void sendEvent(AlgoEvent event) {
        MessageService.getInstance().sendToAll(new Message((Serializable)event));
    }

    public RemoteFileChannelInfo openExecFileChannel(Object algoId, Object versionId, String platformName, String fileName, boolean readOnly) throws RemoteException {
        if (!readOnly) {
            this.checkAlgorithmAdminPermission(algoId);
        }
        if (!this.execFileExists(algoId, versionId, platformName, fileName)) {
            Algorithm algo = this.registeredAlgorithms.get(algoId);
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.exec_file_not_exists", fileName, algo.getInfo().getId(), versionId, platformName);
            Server.logSevereMessage(userMessage);
            throw new ServiceFailureException(userMessage);
        }
        String platformPath = this.getPlatformPath(algoId, versionId, platformName);
        String targetPath = platformPath + File.separator + fileName;
        HashMap<String, Object> notifyArgs = new HashMap<String, Object>();
        notifyArgs.put(ALGO_FILE_TYPE_KEY, (Object)AlgoFileType.EXECUTABLE);
        notifyArgs.put(USER_ID_KEY, Service.getUser().getId());
        notifyArgs.put(ALGO_ID_KEY, algoId);
        notifyArgs.put(VERSION_ID_KEY, versionId);
        notifyArgs.put(PLATFORM_NAME_KEY, platformName);
        notifyArgs.put(FILE_NAME_KEY, fileName);
        return this.createChannel(targetPath, notifyArgs, readOnly ? FileChannelOp.READ : FileChannelOp.WRITE);
    }

    public RemoteFileChannelInfo openDocFileChannel(Object algoId, Object versionId, String fileName, boolean readOnly) throws RemoteException {
        if (!readOnly) {
            this.checkAlgorithmAdminPermission(algoId);
        }
        if (!this.docFileExists(algoId, versionId, fileName)) {
            Algorithm algo = this.registeredAlgorithms.get(algoId);
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.doc_file_not_exists", fileName, algo.getInfo().getId(), versionId);
            Server.logSevereMessage(userMessage);
            throw new ServiceFailureException(userMessage);
        }
        String docDirPath = this.getDocumentationDirPath(algoId, versionId);
        String sourcePath = docDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, readOnly ? FileChannelOp.READ : FileChannelOp.WRITE);
    }

    public RemoteFileChannelInfo openConfFileChannel(Object algoId, Object versionId, String fileName, boolean readOnly) throws RemoteException {
        if (!readOnly) {
            this.checkAlgorithmAdminPermission(algoId);
        }
        if (!this.configFileExists(algoId, versionId, fileName)) {
            Algorithm algo = this.registeredAlgorithms.get(algoId);
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.config_file_not_exists", fileName, algo.getInfo().getId(), versionId);
            Server.logSevereMessage(userMessage);
            throw new ServiceFailureException(userMessage);
        }
        String configDirPath = this.getConfiguratorDirPath(algoId, versionId);
        String sourcePath = configDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, readOnly ? FileChannelOp.READ : FileChannelOp.WRITE);
    }

    public RemoteFileChannelInfo openReleaseNotesFileChannel(Object algoId, Object versionId, String fileName, boolean readOnly) throws RemoteException {
        if (!readOnly) {
            this.checkAlgorithmAdminPermission(algoId);
        }
        if (!this.releaseNotesFileExists(algoId, versionId, fileName)) {
            Algorithm algo = this.registeredAlgorithms.get(algoId);
            String userMessage = this.getMessageFormatted("AlgoService.error.algo.release_notes_file_not_exists", fileName, algo.getInfo().getId(), versionId);
            Server.logSevereMessage(userMessage);
            throw new ServiceFailureException(userMessage);
        }
        String configDirPath = this.getReleaseNotesDirPath(algoId, versionId);
        String sourcePath = configDirPath + File.separator + fileName;
        return this.createChannel(sourcePath, null, readOnly ? FileChannelOp.READ : FileChannelOp.WRITE);
    }

    private class ReloadAlgsThread
    extends Thread {
        private final int reloadIntervalInMilis;

        ReloadAlgsThread(int reloadAlgIntervalInMinutes) {
            this.reloadIntervalInMilis = reloadAlgIntervalInMinutes * 60 * 1000;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (!AlgorithmService.this.shutdown) {
                try {
                    ReloadAlgsThread.sleep(this.reloadIntervalInMilis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (AlgorithmService.this.shutdown) break;
                try {
                    Service.setUserId(User.getAdminId());
                    AlgorithmService.this.reloadAlgorithms(false);
                }
                catch (PermissionException pe) {
                    Server.logSevereMessage("Usu\u00e1rio admin n\u00e3o pode fazer recarga dos algoritmos", pe);
                }
            }
        }
    }

    private class UpdateExecutableThread
    extends Thread {
        private static final int BUFFER_SIZE = 65536;
        private static final String ZIP_EXTENSION = "zip";
        private final Object algoId;
        private final String filePath;
        private final String platform;
        private final Object userId;
        private final Object versionId;

        public UpdateExecutableThread(Object algoId, Object versionId, String platform, String filePath, Object userId) {
            this.algoId = algoId;
            this.versionId = versionId;
            this.platform = platform;
            this.filePath = filePath;
            this.userId = userId;
        }

        @Override
        public void run() {
            Server.logInfoMessage("Thread iniciada: updateExecutable.");
            Algorithm algo = (Algorithm)AlgorithmService.this.registeredAlgorithms.get(this.algoId);
            if (algo == null) {
                return;
            }
            Collection<Object> fileNames = new HashSet<String>();
            fileNames.add(FileUtils.getFileName((String)this.filePath));
            if (this.isZip(this.filePath)) {
                fileNames = this.getZippedFileNames(this.filePath);
                if (fileNames == null) {
                    return;
                }
                this.removeZip(this.filePath);
            }
            try {
                algo.updateExecutables(this.versionId, this.platform);
            }
            catch (OperationFailureException oe) {
                this.logAndNotifyError(this.userId, oe);
            }
            AlgorithmInfo info = algo.getInfo();
            AlgorithmService.this.fireModifyEvent(info);
            String[] path = new String[]{AlgorithmService.this.getSymbolicRootName(), info.getName(), this.versionId.toString(), AlgorithmVersionInfo.BIN_DIR, this.platform};
            for (String string : fileNames) {
                String description = MessageFormat.format(AlgorithmService.this.getString(AlgorithmService.HISTORY_UPDATE_EXECUTABLE), string);
                AlgorithmService.this.appendHistory(this.userId, path, description);
            }
            Server.logInfoMessage("Terminando Thread updateExecutable.");
        }

        private void extractZipEntry(ZipEntry entry, ZipInputStream in, String outputPath) throws IOException {
            FilterOutputStream out = null;
            try {
                int bytesRead;
                String outputFilePath = outputPath + File.separator + entry.getName();
                out = new BufferedOutputStream(new FileOutputStream(outputFilePath), 65536);
                byte[] buffer = new byte[65536];
                while ((bytesRead = in.read(buffer, 0, 65536)) != -1) {
                    ((BufferedOutputStream)out).write(buffer, 0, bytesRead);
                }
                ((BufferedOutputStream)out).flush();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Server.logSevereMessage("Falha ao fechar stream de grava\u00e7\u00e3o para o arquivo " + entry.getName(), e);
                    }
                }
            }
        }

        private Collection<String> getZippedFileNames(String filePath) {
            Collection<String> fileNames = null;
            String outputPath = FileUtils.getFilePath((String)filePath);
            try {
                fileNames = this.unzip(filePath, outputPath);
            }
            catch (OperationFailureException oe) {
                String serverMsg = "Falha em pedido de servi\u00e7o para usu\u00e1rio " + this.userId;
                String zipName = FileUtils.getFileName((String)filePath);
                String clientMsg = MessageFormat.format(AlgorithmService.this.getString("server.algoservice.error.unzip"), zipName);
                ServiceFailureException se = new ServiceFailureException(clientMsg, (Throwable)oe);
                Server.logSevereMessage(serverMsg, (Throwable)se);
                String[] ids = new String[]{(String)this.userId};
                try {
                    MessageService.getInstance().send(new Message((Serializable)new UserNotification(Service.getUser().getLogin(), clientMsg, false, false)), ids);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Erro ao enviar evento listando os arquivos de um pacote de algoritmo.", e);
                }
            }
            return fileNames;
        }

        private boolean isZip(String path) {
            return "zip".equalsIgnoreCase(FileUtils.getFileExtension((String)path));
        }

        private void logAndNotifyError(Object userId, OperationFailureException oe) {
            String serverMsg = "Falha em pedido de servi\u00e7o para usu\u00e1rio " + userId;
            String clientMsg = AlgorithmService.this.getString("server.algoservice.error.update_tree");
            ServiceFailureException se = new ServiceFailureException(clientMsg, (Throwable)oe);
            Server.logSevereMessage(serverMsg, (Throwable)se);
            String[] ids = new String[]{(String)userId};
            try {
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(Service.getUser().getLogin(), clientMsg, false, false)), ids);
            }
            catch (RemoteException e) {
                Server.logSevereMessage("Erro ao enviar evento de notifica\u00e7\u00e3o de erro.", e);
            }
        }

        private void removeZip(String filePath) {
            if (!new File(filePath).delete()) {
                Server.logSevereMessage("N\u00e3o foi poss\u00edvel remover o arquivo zip " + filePath);
            }
        }

        private Collection<String> unzip(String inputFilePath, String outputPath) throws OperationFailureException {
            ZipInputStream in = null;
            HashSet<String> extractedFileNames = new HashSet<String>();
            try {
                ZipEntry entry;
                in = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFilePath)));
                while ((entry = in.getNextEntry()) != null) {
                    extractedFileNames.add(entry.getName());
                    this.extractZipEntry(entry, in, outputPath);
                }
            }
            catch (IOException e) {
                String serverMsg = AlgorithmService.this.getMessageFormatted("AlgoService.error.file.open_failed", new Object[]{inputFilePath});
                throw new OperationFailureException(serverMsg, (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Server.logSevereMessage("Falha ao fechar arquivo " + inputFilePath, e);
                    }
                }
            }
            return extractedFileNames;
        }
    }

    private class Requester
    implements FTCRequester {
        private Map<String, Object> notifyArgs = null;
        private boolean readOnly;

        Requester(Map<String, Object> notifyArgs, boolean readOnly) {
            this.notifyArgs = notifyArgs;
            this.readOnly = readOnly;
        }

        @Override
        public FileChannel createFileChannel(IRepositoryFile file, boolean readOnly) throws Exception {
            if (this.readOnly && !readOnly) {
                String msg = "Tentativa de abrir arquivo RO para escrita: " + file.getPath();
                Server.logSevereMessage(msg);
                throw new Exception(msg);
            }
            String mode = readOnly ? "r" : "rw";
            try {
                return file.getFileChannel(mode);
            }
            catch (FileNotFoundException e) {
                Server.logSevereMessage("Arquivo n\u00e3o encontrado: " + file.getPath(), e);
                return null;
            }
        }

        @Override
        public void fileChannelClosed(IRepositoryFile file) throws Exception {
            try {
                file.close();
            }
            catch (IOException e) {
                Server.logSevereMessage("Erro ao tentar fechar arquivo utilizado pelo servidor de arquivos: " + file.getName(), e);
            }
            if (this.notifyArgs == null) {
                return;
            }
            AlgoFileType type = (AlgoFileType)((Object)this.notifyArgs.get(AlgorithmService.ALGO_FILE_TYPE_KEY));
            Object userId = this.notifyArgs.get(AlgorithmService.USER_ID_KEY);
            Object algoId = this.notifyArgs.get(AlgorithmService.ALGO_ID_KEY);
            Algorithm algo = null;
            if (algoId != null && type != AlgoFileType.ALGORITHMS_PACK && (algo = (Algorithm)AlgorithmService.this.registeredAlgorithms.get(algoId)) == null) {
                String detailedMessage = String.format("O algoritmo %s n\u00e3o foi encontrado.\n", algoId);
                Server.logSevereMessage(detailedMessage);
                String userMsg = AlgorithmService.this.getString("server.algoservice.error.algo_dir_not_found");
                String[] ids = new String[]{(String)userId};
                String login = User.getUser((Object)userId).getLogin();
                MessageService.getInstance().send(new Message((Serializable)new UserNotification(login, userMsg, false, false)), ids);
                return;
            }
            switch (type) {
                case CONFIGURATION: {
                    AlgorithmService.this.configurationUploaded(this.notifyArgs);
                    break;
                }
                case DOCUMENTATION: {
                    AlgorithmService.this.documentationUploaded(this.notifyArgs);
                    break;
                }
                case RELEASE_NOTES: {
                    AlgorithmService.this.releaseNotesUploaded(this.notifyArgs);
                    break;
                }
                case EXECUTABLE: {
                    if (this.notifyArgs.containsKey(AlgorithmService.EXPAND_IF_ZIP)) {
                        AlgorithmService.this.executableUploaded(this.notifyArgs);
                        break;
                    }
                    if (!this.notifyArgs.containsKey(AlgorithmService.EXCLUDE_TMP_ZIP)) break;
                    AlgorithmService.this.executableDownloaded(this.notifyArgs);
                    break;
                }
                case VERSION_PACK: {
                    boolean toExpand = (Boolean)this.notifyArgs.get(AlgorithmService.EXPAND_IF_ZIP);
                    if (toExpand) {
                        AlgorithmService.this.versionPackUploaded(this.notifyArgs);
                        break;
                    }
                    AlgorithmService.this.versionPackDownloaded(this.notifyArgs);
                    break;
                }
                default: {
                    throw new BugException(AlgorithmService.this.getMessageFormatted("AlgoService.error.algo.file.type_unknown", new Object[]{type}));
                }
            }
            AlgorithmInfo algoInfo = algo.getInfo();
            AlgorithmService.this.fireModifyEvent(algoInfo);
        }

        @Override
        public boolean isLocked(IRepositoryFile file) throws Exception {
            return false;
        }
    }

    private static enum FileChannelOp {
        UPLOAD,
        DOWNLOAD,
        READ,
        WRITE;

    }

    private static enum AlgoFileType {
        EXECUTABLE,
        CONFIGURATION,
        DOCUMENTATION,
        RELEASE_NOTES,
        VERSION_PACK,
        ALGORITHMS_PACK;

    }
}

