/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.InfoException;
import csbase.exception.InvalidRequestException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.AdministrationEvent;
import csbase.logic.AttributesPermission;
import csbase.logic.ClientOptimizationMode;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientProjectFileInfo;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.FileInfoSearchResult;
import csbase.logic.FileLockListenerInterface;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectAdminPermission;
import csbase.logic.ProjectAllocationState;
import csbase.logic.ProjectAttribute;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectFileInfo;
import csbase.logic.ProjectFileTypeInfo;
import csbase.logic.ProjectNotification;
import csbase.logic.ProjectPermissions;
import csbase.logic.ProjectUserEvent;
import csbase.logic.ReadOnlyProjectPermission;
import csbase.logic.RevokeProjectPermission;
import csbase.logic.SharedProjectEvent;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.UserProjectInfo;
import csbase.logic.UsersNotification;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.plugin.service.projectservice.IProjectService;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.DefaultProjectTemplate;
import csbase.server.services.projectservice.FileLockInterface;
import csbase.server.services.projectservice.FileLockManager;
import csbase.server.services.projectservice.FileUpdateInfo;
import csbase.server.services.projectservice.ProjectAdministrator;
import csbase.server.services.projectservice.ProjectFileTypeRepository;
import csbase.server.services.projectservice.ProjectFileUpdateScheduler;
import csbase.server.services.projectservice.ProjectTemplate;
import csbase.server.services.projectservice.ServerProject;
import csbase.server.services.projectservice.ServerProjectFile;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.projectservice.UpdatableFileLocation;
import csbase.util.messages.Message;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileFinder;
import tecgraf.javautils.core.io.FileUtils;

public class ProjectService
extends Service
implements ProjectServiceInterface,
IProjectService {
    private static final String LNG_PREFIX = "ProjectService.";
    private ClientOptimizationMode clientOptimizationMode = ClientOptimizationMode.NONE;
    private String clientLocalProjectPath = null;
    private String sourceId = null;
    public static String DATA_SOURCE_ID_PROPERTY_NAME = "openbus.data_source_id";
    private static final String INVALID_REQUEST_MSG = "ProjectService.error.invalid.request";
    private ProjectAdministrator prjAdmin = null;
    private Hashtable<Object, Vector<UserProjectInfo>> sharedProjects;
    private Set<UserProjectInfo> publicProjects;
    public static final int MINIMUM_FILE_ID_SIZE = 1;
    public static final String FILE_ID_SEPARATOR = "@/@";
    private boolean areaReserved;
    private final String projectRepositoryPath;
    private ProjectFileUpdateScheduler updateScheduler;
    private File prjDir;
    private ProjectFileTypeRepository typeRepository;
    private List<ProjectTemplate> projectTemplates;

    public static ProjectService getInstance() {
        return (ProjectService)ProjectService.getInstance("ProjectService");
    }

    public boolean userHasHisOwnProjects(Object userId) {
        return ServerProject.userHasHisOwnProjects(userId);
    }

    public List<UserProjectInfo> getProjectsFromUser(Object userId) {
        User user = Service.getUser();
        ArrayList<UserProjectInfo> result = new ArrayList<UserProjectInfo>();
        List<Object> projectIds = ServerProject.getAllProjectIds(userId);
        for (Object projectId : projectIds) {
            ServerProject project = ServerProject.openProject(projectId, false);
            if (!project.userHasAccess(user.getId())) continue;
            String projectName = ServerProject.getProjectName(projectId);
            result.add(new UserProjectInfo(projectId, projectName, userId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProjectInfo> getProjectsSharedWithUser(Object userId) {
        List prjsSharedWithUser;
        User user = AdministrationService.getInstance().getUser(userId);
        ArrayList<UserProjectInfo> projects = new ArrayList<UserProjectInfo>();
        if (this.publicProjects != null) {
            Set<UserProjectInfo> set = this.publicProjects;
            synchronized (set) {
                for (UserProjectInfo info : this.publicProjects) {
                    if (info.getOwnerId().equals(userId) || RevokeProjectPermission.checkPermission((User)user, (String)info.getProjectName())) continue;
                    projects.add(info);
                }
            }
        }
        if (this.sharedProjects != null && (prjsSharedWithUser = (List)this.sharedProjects.get(userId)) != null) {
            List list = prjsSharedWithUser;
            synchronized (list) {
                for (UserProjectInfo info : prjsSharedWithUser) {
                    if (RevokeProjectPermission.checkPermission((User)user, (String)info.getProjectName())) continue;
                    projects.add(info);
                }
            }
        }
        return projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userParticipatesOnSharedProjects(Object userId) {
        User user = AdministrationService.getInstance().getUser(userId);
        if (this.publicProjects != null && !this.publicProjects.isEmpty()) {
            Set<UserProjectInfo> set = this.publicProjects;
            synchronized (set) {
                for (UserProjectInfo info : this.publicProjects) {
                    if (RevokeProjectPermission.checkPermission((User)user, (String)info.getProjectName())) continue;
                    return true;
                }
            }
        }
        if (this.sharedProjects == null || this.sharedProjects.isEmpty()) {
            return false;
        }
        List prjsSharedWithUser = this.sharedProjects.get(userId);
        if (prjsSharedWithUser != null) {
            List list = prjsSharedWithUser;
            synchronized (list) {
                for (UserProjectInfo info : prjsSharedWithUser) {
                    if (RevokeProjectPermission.checkPermission((User)user, (String)info.getProjectName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUsers(Object projectId, ProjectPermissions.SharingType sharingType, Set<Object> usersRO, Set<Object> usersRW) {
        ServerProject sp;
        this.checkWritePermission(projectId);
        ServerProject serverProject = sp = ServerProject.openProject(projectId, false);
        synchronized (serverProject) {
            ProjectPermissions.SharingType oldSharingType = sp.getSharingType();
            Set<Object> oldUsersRO = sp.getUsersRO();
            Set<Object> oldUsersRW = sp.getUsersRW();
            sp.setSharingType(sharingType);
            sp.setUsersRO(usersRO);
            sp.setUsersRW(usersRW);
            sp.modify();
            switch (sharingType) {
                case ALL_RO: 
                case ALL_RW: {
                    this.prjAccessBecamePublic(sp, oldSharingType, oldUsersRO, oldUsersRW);
                    break;
                }
                case PARTIAL: {
                    this.prjAccessBecamePartial(sp, oldSharingType, oldUsersRO, oldUsersRW);
                    break;
                }
                case PRIVATE: {
                    this.prjAccessBecamePrivate(sp, oldSharingType, oldUsersRO, oldUsersRW);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(Object projectId, Object userId) {
        ServerProject sp;
        this.checkWritePermission(projectId);
        ServerProject serverProject = sp = ServerProject.openProject(projectId, false);
        synchronized (serverProject) {
            if (!sp.getSharingType().equals((Object)ProjectPermissions.SharingType.PARTIAL)) {
                String InfoMsg = this.getFormattedString("ProjectService.info.project.invalid.sharing.type", new Object[]{this.getProjectName(projectId)});
                throw new InfoException(InfoMsg);
            }
            if (sp.userHasSelectiveAccessRO(userId)) {
                Set<Object> newUsers = this.removeUserFrom(userId, sp.getUsersRO());
                this.updateUsersRO(sp, newUsers);
                return true;
            }
            if (sp.userHasSelectiveAccessRW(userId)) {
                Set<Object> newUsers = this.removeUserFrom(userId, sp.getUsersRW());
                this.updateUsersRW(sp, newUsers);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsers(Object projectId, Set<Object> usersId) {
        ServerProject sp;
        this.checkWritePermission(projectId);
        ServerProject serverProject = sp = ServerProject.openProject(projectId, false);
        synchronized (serverProject) {
            HashSet<Object> usersRW;
            HashSet<Object> usersRO = new HashSet<Object>(sp.getUsersRO());
            if (usersRO.removeAll(usersId)) {
                this.updateUsersRO(sp, usersRO);
            }
            if ((usersRW = new HashSet<Object>(sp.getUsersRW())).removeAll(usersId)) {
                this.updateUsersRW(sp, usersRW);
            }
        }
    }

    public boolean removeUserProjects(Object userId) {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        List<UserProjectInfo> infoList = this.getProjectsFromUser(userId);
        for (UserProjectInfo userProjectInfo : infoList) {
            this.removeProject(userProjectInfo.getProjectId());
        }
        return ServerProject.removeBasePrjDirForUser(userId);
    }

    public CommonClientProject openProject(Object projectId, boolean notify) {
        this.checkReadPermission(projectId);
        if (this.prjAdmin.isLocked(projectId)) {
            String InfoMsg = this.getFormattedString("ProjectService.info.project.locked", new Object[]{this.getProjectName(projectId)});
            throw new InfoException(InfoMsg);
        }
        ServerProject sp = ServerProject.openProject(projectId, notify);
        return this.buildClientProject(sp);
    }

    public CommonClientProject createProject(CommonProjectInfo info) {
        if (!Service.getUser().getId().equals(info.userId)) {
            this.checkAdminPermission();
        }
        ServerProject sp = ServerProject.createProject(info);
        CommonClientProject cp = this.buildClientProject(sp);
        Server.logFineMessage("Projeto " + info.name + " do usu\u00e1rio " + info.userId + " criado com sucesso");
        AdministrationEvent action = new AdministrationEvent(1, (Object)info);
        this.notifyProject((RemoteEvent)action, sp.getId());
        info.projectId = sp.getId();
        ProjectUserEvent event = new ProjectUserEvent(1, (Object)info);
        this.notifyProject((RemoteEvent)event, sp.getId());
        return cp;
    }

    public void createProjectWithAllocation(CommonProjectInfo info, long size) {
        if (!Service.getUser().getId().equals(info.userId)) {
            this.checkAdminPermission();
        }
        ServerProject sp = ServerProject.createProject(info);
        ProjectAdminInfo adminInfo = this.prjAdmin.lockProject(sp.getId(), size);
        Server.logInfoMessage("Projeto " + info.name + " do usu\u00e1rio " + info.userId + " criado com sucesso e aguardando libera\u00e7\u00e3o do administrador.");
        AdministrationEvent action = new AdministrationEvent(1, (Object)info);
        this.notifyProject((RemoteEvent)action, sp.getId());
        String message = String.format(this.getString("ProjectService.msg.project.created.with.allocation"), info.name, info.userId);
        this.notifyAdmin(adminInfo, message);
    }

    public void unlockProjectsWithAllocation(ProjectAdminInfo[] infos) {
        this.checkAdminPermission();
        for (int i = 0; i < infos.length; ++i) {
            ProjectAdminInfo info;
            ServerProject sp = ServerProject.openProject(infos[i].getProjectId(), false);
            Hashtable<String, Object> attributes = sp.getAttributes();
            attributes.put(ProjectAttribute.LOCKING_AREA_SIZE.getAttributeKey(), infos[i].getAreaLockedSize());
            sp.setAttributes(attributes);
            sp.modify();
            sp.close(false);
            infos[i] = info = this.prjAdmin.unlockProject(infos[i].getProjectId(), infos[i].getAreaLockedSize());
            ProjectNotification notification = new ProjectNotification(this.getSenderName(), info);
            String[] ids = new String[]{(String)infos[i].getOwnerId()};
            try {
                MessageService.getInstance().send(new Message((Serializable)notification), ids);
            }
            catch (RemoteException e) {
                Server.logSevereMessage("Erro ao enviar evento de concess\u00e3o de \u00e1rea.", e);
            }
            AdministrationEvent event = new AdministrationEvent(2, (Object)infos);
            this.sendAdmistrationEvent(event, sp);
        }
    }

    public void freeAreaForProjects(ProjectAdminInfo[] infos) {
        this.checkAdminPermission();
        for (int i = 0; i < infos.length; ++i) {
            ServerProject sp = ServerProject.openProject(infos[i].getProjectId(), false);
            infos[i] = this.prjAdmin.freeProjectArea(infos[i].getProjectId());
            AdministrationEvent event = new AdministrationEvent(3, (Object)infos[i]);
            this.sendAdmistrationEvent(event, sp);
        }
    }

    public CommonProjectInfo modifyProject(Object projectId, CommonProjectInfo info) {
        this.checkWritePermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        sp.setName(info.name);
        sp.setDescription(info.description);
        sp.setAttributes(info.getAttributes());
        sp.modify();
        info.name = sp.getName();
        info.description = sp.getDescription();
        info.setAttributes(sp.getAttributes());
        return info;
    }

    public void removeProject(Object projectId) {
        ProjectAdminInfo info;
        ServerProject sp = ServerProject.openProject(projectId, false);
        this.checkDeletePermission(projectId);
        Set<Object> removedUsers = this.removeUsers(sp);
        if (removedUsers != null) {
            this.notifyUsers(3, removedUsers, sp);
        }
        HashSet<Object> adminUsers = new HashSet<Object>(0);
        try {
            adminUsers.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        adminUsers.add(sp.getUserId());
        HashSet<Object> allUsers = new HashSet<Object>(0);
        allUsers.addAll(adminUsers);
        if (removedUsers != null) {
            allUsers.addAll(removedUsers);
        }
        sp.remove();
        if (this.prjAdmin.isUnlockedWithAreaAllocated(projectId)) {
            info = this.prjAdmin.setAllocatedProjectRemoved(projectId);
            AdministrationEvent event = new AdministrationEvent(2, (Object)info);
            this.notifyUsers((RemoteEvent)event, adminUsers.toArray(new String[0]));
            String message = String.format(this.getString("ProjectService.msg.project.removed.with.allocation"), info.getProjectName(), info.getOwnerId());
            this.notifyAdmin(info, message);
        } else if (this.prjAdmin.isLocked(projectId)) {
            info = this.prjAdmin.getProjectAdminInfo(projectId);
            this.prjAdmin.removeProjectAdminInfo(projectId);
            String message = String.format(this.getString("ProjectService.msg.project.removed.without.allocation"), info.getProjectName(), info.getOwnerId());
            this.notifyAdmin(info, message);
        }
        ProjectUserEvent event = new ProjectUserEvent(2, (Object)sp.getInfo());
        this.notifyUsers((RemoteEvent)event, allUsers.toArray(new String[0]));
        Server.logInfoMessage("ProjectService:removeProject: projeto" + projectId + " removido com sucesso");
    }

    public void closeProject(Object projectId, boolean notify) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.getProject(projectId);
        if (sp == null) {
            String InfoMsg = this.getFormattedString("ProjectService.info.project.not.found", new Object[]{this.getProjectName(projectId)});
            throw new InfoException(InfoMsg);
        }
        sp.close(notify);
    }

    public void rebuildTree(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        sp.rebuildTree();
    }

    public void refreshTree(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        sp.refreshTree();
    }

    public void rebuildDir(Object projectId, String[] path) {
        if (projectId == null) {
            throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "projectId == null");
        }
        if (path == null) {
            throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "path == null");
        }
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.rebuildDir();
    }

    public void refreshDir(Object projectId, String[] path) {
        if (projectId == null) {
            throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "projectId == null");
        }
        if (path == null) {
            throw new InvalidRequestException(this.getString(INVALID_REQUEST_MSG), "path == null");
        }
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.refreshDir();
    }

    public void createDirectory(Object projectId, String[] path) {
        this.checkWritePermission(projectId);
        String[] root = new String[]{};
        ServerProjectFile parentDir = ServerProjectFile.findFile(projectId, root);
        for (String dirName : path) {
            ServerProjectFile currentDir = parentDir.getChild(dirName);
            if (currentDir != null) {
                if (!currentDir.isDirectory()) {
                    String InfoMsg = this.getFormattedString("ProjectService.info.not.directory", new Object[]{currentDir.getName(), parentDir.getName()});
                    throw new InfoException(InfoMsg);
                }
            } else {
                Object userId = Service.getUser().getId();
                parentDir.createFile(dirName, "DIRECTORY_TYPE", userId);
                currentDir = parentDir.getChild(dirName);
            }
            parentDir = currentDir;
        }
    }

    public ClientProjectFile[] getChildren(Object projectId, String[] path) {
        return this.getChildren(projectId, path, false);
    }

    public ClientProjectFile[] getChildren(Object projectId, String[] path, boolean recursive) {
        this.checkReadPermission(projectId);
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, path);
        if (!dir.isDirectory()) {
            return null;
        }
        ServerProjectFile[] children = dir.getChildren();
        if (children == null) {
            return null;
        }
        int sz = children.length;
        ClientProjectFile[] clientFiles = new ClientProjectFile[sz];
        for (int i = 0; i < sz; ++i) {
            ServerProjectFile srvChild = children[i];
            clientFiles[i] = recursive && srvChild.isDirectory() ? this.buildClientProjectSubtree(srvChild) : this.buildSingleClientProjectFile(srvChild);
        }
        return clientFiles;
    }

    public ClientProjectFile getChild(Object projectId, String[] path, String name) {
        this.checkReadPermission(projectId);
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, path);
        if (!dir.isDirectory()) {
            return null;
        }
        ServerProjectFile srvChild = dir.getChild(name);
        if (null == srvChild) {
            return null;
        }
        return this.buildSingleClientProjectFile(srvChild);
    }

    public ClientProjectFile getChild(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile file = ServerProjectFile.findFile(projectId, path);
        return this.buildSingleClientProjectFile(file);
    }

    public ClientProjectFile getParent(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile file = ServerProjectFile.findFile(projectId, path);
        ServerProjectFile parent = file.getParent();
        if (parent == null) {
            return null;
        }
        return this.buildSingleClientProjectFile(parent);
    }

    public void createFile(Object projectId, String[] path, String name, String type) {
        this.checkWritePermission(projectId);
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, path);
        Object userId = Service.getUser().getId();
        dir.createFile(name, type, userId);
    }

    public void createFiles(Object projectId, String[] parentPath, List<ProjectFileInfo> fileInfoList) {
        this.checkWritePermission(projectId);
        if (projectId == null) {
            throw new InvalidRequestException("ProjectService: createFile: projectId == null");
        }
        if (parentPath == null) {
            throw new InvalidRequestException("ProjectService: createFile: parentPath == null");
        }
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, parentPath);
        Object userId = Service.getUser().getId();
        dir.createFiles(fileInfoList, userId, true);
    }

    public void renameFile(Object projectId, String[] path, String name) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.rename(name);
    }

    public void changeFileType(Object projectId, String[] path, String type) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.changeType(type);
    }

    public void copyFile(Object projectId, String[] filePath, String[] dirPath, String fileName) {
        this.checkWritePermission(projectId);
        ServerProjectFile file = ServerProjectFile.findFile(projectId, filePath);
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, dirPath);
        file.copy(dir, fileName);
    }

    public void copyFile(Object projectId, String[] filePath, String[] dirPath) {
        this.checkWritePermission(projectId);
        ServerProjectFile file = ServerProjectFile.findFile(projectId, filePath);
        ServerProjectFile dir = ServerProjectFile.findFile(projectId, dirPath);
        file.copy(dir);
    }

    public void copyFile(Object sourceProjectId, String[] filePathSource, Object targetProjectId, String[] dirPathTarget) {
        this.checkReadPermission(sourceProjectId);
        this.checkWritePermission(targetProjectId);
        ServerProjectFile file = ServerProjectFile.findFile(sourceProjectId, filePathSource);
        ServerProjectFile dir = ServerProjectFile.findFile(targetProjectId, dirPathTarget);
        file.copy(dir);
    }

    public void moveFile(Object projectId, String[] filePath, String[] dirPath) {
        this.moveFile(projectId, filePath, projectId, dirPath);
    }

    public void moveFile(Object sourceProjectId, String[] filePathSource, Object targetProjectId, String[] dirPathTarget) {
        this.checkWritePermission(sourceProjectId);
        this.checkWritePermission(targetProjectId);
        ServerProjectFile file = ServerProjectFile.findFile(sourceProjectId, filePathSource);
        ServerProjectFile dir = ServerProjectFile.findFile(targetProjectId, dirPathTarget);
        file.move(dir);
    }

    public void removeFile(Object projectId, String[] path) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.remove(true);
    }

    public ClientProjectFileInfo getUpdatedFileInfo(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getUpdatedInfo();
    }

    public void removeFiles(Object projectId, String[][] paths) {
        this.checkWritePermission(projectId);
        paths = this.filterPathsToRemove(paths);
        HashMap<ServerProjectFile, ArrayList<String[]>> parentMap = new HashMap<ServerProjectFile, ArrayList<String[]>>();
        for (String[] path : paths) {
            ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
            if (!spf.removeFile(true)) {
                String errMsg = "Falha ao remover " + spf.getAbsolutePath();
                throw new ServiceFailureException(errMsg);
            }
            ServerProjectFile parent = spf.getParent();
            ArrayList<String[]> removedPathsList = (ArrayList<String[]>)parentMap.get(parent);
            if (removedPathsList == null) {
                removedPathsList = new ArrayList<String[]>();
            }
            removedPathsList.add(spf.getPath());
            parentMap.put(parent, removedPathsList);
        }
        for (List removedPathsList : parentMap.values()) {
            String[][] removedFilePaths = new String[removedPathsList.size()][];
            for (int i = 0; i < removedPathsList.size(); ++i) {
                removedFilePaths[i] = (String[])removedPathsList.get(i);
            }
            this.fireFilesDeletedEvent(projectId, removedFilePaths);
        }
    }

    public String getFileDescription(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getDescription();
    }

    public void setFileDescription(Object projectId, String[] path, String text) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.setDescription(text);
    }

    public void appendFileDescription(Object projectId, String[] path, String text) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.appendDescription(text);
    }

    public boolean existsFile(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        return ServerProjectFile.testFile(projectId, path) != null;
    }

    public RemoteFileChannelInfo openFileChannel(Object projectId, String[] path, boolean readOnly) {
        if (readOnly) {
            this.checkReadPermission(projectId);
        } else {
            this.checkWritePermission(projectId);
        }
        ServerProjectFile spf = null;
        spf = ServerProjectFile.findFile(projectId, path);
        return spf.openChannel(readOnly);
    }

    public String getProjectLocationInServer(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        File file = new File(sp.getAbsolutePath());
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public Object acquireExclusiveLock(Object projectId, String[] path) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.acquireExclusiveLock();
    }

    public Object acquireExclusiveLock(Object projectId, String[] path, FileLockListenerInterface listener, long timeout) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.acquireExclusiveLock(listener, timeout);
    }

    public Object acquireSharedLock(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.acquireSharedLock();
    }

    public Object acquireSharedLock(Object projectId, String[] path, FileLockListenerInterface listener, long timeout) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.acquireSharedLock(listener, timeout);
    }

    public int releaseLock(Object projectId, String[] path, Object lockId) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.releaseLock(lockId);
    }

    public int forceReleaseLock(Object projectId, String[] path) {
        this.checkLockPermission(projectId, path);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.forceReleaseLock();
    }

    public boolean userOwnsLock(Object projectId, String[] path) {
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        FileLockInterface.LockStatus status = FileLockManager.getInstance().isLocked(spf, Service.getKey().toString());
        return status == FileLockInterface.LockStatus.LOCKED_BY_USER;
    }

    public long fileSize(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.size();
    }

    public long getModificationDate(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getModificationDate();
    }

    public void addObserver(RemoteObserver observer, Object arg) {
    }

    public synchronized boolean deleteObserver(RemoteObserver observer, Object arg) {
        return true;
    }

    public Map<String, ProjectFileTypeInfo> getAllFileTypes(Locale loc) {
        return this.typeRepository.getInfos(loc);
    }

    public ProjectFileTypeInfo getFileType(String type) {
        return this.typeRepository.getInfo(this.getDefaultLocale(), type);
    }

    public String getMimeType(String type) {
        ProjectFileTypeInfo info = this.getFileType(type);
        return info.getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectAdminInfo[] getLockedProjectAdminInfo() {
        Object userId = Service.getUser().getId();
        try {
            Service.setUserId(User.getAdminId());
            ProjectAdminInfo[] infos = this.prjAdmin.getAllProjectAdminInfo();
            LinkedList<ProjectAdminInfo> filteredInfos = new LinkedList<ProjectAdminInfo>();
            for (int i = 0; i < infos.length; ++i) {
                boolean waitingAreaFree;
                ServerProject project = null;
                boolean bl = waitingAreaFree = infos[i].getState() == ProjectAllocationState.WAITING_AREA_FREE;
                if (!waitingAreaFree) {
                    Object projectId = ServerProject.getId(infos[i].getOwnerId(), infos[i].getProjectName());
                    project = ServerProject.openProject(projectId, false);
                }
                if (!waitingAreaFree && (project == null || !project.userHasAccess(userId))) continue;
                filteredInfos.add(infos[i]);
            }
            ProjectAdminInfo[] projectAdminInfoArray = filteredInfos.toArray(new ProjectAdminInfo[0]);
            return projectAdminInfoArray;
        }
        finally {
            Service.setUserId(userId);
        }
    }

    public boolean isUnlockedWithAreaAllocated(Object projectId) {
        this.checkReadPermission(projectId);
        return this.prjAdmin.isUnlockedWithAreaAllocated(projectId);
    }

    public void setFileModificationDate(Object projectId, String[] path, long date) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.setModificationDate(date);
    }

    public void setUnderConstruction(Object projectId, String[] path, boolean underConstruction) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        spf.setUnderConstruction(underConstruction);
    }

    public void startUpdate(Object projectId, String[] path, long interval, boolean notification, Serializable extraInfo) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        UpdatableFileInfo updatableFileInfo = spf.getUpdatableFileInfo();
        if (updatableFileInfo == null) {
            throw new ServiceFailureException(MessageFormat.format(this.getString("ProjectService.error.not.updatable"), spf.getName()));
        }
        updatableFileInfo.setExtraUserData(extraInfo);
        this.updateScheduler.startUpdate(spf, interval, notification);
        ServerProjectFile parent = spf.getParent();
        parent.refreshDir();
    }

    public void startUpdate(Object projectId, String[] path, long interval, boolean notification) {
        this.startUpdate(projectId, path, interval, notification, null);
    }

    public void stopUpdate(Object projectId, String[] path) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        this.updateScheduler.stopUpdate(spf);
        ServerProjectFile parent = spf.getParent();
        parent.refreshDir();
    }

    public List<FileInfoSearchResult> getAllFileInfoSearchResult(Object projectId, String text, boolean isCaseInsensitive, boolean isRegex) {
        List fileList;
        this.checkReadPermission(projectId);
        String projectPath = ServerProject.getAbsolutePath(projectId);
        if (projectPath == null) {
            return null;
        }
        FileFinder finder = new FileFinder().matchAll(new FileFilter[]{FileFinder.NO_DOTFILE_FILTER, this.createFileFinderFilter(text, isCaseInsensitive, isRegex)});
        File startDir = new File(projectPath);
        try {
            fileList = finder.findIn(startDir);
        }
        catch (IOException e) {
            throw new ServiceFailureException(String.format(this.getString("ProjectService.error.invalidDir"), projectPath));
        }
        int startDirPrefixLength = startDir.getPath().length();
        ArrayList<FileInfoSearchResult> result = new ArrayList<FileInfoSearchResult>(fileList.size());
        String projectName = ServerProject.getProjectName(projectId);
        String ownerName = ServerProject.getOwnerName(projectId);
        User user = Service.getUser();
        Object userId = user.getId();
        for (File file : fileList) {
            boolean isWritable = user.isAdmin() || this.userHasAccessRW(projectId, userId);
            String relativePath = file.getParent().substring(startDirPrefixLength);
            result.add(new FileInfoSearchResult(file.getName(), relativePath.isEmpty() ? "/" : relativePath, projectName, projectId, ownerName, isWritable));
        }
        return result;
    }

    public Set<Object> getManageableProjectsId() {
        HashSet<Object> manageables = new HashSet<Object>();
        User user = Service.getUser();
        if (user.isAdmin()) {
            Set<Object> allUsers = AdministrationService.getInstance().getAllUserIds();
            for (Object anUserId : allUsers) {
                this.loadAllProjectsId(anUserId, manageables);
            }
        } else {
            this.loadAllProjectsId(user.getId(), manageables);
        }
        return manageables;
    }

    public void setUnallocatedProjectAsLocked(Object projectId, int areaSize) throws RemoteException {
        this.checkIsAdmin();
        if (projectId == null) {
            throw new IllegalArgumentException(this.getString("ProjectService.illegal.argument.exception.msg"));
        }
        if (areaSize <= 0) {
            throw new IllegalArgumentException(this.getString("ProjectService.illegal.argument.value.exception.msg"));
        }
        CommonClientProject ccp1 = this.openProject(projectId, false);
        if (ccp1 == null) {
            String infoMsg = this.getFormattedString("ProjectService.info.project.not.found", new Object[]{this.getProjectName(projectId)});
            throw new InfoException(infoMsg);
        }
        ccp1.close(false);
        if (this.isUnlockedWithAreaAllocated(projectId)) {
            throw new ServiceFailureException(this.getString("ProjectService.project.allocated.exception.msg"));
        }
        this.prjAdmin.lockProject(projectId, areaSize);
    }

    public void setAllocatedProjectAsUnallocated(Object projectId) throws RemoteException {
        this.checkIsAdmin();
        if (projectId == null) {
            throw new IllegalArgumentException(this.getString("ProjectService.illegal.argument.exception.msg"));
        }
        CommonClientProject ccp = this.openProject(projectId, false);
        if (ccp == null) {
            String infoMsg = this.getFormattedString("ProjectService.info.project.not.found", new Object[]{this.getProjectName(projectId)});
            throw new InfoException(infoMsg);
        }
        ccp.close(false);
        if (!this.isUnlockedWithAreaAllocated(projectId)) {
            throw new ServiceFailureException(this.getString("ProjectService.project.unallocated.exception.msg"));
        }
        this.prjAdmin.removeProjectAdminInfo(projectId);
        ccp = this.openProject(projectId, false);
        if (ccp == null) {
            throw new ServiceFailureException(this.getString("ProjectService.modified.project.access.error.exception.msg"));
        }
        ccp.setLockingAreaSize(0L);
        ccp.close(false);
    }

    public void setUnallocatedProjectAsAllocated(Object projectId, int areaSize) throws RemoteException {
        this.checkIsAdmin();
        if (projectId == null) {
            throw new IllegalArgumentException(this.getString("ProjectService.illegal.argument.exception.msg"));
        }
        if (areaSize <= 0) {
            throw new IllegalArgumentException(this.getString("ProjectService.illegal.argument.value.exception.msg"));
        }
        CommonClientProject ccp = this.openProject(projectId, false);
        if (ccp == null) {
            String infoMsg = this.getFormattedString("ProjectService.info.project.not.found", new Object[]{this.getProjectName(projectId)});
            throw new InfoException(infoMsg);
        }
        ccp.close(false);
        if (this.isUnlockedWithAreaAllocated(projectId)) {
            throw new ServiceFailureException(this.getString("ProjectService.project.allocated.exception.msg"));
        }
        this.prjAdmin.lockProject(projectId, areaSize);
        this.prjAdmin.unlockProject(projectId, areaSize);
        ccp = this.openProject(projectId, false);
        if (ccp == null) {
            throw new ServiceFailureException(this.getString("ProjectService.modified.project.access.error.exception.msg"));
        }
        ccp.setLockingAreaSize((long)areaSize);
        ccp.close(false);
    }

    public ProjectAdminInfo getProjectAdminInfo(Object projectId) {
        this.checkReadPermission(projectId);
        return this.prjAdmin.getProjectAdminInfo(projectId);
    }

    public boolean isAreaReserved() {
        return this.areaReserved;
    }

    public static void createService() throws ServerException {
        new ProjectService();
    }

    @Override
    public void initService() throws ServerException {
        this.prjDir = new File(this.projectRepositoryPath);
        this.checkRepository();
        this.prjAdmin = new ProjectAdministrator(this);
        this.areaReserved = this.getBooleanProperty("area.reserved");
        this.loadProjects();
        this.updateScheduler = new ProjectFileUpdateScheduler(this.getStringListProperty("updater.class"));
        FileLockManager.getInstance().startThread();
        this.updateScheduler.init();
    }

    @Override
    public void shutdownService() throws ServerException {
        FileLockManager.getInstance().stopThread();
        if (this.updateScheduler != null) {
            this.updateScheduler.shutdown();
        }
        if (this.prjAdmin != null) {
            this.prjAdmin.finish();
        }
        ServerProjectFile.clearAllCache();
    }

    public Object getProjectId(Object userId, String projectName) {
        return ServerProject.getId(userId, projectName);
    }

    public boolean existsProject(Object projectId) {
        return ServerProject.existsProject(projectId);
    }

    public String getProjectName(Object projectId) {
        return ServerProject.getProjectName(projectId);
    }

    public String[] getProjectPath(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        return sp.getPath();
    }

    public String getProjectRepositoryPath() {
        return this.projectRepositoryPath;
    }

    public String getFileTypesProperty() {
        String prop = this.getStringProperty("FileTypesPath");
        return this.getOSPropertyPath(prop);
    }

    public Object getOwnerId(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        return sp.getUserId();
    }

    public Collection<Object> getAllUsers(Object projectId) {
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        return ProjectPermissions.getAllUsers((CommonProjectInfo)sp.getInfo());
    }

    public boolean userHasAccess(Object projectId, Object userId) {
        try {
            ServerProject sp = ServerProject.openProject(projectId, false);
            return ProjectPermissions.userHasAccess((CommonProjectInfo)sp.getInfo(), (Object)userId);
        }
        catch (PermissionException pe) {
            return false;
        }
    }

    public boolean userCanWrite(Object projectId, Object userId) throws RemoteException {
        return this.userHasAccessRW(projectId, userId);
    }

    public List<Boolean> userCanWrite(List<Object> projects, Object userId) throws RemoteException {
        ArrayList<Boolean> result = new ArrayList<Boolean>(projects.size());
        for (Object prjId : projects) {
            result.add(this.userHasAccessRW(prjId, userId));
        }
        return result;
    }

    public boolean userHasAccessRW(Object projectId, Object userId) {
        ServerProject sp = ServerProject.openProject(projectId, false);
        return ProjectPermissions.userHasAccessRW((CommonProjectInfo)sp.getInfo(), (Object)userId);
    }

    public ProjectPermissions.SharingType getSharingType(Object projectId) {
        if (ProjectService.isInternalServerRequest()) {
            ServerProject sp = ServerProject.openServerProject(projectId);
            return ProjectPermissions.getSharingType((CommonProjectInfo)sp.getInfo());
        }
        this.checkReadPermission(projectId);
        ServerProject sp = ServerProject.openProject(projectId, false);
        return ProjectPermissions.getSharingType((CommonProjectInfo)sp.getInfo());
    }

    public String getAbsolutePath(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getAbsolutePath();
    }

    public InputStream getInputStream(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.openInputStream();
    }

    public OutputStream getOutputStream(Object projectId, String[] path) {
        return this.getOutputStream(projectId, path, false);
    }

    public OutputStream getOutputStream(Object projectId, String[] path, boolean append) {
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.openOutputStream(append);
    }

    @Deprecated
    public File getFile(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getFile();
    }

    public void singleUpdate(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        this.updateScheduler.singleUpdate(spf);
    }

    public String[] getUserToNotify(Object projectId) {
        HashSet<Object> userIds = new HashSet<Object>();
        try {
            userIds.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        userIds.add(ServerProject.getOwnerId(projectId));
        Object user = Service.getKey();
        Service.setUserId(null);
        ProjectPermissions.SharingType sharingType = this.getSharingType(projectId);
        switch (sharingType) {
            case PRIVATE: {
                break;
            }
            case PARTIAL: {
                userIds.addAll(this.getAllUsers(projectId));
                break;
            }
            case ALL_RO: 
            case ALL_RW: {
                UserOutline[] loggedUserOutlines;
                LoginService loginService = LoginService.getInstance();
                for (UserOutline aLoggedUser : loggedUserOutlines = loginService.getLoggedUsers()) {
                    userIds.add(aLoggedUser.getId());
                }
                break;
            }
            default: {
                Server.logSevereMessage("Tipo de compartilhamento do projeto " + projectId + " desconhecido: " + this.getSharingType(projectId) + ".\n");
                Service.setUserId(user);
                return null;
            }
        }
        Service.setUserId(user);
        return userIds.toArray(new String[0]);
    }

    protected ProjectService() throws ServerException {
        super("ProjectService");
        ClientRemoteLocator.projectService = this;
        this.projectRepositoryPath = this.getStringProperty("base.project.dir");
        this.sourceId = this.getStringProperty("sourceid");
        this.typeRepository = new ProjectFileTypeRepository(this.getFileTypesProperty());
        this.projectTemplates = this.createProjectTemplates();
        System.out.println("Diret\u00f3rio base de projetos: " + this.projectRepositoryPath);
        this.readOptimizationProperties();
    }

    private List<ProjectTemplate> createProjectTemplates() {
        ArrayList<ProjectTemplate> fileInfos = new ArrayList<ProjectTemplate>();
        List<String> templateDirs = this.getStringListProperty("template.directory");
        for (int i = 1; i <= templateDirs.size(); ++i) {
            String[] templateParams;
            String templateDir = templateDirs.get(i - 1);
            String[] path = FileUtils.splitPath((String)templateDir);
            this.checkTemplatePath(path);
            String typeProp = "template.type." + i;
            String type = this.hasProperty(this.getName() + "." + typeProp) ? this.getStringProperty(typeProp) : "DIRECTORY_TYPE";
            ProjectFileInfo fileInfo = new ProjectFileInfo(path, type);
            String classProp = "template.class." + i;
            String templateClassName = this.hasProperty(this.getName() + "." + classProp) ? this.getStringProperty(classProp) : DefaultProjectTemplate.class.getName();
            String paramsProp = classProp + ".params";
            if (this.hasProperty(this.getName() + "." + paramsProp)) {
                String paramList = this.getStringProperty(paramsProp);
                templateParams = paramList.replaceAll("\\s", "").split(",");
            } else {
                templateParams = new String[]{};
            }
            ProjectTemplate template = this.createTemplate(templateClassName, fileInfo, templateParams);
            fileInfos.add(template);
        }
        return fileInfos;
    }

    private void checkTemplatePath(String[] path) {
        for (String component : path) {
            String fixedFileName = FileUtils.fixFileName((String)component);
            if (fixedFileName.equals(component)) continue;
            String error = this.getFormattedString("ProjectService.error.template.path", new Object[]{component});
            throw new ServiceFailureException(error);
        }
    }

    private ProjectTemplate createTemplate(String templateClassName, ProjectFileInfo fileInfo, String[] templateParams) {
        ProjectTemplate template;
        Class<ProjectTemplate> templateInterface = ProjectTemplate.class;
        try {
            Class<?> clazz = Class.forName(templateClassName);
            if (!templateInterface.isAssignableFrom(clazz)) {
                String error = this.getFormattedString("ProjectService.error.template.class", new Object[]{templateClassName, templateInterface.getName()});
                throw new ServiceFailureException(error);
            }
            Constructor<?> constructor = clazz.getConstructor(ProjectFileInfo.class, String[].class);
            template = (ProjectTemplate)constructor.newInstance(fileInfo, templateParams);
        }
        catch (Exception e) {
            String error = this.getFormattedString("ProjectService.error.template.class", new Object[]{templateClassName, templateInterface.getName()});
            throw new ServiceFailureException(error, (Throwable)e);
        }
        return template;
    }

    private void readOptimizationProperties() throws ServerException {
        String modeStr = this.getStringProperty("client.optimization.mode");
        this.clientOptimizationMode = ClientOptimizationMode.getClientOptimizationMode((String)modeStr);
        if (this.clientOptimizationMode == null) {
            String err = "A propriedade optimization.mode cont\u00e9m um valor inv\u00e1lido. V\u00e1lidos: [NONE] ou [GLOBAL]";
            Server.logSevereMessage(err);
            throw new ServerException(err);
        }
        this.clientLocalProjectPath = this.getStringProperty("client.optimization.project.path");
        String msg = "Modo de Otimiza\u00e7\u00e3o: " + modeStr;
        if (this.clientOptimizationMode == ClientOptimizationMode.GLOBAL) {
            msg = msg + "\nPath local de Projeto: " + this.clientLocalProjectPath;
        }
        Server.logInfoMessage(msg);
        System.out.println(msg);
    }

    File getRoot(Object projectId) {
        this.checkReadPermission(projectId);
        String path = ServerProject.getAbsolutePath(projectId);
        return new File(path);
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    private boolean checkAdminPermission(User user) {
        if (user.isAdmin()) {
            return true;
        }
        Server server = Server.getInstance();
        String serverName = "local=" + server.getSystemName();
        AttributesPermission p = null;
        try {
            p = user.getMatchAttributesPermission(ProjectAdminPermission.class, serverName);
        }
        catch (Exception e) {
            String errorMsg = String.format("Ocorreu um erro ao buscar a permiss\u00e3o para gerenciar projetos para o usu\u00e1rio %s.", user.getLogin());
            Server.logSevereMessage(errorMsg, e);
        }
        return p != null;
    }

    private void checkAdminPermission() throws PermissionException {
        if (!this.checkAdminPermission(Service.getUser())) {
            throw new PermissionException();
        }
    }

    private void checkIsAdmin() {
        User user = Service.getUser();
        if (user == null || user.isAdmin()) {
            return;
        }
        throw new PermissionException();
    }

    private void checkLockPermission(Object projectId, String[] path) {
        User user = Service.getUser();
        ServerProject sp = ServerProject.openProject(projectId, false);
        Object userId = user.getId();
        if (user.isAdmin() || sp.getUserId().equals(userId) || this.userOwnsLock(projectId, path)) {
            return;
        }
        throw new PermissionException();
    }

    public void checkReadPermission(Object projectId) {
        if (ProjectService.isInternalServerRequest()) {
            ServerProject.openProject(projectId, false);
            return;
        }
        Object userId = Service.getUser().getId();
        ServerProject sp = ServerProject.openProject(projectId, false);
        if (sp.userHasAccess(userId)) {
            return;
        }
        throw new PermissionException();
    }

    public void checkWritePermission(Object projectId) throws PermissionException {
        User user = Service.getUser();
        if (user == null) {
            String msg = "Usu\u00e1rio null.";
            throw new PermissionException(msg);
        }
        Object userId = user.getId();
        ServerProject sp = ServerProject.openProject(projectId, false);
        if (this.isProjectRO(sp) && !this.hasROProjectWritePermission(sp) || !sp.userHasAccessRW(userId)) {
            String msg = MessageFormat.format("O usu\u00e1rio {0} n\u00e3o possui permiss\u00e3o de escrita no projeto {1}.", ProjectService.getUser().getLogin(), projectId);
            throw new PermissionException(msg);
        }
    }

    public void checkDeletePermission(Object projectId) throws PermissionException {
        User user = Service.getUser();
        if (user == null) {
            String msg = "Usu\u00e1rio null.";
            throw new PermissionException(msg);
        }
        if (this.checkAdminPermission(user)) {
            return;
        }
        Object userId = user.getId();
        if (!ServerProject.getOwner(projectId).getId().equals(userId)) {
            String msg = MessageFormat.format("O usu\u00e1rio {0} n\u00e3o pode remover o projeto {1} pois n\u00e3o \u00e9 o dono do projeto.", ProjectService.getUser().getLogin(), projectId);
            throw new PermissionException(msg);
        }
    }

    private boolean isProjectRO(ServerProject sp) {
        return !Server.getInstance().getSystemName().equals(sp.getOwnerServerName()) && !this.isEmptyServerProjectOwner(sp) && !this.checkAdminPermission(Service.getUser());
    }

    private boolean hasROProjectWritePermission(ServerProject sp) {
        boolean hasPermission = false;
        String systemId = null;
        try {
            if (ReadOnlyProjectPermission.checkSystemAndOwnerPermission((User)Service.getUser(), systemId, (String)sp.getOwnerServerName())) {
                hasPermission = true;
            }
        }
        catch (Exception e) {
            hasPermission = false;
        }
        return hasPermission;
    }

    private boolean isEmptyServerProjectOwner(ServerProject sp) {
        return sp.getOwnerServerName().equals("");
    }

    private boolean isProjectWritableFromServer(ServerProject sp) {
        return !this.isProjectRO(sp) || this.hasROProjectWritePermission(sp);
    }

    private String[][] filterPathsToRemove(String[][] inputPaths) {
        if (inputPaths == null) {
            return null;
        }
        LinkedHashSet<String[]> candidates = new LinkedHashSet<String[]>();
        Iterator iter = null;
        block0: for (int inputIndex = 0; inputIndex < inputPaths.length; ++inputIndex) {
            if (inputPaths[inputIndex] == null) continue;
            if (candidates.size() == 0) {
                candidates.add(inputPaths[inputIndex]);
                continue;
            }
            LinkedHashSet candidatesClone = (LinkedHashSet)candidates.clone();
            for (String[] candidatePath : candidatesClone) {
                if (ServerProjectFile.isAncestor(candidatePath, inputPaths[inputIndex])) continue block0;
                if (!ServerProjectFile.isAncestor(inputPaths[inputIndex], candidatePath)) continue;
                candidates.remove(candidatePath);
            }
            candidates.add(inputPaths[inputIndex]);
        }
        String[][] outputPaths = new String[candidates.size()][];
        iter = candidates.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String[] candidatePath;
            candidatePath = (String[])iter.next();
            outputPaths[i++] = candidatePath;
        }
        return outputPaths;
    }

    private void fireFilesDeletedEvent(Object projectId, String[][] paths) {
        Object[] arg = new Object[]{paths};
        ServerProject sp = ServerProject.openProject(projectId, false);
        this.notifyProject((RemoteEvent)ProjectEvent.makeEvent((Object)projectId, (int)10, (Object[])arg), projectId);
    }

    private void updateUsersRO(ServerProject prj, Set<Object> usersRO) {
        this.updateUsers(prj.getId(), prj.getSharingType(), usersRO, prj.getUsersRW());
    }

    private void updateUsersRW(ServerProject prj, Set<Object> usersRW) {
        this.updateUsers(prj.getId(), prj.getSharingType(), prj.getUsersRO(), usersRW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prjAccessBecamePartial(ServerProject sp, ProjectPermissions.SharingType oldSharingType, Set<Object> oldUsersRO, Set<Object> oldUsersRW) {
        HashSet<Object> usersToNotify;
        Set<Object> newUsersRO = sp.getUsersRO();
        Set<Object> newUsersRW = sp.getUsersRW();
        switch (oldSharingType) {
            case PRIVATE: {
                this.usersGainedAccessToProject(sp, newUsersRO, 0);
                this.usersGainedAccessToProject(sp, newUsersRW, 0);
                break;
            }
            case ALL_RO: 
            case ALL_RW: {
                Set<UserProjectInfo> set = this.publicProjects;
                synchronized (set) {
                    this.publicProjects.remove(new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId()));
                }
                if (oldSharingType == ProjectPermissions.SharingType.ALL_RO) {
                    this.usersGainedAccessToProject(sp, newUsersRO, -1);
                    this.usersGainedAccessToProject(sp, newUsersRW, 2);
                } else {
                    this.usersGainedAccessToProject(sp, newUsersRO, 2);
                    this.usersGainedAccessToProject(sp, newUsersRW, -1);
                }
                usersToNotify = new HashSet<Object>(AdministrationService.getInstance().getAllUserIds());
                usersToNotify.remove(sp.getUserId());
                usersToNotify.removeAll(newUsersRO);
                usersToNotify.removeAll(newUsersRW);
                this.notifyUsers(1, usersToNotify, sp);
                this.notifyUsers((RemoteEvent)new SharedProjectEvent(usersToNotify, sp.getInfo(), newUsersRO, newUsersRW, sp.getSharingType()), usersToNotify.toArray(new String[0]));
                break;
            }
            case PARTIAL: {
                HashSet<Object> oldUsers = new HashSet<Object>();
                oldUsers.addAll(oldUsersRO);
                oldUsers.addAll(oldUsersRW);
                oldUsers.removeAll(newUsersRO);
                oldUsers.removeAll(newUsersRW);
                this.usersLostAccessToProject(sp, oldUsers, true);
                HashSet<Object> newUsers = new HashSet<Object>();
                newUsers.addAll(newUsersRO);
                newUsers.addAll(newUsersRW);
                newUsers.removeAll(oldUsersRO);
                newUsers.removeAll(oldUsersRW);
                this.usersGainedAccessToProject(sp, newUsers, 0);
                HashSet<Object> changedUsers = new HashSet<Object>();
                changedUsers.addAll(oldUsersRO);
                changedUsers.retainAll(newUsersRW);
                this.notifyUsers(2, changedUsers, sp);
                changedUsers.clear();
                changedUsers.addAll(oldUsersRW);
                changedUsers.retainAll(newUsersRO);
                this.notifyUsers(2, changedUsers, sp);
            }
        }
        usersToNotify = new HashSet<Object>();
        usersToNotify.addAll(oldUsersRO);
        usersToNotify.addAll(newUsersRO);
        usersToNotify.addAll(oldUsersRW);
        usersToNotify.addAll(newUsersRW);
        usersToNotify.add(sp.getUserId());
        try {
            usersToNotify.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        SharedProjectEvent event = new SharedProjectEvent(usersToNotify, sp.getInfo(), newUsersRO, newUsersRW, sp.getSharingType());
        this.notifyUsers((RemoteEvent)event, usersToNotify.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prjAccessBecamePrivate(ServerProject sp, ProjectPermissions.SharingType oldSharingType, Set<Object> oldUsersRO, Set<Object> oldUsersRW) {
        Set<Object> usersToNotify = null;
        switch (oldSharingType) {
            case PARTIAL: {
                this.usersLostAccessToProject(sp, oldUsersRO, true);
                this.usersLostAccessToProject(sp, oldUsersRW, true);
                break;
            }
            case ALL_RO: 
            case ALL_RW: {
                Set<UserProjectInfo> set = this.publicProjects;
                synchronized (set) {
                    this.publicProjects.remove(new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId()));
                }
                usersToNotify = AdministrationService.getInstance().getAllUserIds();
                usersToNotify.remove(sp.getUserId());
                this.usersLostAccessToProject(sp, usersToNotify, true);
                break;
            }
        }
        SharedProjectEvent event = new SharedProjectEvent(sp.getInfo(), sp.getSharingType());
        this.notifyProject((RemoteEvent)event, sp.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prjAccessBecamePublic(ServerProject sp, ProjectPermissions.SharingType oldSharingType, Set<Object> oldUsersRO, Set<Object> oldUsersRW) {
        Set<UserProjectInfo> set = this.publicProjects;
        synchronized (set) {
            this.publicProjects.add(new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId()));
        }
        ProjectPermissions.SharingType sharingType = sp.getSharingType();
        switch (oldSharingType) {
            case PARTIAL: {
                HashSet<Object> oldUsers = new HashSet<Object>();
                oldUsers.addAll(oldUsersRO);
                oldUsers.addAll(oldUsersRW);
                this.usersLostAccessToProject(sp, oldUsers, false);
                if (sharingType == ProjectPermissions.SharingType.ALL_RO) {
                    this.notifyUsers(2, oldUsersRW, sp);
                    break;
                }
                this.notifyUsers(2, oldUsersRO, sp);
                break;
            }
            case PRIVATE: {
                HashSet<Object> users = new HashSet<Object>(AdministrationService.getInstance().getAllUserIds());
                users.remove(sp.getUserId());
                this.notifyUsers(0, users, sp);
                break;
            }
            case ALL_RO: 
            case ALL_RW: {
                HashSet<Object> users = new HashSet<Object>(AdministrationService.getInstance().getAllUserIds());
                users.remove(sp.getUserId());
                this.notifyUsers(2, users, sp);
            }
        }
        SharedProjectEvent event = new SharedProjectEvent(sp.getInfo(), sharingType);
        this.notifyProject((RemoteEvent)event, sp.getId());
    }

    private Set<Object> removeUserFrom(Object userID, Set<Object> users) {
        HashSet<Object> newUsers = new HashSet<Object>(users);
        newUsers.remove(userID);
        return newUsers;
    }

    private CommonClientProject buildClientProject(ServerProject sp) {
        CommonProjectInfo info = new CommonProjectInfo();
        info.userId = sp.getUserId();
        info.name = sp.getName();
        info.description = sp.getDescription();
        info.setAttributes(sp.getAttributes());
        ServerProjectFile serverTree = sp.getTree();
        ClientProjectFile clientTree = this.buildSingleClientProjectFile(serverTree);
        CommonClientProject comProj = new CommonClientProject(sp.getId(), info, clientTree, sp.getPath());
        comProj.setServerCanWriteProject(this.isProjectWritableFromServer(sp));
        return comProj;
    }

    ClientProjectFile buildClientProjectSubtree(ServerProjectFile spf) {
        ClientProjectFile clientFile = this.buildSingleClientProjectFile(spf);
        if (!spf.isDirectory()) {
            return clientFile;
        }
        ServerProjectFile[] serverChildren = spf.getChildren();
        if (serverChildren != null) {
            ClientProjectFile[] clientChildren = null;
            clientChildren = new ClientProjectFile[serverChildren.length];
            for (int j = 0; j < serverChildren.length; ++j) {
                clientChildren[j] = this.buildClientProjectSubtree(serverChildren[j]);
            }
            clientFile.setChildren(false, false, clientChildren);
        }
        return clientFile;
    }

    ClientProjectFile buildSingleClientProjectFile(ServerProjectFile spf) {
        UpdatableFileLocation fileLocation;
        FileUpdateInfo info;
        ProjectService prjSrv;
        String updateUserLogin = null;
        long updateInterval = 0L;
        Object key = Service.getKey();
        if (key != null && (prjSrv = ProjectService.getInstance()) != null && (info = prjSrv.updateScheduler.getFileUpdateInfo(fileLocation = prjSrv.updateScheduler.getFileLocation(spf))) != null) {
            updateUserLogin = info.getUserLogin();
            updateInterval = info.getInterval();
        }
        ClientProjectFile clientFile = new ClientProjectFile(spf.getProjectId(), spf.getName(), spf.getPath(), null, spf.getType(), spf.isDirectory(), spf.hasChildren(), spf.isUnderConstruction(), spf.whoCreated(), spf.getCreationDate(), spf.size(), spf.getModificationDate(), spf.isLocked(), spf.getUpdatableFileInfo() != null, updateUserLogin, updateInterval);
        return clientFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIfSharedProject(File prjConfigFile, Object ownerId) {
        if (!prjConfigFile.exists()) {
            return;
        }
        if (!prjConfigFile.isFile()) {
            String path = prjConfigFile.getAbsolutePath();
            String fmt = "Dado de controle de projeto n\u00e3o \u00e9 arquivo: %s";
            String err = String.format(fmt, path);
            Server.logSevereMessage(err);
            return;
        }
        CommonProjectInfo info = null;
        info = ServerProject.readProjectInfoFromConfigFile(prjConfigFile, ownerId);
        if (info == null) {
            return;
        }
        Object id = ServerProject.getId(ownerId, info.name);
        UserProjectInfo userProj = new UserProjectInfo(id, info.name, info.userId);
        if (ProjectPermissions.isPublic((CommonProjectInfo)info)) {
            Set<UserProjectInfo> set = this.publicProjects;
            synchronized (set) {
                this.publicProjects.add(userProj);
            }
        } else if (ProjectPermissions.getSharingType((CommonProjectInfo)info) == ProjectPermissions.SharingType.PARTIAL) {
            Set u = ProjectPermissions.getAllUsers((CommonProjectInfo)info);
            for (Object user : u) {
                this.associateUserToSharedProject(user, userProj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateUserToSharedProject(Object user, UserProjectInfo prjInfo) {
        Hashtable<Object, Vector<UserProjectInfo>> hashtable = this.sharedProjects;
        synchronized (hashtable) {
            Vector<Object> prjsSharedWithUser = this.sharedProjects.get(user);
            if (prjsSharedWithUser == null) {
                prjsSharedWithUser = new Vector();
                this.sharedProjects.put(user, prjsSharedWithUser);
            }
            prjsSharedWithUser.add(prjInfo);
        }
    }

    private Object getUserIdByLogin(String login) {
        try {
            User user = User.getUserByLogin((String)login);
            if (user == null) {
                return null;
            }
            return user.getId();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String addErrorStringItem(String sourceString, String err) {
        String destString = sourceString + "  # " + err + "\n\n";
        return destString;
    }

    private void checkRepository() throws ServerException {
        File[] usersDirs;
        File[] dummyFiles;
        if (!this.prjDir.exists()) {
            String fmt = "Reposit\u00f3rio de projetos n\u00e3o encontrado: %s!";
            String err = String.format(fmt, this.prjDir.getAbsolutePath());
            try {
                System.out.println(MessageFormat.format("\nVerifique a propriedade ProjectService.base.project.dir que define o diret\u00f3rio do reposit\u00f3rio de projetos, pois o diret\u00f3rio {0} n\u00e3o existe.\n", this.prjDir.getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Server.logSevereMessage(err);
            throw new ServerException(err);
        }
        if (!this.prjDir.isDirectory()) {
            String fmt = "Reposit\u00f3rio de projetos n\u00e3o \u00e9 diret\u00f3rio: %s!";
            String err = String.format(fmt, this.prjDir.getAbsolutePath());
            Server.logSevereMessage(err);
            throw new ServerException(err);
        }
        MailService mailService = MailService.getInstance();
        String adminMailContent = "";
        for (File dummyFile : dummyFiles = this.prjDir.listFiles(this.getUnknownFileInsideRepositoryFilter())) {
            String fmt = "Ignorando arquivo inv\u00e1lido %s na \u00e1rea de projetos (%s).";
            String dummyName = dummyFile.getName();
            String dummyPath = dummyFile.getAbsolutePath();
            String err = String.format(fmt, dummyName, dummyPath);
            Server.logSevereMessage(err);
            adminMailContent = this.addErrorStringItem(adminMailContent, err);
        }
        for (File userDir : usersDirs = this.prjDir.listFiles(this.getDirectoryFilter())) {
            String dirPath = userDir.getAbsolutePath();
            String dirName = userDir.getName();
            String ownerLogin = dirName;
            Object ownerId = this.getUserIdByLogin(ownerLogin);
            if (ownerId == null) {
                String fmt = "Ignorando usu\u00e1rio inexistente (diret\u00f3rio) %s ";
                fmt = fmt + "na \u00e1rea de projetos (%s).";
                String err = String.format(fmt, ownerLogin, dirPath);
                Server.logWarningMessage(err);
                adminMailContent = this.addErrorStringItem(adminMailContent, err);
                continue;
            }
            File[] trashFiles = userDir.listFiles(this.getUnknownFilesInsideUserAreaFilter());
            if (trashFiles == null) {
                File[] fmt = "Erro ao recuperar os arquivos na \u00e1rea de projetos para usu\u00e1rio %s (%s).";
                String err = String.format((String)fmt, ownerLogin, userDir);
                Server.logSevereMessage(err);
                adminMailContent = this.addErrorStringItem(adminMailContent, err);
            } else {
                for (File trashFile : trashFiles) {
                    String fmt = "Ignorando arquivo inv\u00e1lido %s na \u00e1rea de projetos ";
                    fmt = fmt + "do usu\u00e1rio %s (%s)";
                    String trashName = trashFile.getName();
                    String trashPath = trashFile.getAbsolutePath();
                    String err = String.format(fmt, trashName, ownerLogin, trashPath);
                    Server.logWarningMessage(err);
                    adminMailContent = this.addErrorStringItem(adminMailContent, err);
                }
            }
            String ownerMailContent = "";
            File[] projectsDirs = userDir.listFiles(this.getDirectoryFilter());
            if (projectsDirs == null || projectsDirs.length == 0) continue;
            for (File projectDir : projectsDirs) {
                String projectName = projectDir.getName();
                if (!ServerProject.isValidBaseDirectory(projectDir)) {
                    String prjDirPath = projectDir.getAbsolutePath();
                    String fmt = "Ignorando diret\u00f3rio oculto %s do usu\u00e1rio %s (%s).";
                    String err = String.format(fmt, projectName, ownerLogin, prjDirPath);
                    Server.logSevereMessage(err);
                    adminMailContent = this.addErrorStringItem(adminMailContent, err);
                    continue;
                }
                File configFile = ServerProject.getConfigFile(projectDir);
                CommonProjectInfo cpi = ServerProject.createProjectInfo(configFile);
                if (cpi != null) continue;
                boolean ok = ServerProject.generateConfigFile(configFile, ownerId, projectName);
                String status = "recuperado (acesso reconfigurado para \"privado\")";
                if (!ok) {
                    status = "*N\u00c3O* recuperado ap\u00f3s tentativa de restaura\u00e7\u00e3o";
                }
                if ((cpi = ServerProject.createProjectInfo(configFile)) == null) {
                    status = " *N\u00c3O recuperado ap\u00f3s sucesso de restaura\u00e7\u00e3o";
                }
                String fmt = "Projeto %s do usu\u00e1rio %s %s.";
                String err = String.format(fmt, projectName, ownerLogin, status);
                Server.logSevereMessage(err);
                adminMailContent = this.addErrorStringItem(adminMailContent, err);
                ownerMailContent = this.addErrorStringItem(ownerMailContent, err);
            }
            if (ownerMailContent.trim().isEmpty()) continue;
            Object[] addresse = new Object[]{ownerId};
            mailService.mailSomeUsersFromService(this, addresse, ownerMailContent);
        }
        if (!adminMailContent.trim().isEmpty()) {
            Vector addresse = new Vector();
            try {
                addresse.addAll(User.getAdminIds());
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
            }
            mailService.mailSomeUsersFromService(this, addresse.toArray(new Object[0]), adminMailContent);
        }
    }

    private void loadProjects() {
        File[] usersDirs;
        this.publicProjects = Collections.synchronizedSet(new HashSet());
        this.sharedProjects = new Hashtable();
        File rootDir = new File(this.projectRepositoryPath);
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            return;
        }
        for (File userDir : usersDirs = rootDir.listFiles(this.getDirectoryFilter())) {
            File[] projectsDirs;
            String dirName = userDir.getName();
            String ownerLogin = dirName;
            Object ownerId = this.getUserIdByLogin(ownerLogin);
            if (ownerId == null || (projectsDirs = userDir.listFiles(this.getDirectoryFilter())) == null || projectsDirs.length == 0) continue;
            for (int j = 0; j < projectsDirs.length; ++j) {
                File projectDir = projectsDirs[j];
                String projectName = projectDir.getName();
                if (!ServerProject.isValidBaseDirectory(projectDir)) continue;
                File configFile = ServerProject.getConfigFile(projectDir);
                CommonProjectInfo cpi = ServerProject.readProjectInfoFromConfigFile(configFile, ownerId);
                if (cpi != null) {
                    this.registerIfSharedProject(configFile, ownerId);
                    continue;
                }
                String fmt = "Falha na carga do projeto %s do usu\u00e1rio %s";
                String err = String.format(fmt, projectName, ownerLogin);
                Server.logSevereMessage(err);
            }
        }
    }

    private FileFilter getDirectoryFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    private FileFilter getUnknownFileInsideRepositoryFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String lockingFileName = "locked_projects.csbase";
                String fileName = file.getName();
                return file.isFile() && !fileName.equals(lockingFileName);
            }
        };
    }

    private FileFilter getUnknownFilesInsideUserAreaFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                boolean isCtrl = fileName.endsWith(".csbase_project_info");
                boolean isDesc = fileName.endsWith(".csbase_description");
                return file.isFile() && !isCtrl && !isDesc;
            }
        };
    }

    private void notifyAdmin(ProjectAdminInfo info, String mailMessage) {
        try {
            ArrayList<Object> adminUsers = new ArrayList<Object>();
            List allUsers = User.getAllUsers();
            for (int i = 0; i < allUsers.size(); ++i) {
                User user = (User)allUsers.get(i);
                if (!this.checkAdminPermission(user)) continue;
                Object uid = user.getId();
                adminUsers.add(uid);
                if (mailMessage == null) continue;
                MailService mSrv = MailService.getInstance();
                mSrv.mailUserFromService(this, uid, mailMessage);
            }
            ProjectNotification notification = new ProjectNotification(this.getSenderName(), info);
            MessageService.getInstance().send(new Message((Serializable)notification), adminUsers.toArray(new String[0]));
        }
        catch (RemoteException e) {
            Server.logSevereMessage("ProjectService:notifyAdmin", e);
        }
    }

    private void notifyUsers(int eventType, Collection<Object> usersToNotify, ServerProject project) {
        if (usersToNotify.isEmpty()) {
            return;
        }
        usersToNotify.remove(User.getAdminId());
        UsersNotification notification = new UsersNotification(this.getSenderName(), eventType, usersToNotify, project.getUserId(), project.getName());
        try {
            MessageService.getInstance().send(new Message((Serializable)notification), usersToNotify.toArray(new String[0]));
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao enviar notifica\u00e7\u00e3o para usu\u00e1rios do projeto " + project.getName() + ".", e);
        }
    }

    private void notifyProject(RemoteEvent event, Object projectId) {
        try {
            String[] users = this.getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)event), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao enviar notifica\u00e7\u00e3o para usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private void notifyUsers(RemoteEvent event, String[] users) {
        try {
            MessageService.getInstance().send(new Message((Serializable)event), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao enviar notifica\u00e7\u00e3o para usu\u00e1rios.", e);
        }
    }

    private void sendAdmistrationEvent(AdministrationEvent event, ServerProject project) {
        HashSet<Object> destinations = new HashSet<Object>();
        try {
            destinations.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        destinations.add(project.getUserId());
        try {
            MessageService.getInstance().send(new Message((Serializable)event), destinations.toArray(new String[0]));
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao enviar notifica\u00e7\u00e3o para usu\u00e1rios.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usersLostAccessToProject(ServerProject sp, Set<Object> usersRemoved, boolean notify) {
        if (usersRemoved == null || usersRemoved.isEmpty()) {
            return;
        }
        UserProjectInfo prjInfo = new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId());
        Hashtable<Object, Vector<UserProjectInfo>> hashtable = this.sharedProjects;
        synchronized (hashtable) {
            for (Object uid : usersRemoved) {
                Vector<UserProjectInfo> prjsSharedWithUser = this.sharedProjects.get(uid);
                if (prjsSharedWithUser == null || !prjsSharedWithUser.remove(prjInfo) || !prjsSharedWithUser.isEmpty()) continue;
                this.sharedProjects.remove(uid);
            }
        }
        if (notify) {
            this.notifyUsers(1, usersRemoved, sp);
        }
        SharedProjectEvent event = new SharedProjectEvent(sp.getInfo(), sp.getSharingType());
        this.notifyUsers((RemoteEvent)event, usersRemoved.toArray(new String[0]));
    }

    private void usersGainedAccessToProject(ServerProject sp, Set<Object> usersAdded, int event) {
        if (usersAdded == null || usersAdded.isEmpty()) {
            return;
        }
        UserProjectInfo prjInfo = new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId());
        for (Object uid : usersAdded) {
            this.associateUserToSharedProject(uid, prjInfo);
        }
        if (event != -1) {
            this.notifyUsers(event, usersAdded, sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> removeUsers(ServerProject sp) {
        if (sp.isPublic().booleanValue()) {
            Set<Object> allUsers = AdministrationService.getInstance().getAllUserIds();
            allUsers.remove(sp.getUserId());
            Set<UserProjectInfo> set = this.publicProjects;
            synchronized (set) {
                this.publicProjects.remove(new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId()));
            }
            return allUsers;
        }
        HashSet<Object> users = new HashSet<Object>();
        Hashtable<Object, Vector<UserProjectInfo>> hashtable = this.sharedProjects;
        synchronized (hashtable) {
            Enumeration<Object> e = this.sharedProjects.keys();
            while (e.hasMoreElements()) {
                Object user = e.nextElement();
                Vector<UserProjectInfo> prjsSharedWithUser = this.sharedProjects.get(user);
                UserProjectInfo info = new UserProjectInfo(sp.getId(), sp.getName(), sp.getUserId());
                boolean removed = prjsSharedWithUser.remove(info);
                if (prjsSharedWithUser.isEmpty()) {
                    this.sharedProjects.remove(user);
                }
                if (!removed) continue;
                users.add(user);
            }
        }
        if (users.size() <= 0) {
            return null;
        }
        return users;
    }

    private void loadAllProjectsId(Object ownerId, Collection<Object> projectsId) {
        List<UserProjectInfo> projects = this.getProjectsFromUser(ownerId);
        if (projects != null) {
            for (UserProjectInfo project : projects) {
                projectsId.add(project.getProjectId());
            }
        }
    }

    public boolean setUpdatableFileInfo(ClientProjectFile file, UpdatableFileInfo updatableFileInfo) {
        Object projectId = file.getProjectId();
        this.checkWritePermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, file.getPath());
        if (spf == null) {
            return false;
        }
        spf.setUpdatableFileInfo(updatableFileInfo);
        return true;
    }

    public UpdatableFileInfo getUpdatableFileInfo(Object projectId, String[] path) {
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, path);
        return spf.getUpdatableFileInfo();
    }

    public RemoteFileChannelInfo createFileChannelInfo(ClientProjectFile file) throws Exception {
        Object projectId = file.getProjectId();
        this.checkReadPermission(projectId);
        ServerProjectFile spf = ServerProjectFile.findFile(projectId, file.getPath());
        Object userId = Service.getUser().getId();
        ServerProject sp = ServerProject.openProject(projectId, false);
        boolean isReadOnly = this.isProjectRO(sp) && !this.hasROProjectWritePermission(sp) || !sp.userHasAccessRW(userId);
        return spf.openChannel(isReadOnly);
    }

    private FileFilter createFileFinderFilter(String text, boolean caseInsensitive, boolean isRegex) {
        if (text.equals("*")) {
            return null;
        }
        if (!caseInsensitive) {
            if (text.lastIndexOf(42) == 0) {
                return FileFinder.suffixFilter((String[])new String[]{text.substring(1)});
            }
            if (text.indexOf(42) == text.length()) {
                return FileFinder.prefixFilter((String[])new String[]{text.substring(0, text.length() - 1)});
            }
            if (Pattern.matches("\\*.+?\\*", text)) {
                return FileFinder.namePartFilter((String[])new String[]{text.substring(1, text.length() - 1)});
            }
            if (text.contains("*")) {
                String regex = text.replace(".", "\\.").replace("*", ".*");
                return FileFinder.regexFilter((String[])new String[]{regex});
            }
            if (isRegex) {
                return FileFinder.regexFilter((String[])new String[]{text});
            }
            return FileFinder.nameFilter((String[])new String[]{text});
        }
        if (text.lastIndexOf(42) == 0) {
            return FileFinder.suffixIgnoreCaseFilter((String)text.substring(1));
        }
        if (text.indexOf(42) == text.length()) {
            return FileFinder.prefixIgnoreCaseFilter((String)text.substring(0, text.length() - 1));
        }
        if (Pattern.matches("\\*.+?\\*", text)) {
            return FileFinder.namePartIgnoreCaseFilter((String)text.substring(1, text.length() - 1));
        }
        if (text.contains("*")) {
            String regex = text.replace(".", "\\.").replace("*", ".*");
            Pattern pattern = Pattern.compile(regex, 2);
            return FileFinder.regexFilter((Pattern[])new Pattern[]{pattern});
        }
        if (isRegex) {
            return FileFinder.regexFilter((Pattern[])new Pattern[]{Pattern.compile(text, 2)});
        }
        return FileFinder.nameIgnoreCaseFilter((String)text);
    }

    public static String[] getParentPath(String[] path) {
        if (path.length == 0) {
            return null;
        }
        return Arrays.copyOf(path, path.length - 1);
    }

    public static String getFileName(String[] path) {
        if (path.length == 0) {
            return null;
        }
        return path[path.length - 1];
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public ProjectFileTypeInfo getTypeFromExtension(String name, boolean isDirectory) {
        String extension = FilenameUtils.getExtension((String)name);
        ProjectFileTypeInfo info = this.typeRepository.findInfoByExtension(this.getDefaultLocale(), extension);
        if (info.getCode().equals("UNKNOWN") && isDirectory) {
            info = this.typeRepository.getInfo(this.getDefaultLocale(), "DIRECTORY_TYPE");
        }
        return info;
    }

    public ClientOptimizationMode getOptimizationMode() throws RemoteException {
        return this.clientOptimizationMode;
    }

    public String getLocalProjectPath() throws RemoteException {
        return this.clientLocalProjectPath;
    }

    List<ProjectTemplate> getProjectTemplate() {
        return this.projectTemplates;
    }
}

