/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.InvalidRequestException;
import csbase.logic.FileLockListenerInterface;
import csbase.logic.SecureKey;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.projectservice.ExclusiveFileLock;
import csbase.server.services.projectservice.FileLockInterface;
import csbase.server.services.projectservice.ServerProjectFile;
import csbase.server.services.projectservice.SharedFileLock;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FileLockManager {
    private static final long MAX_SLEEP_INTERVAL = 60000L;
    private static FileLockManager instance;
    private final Map<String, FileLockInterface> lockedFiles = new Hashtable<String, FileLockInterface>();
    private Thread managerThread;
    private boolean exitManagerThread;
    private final LockQueue lockQueue = new LockQueue();

    private FileLockManager() {
    }

    static synchronized FileLockManager getInstance() {
        if (instance == null) {
            instance = new FileLockManager();
        }
        return instance;
    }

    FileLockInterface getLock(String filePath) {
        return this.lockedFiles.get(filePath);
    }

    Object acquireSharedLock(ServerProjectFile prjFile, SecureKey sessionKey) {
        SecureKey lockId = new SecureKey();
        if (this.acquireSharedLock(prjFile, sessionKey, lockId)) {
            return lockId;
        }
        return null;
    }

    private synchronized boolean acquireSharedLock(ServerProjectFile prjFile, SecureKey sessionKey, Object lockId) {
        if (prjFile == null) {
            return false;
        }
        String absolutePath = prjFile.getAbsolutePath();
        FileLockInterface lockRef = this.lockedFiles.get(absolutePath);
        if (lockRef != null) {
            if (!lockRef.isShared()) {
                return false;
            }
            lockRef.newLocker(sessionKey, lockId);
            this.acquireSharedLock(prjFile.getParent(), sessionKey, lockId);
            return true;
        }
        this.lockedFiles.put(absolutePath, new SharedFileLock(sessionKey, lockId));
        this.acquireSharedLock(prjFile.getParent(), sessionKey, lockId);
        return true;
    }

    Object acquireExclusiveLock(ServerProjectFile prjFile, SecureKey sessionKey, FileLockListenerInterface listener, long timeout) {
        return this.registerLockRequest(prjFile, listener, timeout, false, sessionKey);
    }

    Object acquireSharedLock(ServerProjectFile prjFile, SecureKey sessionKey, FileLockListenerInterface listener, long timeout) {
        return this.registerLockRequest(prjFile, listener, timeout, true, sessionKey);
    }

    private synchronized Object registerLockRequest(ServerProjectFile prjFile, FileLockListenerInterface listener, long timeout, boolean shared, SecureKey sessionKey) {
        long expirationDate = timeout == -1L ? timeout : System.currentTimeMillis() + timeout;
        LockRequest request = new LockRequest(sessionKey, listener, expirationDate, shared, prjFile);
        if (this.isLocked(prjFile)) {
            this.lockQueue.addRequest(request);
        } else {
            if (shared) {
                this.acquireSharedLock(prjFile, sessionKey, request.id);
            } else {
                this.acquireExclusiveLock(prjFile, sessionKey, request.id);
            }
            this.notifyFileLocked(request);
        }
        return request.id;
    }

    Object acquireExclusiveLock(ServerProjectFile prjFile, SecureKey sessionKey) {
        SecureKey lockId = new SecureKey();
        if (this.acquireExclusiveLock(prjFile, sessionKey, lockId)) {
            return lockId;
        }
        return null;
    }

    private synchronized boolean acquireExclusiveLock(ServerProjectFile prjFile, SecureKey sessionKey, Object lockId) {
        if (prjFile == null) {
            return false;
        }
        String absolutePath = prjFile.getAbsolutePath();
        FileLockInterface lockRef = this.lockedFiles.get(absolutePath);
        if (lockRef != null) {
            if (lockRef.isShared()) {
                return false;
            }
            if (!lockRef.hasExpired()) {
                return false;
            }
        }
        this.lockedFiles.put(absolutePath, new ExclusiveFileLock(sessionKey, lockId));
        this.acquireSharedLock(prjFile.getParent(), sessionKey, lockId);
        return true;
    }

    synchronized int releaseLock(String absolutePath, Object lockId) {
        FileLockInterface lockRef;
        if (lockId == null) {
            throw new InvalidRequestException("lockId == null");
        }
        if (absolutePath == null) {
            return 0;
        }
        LockRequest request = this.lockQueue.getRequest(absolutePath, lockId);
        if (request != null) {
            // empty if block
        }
        if ((lockRef = this.lockedFiles.get(absolutePath)) != null) {
            lockRef.removeLocker(lockId);
            this.releaseLock(this.getParentPath(absolutePath), lockId);
            if (lockRef.getLockRefCount() == 0) {
                this.lockedFiles.remove(absolutePath);
                this.lockQueue.lockReleased();
                return 0;
            }
            return lockRef.getLockRefCount();
        }
        return 0;
    }

    int releaseLock(ServerProjectFile prjFile, Object lockId) {
        if (prjFile == null) {
            return 0;
        }
        int lockRefCount = this.releaseLock(prjFile.getAbsolutePath(), lockId);
        return lockRefCount;
    }

    synchronized int forceReleaseLock(ServerProjectFile prjFile) {
        if (prjFile == null) {
            return 0;
        }
        FileLockInterface fileLock = this.lockedFiles.get(prjFile.getAbsolutePath());
        if (fileLock == null) {
            return 0;
        }
        int lockRefCount = 0;
        if (fileLock.isShared()) {
            Object[] lockIds;
            for (Object id : lockIds = ((SharedFileLock)fileLock).getIds()) {
                lockRefCount = this.releaseLock(prjFile.getAbsolutePath(), id);
            }
        } else {
            lockRefCount = this.releaseLock(prjFile.getAbsolutePath(), ((ExclusiveFileLock)fileLock).getId());
        }
        return lockRefCount;
    }

    synchronized int getLockRefCount(ServerProjectFile prjFile) {
        String absolutePath = prjFile.getAbsolutePath();
        FileLockInterface lock = this.lockedFiles.get(absolutePath);
        if (lock == null) {
            return 0;
        }
        return lock.getLockRefCount();
    }

    synchronized FileLockInterface.LockStatus isLocked(ServerProjectFile prjFile, String sessionKey) {
        String absolutePath = prjFile.getAbsolutePath();
        FileLockInterface lock = this.lockedFiles.get(absolutePath);
        if (lock != null) {
            FileLockInterface.LockStatus lockStatus = lock.checkLockStatus(sessionKey);
            if (lockStatus == FileLockInterface.LockStatus.EXPIRED) {
                this.lockedFiles.remove(absolutePath);
            }
            return lockStatus;
        }
        return FileLockInterface.LockStatus.UNLOCKED;
    }

    boolean isLocked(ServerProjectFile prjFile) {
        return this.isLocked(prjFile.getAbsolutePath());
    }

    synchronized boolean isLocked(String absolutePath) {
        FileLockInterface lock = this.lockedFiles.get(absolutePath);
        if (lock == null) {
            return false;
        }
        if (lock.hasExpired()) {
            this.lockedFiles.remove(absolutePath);
            return false;
        }
        return true;
    }

    private String getParentPath(String path) {
        int lastSeparator = path.lastIndexOf(File.separator);
        if (lastSeparator == -1) {
            return null;
        }
        return path.substring(0, lastSeparator);
    }

    private synchronized void notifyFileLockExpired(final LockRequest lockRequest) {
        final Object key = lockRequest.sessionKey == null ? Service.getKey() : lockRequest.sessionKey;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Service.setKey(key);
                    lockRequest.listener.fileLockExpired((Object)lockRequest.id);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Falha na notifica\u00e7\u00e3o de lock expirado. Pedido de lock: " + lockRequest);
                }
            }
        });
        thread.start();
    }

    private synchronized void notifyFileLocked(final LockRequest lockRequest) {
        final Object key = lockRequest.sessionKey == null ? Service.getKey() : lockRequest.sessionKey;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Service.setKey(key);
                    lockRequest.listener.fileLocked((Object)lockRequest.id);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Falha na notifica\u00e7\u00e3o de lock obtido. Pedido de lock: " + lockRequest, e);
                }
            }
        });
        thread.start();
    }

    private synchronized void clearExpiredLockSessions() {
        Set<Map.Entry<String, FileLockInterface>> locks = this.lockedFiles.entrySet();
        HashSet<String> expiredLocks = new HashSet<String>();
        for (Map.Entry<String, FileLockInterface> lock : locks) {
            if (!lock.getValue().hasExpired()) continue;
            expiredLocks.add(lock.getKey());
        }
        for (String filePath : expiredLocks) {
            this.lockedFiles.remove(filePath);
        }
    }

    private void processRequests() {
        String[] filePaths;
        for (String filePath : filePaths = this.lockQueue.getAndWaitForQueuesKeys()) {
            ArrayList<LockRequest> acquiredLocks = new ArrayList<LockRequest>();
            ArrayList<LockRequest> expiredLocks = new ArrayList<LockRequest>();
            LockRequest[] requests = this.lockQueue.getRequests(filePath);
            long currentDate = System.currentTimeMillis();
            for (LockRequest lockRequest : requests) {
                boolean locked = false;
                locked = lockRequest.shared ? this.acquireSharedLock(lockRequest.projectFile, lockRequest.sessionKey, lockRequest.id) : this.acquireExclusiveLock(lockRequest.projectFile, lockRequest.sessionKey, lockRequest.id);
                if (locked) {
                    acquiredLocks.add(lockRequest);
                    this.notifyFileLocked(lockRequest);
                    continue;
                }
                if (lockRequest.expirationDate == -1L || currentDate < lockRequest.expirationDate) continue;
                expiredLocks.add(lockRequest);
                this.notifyFileLockExpired(lockRequest);
            }
            this.lockQueue.remove(filePath, acquiredLocks);
            this.lockQueue.remove(filePath, expiredLocks);
        }
    }

    void startThread() {
        this.managerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!FileLockManager.this.exitManagerThread) {
                    FileLockManager.this.clearExpiredLockSessions();
                    FileLockManager.this.processRequests();
                    LockRequest next = FileLockManager.this.lockQueue.getNextRequest();
                    if (next == null) continue;
                    long now = System.currentTimeMillis();
                    long nextTimeout = next.expirationDate - now;
                    long interval = nextTimeout < 0L || 60000L < nextTimeout ? 60000L : nextTimeout;
                    FileLockManager.this.lockQueue.sleep(interval);
                }
            }
        }, "FileLockManager");
        this.managerThread.start();
    }

    void stopThread() {
        this.exitManagerThread = true;
    }

    private class LockRequest {
        SecureKey id = new SecureKey();
        SecureKey sessionKey;
        FileLockListenerInterface listener;
        long expirationDate;
        boolean shared;
        ServerProjectFile projectFile;

        LockRequest(SecureKey sessionKey, FileLockListenerInterface listener, long expirationDate, boolean shared, ServerProjectFile projectFile) {
            this.sessionKey = sessionKey;
            this.listener = listener;
            this.expirationDate = expirationDate;
            this.shared = shared;
            this.projectFile = projectFile;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("\nId: " + this.id);
            str.append("Arquivo pedido para lock: " + this.projectFile.getAbsolutePath());
            str.append("\nSess\u00e3o do Usu\u00e1rio: " + this.sessionKey);
            str.append("Data de expira\u00e7\u00e3o: " + new Date(this.expirationDate));
            str.append("\nCompartilhado: " + this.shared);
            return str.toString();
        }
    }

    private class LockQueue {
        private final Map<String, List<LockRequest>> lockRequests = new Hashtable<String, List<LockRequest>>();
        private final List<LockRequest> sortedLockRequests = new ArrayList<LockRequest>();

        LockQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockRequest getNextRequest() {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                if (this.sortedLockRequests.size() > 0) {
                    return this.sortedLockRequests.get(0);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequest(LockRequest request) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                List<LockRequest> requests = this.lockRequests.get(request.projectFile.getAbsolutePath());
                if (requests == null) {
                    requests = new ArrayList<LockRequest>();
                    this.lockRequests.put(request.projectFile.getAbsolutePath(), requests);
                }
                requests.add(request);
                this.addSortedRequest(request);
                FileLockManager.this.notifyAll();
            }
        }

        private void addSortedRequest(LockRequest request) {
            if (this.sortedLockRequests.size() <= 0) {
                this.sortedLockRequests.add(request);
                return;
            }
            for (int i = 0; i < this.sortedLockRequests.size(); ++i) {
                if (request.expirationDate >= this.sortedLockRequests.get((int)i).expirationDate) continue;
                this.sortedLockRequests.add(i, request);
                return;
            }
            this.sortedLockRequests.add(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockRequest[] getRequests(String filePath) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                List<LockRequest> requests = this.lockRequests.get(filePath);
                return requests.toArray(new LockRequest[requests.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(String filePath, List<LockRequest> requests) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                List<LockRequest> queue = this.lockRequests.get(filePath);
                if (queue == null) {
                    return;
                }
                queue.removeAll(requests);
                if (queue.isEmpty()) {
                    this.lockRequests.remove(filePath);
                }
                this.sortedLockRequests.removeAll(requests);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(String filePath, LockRequest request) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                List<LockRequest> queue = this.lockRequests.get(filePath);
                if (queue == null) {
                    return false;
                }
                queue.remove(request);
                if (queue.isEmpty()) {
                    this.lockRequests.remove(filePath);
                }
                return this.sortedLockRequests.remove(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockRequest getRequest(String filePath, Object lockId) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                List<LockRequest> requests = this.lockRequests.get(filePath);
                if (requests == null) {
                    return null;
                }
                for (LockRequest request : requests) {
                    if (!request.id.equals(lockId)) continue;
                    return request;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getAndWaitForQueuesKeys() {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                while (this.size() <= 0) {
                    try {
                        FileLockManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.lockRequests.keySet().toArray(new String[this.lockRequests.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int size() {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                return this.lockRequests.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sleep(long interval) {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                try {
                    FileLockManager.this.wait(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void lockReleased() {
            FileLockManager fileLockManager = FileLockManager.this;
            synchronized (fileLockManager) {
                FileLockManager.this.notifyAll();
            }
        }
    }
}

