/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.serverservice;

import csbase.exception.CSBaseException;
import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ServerURI;
import csbase.logic.User;
import csbase.logic.diagnosticservice.DeploymentInfo;
import csbase.logic.server.ServerInfo;
import csbase.logic.server.ServerInfoAddEvent;
import csbase.logic.server.ServerInfoData;
import csbase.logic.server.ServerInfoEvent;
import csbase.logic.server.ServerInfoModifyEvent;
import csbase.logic.server.ServerInfoRemoveEvent;
import csbase.remote.ServerServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.keystore.CSKeyStore;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.messageservice.MessageService;
import csbase.util.messages.Message;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ServerService
extends Service
implements ServerServiceInterface {
    private static final String SERVER_REPOSITORY_NAME_PROPERTY = "serverRepositoryName";
    private String serverRepository;
    private SortedSet<ServerInfo> serverSortedSet;
    private SortedMap<Integer, ServerInfo> serverIdSortedMap;
    private Map<String, ServerInfo> serverNameMap;
    private static ServerService instance;
    private static final String SERVER_ROOT_TAG = "servidores";
    private static final String SERVER_TAG = "servidor";
    private static final String SERVER_ID_TAG = "id";
    private static final String SERVER_NAME_TAG = "nome";
    private static final String SERVER_SUSPENDED_TAG = "suspenso";
    private static final String SERVER_LOCAL_TAG = "local";
    private static final String SERVER_URI_TAG = "uri";

    private ServerService() throws ServerException {
        super("ServerService");
        this.createCache();
        this.readProperties();
        if (!this.createServerInfoRepository()) {
            this.reloadCache(ServerService.loadServerInfoRepository(this.serverRepository));
            try {
                this.updateServersInfos();
            }
            catch (OperationFailureException e) {
                Server.logSevereMessage("Erro ao carregar o reposit\u00f3rio de chaves/certificados.", e);
            }
        }
        this.calculateNextId();
    }

    private void createCache() {
        this.serverSortedSet = new TreeSet<ServerInfo>();
        this.serverIdSortedMap = new TreeMap<Integer, ServerInfo>();
        this.serverNameMap = new HashMap<String, ServerInfo>();
    }

    private void readProperties() {
        Server server = Server.getInstance();
        String dirPath = server.getPersistencyRootDirectoryName();
        this.serverRepository = dirPath + File.separator + this.getStringProperty(SERVER_REPOSITORY_NAME_PROPERTY);
    }

    private int calculateNextId() {
        if (this.serverIdSortedMap.isEmpty()) {
            return 1;
        }
        return this.serverIdSortedMap.lastKey() + 1;
    }

    private boolean createServerInfoRepository() throws ServerException {
        if (this.serverSortedSet == null) {
            throw new IllegalStateException("Tentativa de criar o arquivo do reposit\u00f3rio de informa\u00e7\u00f5es de servidores antes de criar a cole\u00e7\u00e3o de informa\u00e7\u00f5es servidores.");
        }
        File localServersFile = new File(this.serverRepository);
        if (localServersFile.exists()) {
            return false;
        }
        try {
            File dir = localServersFile.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            localServersFile.createNewFile();
        }
        catch (IOException e) {
            throw new ServerException("Erro ao criar o arquivo com o reposit\u00f3rio de informa\u00e7\u00f5es dos servidores. Caminho usado: {0}.", new Object[]{localServersFile.getPath()}, e);
        }
        try {
            ServerService.writeServerRepository(this.serverSortedSet, this.serverRepository);
        }
        catch (CSBaseException e) {
            throw new ServerException("Erro ao gravar as informa\u00e7\u00f5es dos servidores no reposit\u00f3rio.", e);
        }
        return true;
    }

    public static ServerService getInstance() {
        return instance;
    }

    public static void createService() throws ServerException {
        instance = new ServerService();
    }

    @Override
    public void initService() {
    }

    @Override
    public void shutdownService() {
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    private void updateServersInfos() throws OperationFailureException {
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            return;
        }
        LinkedList<ServerInfo> localServerList = new LinkedList<ServerInfo>();
        LinkedList<ServerInfo> localServerOldStateList = new LinkedList<ServerInfo>();
        LinkedList<ServerInfo> localServerNewStateList = new LinkedList<ServerInfo>();
        for (ServerInfo localServer : this.serverSortedSet) {
            Certificate certificate;
            try {
                certificate = this.getCertificate(localServer.getName());
            }
            catch (CSBaseException e) {
                continue;
            }
            ServerInfo newLocalServer = certificate == null ? new ServerInfo(localServer) : new ServerInfo(localServer, certificate);
            if (localServer.isCompleted() != newLocalServer.isCompleted()) {
                localServerOldStateList.add(localServer);
                localServerNewStateList.add(newLocalServer);
            }
            localServerList.add(newLocalServer);
        }
        ServerService.writeServerRepository(localServerList, this.serverRepository);
        this.reloadCache(localServerList);
        this.fireWasModifiedServerInfo(localServerOldStateList, localServerNewStateList);
    }

    private void reloadCache(Collection<ServerInfo> serverInfoCollection) {
        this.serverSortedSet.clear();
        this.serverIdSortedMap.clear();
        this.serverNameMap.clear();
        for (ServerInfo localServer : serverInfoCollection) {
            this.serverSortedSet.add(localServer);
            this.serverIdSortedMap.put((Integer)localServer.getId(), localServer);
            this.serverNameMap.put(localServer.getName(), localServer);
        }
    }

    public SortedSet<ServerInfo> getServersInfos() {
        try {
            this.updateServersInfos();
        }
        catch (CSBaseException e) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_LOAD_REPOSITORIES_ERROR"), (Throwable)e);
        }
        return Collections.unmodifiableSortedSet(this.serverSortedSet);
    }

    public boolean addServerInfo(ServerInfoData serverInfoData) {
        ServerInfo newLocalServer;
        if (this.hasServerInfo(serverInfoData.getName())) {
            return false;
        }
        try {
            Certificate certificate = this.getCertificate(serverInfoData.getName());
            int localServerId = this.calculateNextId();
            if (this.serverIdSortedMap.get(localServerId) != null) {
                throw new IllegalStateException(MessageFormat.format("Foi gerado um identificador repetido para as informa\u00e7\u00f5es do servidor. Identificador: {0}.", localServerId));
            }
            newLocalServer = certificate == null ? new ServerInfo(Integer.valueOf(localServerId), serverInfoData) : new ServerInfo(Integer.valueOf(localServerId), serverInfoData, certificate);
            TreeSet<ServerInfo> localServerSortedSetTemp = new TreeSet<ServerInfo>(this.serverSortedSet);
            localServerSortedSetTemp.add(newLocalServer);
            ServerService.writeServerRepository(localServerSortedSetTemp, this.serverRepository);
        }
        catch (CSBaseException e) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_ADD_SERVER_ERROR"), (Throwable)e);
        }
        this.addToCache(newLocalServer);
        this.fireWasAddedServerInfo(newLocalServer);
        return true;
    }

    private Certificate getCertificate(String serverName) throws OperationFailureException {
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            return null;
        }
        return keyStore.getCertificate(serverName);
    }

    private boolean hasServerInfo(ServerInfo serverInfo) {
        ServerInfo matchedLocalServer = this.serverNameMap.get(serverInfo.getName());
        if (matchedLocalServer == null) {
            return false;
        }
        return !matchedLocalServer.getId().equals(serverInfo.getId());
    }

    private boolean hasServerInfo(String serverName) {
        ServerInfo matchedLocalServer = this.serverNameMap.get(serverName);
        return matchedLocalServer != null;
    }

    private void addToCache(ServerInfo serverInfo) {
        this.serverSortedSet.add(serverInfo);
        this.serverIdSortedMap.put((Integer)serverInfo.getId(), serverInfo);
        this.serverNameMap.put(serverInfo.getName(), serverInfo);
    }

    private void fireWasAddedServerInfo(ServerInfo serverInfo) {
        this.sendEvent((ServerInfoEvent)new ServerInfoAddEvent(serverInfo));
    }

    public void removeServerInfo(ServerInfo serverInfo) {
        if (this.serverIdSortedMap.get(serverInfo.getId()) == null) {
            throw new IllegalStateException(MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel remover as informa\u00e7\u00f5es de um servidor que n\u00e3o existe. Identificador {0}.", serverInfo.getId()));
        }
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore != null) {
            keyStore.removeCertificate(serverInfo.getName());
        }
        TreeSet<ServerInfo> localServerSortedSetTemp = new TreeSet<ServerInfo>(this.serverSortedSet);
        localServerSortedSetTemp.remove(serverInfo);
        try {
            ServerService.writeServerRepository(localServerSortedSetTemp, this.serverRepository);
        }
        catch (CSBaseException e) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_REMOVE_SERVER_ERROR"), (Throwable)e);
        }
        this.removeFromCache(serverInfo);
        this.fireWasRemovedServerInfo(serverInfo);
    }

    private void removeFromCache(ServerInfo serverInfo) {
        this.serverSortedSet.remove(serverInfo);
        this.serverIdSortedMap.remove(serverInfo.getId());
        this.serverNameMap.remove(serverInfo.getName());
    }

    private void fireWasRemovedServerInfo(ServerInfo serverInfo) {
        this.sendEvent((ServerInfoEvent)new ServerInfoRemoveEvent((Object)this, serverInfo));
    }

    public boolean modifyServerInfo(ServerInfo serverInfo, ServerInfoData serverInfoData) {
        ServerInfo newLocalServer;
        if (this.serverIdSortedMap.get(serverInfo.getId()) == null) {
            throw new IllegalStateException(MessageFormat.format("N\u00e3o \u00e9 poss\u00edvel modificar as informa\u00e7\u00f5es de um servidor que n\u00e3o existe. Identificador {0}.", serverInfo.getId()));
        }
        try {
            Certificate certificate = this.getCertificate(serverInfoData.getName());
            newLocalServer = certificate == null ? new ServerInfo((Integer)serverInfo.getId(), serverInfoData) : new ServerInfo((Integer)serverInfo.getId(), serverInfoData, certificate);
            if (this.hasServerInfo(newLocalServer)) {
                return false;
            }
            TreeSet<ServerInfo> localServerSortedSetTemp = new TreeSet<ServerInfo>(this.serverSortedSet);
            localServerSortedSetTemp.remove(serverInfo);
            localServerSortedSetTemp.add(newLocalServer);
            ServerService.writeServerRepository(localServerSortedSetTemp, this.serverRepository);
        }
        catch (OperationFailureException e) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_MODIFY_SERVER_ERROR"), (Throwable)e);
        }
        this.updateCache(serverInfo, newLocalServer);
        this.fireWasModifiedServerInfo(serverInfo, newLocalServer);
        return true;
    }

    public boolean addCert(String serverName, Certificate c) {
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_KEYSTORE_NOT_FOUND"));
        }
        return keyStore.addCertificate(serverName, c);
    }

    public void removeCert(String serverName) {
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            throw new ServiceFailureException(ServerService.getInstance().getString("SERVER_SERVICE_KEYSTORE_NOT_FOUND"));
        }
        keyStore.removeCertificate(serverName);
    }

    private void updateCache(ServerInfo oldServerInfo, ServerInfo currentServerInfo) {
        this.serverSortedSet.remove(oldServerInfo);
        this.serverSortedSet.add(currentServerInfo);
        this.serverIdSortedMap.put((Integer)currentServerInfo.getId(), currentServerInfo);
        this.serverNameMap.put(currentServerInfo.getName(), currentServerInfo);
    }

    private void fireWasModifiedServerInfo(ServerInfo oldServerInfo, ServerInfo currentServerInfo) {
        this.sendEvent((ServerInfoEvent)new ServerInfoModifyEvent((Object)this, oldServerInfo, currentServerInfo));
    }

    private void fireWasModifiedServerInfo(List<ServerInfo> serverInfoOldStateList, List<ServerInfo> serverInfoNewStateList) {
        if (serverInfoOldStateList.size() != serverInfoNewStateList.size()) {
            throw new IllegalArgumentException("A quantidade de servidor locais deve ser igual nas duas listas.");
        }
        Iterator<ServerInfo> localServerOldStateIterator = serverInfoOldStateList.iterator();
        Iterator<ServerInfo> localServerNewStateIterator = serverInfoNewStateList.iterator();
        while (localServerOldStateIterator.hasNext()) {
            ServerInfo oldLocalServer = localServerOldStateIterator.next();
            ServerInfo newLocalServer = localServerNewStateIterator.next();
            this.sendEvent((ServerInfoEvent)new ServerInfoModifyEvent((Object)this, oldLocalServer, newLocalServer));
        }
    }

    private static Collection<ServerInfo> loadServerInfoRepository(String filePath) throws ServerException {
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServerException("Erro ao criar leitor de documentos para a leitura do reposit\u00f3rio de servidores.", e);
        }
        try {
            document = builder.parse(new File(filePath));
        }
        catch (SAXException e) {
            throw new ServerException("O arquivo do reposit\u00f3rio de servidores est\u00e1 inv\u00e1lido. Caminho {0}", new Object[]{filePath}, e);
        }
        catch (IOException e) {
            throw new ServerException("O arquivo do reposit\u00f3rio de servidores est\u00e1 inv\u00e1lido. Caminho {0}", new Object[]{filePath}, e);
        }
        Element rootElement = document.getDocumentElement();
        NodeList childNodeList = rootElement.getChildNodes();
        LinkedList<ServerInfo> localServerList = new LinkedList<ServerInfo>();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node node = childNodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element localServerElement = (Element)node;
            Integer localServerId = new Integer(localServerElement.getAttribute(SERVER_ID_TAG));
            String localServerName = localServerElement.getAttribute(SERVER_NAME_TAG);
            Boolean isComplete = new Boolean(localServerElement.getAttribute(SERVER_SUSPENDED_TAG));
            Boolean isLocal = new Boolean(localServerElement.getAttribute(SERVER_LOCAL_TAG));
            String uriStr = localServerElement.getAttribute(SERVER_URI_TAG);
            localServerList.add(new ServerInfo(localServerId, localServerName, isComplete.booleanValue(), isLocal.booleanValue(), ServerURI.parse((String)uriStr)));
        }
        return localServerList;
    }

    private static void writeServerRepository(Collection<ServerInfo> serverInfoCollection, String filePath) throws OperationFailureException {
        DocumentBuilder builder;
        String INDENT_OUTPUT_PROPERTY = "indent";
        String YES_VALUE = "yes";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OperationFailureException("Erro ao criar gerador de documentos para a grava\u00e7\u00e3o do reposit\u00f3rio de servidores locais.", (Throwable)e);
        }
        Document document = builder.newDocument();
        Element rootElement = document.createElement(SERVER_ROOT_TAG);
        for (ServerInfo serverInfo : serverInfoCollection) {
            Element serverElement = document.createElement(SERVER_TAG);
            Attr idAttribute = document.createAttribute(SERVER_ID_TAG);
            idAttribute.setValue(serverInfo.getId().toString());
            serverElement.setAttributeNode(idAttribute);
            Attr nameAttribute = document.createAttribute(SERVER_NAME_TAG);
            nameAttribute.setValue(serverInfo.getName());
            serverElement.setAttributeNode(nameAttribute);
            Attr stateAttribute = document.createAttribute(SERVER_SUSPENDED_TAG);
            stateAttribute.setValue(String.valueOf(serverInfo.isSuspended()));
            serverElement.setAttributeNode(stateAttribute);
            Attr localAttribute = document.createAttribute(SERVER_LOCAL_TAG);
            localAttribute.setValue(String.valueOf(serverInfo.isLocal()));
            serverElement.setAttributeNode(localAttribute);
            Attr uriAttribute = document.createAttribute(SERVER_URI_TAG);
            uriAttribute.setValue(serverInfo.getURI().toString());
            serverElement.setAttributeNode(uriAttribute);
            rootElement.insertBefore(serverElement, null);
        }
        document.appendChild(rootElement);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            StreamResult output = new StreamResult(new File(filePath));
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new OperationFailureException("Erro ao gerar o reposit\u00f3rio de servidores.", (Throwable)e);
        }
    }

    public ServerInfo getServerInfo(String serverName) throws OperationFailureException {
        this.updateServersInfos();
        return this.serverNameMap.get(serverName);
    }

    public String listRuntimeProperties() {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Server.getInstance().listRuntimeProperties();
    }

    public Map<String, String> getRuntimeProperties() throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Server.getInstance().getRuntimeProperties();
    }

    public DeploymentInfo getDeploymentInfo() throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return DeploymentInfo.getInstance();
    }

    public int getNumRegisteredUsers() throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return User.getNumRegisteredUsers();
    }

    public long getStartupTime() {
        return Server.getInstance().getStartupTime();
    }

    public Map<String, Integer> getLoginStats(boolean succeeded) throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return LoginService.getInstance().getLoginStats(succeeded);
    }

    private void sendEvent(ServerInfoEvent event) {
        MessageService.getInstance().sendToAll(new Message((Serializable)event));
    }
}

