/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.server.Server;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketUtils {
    private static final String WS_DIR = "wspersistence";

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static String generatePath(String filename) {
        String dir = WS_DIR;
        try {
            Server server = Server.getInstance();
            String sep = File.separator;
            String pName = server.getPersistencyRootDirectoryName();
            String dName = pName + sep + dir;
            Server.checkDirectory(dName);
            Server.logWarningMessage(dName + sep + filename);
            return dName + sep + filename;
        }
        catch (Throwable t) {
            Server.logSevereMessage("Falha na cria\u00e7\u00e3o do arquivo de persist\u00eancia " + dir + "/" + filename + " " + t.getMessage());
            return filename;
        }
    }
}

