/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.loginservice;

import csbase.exception.CSBaseException;
import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.AdministrationEvent;
import csbase.logic.EncryptedPassword;
import csbase.logic.LoginAsPermission;
import csbase.logic.LoginPasswordCipher;
import csbase.logic.Permission;
import csbase.logic.PreLoginData;
import csbase.logic.SecureKey;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.logic.server.ServerInfo;
import csbase.remote.ServerEntryPoint;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.keystore.CSKeyStore;
import csbase.server.plugin.service.loginservice.ILoginService;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.loginservice.ClientConnectionSpy;
import csbase.server.services.loginservice.LoginServiceListener;
import csbase.server.services.loginservice.LogoutEvent;
import csbase.server.services.loginservice.ReferedServerCache;
import csbase.server.services.loginservice.ServerSession;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.pluginservice.PluginService;
import csbase.server.services.serverservice.ServerService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.DigestException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LoginService
extends Service {
    public static final String SERVICE_NAME = "LoginService";
    public static final String LOGIN_METHOD = "loginMethod";
    public static final String LOCAL_LOGIN_METHOD = "LOCAL";
    public static final String LDAP_LOGIN_METHOD = "LDAP";
    public static final String VOMS_LOGIN_METHOD = "VOMS";
    public static final String PRE_LOGIN_DELAY = "preLoginDelay";
    public static final String MAX_SIMULTANEOUS_SESSIONS = "maxUserSimultaneousSessions";
    private static final String USER_DATA = "USER_DATA";
    private static final long MINUTE_IN_MS = 60000L;
    protected Hashtable<SecureKey, ServerSession> loggedUsers = new Hashtable();
    public static final String REAL_USER_ATTRIBUTE = "realUser";
    private final Map<SessionLimiterKey, AtomicInteger> sessionCounter = new ConcurrentHashMap<SessionLimiterKey, AtomicInteger>();
    private int maxSimultaneousSessions;
    protected Hashtable<String, PreLoginInfo> preLoggedUsers = new Hashtable();
    private boolean localLogin;
    private long preLoginDelay;
    private Timer timer;
    private final Set<LoginServiceListener> listeners;
    private final Map<String, Integer> loginCounter = new TreeMap<String, Integer>();
    private final Map<String, Integer> failedLoginCounter = new TreeMap<String, Integer>();
    private Serializable consumerId;
    private final Map<String, ILoginService> loginProtocolPlugins = new HashMap<String, ILoginService>();
    private KeyPair loginPasswordKeyPair;

    public static void createService() throws ServerException {
        new LoginService();
    }

    public static LoginService getInstance() {
        return (LoginService)LoginService.getInstance(SERVICE_NAME);
    }

    protected LoginService() throws ServerException {
        super(SERVICE_NAME);
        this.listeners = new HashSet<LoginServiceListener>();
        try {
            this.loginPasswordKeyPair = LoginPasswordCipher.generateKeyPair();
        }
        catch (Exception e) {
            throw new ServerException("Erro ao gerar o par de chaves p\u00fablica e privada para criptografar e descriptografar a senha.", e);
        }
    }

    public PublicKey getPublicKey() {
        return this.loginPasswordKeyPair.getPublic();
    }

    public synchronized void addListener(LoginServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O listener n\u00e3o pode ser nulo.");
        }
        this.listeners.add(listener);
    }

    public synchronized boolean removeListener(LoginServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O listener n\u00e3o pode ser nulo.");
        }
        return this.listeners.remove(listener);
    }

    protected void fireSessionCreated(String login, Object sessionKey, long time) {
        for (LoginServiceListener listener : this.listeners) {
            listener.sessionCreated(login, sessionKey, time);
        }
    }

    protected void fireUserLoggingOut(String login, Object sessionKey, String systemName, long time) {
        for (LoginServiceListener listener : this.listeners) {
            listener.userLoggingOut(login, sessionKey, systemName, time);
        }
    }

    protected void fireConnectionLost(String login, Object sessionKey, String systemName, long time) {
        for (LoginServiceListener listener : this.listeners) {
            listener.connectionLost(login, sessionKey, systemName, time);
        }
    }

    protected void fireSystemNameSet(String login, Object sessionKey, String systemName, long time) {
        for (LoginServiceListener listener : this.listeners) {
            listener.systemNameSet(login, sessionKey, systemName, time);
        }
    }

    @Override
    public void initService() throws ServerException {
        this.timer = new Timer(true);
        this.loadLoginProtocolPluginList();
        this.loadAuthenticationProperties();
        try {
            this.install();
        }
        catch (RemoteException re) {
            throw new ServerException(re);
        }
        this.maxSimultaneousSessions = this.getIntProperty(MAX_SIMULTANEOUS_SESSIONS);
    }

    private void loadLoginProtocolPluginList() throws ServerException {
        if (PluginService.getInstance() == null) {
            return;
        }
        Map<String, Class<?>> loginPluginMap = PluginService.getInstance().getPluginExtensionPoints(this.getStringProperty("plugin.login.id"), this.getStringProperty("plugin.login.extension.point.id"));
        List<String> loginPlugins = this.getStringListProperty("login.plugin.protocol");
        List<String> loginPluginProps = this.getStringListProperty("login.plugin.properties");
        for (int i = 0; i < loginPlugins.size(); ++i) {
            String loginProtocol = loginPlugins.get(i);
            Class<?> pluginClass = loginPluginMap.get(loginProtocol);
            String pluginPropFile = loginPluginProps.get(i);
            try {
                Constructor<?> constr = pluginClass.getDeclaredConstructor(new Class[0]);
                ILoginService plugin = (ILoginService)constr.newInstance(new Object[0]);
                if (loginPluginProps == null || loginPluginProps.isEmpty() || pluginPropFile == null) continue;
                Properties pluginProps = new Properties();
                pluginProps.load(new FileInputStream(pluginPropFile));
                plugin.setProperties(pluginProps);
                this.loginProtocolPlugins.put(loginProtocol, plugin);
                continue;
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    throw new ServerException("Arquivo de propriedades do plugin n\u00e3o encontrado: " + pluginPropFile, e);
                }
                throw new ServerException("Erro na carga do plugin " + pluginClass.getName(), e);
            }
        }
    }

    private void loadAuthenticationProperties() throws ServerException {
        String loginMethod = this.getStringProperty(LOGIN_METHOD);
        if (!(loginMethod.equals(LOCAL_LOGIN_METHOD) || loginMethod.equals(LDAP_LOGIN_METHOD) || loginMethod.equals(VOMS_LOGIN_METHOD))) {
            throw new ServerException(String.format("M\u00e9todo de autentica\u00e7\u00e3o %s desconhecido!", loginMethod));
        }
        this.preLoginDelay = (long)this.getIntProperty(PRE_LOGIN_DELAY) * 60000L;
        if (loginMethod.equals(LOCAL_LOGIN_METHOD)) {
            this.localLogin = true;
            Server.logWarningMessage("M\u00e9todo de autentica\u00e7\u00e3o configurado para LOCAL.");
        } else if (loginMethod.equals(LDAP_LOGIN_METHOD) || loginMethod.equals(VOMS_LOGIN_METHOD)) {
            this.localLogin = false;
            Server.logInfoMessage("M\u00e9todo de autentica\u00e7\u00e3o configurado para " + loginMethod + ".");
        }
    }

    public void install() throws RemoteException {
        IMessageListener listener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    AdministrationEvent event = (AdministrationEvent)message.getBody();
                    if (!(event.item instanceof User)) {
                        return;
                    }
                    User targetUser = (User)event.item;
                    Vector<SecureKey> logoutUsers = new Vector<SecureKey>();
                    Enumeration<SecureKey> e = LoginService.this.loggedUsers.keys();
                    while (e.hasMoreElements()) {
                        SecureKey key = e.nextElement();
                        ServerSession session = LoginService.this.loggedUsers.get(key);
                        if (session == null) {
                            return;
                        }
                        User user = session.getUser();
                        if (!user.getId().equals(targetUser.getId())) continue;
                        switch (event.type) {
                            case 2: {
                                session.setUser(targetUser);
                                break;
                            }
                            case 3: {
                                logoutUsers.add(key);
                            }
                        }
                    }
                    for (int i = 0; i < logoutUsers.size(); ++i) {
                        LoginService.this.logout(logoutUsers.get(i));
                    }
                }
            }
        };
        this.consumerId = MessageService.getInstance().setServerMessageListener(listener, new BodyTypeFilter(AdministrationEvent.class));
    }

    @Override
    public void shutdownService() throws ServerException {
        try {
            ReferedServerCache.getInstance().clear();
            this.uninstall();
        }
        catch (RemoteException re) {
            throw new ServerException(re);
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void uninstall() throws RemoteException {
        MessageService.getInstance().clearServerMessageListener(this.consumerId);
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    public boolean canChangePasswords() {
        return this.localLogin;
    }

    public boolean isLocalLogin() {
        return this.localLogin;
    }

    public PreLoginData preLogin(String login, String password, Locale locale) {
        return this.preLogin(login, password, locale, (Map<String, Serializable>)null);
    }

    public PreLoginData preLogin(String login, String password, Locale locale, Map<String, Serializable> attributes) {
        if (login == null || password == null || locale == null) {
            throw new IllegalArgumentException("(login || password || locale) == null");
        }
        User user = this.checkLogin(login, password, attributes);
        if (user == null) {
            return null;
        }
        return this.doPreLogin(user, locale, attributes, null, null);
    }

    public PreLoginData preLogin(String login, String password, Locale locale, String delegatedLogin, Remote control, Serializable userData) {
        User user = this.checkLogin(login, password);
        if (user == null) {
            return null;
        }
        if (delegatedLogin != null) {
            user = AdministrationService.getInstance().changeUser(user, delegatedLogin);
            user.setSuperUserLogin(login);
            Server.logInfoMessage(String.format("Usu\u00e1rio %s foi delegado pelo usu\u00e1rio %s.", delegatedLogin, login));
        }
        HashMap<String, Serializable> serverAttributes = new HashMap<String, Serializable>();
        serverAttributes.put(USER_DATA, userData);
        return this.doPreLogin(user, locale, null, serverAttributes, control);
    }

    public PreLoginData preLogin(String login, String password, Locale locale, String delegatedLogin) {
        User user = this.checkLogin(login, password);
        if (user == null) {
            return null;
        }
        User delegatedUser = AdministrationService.getInstance().changeUser(user, delegatedLogin);
        if (delegatedUser != null) {
            user = delegatedUser;
            user.setSuperUserLogin(login);
        }
        HashMap<String, Serializable> serverAttributes = new HashMap<String, Serializable>();
        return this.doPreLogin(user, locale, null, serverAttributes, null);
    }

    private PreLoginData doPreLogin(User user, Locale locale, Map<String, Serializable> attributes, Map<String, Serializable> serverAttributes, Remote control) {
        String token;
        try {
            token = new SecureKey().digest();
        }
        catch (DigestException e) {
            Server.logSevereMessage(String.format("Erro ao gerar digest para cria\u00e7\u00e3o do token do usu\u00e1rio %s.", user.getLogin()), e);
            throw new ServiceFailureException("Erro ao gerar token para pr\u00e9-login.");
        }
        SecureKey sessionKey = new SecureKey();
        CheckPreLoginTask task = new CheckPreLoginTask(token);
        PreLoginInfo info = new PreLoginInfo(sessionKey, user, locale, attributes, serverAttributes, control);
        this.preLoggedUsers.put(token, info);
        this.timer.schedule((TimerTask)task, this.preLoginDelay);
        Server.logInfoMessage(String.format("Prelogin de %s para o locale %s. Token: %s", user.getLogin() + this.getRealUserForLog(attributes), locale, token));
        return new PreLoginData((Object)sessionKey, token);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale) {
        return this.login(login, encryptedPassword, locale, null, null, null);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, TimeZone timeZone) {
        return this.login(login, encryptedPassword, locale, null, timeZone, null);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, String delegatedLogin) {
        return this.login(login, encryptedPassword, locale, delegatedLogin, null, null);
    }

    public Session login(String login, EncryptedPassword encryptedPassword, Locale locale, String delegatedLogin, TimeZone timeZone, Map<String, Serializable> params) {
        if (login == null) {
            throw new IllegalArgumentException("login == null");
        }
        if (encryptedPassword == null) {
            throw new IllegalArgumentException("password == null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale == null");
        }
        String plainPassoword = LoginPasswordCipher.decrypt((EncryptedPassword)encryptedPassword, (PrivateKey)this.loginPasswordKeyPair.getPrivate());
        User user = this.checkLogin(login, plainPassoword);
        if (user == null) {
            this.incrCounter(this.failedLoginCounter, login);
            return null;
        }
        if (delegatedLogin != null) {
            user = AdministrationService.getInstance().changeUser(user, delegatedLogin);
            user.setSuperUserLogin(login);
            Server.logInfoMessage(String.format("O usu\u00e1rio %s foi delegado pelo usu\u00e1rio %s.", delegatedLogin, login));
        }
        this.incrCounter(this.loginCounter, login);
        Session session = this.createSession(new SecureKey(), user, locale, params, null, null);
        this.saveTimeZone(session.getKey(), timeZone);
        Server.logInfoMessage(String.format("Login de %s com locale %s. (%d sess\u00e3o(\u00f5es) simult\u00e2nea(s))", LoginService.getLoginStr(user) + this.getRealUserForLog(params), locale, this.sessionCounter.get(new SessionLimiterKey(user)).get()));
        return session;
    }

    private boolean isSameAddress(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName == null");
        }
        try {
            return InetAddress.getByName(hostName).isLoopbackAddress() || InetAddress.getByName(hostName).equals(InetAddress.getByName(Server.getInstance().getHostName()));
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro resolvendo endere\u00e7o IP.", e);
            return false;
        }
    }

    public Session login(ServerURI referedServerURI, Map<String, Serializable> attr, boolean copyServerSessionAttrs, Object sessionkey, String login, String delegatedLogin, Locale locale, TimeZone tz) {
        try {
            User user = User.getUserByLogin((String)login);
            String realUserLog = this.getRealUserForLog(attr);
            if (user == null) {
                Server.logSevereMessage(String.format("Login por refer\u00eancia negado. Usu\u00e1rio %s inexistente.", login + realUserLog));
                return null;
            }
            Map referedServerSessionAttrs = null;
            if (referedServerURI.getPort() != Server.getInstance().getRegistryPort() || !this.isSameAddress(referedServerURI.getHost())) {
                CSKeyStore keyStore = CSKeyStore.getInstance();
                if (keyStore == null) {
                    Server.logWarningMessage(String.format("Login por refer\u00eancia negado. Usu\u00e1rio %s. O reposit\u00f3rio de chaves/certificados n\u00e3o existe.", login + realUserLog));
                    return null;
                }
                if (!keyStore.containsAlias(Server.getInstance().getSystemName())) {
                    Server.logWarningMessage(String.format("Login por refer\u00eancia negado. Usu\u00e1rio %s. O servidor n\u00e3o possui certificado cadastrado.", login + realUserLog));
                    return null;
                }
                String privateKeyPassword = Server.getInstance().getPrivateKeyPassword();
                if (privateKeyPassword == null) {
                    Server.logSevereMessage("A senha da chave privada do servidor n\u00e3o foi informada.");
                    return null;
                }
                byte[] signedServerName = keyStore.sign(Server.getInstance().getSystemName(), privateKeyPassword, Server.getInstance().getSystemName());
                if (signedServerName == null) {
                    Server.logSevereMessage("Login por refer\u00eancia negado. Usu\u00e1rio " + login + ". O servidor n\u00e3o possui chave gerada no reposit\u00f3rio de chaves/certificados.");
                    return null;
                }
                ServerEntryPoint server = ReferedServerCache.getInstance().getServer(referedServerURI);
                if (server == null) {
                    Server.logSevereMessage("Login por refer\u00eancia negado. Servidor " + referedServerURI + " fora do ar");
                    return null;
                }
                if (!server.getVersionName().equals(Server.getInstance().getVersion())) {
                    Server.logSevereMessage("Login por refer\u00eancia negado. Servidor " + referedServerURI + " possui vers\u00e3o diferente deste.");
                    return null;
                }
                referedServerSessionAttrs = server.isValidSession(sessionkey, Server.getInstance().getSystemName(), signedServerName);
                if (referedServerSessionAttrs == null) {
                    Server.logSevereMessage(String.format("Login por refer\u00eancia negado. Usu\u00e1rio %s n\u00e3o foi validado no servidor %s.", login + realUserLog, referedServerURI));
                    return null;
                }
            } else {
                if (!this.isValidSession(sessionkey)) {
                    Server.logSevereMessage(String.format("Login por refer\u00eancia negado. Usu\u00e1rio %s n\u00e3o foi validado no servidor %s.", login + realUserLog, referedServerURI));
                    return null;
                }
                referedServerSessionAttrs = this.loggedUsers.get(sessionkey).getPropertes();
            }
            if (delegatedLogin != null) {
                user = AdministrationService.getInstance().changeUser(user, delegatedLogin);
                user.setSuperUserLogin(login);
                Server.logInfoMessage(String.format("Usu\u00e1rio %s foi delegado pelo usu\u00e1rio %s.", delegatedLogin, login + realUserLog));
            }
            Session session = null;
            session = copyServerSessionAttrs ? this.createSession(new SecureKey(), user, locale, attr, referedServerSessionAttrs, null) : this.createSession(new SecureKey(), user, locale, attr, null, null);
            this.saveTimeZone(session.getKey(), tz);
            Server.logInfoMessage(String.format("Login de %s com locale %s. Validado por %s. (%d sess\u00e3o(\u00f5es) simult\u00e2nea(s))", LoginService.getLoginStr(user) + realUserLog, locale, referedServerURI, this.sessionCounter.get(new SessionLimiterKey(user)).get()));
            return session;
        }
        catch (Exception e) {
            Server.logSevereMessage(String.format("Erro no login por refer\u00eancia para usu\u00e1rio %s do servidor %s.", login, referedServerURI), e);
            return null;
        }
    }

    public User checkLogin(String login, String password) {
        return this.checkLogin(login, password, null);
    }

    public User checkLogin(String login, String password, Map<String, Serializable> attributes) {
        String loginMethod = this.getStringProperty(LOGIN_METHOD);
        User user = null;
        try {
            user = User.getUserByLogin((String)login);
            if (user == null) {
                Server.logWarningMessage(String.format("Tentativa de login de usu\u00e1rio inexistente: %s.", login));
                return null;
            }
            if (attributes != null && password.equals("") && attributes.containsKey(REAL_USER_ATTRIBUTE)) {
                String realUser = (String)((Object)attributes.get(REAL_USER_ATTRIBUTE));
                return this.canLoginAs(realUser, login) ? user : null;
            }
            Object forceLocalLogin = user.getAttribute("forceLocalLogin");
            if (user.getId().equals(User.getAdminId()) || this.localLogin || forceLocalLogin != null && forceLocalLogin.equals(Boolean.TRUE)) {
                ILoginService plugin = this.loginProtocolPlugins.get(LOCAL_LOGIN_METHOD.toLowerCase());
                System.out.println("PROTOCOL: " + plugin.getProtocolType());
                return plugin.authenticate(user, password);
            }
            if (loginMethod.equals(LDAP_LOGIN_METHOD) || loginMethod.equals(VOMS_LOGIN_METHOD)) {
                ILoginService plugin = this.loginProtocolPlugins.get(loginMethod.toLowerCase());
                System.out.println("PROTOCOL: " + plugin.getProtocolType());
                return plugin.authenticate(user, password);
            }
            Server.logWarningMessage(String.format("Protocolo de login n\u00e3o suportado: %s.", loginMethod));
            return null;
        }
        catch (Exception e) {
            Server.logSevereMessage(String.format("Erro no login de: %s.", login), e);
            return null;
        }
    }

    private boolean canLoginAs(String realUserLogin, String newUserLogin) {
        boolean ret = false;
        try {
            List perms = Permission.getAllPermissions();
            for (Permission permission : perms) {
                LoginAsPermission loginPerm;
                if (!(permission instanceof LoginAsPermission) || !(loginPerm = (LoginAsPermission)permission).canLoginAs(realUserLogin, newUserLogin)) continue;
                ret = true;
                break;
            }
        }
        catch (Exception e) {
            Server.logSevereMessage(String.format("Erro ao verificar permiss\u00f5es para usu\u00e1rio %s logar como: %s.", realUserLogin, newUserLogin), e);
        }
        return ret;
    }

    public Session login(String token) {
        return this.login(token, null);
    }

    public Session login(String token, TimeZone timeZone) {
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        PreLoginInfo info = this.preLoggedUsers.remove(token);
        if (info == null) {
            Server.logWarningMessage(String.format("Tentativa de login a partir de um token n\u00e3o v\u00e1lido: %s.", token));
            return null;
        }
        User user = info.getUser();
        Session session = this.createSession(info);
        this.saveTimeZone(session.getKey(), timeZone);
        Server.logInfoMessage(String.format("login a partir de preLogin de %s para locale %s.", user.getLogin() + this.getRealUserForLog(session.getAttributes()), info.getLocale()));
        return session;
    }

    public Session login(String serverName, byte[] signedServerName, Locale locale) {
        if (serverName == null || signedServerName == null || locale == null) {
            throw new IllegalArgumentException("(localServerName || signedLocalServerName || locale) == null");
        }
        User user = this.checkLogin(serverName, signedServerName);
        if (user == null) {
            return null;
        }
        Session session = this.createSession(user, locale);
        Server.logInfoMessage(String.format("Login (servidor local) de %s com locale %s.", user.getLogin(), locale));
        return session;
    }

    public Session login(OpenBusLoginToken token, Locale locale, TimeZone timeZone) {
        User user;
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale == null");
        }
        String login = token.user;
        if (!OpenBusService.getInstance().isEnabled()) {
            Server.logWarningMessage(String.format("N\u00e3o foi poss\u00edvel logar o usu\u00e1rio %s porque o OpenBus est\u00e1 desabilitado.", login));
            return null;
        }
        try {
            user = User.getUserByLogin((String)login);
        }
        catch (Exception e) {
            Server.logSevereMessage(String.format("Erro ao obter o usu\u00e1rio %s.", login), e);
            return null;
        }
        if (user == null) {
            Server.logWarningMessage(String.format("Tentativa de login de usu\u00e1rio inexistente: %s.", login));
            return null;
        }
        OpenBusLoginToken clientToken = OpenBusService.getInstance().doTokenLogin(token);
        if (clientToken == null) {
            Server.logSevereMessage(String.format("Erro ao validar o usu\u00e1rio %s no barramento.", login));
            return null;
        }
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("CLIENT_TOKEN", (Serializable)clientToken);
        Session session = this.createSession(new SecureKey(), user, locale, attributes, null, null);
        this.saveTimeZone(session.getKey(), timeZone);
        Server.logInfoMessage(String.format("Login de %s com locale %s (%d sess\u00e3o(\u00f5es) simult\u00e2nea(s))", LoginService.getLoginStr(user), locale, this.sessionCounter.get(new SessionLimiterKey(user)).get()));
        return session;
    }

    private User checkLogin(String serverName, byte[] signedServerName) {
        ServerInfo serverInfo;
        try {
            serverInfo = ServerService.getInstance().getServerInfo(serverName);
        }
        catch (OperationFailureException e) {
            Server.logSevereMessage(String.format("Falha ao obter o servidor local %s.", serverName), e);
            return null;
        }
        if (serverInfo == null) {
            Server.logWarningMessage(String.format("O servidor local %s n\u00e3o foi encontrado.", serverName));
            return null;
        }
        if (!serverInfo.isLocal()) {
            Server.logWarningMessage(String.format("O servidor %s n\u00e3o \u00e9 um servidor local.", serverName));
            return null;
        }
        if (serverInfo.isSuspended()) {
            Server.logWarningMessage(String.format("O servidor local %s est\u00e1 suspenso.", serverName));
            return null;
        }
        CSKeyStore keyStore = CSKeyStore.getInstance();
        if (keyStore == null) {
            Server.logWarningMessage("O reposit\u00f3rio de chaves/certificados n\u00e3o existe.");
            return null;
        }
        try {
            if (!keyStore.containsAlias(serverName)) {
                Server.logWarningMessage(String.format("O servidor local %s n\u00e3o possui certificado cadastrado.", serverName));
                return null;
            }
        }
        catch (CSBaseException e) {
            Server.logSevereMessage(String.format("Falha ao verificar se o servidor local %s existe no reposit\u00f3rio.", serverName), e);
            return null;
        }
        try {
            if (!keyStore.verify(serverName, serverName, signedServerName)) {
                Server.logWarningMessage(String.format("A assinatura do servidor local %s est\u00e1 inv\u00e1lida.", serverName));
                return null;
            }
        }
        catch (CSBaseException e) {
            Server.logSevereMessage(String.format("Erro ao verificar a assinatura do servidor local %s.", serverName), e);
            return null;
        }
        try {
            return User.getUserByLogin((String)((String)User.getAdminId()));
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter o usu\u00e1rio administrador.", e);
            return null;
        }
    }

    protected Session createSession(User user, Locale locale) {
        return this.createSession(new SecureKey(), user, locale, null, null, null);
    }

    private Session createSession(PreLoginInfo info) {
        return this.createSession(info.getSessionKey(), info.getUser(), info.getLocale(), info.getAttributes(), info.getServerAttributes(), info.getControl());
    }

    private Session createSession(SecureKey sessionKey, User user, Locale locale, Map<String, Serializable> attributes, Map<String, Serializable> serverAttributes, Remote control) {
        ClientConnectionSpy spy = null;
        SessionLimiterKey sessionLimiterKey = new SessionLimiterKey(user);
        AtomicInteger counter = this.sessionCounter.get(sessionLimiterKey);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.sessionCounter.put(sessionLimiterKey, counter);
        }
        if (this.maxSimultaneousSessions > 0 && counter.get() >= this.maxSimultaneousSessions) {
            Server.logWarningMessage("Usu\u00e1rio " + LoginService.getLoginStr(user) + this.getRealUserForLog(attributes) + " excedeu o n\u00famero de sess\u00f5es simult\u00e2neas (" + this.maxSimultaneousSessions + ")");
            throw new PermissionException("N\u00famero m\u00e1ximo de sess\u00f5es excedido (" + this.maxSimultaneousSessions + "). Fa\u00e7a logout em outras sess\u00f5es para poder realizar este login.");
        }
        counter.incrementAndGet();
        try {
            spy = new ClientConnectionSpy(sessionKey);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao criar espi\u00e3o de conex\u00e3o.", e);
            throw new ServiceFailureException("Erro ao criar sess\u00e3o do usu\u00e1rio.");
        }
        Session clientSession = new Session(user, (Serializable)sessionKey, (Remote)spy, attributes);
        ServerSession serverSession = new ServerSession(user, locale);
        serverSession.setControl(control);
        if (attributes != null) {
            serverSession.putAllProperties(attributes);
        }
        if (serverAttributes != null) {
            serverSession.putAllProperties(serverAttributes);
        }
        this.loggedUsers.put(sessionKey, serverSession);
        String login = user != null ? user.getLogin() : null;
        this.fireSessionCreated(login, sessionKey, System.currentTimeMillis());
        return clientSession;
    }

    public boolean isValidSession(Object sessionKey) {
        return this.loggedUsers.containsKey(sessionKey);
    }

    void warnConnectionLost(Object sessionKey) {
        ServerSession session = this.loggedUsers.get(sessionKey);
        if (session != null) {
            User user = session.getUser();
            String name = session.getApp();
            String login = user != null ? user.getLogin() : null;
            this.fireConnectionLost(login, sessionKey, name, System.currentTimeMillis());
            this.logout(sessionKey);
        }
    }

    public void logout(Object sessionKey) {
        if (sessionKey == null) {
            throw new IllegalArgumentException("sessionKey == null");
        }
        ServerSession session = this.loggedUsers.get(sessionKey);
        if (session != null) {
            MessageService.getInstance().clearMessageListener(session);
            User user = session.getUser();
            String login = user != null ? user.getLogin() : null;
            String name = session.getApp();
            this.fireUserLoggingOut(login, sessionKey, name, System.currentTimeMillis());
            this.loggedUsers.remove(sessionKey);
            this.notifyObservers(new LogoutEvent(sessionKey));
            SessionLimiterKey sessionLimiterKey = new SessionLimiterKey(user);
            if (this.sessionCounter.get(sessionLimiterKey).decrementAndGet() == 0) {
                this.sessionCounter.remove(sessionLimiterKey);
            }
            Server.logInfoMessage(String.format("Logout de %s.", user.getLogin() + this.getRealUserForLog(session.getPropertes())));
        } else {
            Server.logWarningMessage(String.format("Tentativa de logout para uma sess\u00e3o inv\u00e1lida: %s.", sessionKey));
        }
    }

    public Locale getUserSessionLocale(Object key) {
        ServerSession session = this.loggedUsers.get(key);
        if (session == null) {
            return null;
        }
        return session.getLocale();
    }

    public UserOutline[] getLoggedUsers() {
        Enumeration<ServerSession> userEnumeration = this.loggedUsers.elements();
        ArrayList<UserOutline> userList = new ArrayList<UserOutline>();
        while (userEnumeration.hasMoreElements()) {
            ServerSession session = userEnumeration.nextElement();
            User user = session.getUser();
            try {
                userList.add(user.getOutline());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return userList.toArray(new UserOutline[userList.size()]);
    }

    public User getUserByKey(Object key) {
        ServerSession session = this.loggedUsers.get(key);
        if (session == null) {
            return null;
        }
        return session.getUser();
    }

    public <T> T getSessionProperty(Object key, String propertyName) {
        ServerSession session = this.loggedUsers.get(key);
        if (session == null) {
            return null;
        }
        return (T)session.getProperty(propertyName);
    }

    public void setSessionProperty(Object key, String propertyName, Serializable propertyValue) {
        ServerSession session = this.loggedUsers.get(key);
        if (session != null) {
            session.setProperty(propertyName, propertyValue);
        }
    }

    public void removeSessionProperty(Object key, String propertyName) {
        ServerSession session = this.loggedUsers.get(key);
        if (session != null) {
            session.removeProperty(propertyName);
        }
    }

    public void setSystemName(Object sessionKey, String systemName) {
        ServerSession session = this.loggedUsers.get(sessionKey);
        if (session != null) {
            session.setApp(systemName);
            User user = session.getUser();
            String login = user != null ? user.getLogin() : null;
            this.fireSystemNameSet(login, sessionKey, systemName, System.currentTimeMillis());
        }
    }

    private void saveTimeZone(Object key, TimeZone timeZone) {
        if (timeZone != null) {
            ServerSession session = this.loggedUsers.get(key);
            if (session == null) {
                throw new IllegalStateException("Sess\u00e3o inv\u00e1lida.");
            }
            session.setTimeZone(timeZone);
        }
    }

    public TimeZone getTimeZone() {
        ServerSession session = this.loggedUsers.get(LoginService.getKey());
        if (session == null) {
            return TimeZone.getDefault();
        }
        return session.getTimeZone();
    }

    public Map<String, Serializable> getSessionAttributes(Object key) {
        if (this.loggedUsers.get(key) != null) {
            return this.loggedUsers.get(key).getPropertes();
        }
        return null;
    }

    public Map<String, Integer> getLoginStats(boolean succeeded) {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        if (succeeded) {
            return Collections.unmodifiableMap(this.loginCounter);
        }
        return Collections.unmodifiableMap(this.failedLoginCounter);
    }

    private static final String getLoginStr(User user) {
        if (user.getSuperUserLogin() == null) {
            return user.getLogin();
        }
        return user.getSuperUserLogin() + ">>" + user.getLogin();
    }

    private String getRealUserForLog(Map<String, Serializable> attributes) {
        String realUserLog = "";
        if (attributes != null && attributes.containsKey(REAL_USER_ATTRIBUTE)) {
            realUserLog = "/realUser:" + attributes.get(REAL_USER_ATTRIBUTE);
        }
        return realUserLog;
    }

    public String getRealUserForLog(Object key) {
        return this.getRealUserForLog(this.getSessionAttributes(key));
    }

    private class CheckPreLoginTask
    extends TimerTask {
        private final Object token;

        public CheckPreLoginTask(Object token) {
            if (token == null) {
                throw new IllegalArgumentException("token == null");
            }
            this.token = token;
        }

        @Override
        public void run() {
            if (LoginService.this.preLoggedUsers.remove(this.token) != null) {
                Server.logInfoMessage(String.format("Prelogin n\u00e3o confirmado para token %s", this.token));
            }
        }
    }

    private class PreLoginInfo {
        private final SecureKey sessionKey;
        private final User user;
        private final Locale locale;
        private final Map<String, Serializable> attributes;
        private final Map<String, Serializable> serverAttributes;
        private final Remote control;

        public PreLoginInfo(SecureKey sessionKey, User user, Locale locale, Map<String, Serializable> attributes, Map<String, Serializable> serverAttributes, Remote control) {
            if (sessionKey == null) {
                throw new IllegalArgumentException("Chave de sess\u00e3o n\u00e3o pode ser nula.");
            }
            if (user == null) {
                throw new IllegalArgumentException("Usu\u00e1rio n\u00e3o pode ser nulo.");
            }
            if (locale == null) {
                throw new IllegalArgumentException("O locale do usu\u00e1rio n\u00e3o pode ser nulo.");
            }
            this.sessionKey = sessionKey;
            this.user = user;
            this.locale = locale;
            this.control = control;
            this.attributes = new HashMap<String, Serializable>();
            if (attributes != null) {
                this.attributes.putAll(attributes);
            }
            this.serverAttributes = new HashMap<String, Serializable>();
            if (serverAttributes != null) {
                this.serverAttributes.putAll(serverAttributes);
            }
        }

        public SecureKey getSessionKey() {
            return this.sessionKey;
        }

        public User getUser() {
            return this.user;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Map<String, Serializable> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        public Map<String, Serializable> getServerAttributes() {
            return Collections.unmodifiableMap(this.serverAttributes);
        }

        public Remote getControl() {
            return this.control;
        }
    }

    private static final class SessionLimiterKey {
        private final String superUser;
        private final String user;

        public SessionLimiterKey(User user) {
            if (user == null) {
                throw new IllegalArgumentException("login n\u00e3o pode ser nulo!");
            }
            this.superUser = user.getSuperUserLogin();
            this.user = user.getLogin();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.superUser == null ? 0 : this.superUser.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionLimiterKey other = (SessionLimiterKey)obj;
            if (this.superUser == null ? other.superUser != null : !this.superUser.equals(other.superUser)) {
                return false;
            }
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }

        public String toString() {
            if (this.superUser != null) {
                return this.superUser + ">" + this.user;
            }
            return this.user;
        }
    }
}

