package csbase.server.services.opendreamsservice.opendreams.v2_0;

import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

import tecgraf.openbus.DRMAA.v2_0.Job;
import tecgraf.openbus.DRMAA.v2_0.JobHelper;
import tecgraf.openbus.DRMAA.v2_0.JobOperations;
import tecgraf.openbus.DRMAA.v2_0.JobPOATie;
import tecgraf.openbus.DRMAA.v2_0.JobSession;
import tecgraf.openbus.DRMAA.v2_0.JobSessionHelper;
import tecgraf.openbus.DRMAA.v2_0.JobSessionOperations;
import tecgraf.openbus.DRMAA.v2_0.JobSessionPOATie;
import csbase.exception.OperationFailureException;
import csbase.server.services.openbusservice.OpenBusService;

/**
 *
 *
 * @author Tecgraf/PUC-Rio
 */
public class CorbaUtils {

  /**
   * @param job
   * @return
   * @throws OperationFailureException
   * @throws ServantNotActive
   * @throws WrongPolicy
   */
  public static Job narrow(JobOperations job) throws OperationFailureException,
    ServantNotActive, WrongPolicy {
    System.out.println("Job narrow()");
    POA poa = OpenBusService.getInstance().getRootPOA();
    JobPOATie tie = new JobPOATie(job, poa);
    org.omg.CORBA.Object obj = poa.servant_to_reference(tie);
    Job ref = JobHelper.narrow(obj);
    System.out.println("Returning Job ref " + poa + " " + ref);
    return ref;
  }

  /**
   * @param session
   * @return
   * @throws OperationFailureException
   * @throws ServantNotActive
   * @throws WrongPolicy
   */
  public static JobSession narrow(JobSessionOperations session)
    throws OperationFailureException, ServantNotActive, WrongPolicy {
    System.out.println("JobSession narrow()");
    POA poa = OpenBusService.getInstance().getRootPOA();
    JobSessionPOATie tie = new JobSessionPOATie(session, poa);
    org.omg.CORBA.Object obj = poa.servant_to_reference(tie);
    JobSession ref = JobSessionHelper.narrow(obj);
    System.out.println("Returning JobSession ref " + poa + " " + ref);
    return ref;
  }
}
