package csbase.server.services.schedulerservice;

import java.rmi.RemoteException;
import java.util.Comparator;

import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;

public class CommandGreedinessComparator implements Comparator<CommandInfo> {
	@Override
	public int compare(CommandInfo o1, CommandInfo o2) {
		try {
			AlgorithmConfigurator conf1 = o1.getConfigurator();
			AlgorithmConfigurator conf2 = o2.getConfigurator();

			int prior1 = o1.getPriority().ordinal();
			int prior2 = o2.getPriority().ordinal();

			float mem1 = conf1.getMemoryAmount();
			float mem2 = conf2.getMemoryAmount();

			float cpu1 = conf1.getCpuAmount();
			float cpu2 = conf2.getCpuAmount();

			int numReq1 = conf1.getRequirements().size();
			int numReq2 = conf2.getRequirements().size();

			if (prior1 > prior2)
				return -1;
			else if (prior1 < prior2)
				return 1;
			else if (cpu1 < cpu2)
				return -1;
			else if (cpu1 > cpu2)
				return 1;
			else if (mem1 < mem2)
				return -1;
			else if (mem1 > mem2)
				return 1;
			else if (numReq1 < numReq2)
				return -1;
			else if (numReq1 > numReq2)
				return 1;
			return 0;

		} catch (RemoteException e) {
			return 0;
		}
	}

}