package csbase.server.services.diagnosticservice;

import java.text.MessageFormat;
import java.util.Locale;

/**
 * Classe utilitria para ser usada na traduo dos textos utilizados no servio
 * de diagnstico.
 * 
 * 
 * @author Tecgraf
 */
public class MessageTranslator {

  /**
   * Obtm o texto traduzido no idioma da sesso corrente.
   * 
   * @param locale o Locale para traduo dos textos
   * @param key a chave no arquivo de bundle de idioma
   * @return o texto traduzido
   */
  public static String getString(String key, Locale locale) {
    return DiagnosticService.getInstance().getString(key, locale);
  }

  /**
   * Obtm o texto traduzido no idioma da sesso corrente.
   * 
   * @param locale o Locale para traduo dos textos
   * @param key a chave no arquivo de bundle de idioma
   * @param args os argumentos para a formatao do texto
   * @return o texto traduzido
   */
  public static String getString(String key, Object[] args, Locale locale) {
    return MessageFormat.format(
      DiagnosticService.getInstance().getString(key, locale), args);
  }

  /**
   * Obtm o tipo da exceo.
   * 
   * @param t a exceo
   * @param locale o Locale para traduo dos textos
   * @return o tipo da exceo
   */
  public static String getDetailMessage(Throwable t, Locale locale) {
    if (t == null) {
      return null;
    }
    return MessageTranslator.getString("diagnosticservice.detail.message",
      new String[] { t.getClass().getName() }, locale);
  }
}
