package csbase.server.services.opendreamsservice.opendreams.v2_0;

import java.lang.reflect.Field;

import org.omg.CORBA.UserException;

import csbase.server.Server;

/**
 * Classe de mtodos relacionados ao log da aplicao.
 *
 * @author Tecgraf/PUC-Rio
 */
public class LogUtils {

	/**
	 * Cria uma mensagem formatada com o texto de uma mensagem junto com
	 * informaes mais detalhadas sobre a prpria exceo.
	 *
	 * @param e
	 *            a exceo que ocorreu
	 * @param msg
	 *            uma mensagem descritiva do contexto da exceo
	 * @return um texto formatado
	 */
	public static String formatMessage(Throwable e, String msg) {
		StringBuffer message = new StringBuffer(msg);
		message.append(": " + e.getClass().getName() + ": " + e.getMessage());
		message.append("\nCaused by:\n");
		StackTraceElement[] stackTrace = e.getStackTrace();
		for (int i = 0; i < stackTrace.length; i++) {
			message.append(stackTrace[i].toString() + "\n");
		}
		return message.toString();
	}

	/**
	 * Registra no log uma mensagem de warning referente a uma exceo prevista
	 * na API da IDL do OpenDreams.
	 *
	 * @param msg
	 *            a mensagem
	 * @param exception
	 *            a exceo
	 */
	public static void logWarningException(String msg, UserException exception) {
		try {
			Field messageField = exception.getClass().getField("message");
			Server.logWarningMessage(msg + ": " + messageField.get(exception));
		} catch (Exception e) {
			Server.logSevereMessage(msg, e);
		}
	}
}
