package csbase.server.services.opendreamsservice.opendreams.v2_0;

import java.util.Properties;

import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;

/**
 *
 * Cria a configurao para o OpenDreamsService da verso 1.2
 *
 * @author Tecgraf PUC-Rio
 */
public class OpenDreamsServiceOffer implements OpenBusServiceOffer {

	@Override
	public OpenBusServiceFacet[] getFacets() {
		return new OpenBusServiceFacet[]{
				new OpenBusServiceFacet("opendreams_v2_0", tecgraf.openbus.opendreams.v2_0.IOpenDreamsHelper.id(),
						new csbase.server.services.opendreamsservice.opendreams.v2_0.SessionManager()),
				new OpenBusServiceFacet("opendreams_algorithm_v1_1",
						tecgraf.openbus.algorithmservice.v1_1.AlgorithmServiceHelper.id(),
						new csbase.server.services.opendreamsservice.algorithm.v1_1.AlgorithmService()),
				new OpenBusServiceFacet("opendreams_servermonitor_v1_0",
						tecgraf.openbus.servermonitor.v1_0.IServerMonitorHelper.id(),
						new csbase.server.services.opendreamsservice.servermonitor.v1_0.ServerMonitor())};
	}

	@Override
	public Properties getProperties() {
		return null;
	}

	@Override
	public void registerFactories() {
		org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB) OpenBusService.getInstance().getORB();
		orb.register_value_factory(tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplateHelper.id(),
				new tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplateFactory());
		orb.register_value_factory(tecgraf.openbus.algorithmservice.v1_1.SimpleConfiguratorHelper.id(),
				new tecgraf.openbus.algorithmservice.v1_1.SimpleConfiguratorFactory());
		orb.register_value_factory(tecgraf.openbus.algorithmservice.v1_1.FlowConfiguratorHelper.id(),
				new tecgraf.openbus.algorithmservice.v1_1.FlowConfiguratorFactory());
	}
}
