/**
 * $Id: SSLServerInterceptor.java 163065 2015-03-27 18:41:34Z fpina $
 */
package csbase.server.services.sgaservice.ssl;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

import csbase.server.Server;

/**
 * Interceptador de chamadas SSL.
 *
 * @author Tecgraf/PUC-Rio
 */
public class SSLServerInterceptor extends LocalObject implements
  ServerRequestInterceptor {

  /**
   * Identificador.
   */
  private static final long serialVersionUID = -7115220989115590930L;
  /**
   * O inspetor de contexto.
   */
  private SSLContext inspector;

  /**
   * Construtor.
   *
   * @param contextInspector inspetor de contexto.
   */
  public SSLServerInterceptor(SSLContext contextInspector) {
    this.inspector = contextInspector;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void receive_request_service_contexts(ServerRequestInfo ri)
    throws ForwardRequest {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    //Somente a chamada de registerSGA tem o contexto armazenado.
    if (!ri.operation().equals("registerSGA")) {
      return;
    }

    GIOPConnection connection = ((ServerRequestInfoImpl) ri).getConnection();

    if (connection == null) {
      return;
    }
    if (!connection.isSSL()) {
      return;
    }
    if (!(connection.getTransport() instanceof ServerIIOPConnection)) {
      return;
    }

    ServerIIOPConnection transport =
      (ServerIIOPConnection) connection.getTransport();
    SSLSocket sslSocket = (SSLSocket) transport.getSocket();

    javax.security.cert.X509Certificate[] certs;
    try {
      certs = sslSocket.getSession().getPeerCertificateChain();

      String dn = certs[0].getSubjectDN().getName();
      LdapName ln = new LdapName(dn);

      String sgaName = null;
      for (Rdn rdn : ln.getRdns()) {
        if (rdn.getType().equalsIgnoreCase("CN")) {
          sgaName = (String) rdn.getValue();
          break;
        }
      }
      this.inspector.setContextInformation(sgaName);
    }
    catch (SSLPeerUnverifiedException e) {
      Server.logSevereMessage("Erro ao obter o certificado de SGA.");
    }
    catch (InvalidNameException e) {
      Server.logSevereMessage("Erro ao obter o CN do certificado.");
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void send_reply(ServerRequestInfo ri) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void send_other(ServerRequestInfo ri) throws ForwardRequest {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String name() {
    return this.getClass().getSimpleName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void destroy() {
  }
}
