package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.Role;
import csbase.logic.RoleInfo;

/**
 * Interface para acesso a dados de perfil. A criao de objetos que implementam
 * essa interface  responsabilidade da fbrica de DAOs do servio de
 * administrao ({@link AdministrationDAOFactory}}).
 * 
 * @author Jorge Alexandre
 * 
 */
public interface RoleDAO {

  /**
   * Recupera um perfil da fonte de dados pelo seu identificador.
   * 
   * @param id identificador do perfil.
   * @return referncia para o perfil.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  Role readRole(Object id) throws DAOException;

  /**
   * Recupera todos os perfis que existem na fonte de dados.
   * 
   * @return uma referncia para a lista com os perfis.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  List<Role> readAllRoles() throws DAOException;

  /**
   * Persiste o perfil na fonte de dados.
   * 
   * @param info informaes de perfil que sero persistida.
   * @return uma referncia para o perfil persistido contendo o seu
   *         identificador.
   * @throws DAOException se ocorrer algum problema na incluso do perfil na
   *         fonte de dados.
   */
  Role createRole(RoleInfo info) throws DAOException;

  /**
   * Modifica um perfil na fonte de dados.
   * 
   * @param id identificador do perfil.
   * @param info informaes que sero modificadas.
   * @return uma referncia para o perfil modificado.
   * @throws DAOException se ocorrer algum problema na modificao do perfil na
   *         fonte de dados.
   */
  Role modifyRole(Object id, RoleInfo info) throws DAOException;

  /**
   * Exclui um perfil na fonte de dados.
   * 
   * @param id identificador do perfil.
   * @throws DAOException se ocorrer algum problema na excluso do perfil na
   *         fonte de dados.
   */
  void deleteRole(Object id) throws DAOException;
}
