/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diskusageservice;

import csbase.exception.InvalidRequestException;
import csbase.logic.FileSystemSpaceNotification;
import csbase.logic.Notification;
import csbase.logic.User;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.DiskUsageServiceInterface;
import csbase.server.FileSystem;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.diskusageservice.MonitoredDirectory;
import csbase.server.services.eventlogservice.EventLogService;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.notificationservice.NotificationService;
import csbase.server.services.projectservice.ProjectService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class DiskUsageService
extends Service
implements DiskUsageServiceInterface {
    private boolean exitAuditThread = false;
    private Thread auditThread = null;
    private final List<MonitoredDirectory> monitoredList = new ArrayList<MonitoredDirectory>();
    private final int DEFAULT_WARNING_PERC = 75;
    private final int DEFAULT_ALERT_PERC = 90;
    private int warningPerc = 75;
    private int alertPerc = 90;
    private boolean mailOnAlert;

    public static void createService() throws ServerException {
        new DiskUsageService();
    }

    public static DiskUsageService getInstance() {
        return (DiskUsageService)DiskUsageService.getInstance("DiskUsageService");
    }

    private MonitoredDirectory findMonitorFromId(String id) {
        for (MonitoredDirectory monitored : this.monitoredList) {
            if (!monitored.getId().equals(id)) continue;
            return monitored;
        }
        return null;
    }

    private void addToMonitor(String id, String path) throws ServerException {
        MonitoredDirectory md = this.findMonitorFromId(id);
        if (md != null) {
            String err = "Id de diret\u00f3rio duplicado: " + id;
            throw new ServerException(err);
        }
        MonitoredDirectory newMonitor = new MonitoredDirectory(id, path);
        if (!newMonitor.isConsistent()) {
            String prefix = "\u00c1rea inconsistente no start-up: ";
            String err = "\u00c1rea inconsistente no start-up: " + newMonitor;
            throw new ServerException(err);
        }
        if (newMonitor.isAvailable()) {
            String prefix = "\u00c1rea acess\u00edvel no start-up: ";
            Server.logInfoMessage("\u00c1rea acess\u00edvel no start-up: " + newMonitor);
        } else {
            String prefix = "\u00c1rea inacess\u00edvel no start-up: ";
            Server.logSevereMessage("\u00c1rea inacess\u00edvel no start-up: " + newMonitor);
        }
        this.monitoredList.add(newMonitor);
    }

    private void auditData() {
        String eventLogPrefix = "disk";
        for (MonitoredDirectory monitor : this.monitoredList) {
            String id = monitor.getId();
            DiskOccupation occupation = this.getDiskOccupation(id);
            if (occupation == null || !occupation.isValid()) {
                return;
            }
            EventLogService eventService = EventLogService.getInstance();
            String usedFS = "[" + id + "]";
            String[] usedQueue = new String[]{"disk", id + "-file-system"};
            double usedSrvPerc = occupation.getUsedSpacePerc();
            double usedSrvMb = occupation.getUsedSpaceMb();
            double totalSrvMb = occupation.getTotalSpaceMb();
            String[] usedInfo = new String[]{usedFS, this.formatToAudit(usedSrvPerc), this.formatToAudit(usedSrvMb), this.formatToAudit(totalSrvMb)};
            eventService.addServerInformation(usedQueue, usedInfo);
            this.notifyAdminIfNeeded(id, occupation);
        }
    }

    private void createAuditThread() {
        boolean ONE_HOUR = true;
        long auditIntervalHours = this.getAuditIntervalHours();
        if (auditIntervalHours < 1L) {
            auditIntervalHours = 1L;
        }
        Server.logInfoMessage("Intervalo de auditagens: " + auditIntervalHours + " horas.");
        final long sleepTime = auditIntervalHours * 60L * 60L * 1000L;
        this.auditThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!DiskUsageService.this.exitAuditThread) {
                    try {
                        Server.logFineMessage("Thread iniciada: createAuditThread.");
                        DiskUsageService.this.auditData();
                        Server.logFineMessage("Thread terminada: createAuditThread.");
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        Server.logWarningMessage("Grava\u00e7\u00e3o de auditagem interrompida!");
                    }
                }
                Server.logWarningMessage("Finalizando thread de grava\u00e7\u00e3o de auditagem...");
            }
        });
        this.warningPerc = this.getIntProperty("warningPercentage");
        this.alertPerc = this.getIntProperty("alertPercentage");
        this.warningPerc = Math.abs(this.warningPerc);
        this.alertPerc = Math.abs(this.alertPerc);
        int minWarnPerc = 10;
        int minAlertPerc = 20;
        if (this.warningPerc < 10) {
            this.warningPerc = 10;
        }
        if (this.alertPerc < 20) {
            this.alertPerc = 20;
        }
        int maxPerc = 100;
        if (this.warningPerc > 100) {
            this.warningPerc = 100;
        }
        if (this.alertPerc > 100) {
            this.alertPerc = 100;
        }
        if (this.alertPerc <= this.warningPerc) {
            this.alertPerc = this.warningPerc + 1;
        }
        Server.logInfoMessage("Percentual para aviso: " + this.warningPerc + "%");
        Server.logInfoMessage("Percentual para alerta: " + this.alertPerc + "%");
        this.exitAuditThread = false;
        String threadPrefixName = ((Object)((Object)this)).getClass().getSimpleName();
        this.auditThread.setName(threadPrefixName + "::auditThread");
        this.auditThread.start();
    }

    private String formatToAudit(double value) {
        String str = String.format("%.3f", value);
        return str;
    }

    public final DiskOccupation getAlgorithmOccupation() {
        DiskOccupation oc = this.getDiskOccupation("algorithm");
        return oc;
    }

    private DiskOccupation getDiskOccupation(String id) {
        MonitoredDirectory md = this.findMonitorFromId(id);
        if (md == null) {
            Server.logSevereMessage("N\u00e3o localizado id :" + id + ".");
            DiskOccupation dummy = new DiskOccupation();
            return dummy;
        }
        if (!md.isAvailable()) {
            String err = "\u00c1rea monitorada n\u00e3o dispon\u00edvel: " + md;
            Server.logSevereMessage(err);
            DiskOccupation dummy = new DiskOccupation();
            return dummy;
        }
        if (!md.isConsistent()) {
            String err = "\u00c1rea monitorada inconsistente: " + md;
            Server.logSevereMessage(err);
            DiskOccupation dummy = new DiskOccupation();
            return dummy;
        }
        File directory = md.getDirectory();
        DiskOccupation occupation = this.getDiskOccupationFromPath(directory);
        return occupation;
    }

    private DiskOccupation getDiskOccupationFromPath(File directory) {
        if (!directory.exists()) {
            String path = directory.getAbsolutePath();
            String prefixErr = "N\u00e3o foi poss\u00edvel localizar diret\u00f3rio: ";
            String sufixErr = ". Diret\u00f3rio ou arquivo n\u00e3o existe.";
            Server.logWarningMessage("N\u00e3o foi poss\u00edvel localizar diret\u00f3rio: " + path + ". Diret\u00f3rio ou arquivo n\u00e3o existe.");
            return new DiskOccupation();
        }
        String path = directory.getAbsolutePath();
        long total = FileSystem.getTotalSpace(path);
        long free = FileSystem.getFreeSpace(path);
        DiskOccupation diskOccupation = new DiskOccupation(free, total, (long)this.alertPerc, (long)this.warningPerc);
        return diskOccupation;
    }

    private double getDiskUsageFromFileMb(File dir) {
        double diskUsageMb = 0.0;
        File[] files = dir.listFiles();
        if (files == null) {
            return 0.0;
        }
        for (File file : files) {
            double itemUsageMb = file.isDirectory() ? this.getDiskUsageFromFileMb(file) : (double)file.length() / 1024.0 / 1024.0;
            diskUsageMb += itemUsageMb;
        }
        return diskUsageMb;
    }

    private double getDiskUsageFromPathMb(String path) {
        File dir = new File(path);
        double diskUsage = this.getDiskUsageFromFileMb(dir);
        return diskUsage;
    }

    private String getPathFromOwnerAndProjectName(Object ownerId, String projName) {
        if (ownerId == null) {
            throw new InvalidRequestException("ownerId null detected!");
        }
        if (projName == null) {
            throw new InvalidRequestException("project name null detected!");
        }
        String dirName = this.getUserProjectDirectoryPath(ownerId, projName);
        if (dirName == null) {
            String id = ownerId + File.separator + projName;
            Server.logSevereMessage("Usu\u00e1rio/Projeto [" + id + "] n\u00e3o tem diret\u00f3rio!");
            throw new InvalidRequestException("project not detected!" + id);
        }
        return dirName;
    }

    public final DiskOccupation getProjectOccupation() {
        DiskOccupation oc = this.getDiskOccupation("project");
        return oc;
    }

    public final DiskOccupation getServerOccupation() {
        DiskOccupation oc = this.getDiskOccupation("server");
        return oc;
    }

    public final List<String> getAllAreasIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (MonitoredDirectory m : this.monitoredList) {
            String id = m.getId();
            list.add(id);
        }
        Collections.unmodifiableList(list);
        return list;
    }

    public final DiskOccupation getAreaOccupation(String id) {
        MonitoredDirectory monitored = this.findMonitorFromId(id);
        if (monitored == null) {
            return null;
        }
        DiskOccupation oc = this.getDiskOccupation(id);
        return oc;
    }

    public DiskOccupation getSingleProjectOccupation(Object ownerId, String projName) {
        String dirName = this.getPathFromOwnerAndProjectName(ownerId, projName);
        File directory = new File(dirName);
        DiskOccupation occupation = this.getDiskOccupationFromPath(directory);
        return occupation;
    }

    public final double getUsedSpaceForProjectMb(Object ownerId, String projName) {
        String dirName = this.getPathFromOwnerAndProjectName(ownerId, projName);
        return this.getDiskUsageFromPathMb(dirName);
    }

    public final double getUsedSpaceForUserMb(Object userId) {
        if (userId == null) {
            String err = "null user detected!";
            throw new InvalidRequestException("null user detected!");
        }
        String dirName = this.getUserDirectoryPath(userId);
        if (dirName == null) {
            String msg = "Usu\u00e1rio " + userId + "n\u00e3o tem diret\u00f3rio!";
            Server.logSevereMessage(msg);
            String err = "User area not detected! " + userId;
            throw new InvalidRequestException(err);
        }
        double usedMegaBytes = this.getDiskUsageFromPathMb(dirName);
        return usedMegaBytes;
    }

    private User getUser(Object userId) {
        try {
            User user = User.getUser((Object)userId);
            if (user == null) {
                String msg = "Detectado usu\u00e1rio nulo para: " + userId;
                Server.logSevereMessage(msg);
            }
            return user;
        }
        catch (Exception ue) {
            String msg = "Falha na detec\u00e7\u00e3o de usu\u00e1rio!";
            Server.logSevereMessage("Falha na detec\u00e7\u00e3o de usu\u00e1rio!");
            return null;
        }
    }

    private String getUserDirectoryPath(Object userId) {
        User user = this.getUser(userId);
        if (user == null) {
            return null;
        }
        ProjectService projectService = ProjectService.getInstance();
        String repositoryPath = projectService.getProjectRepositoryPath();
        String path = repositoryPath + File.separator + user.getId();
        return path;
    }

    private String getUserProjectDirectoryPath(Object ownerId, String projName) {
        String uPath = this.getUserDirectoryPath(ownerId);
        String sep = File.separator;
        return uPath + sep + projName;
    }

    public final Hashtable<Object, Double> getUsersList() {
        return this.mountUserHash();
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public void initService() throws ServerException {
        boolean auditData;
        String serverPath = ".";
        this.addToMonitor("server", ".");
        ProjectService prjService = ProjectService.getInstance();
        String projectPath = prjService.getProjectRepositoryPath();
        this.addToMonitor("project", projectPath);
        AlgorithmService algService = AlgorithmService.getInstance();
        String algorithPath = algService.getAlgorithmRepositoryPath();
        this.addToMonitor("algorithm", algorithPath);
        String idPropName = "monitor.id";
        List<String> ids = this.getStringListProperty("monitor.id");
        String pathPropName = "monitor.path";
        List<String> paths = this.getStringListProperty("monitor.path");
        if (ids.size() != paths.size()) {
            String prefix = "Tamanhos distintos nas propriedades: ";
            String err = "Tamanhos distintos nas propriedades: [monitor.id]/[monitor.path]";
            throw new ServerException("Tamanhos distintos nas propriedades: [monitor.id]/[monitor.path]");
        }
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            String id = ids.get(i);
            String path = paths.get(i);
            this.addToMonitor(id, path);
        }
        this.mailOnAlert = this.isMailOnAlertEnabled();
        if (this.mailOnAlert) {
            Server.logInfoMessage("Envio de email habilitado (para casos de alerta)");
        }
        if (auditData = this.isAuditEnabled()) {
            this.createAuditThread();
            Server.logInfoMessage("Auditagem de ocupa\u00e7\u00e3o de disco habilitada.");
        } else {
            this.auditThread = null;
            Server.logInfoMessage("Auditagem de ocupa\u00e7\u00e3o de disco desabilitada.");
        }
    }

    private Hashtable<Object, Double> mountUserHash() {
        Hashtable<Object, Double> hash = new Hashtable<Object, Double>();
        try {
            List allUsers = User.getAllUsers();
            for (User user : allUsers) {
                double mega;
                try {
                    mega = this.getUsedSpaceForUserMb(user.getId());
                }
                catch (Exception e) {
                    mega = 0.0;
                }
                hash.put(user.getId(), mega);
            }
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void notifyAdminIfNeeded(String id, DiskOccupation occupation) {
        NotificationService ntSrv = NotificationService.getInstance();
        double percentage = occupation.getUsedSpacePerc();
        String senderName = this.getSenderName();
        ArrayList adminIds = new ArrayList();
        try {
            adminIds.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        Object[] ids = adminIds.toArray(new Object[0]);
        if (percentage >= (double)this.alertPerc) {
            FileSystemSpaceNotification data = new FileSystemSpaceNotification(senderName, id, percentage, this.alertPerc, false);
            ntSrv.notifyTo(ids, (Notification)data);
            if (this.mailOnAlert) {
                MailService mailSrv = MailService.getInstance();
                mailSrv.mailUserFromService(this, ids, data.toString());
            }
        } else if (percentage >= (double)this.warningPerc) {
            FileSystemSpaceNotification data = new FileSystemSpaceNotification(senderName, id, percentage, this.warningPerc, true);
            ntSrv.notifyTo(ids, (Notification)data);
        }
    }

    @Override
    public void shutdownService() {
        this.exitAuditThread = true;
        if (this.auditThread != null) {
            this.auditThread.interrupt();
        }
        this.auditThread = null;
    }

    protected DiskUsageService() throws ServerException {
        super("DiskUsageService");
    }

    public int getWarningPerc() {
        return this.warningPerc;
    }

    public int getAlertPerc() {
        return this.alertPerc;
    }

    public boolean isAuditEnabled() {
        return this.getBooleanProperty("enableAudit");
    }

    public boolean isMailOnAlertEnabled() {
        return this.getBooleanProperty("mailOnAlert");
    }

    public int getAuditIntervalHours() {
        return this.getIntProperty("auditIntervalHours");
    }
}

