package csbase.server.services.restservice;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Filter request para CORs
 *
 * @author Tecgraf/PUC-Rio
 */
public final class CorsServletFilter implements Filter {
  /**
   * {@inheritDoc}
   */
  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void doFilter(ServletRequest servletRequest,
    ServletResponse servletResponse, FilterChain filterChain)
      throws IOException, ServletException {

    HttpServletResponse response = (HttpServletResponse) servletResponse;

    HttpServletRequest request = (HttpServletRequest) servletRequest;

    response.setHeader("Access-Control-Allow-Origin", request.getHeader(
      "Origin"));
    response.setHeader("Access-Control-Allow-Credentials", "true");
    response.setHeader("Access-Control-Allow-Methods",
      "POST, GET, PUT, HEAD, OPTIONS, DELETE");
    response.setHeader("Access-Control-Allow-Headers",
      "Authorization, Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");

    if (request.getMethod().equals("OPTIONS")) {
      response.setStatus(HttpServletResponse.SC_OK);
      return;
    }
    try {
      filterChain.doFilter(servletRequest, servletResponse);
    }catch (Throwable e) {
      response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
      return;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void destroy() {
  }
}