package csbase.server.services.schedulerservice;

import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;

/**
 * Interface das classes que implementam as polticas de escalonamento que podem 
 * ser empregadas pelo SchedulerService.
 * 
 * @author valeria
 *
 */
public interface SchedulerPolicyInterface {
  /**
   * Escolhe, dentre os servidores SGAs dados, um para processar o comando.
   * 
   * @param command Comando para execuo
   * @param serversNames Lista de todos os servidores disponveis
   * @return O servidor escolhido para execuo do comando.
   */
  public Map<CommandInfo,SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> sgaSets);
}
