/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.exception.ServiceFailureException;
import csbase.server.ServerException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class ServerSideProperties {
    private static final String NO_PROP_FILE = "_empty_";
    private final Properties properties = new Properties();
    private final String fileName;
    private boolean isLoaded = false;
    private static final List<String> NOT_USED = Arrays.asList("NULL");

    public static final boolean isPropertyValueNull(String value) {
        return NOT_USED.contains(value.trim());
    }

    protected final Properties getExternalPropertyFile(String key) {
        String fileName = this.getInternalProperty(key);
        if (ServerSideProperties.isPropertyValueNull(fileName)) {
            return new Properties();
        }
        try {
            return PropertiesUtils.loadProperties((String)fileName);
        }
        catch (Exception e) {
            throw new ServiceFailureException("erro na carga das propriedaedes de " + fileName, (Throwable)e);
        }
    }

    protected final boolean getBooleanProperty(String key) {
        try {
            return PropertiesUtils.getBoolenValue((Properties)this.properties, (String)key, (boolean)true);
        }
        catch (PropertyException e) {
            throw new ServiceFailureException(this.fileName + ": " + e.getMessage());
        }
    }

    protected final double getDoubleProperty(String key) {
        try {
            return PropertiesUtils.getDoubleValue((Properties)this.properties, (String)key);
        }
        catch (PropertyException e) {
            throw new ServiceFailureException(this.fileName + ": " + e.getMessage());
        }
    }

    private String getInternalProperty(String key) {
        try {
            return PropertiesUtils.getValue((Properties)this.properties, (String)key);
        }
        catch (PropertyException e) {
            throw new ServiceFailureException(this.fileName + ": " + e.getMessage());
        }
    }

    protected final int getIntProperty(String key) {
        try {
            return PropertiesUtils.getIntValue((Properties)this.properties, (String)key);
        }
        catch (PropertyException e) {
            throw new ServiceFailureException(this.fileName + ": " + e.getMessage());
        }
    }

    protected final long getLongProperty(String key) {
        try {
            return PropertiesUtils.getLongValue((Properties)this.properties, (String)key);
        }
        catch (PropertyException e) {
            throw new ServiceFailureException(this.fileName + ": " + e.getMessage());
        }
    }

    protected final List<String> getStringListProperty(String keyPrefix) {
        return PropertiesUtils.getValuesList((Properties)this.properties, (String)keyPrefix);
    }

    protected final String getStringProperty(String key) {
        return this.getInternalProperty(key);
    }

    protected final boolean hasProperty(String key) {
        String property = this.properties.getProperty(key);
        return property != null;
    }

    protected final boolean isPropertyNull(String key) {
        String value = this.getInternalProperty(key);
        return ServerSideProperties.isPropertyValueNull(value);
    }

    public void load() throws ServerException {
        if (NO_PROP_FILE.equals(this.fileName)) {
            throw new IllegalStateException("N\u00e3o h\u00e1 arquivo associado");
        }
        if (this.isLoaded) {
            throw new ServerException("Dupla carga de arquivo de propriedade:" + this.fileName);
        }
        try {
            PropertiesUtils.loadProperties((Properties)this.properties, (String)this.fileName);
            this.isLoaded = true;
        }
        catch (Exception e) {
            throw new ServerException("Erro na carga de propriedades de " + this.fileName, e);
        }
    }

    void overrideProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public ServerSideProperties(String name) {
        this.fileName = name;
    }

    ServerSideProperties() {
        this.fileName = NO_PROP_FILE;
    }

    SortedSet<Object> getPropertiesKeys() {
        TreeSet<Object> keys = new TreeSet<Object>(this.properties.keySet());
        return keys;
    }

    Map<String, String> getPropertiesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<Map.Entry<Object, Object>> entrySet = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            result.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return result;
    }
}

