/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.eventlogservice;

import csbase.logic.User;
import csbase.logic.eventlogservice.LogsInfo;
import csbase.remote.EventLogServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.eventlogservice.EventLogParser;
import csbase.server.services.loginservice.LoginService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class EventLogService
extends Service
implements EventLogServiceInterface {
    private String eventDirName = null;
    private static final String NO_NAME = "no_name";
    private static final String FILE_SUFIX = "log";

    private String createId(Date date) {
        String format = "{0,date,yyyy-MM-dd}";
        MessageFormat formatter = new MessageFormat("{0,date,yyyy-MM-dd}");
        Object[] args = new Object[]{date};
        StringBuffer text = new StringBuffer();
        formatter.format(args, text, (FieldPosition)null);
        return text.toString();
    }

    private final String getQueueFileName(String[] queue) {
        String id = this.createId(new Date());
        return this.getQueueFileName(queue, id);
    }

    private final String getQueueFileName(String[] queue, String id) {
        String fName;
        int i;
        String sep = "/";
        String pt = ".";
        if (queue == null || queue.length < 1) {
            return this.eventDirName + "/" + NO_NAME + "." + id + "." + FILE_SUFIX;
        }
        int n = queue.length;
        if (n == 1) {
            String fName2 = queue[0] == null ? NO_NAME : queue[0];
            return fName2 + "." + id + "." + FILE_SUFIX;
        }
        int min = 4;
        if (n < 5) {
            min = n - 1;
        }
        StringBuffer baseDirName = new StringBuffer(this.eventDirName);
        for (i = 0; i < min; ++i) {
            String dName = queue[i] == null ? NO_NAME : queue[i];
            baseDirName.append("/" + dName);
            Server server = Server.getInstance();
            try {
                Server.checkDirectory(baseDirName.toString());
                continue;
            }
            catch (ServerException e) {
                return null;
            }
        }
        if (n < 5) {
            fName = queue[i] == null ? NO_NAME : queue[i];
            return baseDirName + "/" + fName + "." + id + "." + FILE_SUFIX;
        }
        fName = baseDirName + "/";
        String xName = queue[4] == null ? NO_NAME : queue[4];
        fName = fName + xName;
        for (i = 5; i < n; ++i) {
            String qName = queue[i] == null ? NO_NAME : queue[i];
            fName = fName + "." + qName;
        }
        return fName + "." + id + "." + FILE_SUFIX;
    }

    private String getQueueName(String[] q) {
        String bar = "|";
        if (q == null || q.length <= 0) {
            return NO_NAME;
        }
        String qName = q[0];
        int n = q.length;
        for (int i = 1; i < n; ++i) {
            qName = qName + "|" + q[i];
        }
        return "[" + qName + "]";
    }

    public final boolean has2Update(Object o1, Object o2) {
        return true;
    }

    public static EventLogService getInstance() {
        return (EventLogService)EventLogService.getInstance("EventLogService");
    }

    public boolean addClientInformation(String[] queue, String[] info) {
        String[] reQueue = null;
        if (queue == null || queue.length <= 0) {
            return false;
        }
        int N = queue.length;
        reQueue = new String[N + 1];
        reQueue[0] = "client";
        for (int i = 0; i < N; ++i) {
            reQueue[i + 1] = queue[i];
        }
        boolean added = this.addInformation(reQueue, info);
        return added;
    }

    public boolean addServerInformation(String[] queue, String[] info) {
        String[] reQueue = null;
        if (queue == null || queue.length <= 0) {
            return false;
        }
        int N = queue.length;
        reQueue = new String[N + 1];
        reQueue[0] = "server";
        for (int i = 0; i < N; ++i) {
            reQueue[i + 1] = queue[i];
        }
        boolean added = this.addInformation(reQueue, info);
        return added;
    }

    private boolean addInformation(String[] queue, String[] info) {
        boolean created;
        String queueName = this.getQueueName(queue);
        User user = Service.getUser();
        String userName = user == null ? " - " : user.getId().toString() + LoginService.getInstance().getRealUserForLog(Service.getKey());
        String fileName = this.getQueueFileName(queue);
        if (fileName == null) {
            String err = "<<" + queueName + ">>: Falha de verifica\u00e7\u00e3o!";
            Server.logSevereMessage(err);
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() && !(created = this.createAndWriteHeaderForNewFile(queueName, fileName, file))) {
            return false;
        }
        if (file.isDirectory()) {
            String err = "<<" + queueName + ">>: Escrita em diret\u00f3rio!";
            Server.logSevereMessage(err);
            return false;
        }
        if (!file.canWrite()) {
            String err = "<<" + queueName + ">>: Sem permiss\u00e3o de escrita";
            Server.logSevereMessage(err);
            return false;
        }
        boolean written = this.writeInfoToFile(info, userName, file);
        return written;
    }

    private boolean writeInfoToFile(String[] info, String userName, File file) {
        Server server = Server.getInstance();
        Charset charset = server.getSystemDefaultCharset();
        try (FileOutputStream stream = new FileOutputStream(file, true);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            Date dt = new Date();
            long tm = dt.getTime();
            writer.write(tm + " ; " + dt + " ; " + userName);
            String[] data = info;
            if (info == null || info.length == 0) {
                data = new String[]{"*"};
            }
            for (int i = 0; i < data.length; ++i) {
                writer.write(" ; " + data[i]);
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException ioe) {
            String path = file.getAbsolutePath();
            String err = "Falha na grava\u00e7\u00e3o de evento em " + path;
            Server.logSevereMessage(err, ioe);
            return false;
        }
        return true;
    }

    private boolean createAndWriteHeaderForNewFile(String queueName, String fileName, File file) {
        String path = file.getAbsolutePath();
        Server.logInfoMessage("Pedido de cria\u00e7\u00e3o de: " + path);
        try {
            file.createNewFile();
            Server.logInfoMessage("Arquivo criado: " + path);
        }
        catch (IOException ioe) {
            Server.logSevereMessage("Falha na cria\u00e7\u00e3o: " + path + " - ", ioe);
            return false;
        }
        String dt = new Date().toString();
        Server server = Server.getInstance();
        Charset charset = server.getSystemDefaultCharset();
        try (FileOutputStream stream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write("# Arquivo de auditagem de eventos CSBASE.\n");
            writer.write("# Arquivo: [" + queueName + "]\n");
            writer.write("# Abertura em: " + dt + "\n");
            writer.write("# \n");
            Server.logInfoMessage("Header gravado em: " + path);
        }
        catch (IOException ioe) {
            String err = "Falha na grava\u00e7\u00e3o de header: " + path;
            Server.logSevereMessage(err, ioe);
            return false;
        }
        return true;
    }

    public LogsInfo find(String[][] queues, Date initialDate, Date finalDate) {
        Server server = Server.getInstance();
        Charset charset = server.getSystemDefaultCharset();
        EventLogParser logParser = new EventLogParser(initialDate, finalDate);
        List<String> ids = this.createIdList(initialDate, finalDate);
        for (int i = 0; i < queues.length; ++i) {
            String[] fileQueue = queues[i];
            for (String fileId : ids) {
                String fileName = this.getQueueFileName(fileQueue, fileId);
                File file = new File(fileName);
                if (!file.exists()) continue;
                try {
                    FileInputStream fileStream = new FileInputStream(fileName);
                    logParser.parse(fileStream, charset);
                    fileStream.close();
                }
                catch (Exception e) {
                    String queueName = this.getQueueName(fileQueue);
                    String err = "<<" + queueName + ">>: Ignorando arquivo de log " + fileName + ".";
                    Server.logInfoMessage(err);
                }
            }
        }
        return logParser.getInfo();
    }

    private List<String> createIdList(Date initialDate, Date finalDate) {
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(initialDate);
        while (!calendar.getTime().after(finalDate)) {
            String id = this.createId(calendar.getTime());
            list.add(id);
            calendar.add(5, 1);
        }
        return list;
    }

    @Override
    public final void initService() throws ServerException {
        this.eventDirName = this.getStringProperty("directory");
        Server.getInstance();
        Server.checkDirectory(this.eventDirName);
    }

    @Override
    public final void shutdownService() {
    }

    public static void createService() throws ServerException {
        new EventLogService();
    }

    protected EventLogService() throws ServerException {
        super("EventLogService");
    }
}

