/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v2_0;

import csbase.exception.OperationFailureException;
import csbase.logic.CommandNotification;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v2_0.InvalidJobTemplateException;
import csbase.server.services.opendreamsservice.opendreams.v2_0.LogUtils;
import csbase.server.services.opendreamsservice.opendreams.v2_0.OpenDreamsJob;
import csbase.server.services.opendreamsservice.opendreams.v2_0.OpenDreamsJobArray;
import csbase.server.services.opendreamsservice.opendreams.v2_0.PersistentMap;
import csbase.server.services.opendreamsservice.opendreams.v2_0.PersistentObject;
import csbase.server.services.opendreamsservice.opendreams.v2_0.SessionManager;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;
import tecgraf.openbus.DRMAA.v2_0.InternalException;
import tecgraf.openbus.DRMAA.v2_0.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v2_0.Job;
import tecgraf.openbus.DRMAA.v2_0.JobArray;
import tecgraf.openbus.DRMAA.v2_0.JobInfo;
import tecgraf.openbus.DRMAA.v2_0.JobSession;
import tecgraf.openbus.DRMAA.v2_0.JobSessionHelper;
import tecgraf.openbus.DRMAA.v2_0.JobSessionOperations;
import tecgraf.openbus.DRMAA.v2_0.JobSessionPOATie;
import tecgraf.openbus.DRMAA.v2_0.JobState;
import tecgraf.openbus.DRMAA.v2_0.JobTemplate;
import tecgraf.openbus.DRMAA.v2_0.TimeoutException;
import tecgraf.openbus.DRMAA.v2_0.UnsupportedOperationException;
import tecgraf.openbus.opendreams.v2_0.FinalizationType;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplate;

public class OpenDreamsJobSession
implements JobSessionOperations,
Serializable {
    public static long TIMEOUT_WAIT_FOREVER = -1L;
    public static long TIMEOUT_NO_WAIT = 0L;
    private static final String JOBS_DIR = "jobs";
    private static final String JOB_ARRAYS_DIR = "job_arrays";
    private String sessionName;
    private String contact;
    private String userId;
    private PersistentMap<String, OpenDreamsJob> jobs;
    private PersistentMap<String, OpenDreamsJobArray> jobArrays;
    private transient JobSession ref;
    private transient Serializable listenerId;
    private transient boolean opened = false;

    public OpenDreamsJobSession(String sessionName, String contact, String userId) {
        this.sessionName = sessionName;
        this.contact = contact;
        this.userId = userId;
        this.jobs = new PersistentMap(PersistentObject.generatePath(JOBS_DIR, sessionName));
        this.jobArrays = new PersistentMap(PersistentObject.generatePath(JOB_ARRAYS_DIR, sessionName));
        this.listenerId = this.setSessionOnJobTerminateListener();
        this.opened = true;
    }

    public void onResume() {
        if (!this.opened) {
            System.out.println("Session " + this.sessionName + " being resumed");
            if (this.listenerId != null) {
                MessageService.getInstance().clearServerMessageListener(this.listenerId);
            }
            this.listenerId = this.setSessionOnJobTerminateListener();
            this.opened = true;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.jobs = new PersistentMap(PersistentObject.generatePath(JOBS_DIR, this.sessionName));
        this.jobArrays = new PersistentMap(PersistentObject.generatePath(JOB_ARRAYS_DIR, this.sessionName));
    }

    public String contact() {
        return this.contact;
    }

    public String sessionName() {
        return this.sessionName;
    }

    public String[] jobCategories() {
        return null;
    }

    public Job[] getJobs(JobInfo filter) {
        OpenDreamsJobInfo filterJobInfo = (OpenDreamsJobInfo)filter;
        ArrayList<Job> filtered = new ArrayList<Job>();
        for (OpenDreamsJob job : this.jobs.values()) {
            String msg;
            try {
                JobInfo jobInfo = job.getInfo();
                List<Field> fields = new ArrayList<Field>();
                if (!this.match(filter, jobInfo, fields = OpenDreamsJobSession.getAllFields(fields, filter.getClass())) && !filterJobInfo.description.equals("UNSET")) continue;
                filtered.add(job.corbaObjectReference());
            }
            catch (OperationFailureException | ServantNotActive | WrongPolicy e) {
                msg = "Erro ao criar refer\u00eancias do Job " + job.jobId();
                Server.logSevereMessage(msg, e);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                msg = "Erro ao filtrar jobs a partir das informa\u00e7\u00f5es " + filter.toString();
                Server.logSevereMessage(msg, e);
                e.printStackTrace();
            }
        }
        return filtered.toArray(new Job[0]);
    }

    private boolean match(JobInfo filter, JobInfo info, List<Field> fields) throws IllegalAccessException {
        for (Field field : fields) {
            String[][] stringMatrixValue;
            String[] stringVectorValue;
            String stringValue;
            Long longValue;
            Integer integerValue;
            if (field.getName().equals("serialVersionUID") || field.getName().equals("_truncatable_ids") || field.getName().equals("allocatedMachines")) continue;
            field.setAccessible(true);
            if (!(field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class) ? !(integerValue = (Integer)field.get(filter)).equals(SessionManager.UNSET_INTEGER) && !integerValue.equals(0) && !integerValue.equals(field.get(info)) : (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class) ? !(longValue = (Long)field.get(filter)).equals(SessionManager.UNSET_LONG) && !longValue.equals(0L) && !longValue.equals(field.get(info)) : (field.getType().equals(String.class) ? !(stringValue = (String)field.get(filter)).equals("indefinido") && !stringValue.isEmpty() && !stringValue.equals(field.get(info)) : (field.getType().equals(String[].class) ? (stringVectorValue = (String[])field.get(filter)).length > 0 && !stringVectorValue.equals(field.get(info)) : (field.getType().equals(String[][].class) ? (stringMatrixValue = (String[][])field.get(filter)).length > 0 && !stringMatrixValue.equals(field.get(info)) : (field.getType().equals(JobState.class) ? !field.get(filter).equals(JobState.UNDETERMINED) && !field.get(filter).equals(field.get(info)) : (field.getType().equals(FinalizationType.class) ? !field.get(filter).equals(FinalizationType.UNDEFINED) && !field.get(filter).equals(field.get(info)) : !field.get(filter).equals(field.get(info)))))))))) continue;
            return false;
        }
        return true;
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = OpenDreamsJobSession.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public JobArray getJobArray(String jobArrayId) throws InvalidArgumentException, InternalException {
        try {
            if (this.jobArrays.containsKey(jobArrayId)) {
                return this.jobArrays.get(jobArrayId).corbaObjectReference();
            }
            throw new InvalidArgumentException("O job array especificado " + jobArrayId + " n\u00e3o foi encontrado.");
        }
        catch (Throwable e) {
            String msg = "Erro na recupera\u00e7\u00e3o do job array " + jobArrayId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(LogUtils.formatMessage(e, msg));
        }
    }

    public Job runJob(JobTemplate jobTemplate) throws DeniedByDrmsException, InvalidArgumentException, InternalException {
        Server.logFineMessage("OpenDreamsJobSession: runJob");
        try {
            this.userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(this.userId);
            if (jobTemplate instanceof OpenDreamsJobTemplate) {
                OpenDreamsJobTemplate jt = (OpenDreamsJobTemplate)jobTemplate;
                OpenDreamsJob job = new OpenDreamsJob(this.sessionName, jt);
                job.execute(this.userId);
                this.jobs.put(job.jobId(), job);
                Job job2 = job.corbaObjectReference();
                return job2;
            }
            try {
                throw new InvalidJobTemplateException("N\u00e3o foi poss\u00edvel executar o JobTemplate recebido");
            }
            catch (DeniedByDrmsException e) {
                e.printStackTrace();
                String msg = "Erro de autentica\u00e7\u00e3o no CSBASE do usu\u00e1rio " + this.userId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (InvalidJobTemplateException e) {
                String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + this.userId + ": " + e.getMessage();
                Server.logWarningMessage(msg);
                throw new InvalidArgumentException(LogUtils.formatMessage(e, msg));
            }
            catch (Throwable e) {
                String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + this.userId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    public JobSession corbaObjectReference() throws OperationFailureException, ServantNotActive, WrongPolicy {
        POA poa = OpenBusService.getInstance().getRootPOA();
        if (this.ref == null) {
            JobSessionPOATie tie = new JobSessionPOATie((JobSessionOperations)this, poa);
            Object obj = poa.servant_to_reference((Servant)tie);
            this.ref = JobSessionHelper.narrow((Object)obj);
        }
        return this.ref;
    }

    public JobArray runBulkJobs(JobTemplate jobTemplate, int beginIndex, int endIndex, int step, int maxParallel) throws DeniedByDrmsException, InvalidArgumentException, InternalException {
        Server.logFineMessage("OpenDreamsSession: runBulkJobs (" + beginIndex + ", " + endIndex + ", " + step + ")");
        String userId = "indefinido";
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(userId);
            if (jobTemplate instanceof OpenDreamsJobTemplate) {
                OpenDreamsJobTemplate jt = (OpenDreamsJobTemplate)jobTemplate;
                OpenDreamsJobArray jobArray = new OpenDreamsJobArray(this.sessionName, userId, jt);
                jobArray.execute(userId, beginIndex, endIndex, step);
                this.jobArrays.put(jobArray.jobArrayId(), jobArray);
                this.jobs.putAll(jobArray.jobsMap());
                JobArray jobArray2 = jobArray.corbaObjectReference();
                return jobArray2;
            }
            try {
                throw new InvalidJobTemplateException("N\u00e3o foi poss\u00edvel executar o JobTemplate recebido");
            }
            catch (DeniedByDrmsException e) {
                String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio  " + userId + ": " + e.message;
                Server.logWarningMessage(msg);
                throw e;
            }
            catch (InvalidJobTemplateException e) {
                String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.getMessage();
                Server.logWarningMessage(msg);
                throw new InvalidArgumentException(LogUtils.formatMessage(e, msg));
            }
            catch (InvalidArgumentException e) {
                String msg = "Falha na submiss\u00e3o do comando pelo usu\u00e1rio " + userId + ": " + e.message;
                Server.logWarningMessage(msg);
                throw e;
            }
            catch (Throwable e) {
                String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    public Job waitAnyStarted(Job[] jobs, long timeout) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }

    public Job waitAnyTerminated(Job[] jobs, long timeout) throws TimeoutException, DeniedByDrmsException, InternalException {
        Server.logFineMessage("OpenDreamsJobSession: waitAnyTerminated");
        try {
            String msg;
            this.userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(this.userId);
            SynchronousQueue<OpenDreamsJob> anyTerminatedJob = new SynchronousQueue<OpenDreamsJob>();
            Serializable listenerId = this.setOnJobTerminateListener(jobs, anyTerminatedJob);
            OpenDreamsJob terminated = anyTerminatedJob.poll(timeout, TimeUnit.SECONDS);
            MessageService.getInstance().clearServerMessageListener(listenerId);
            if (terminated != null) {
                Job job = terminated.corbaObjectReference();
                return job;
            }
            try {
                throw new TimeoutException("Nenhum job terminou dentro do timeout especificado.");
            }
            catch (DeniedByDrmsException e) {
                e.printStackTrace();
                msg = "Erro de autentica\u00e7\u00e3o no CSBASE do usu\u00e1rio " + this.userId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                msg = "Timeout excedido na espera por finaliza\u00e7\u00e3o de jobs " + this.userId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                msg = "Erro na espera por finaliza\u00e7\u00e3o de jobs " + this.userId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
            catch (Throwable e) {
                msg = "Erro na espera por finaliza\u00e7\u00e3o de jobs " + this.userId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    private Serializable setOnJobTerminateListener(Job[] jobsToListen, final SynchronousQueue<OpenDreamsJob> anyTerminatedJob) {
        final ArrayList<String> jobIdsToListen = new ArrayList<String>();
        for (Job job : jobsToListen) {
            jobIdsToListen.add(job.jobId());
        }
        return MessageService.getInstance().setServerMessageListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    if (!jobIdsToListen.contains(cmdId)) continue;
                    boolean bl = anyTerminatedJob.offer(OpenDreamsJobSession.this.jobs.get(cmdId));
                }
            }
        }, new BodyTypeFilter(CommandNotification.class));
    }

    private Serializable setSessionOnJobTerminateListener() {
        return MessageService.getInstance().setServerMessageListener(new IMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    System.out.println(OpenDreamsJobSession.this.sessionName + " onSessionJobTerminateListener: onMessageReceived " + cmdId);
                    try {
                        Service.setUserId(OpenDreamsJobSession.this.userId);
                        if (OpenDreamsJobSession.this.jobs.containsKey(cmdId)) {
                            System.out.println("Finishing job " + cmdId + " of user " + OpenDreamsJobSession.this.userId + " of session " + OpenDreamsJobSession.this.sessionName);
                            ((OpenDreamsJob)OpenDreamsJobSession.this.jobs.get(cmdId)).onFinish(OpenDreamsJobSession.this.userId, notification);
                            continue;
                        }
                        System.out.println("Job " + cmdId + " of user " + OpenDreamsJobSession.this.userId + " don't belong to session " + OpenDreamsJobSession.this.sessionName);
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Erro ao finalizar o comando " + cmdId, e);
                    }
                    finally {
                        Service.setUserId(null);
                    }
                }
            }
        }, new BodyTypeFilter(CommandNotification.class));
    }
}

