/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.CommandInfoCache;
import csbase.logic.Priority;
import csbase.server.Server;
import csbase.server.services.schedulerservice.PriorityQueueVO;
import csbase.server.services.schedulerservice.SchedulerService;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PriorityQueue {
    private List<List<CommandInfo>> queues;
    private Map<Object, CommandInfo> commandIndex;
    private Map<Object, List<CommandInfo>> queueIndex;
    private boolean blocked;
    private String backupFilePath;
    private SchedulerService service;

    protected PriorityQueue(String backupFilePath) {
        this.initQueue();
        this.backupFilePath = backupFilePath;
        this.service = SchedulerService.getInstance();
    }

    public synchronized void add(CommandInfo cmd) {
        List<CommandInfo> queue = this.getQueue(cmd.getPriority());
        queue.add(cmd);
        this.commandIndex.put(cmd.getId(), cmd);
        this.queueIndex.put(cmd.getId(), queue);
        this.saveToBackup();
        this.notify();
    }

    public synchronized boolean setPriority(Object commandId, Priority priority) {
        CommandInfo cmd = this.getCommand(commandId);
        if (cmd == null) {
            return false;
        }
        if (cmd.getPriority() != priority) {
            cmd.setPriority(priority);
            List<CommandInfo> fromQueue = this.getQueue(cmd);
            List<CommandInfo> toQueue = this.getQueue(priority);
            if (fromQueue != toQueue) {
                fromQueue.remove(cmd);
                toQueue.add(cmd);
                this.queueIndex.put(commandId, toQueue);
            }
            this.saveToBackup();
        }
        return true;
    }

    public synchronized boolean setPosition(Object commandId, int position) {
        CommandInfo cmd = this.getCommand(commandId);
        if (cmd == null) {
            return false;
        }
        int atual = this.indexOf(cmd);
        if (atual == position) {
            return true;
        }
        List<CommandInfo> fromQueue = this.getQueue(cmd);
        List<CommandInfo> toQueue = this.getQueue(position);
        int fromPos = this.normalizePosition(atual);
        int toPos = this.normalizePosition(position);
        if (position > atual) {
            ++toPos;
        }
        toQueue.add(toPos, cmd);
        if (fromQueue == toQueue && toPos < fromPos) {
            ++fromPos;
        }
        fromQueue.remove(fromPos);
        this.queueIndex.put(commandId, toQueue);
        this.saveToBackup();
        return true;
    }

    public synchronized int size() {
        return this.commandIndex.size();
    }

    public synchronized List<CommandInfo> getAndWaitForCommands() {
        if (this.blocked || this.size() <= 0) {
            try {
                do {
                    this.wait();
                } while (this.blocked);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getCommands();
    }

    public synchronized List<CommandInfo> getCommands() {
        return this.queues.stream().flatMap(q -> q.stream()).collect(Collectors.toList());
    }

    public synchronized void setBlocked(boolean blocked) {
        this.blocked = blocked;
        this.saveToBackup();
        if (!blocked) {
            this.notify();
        }
    }

    public synchronized CommandInfo remove(Object commandId) {
        CommandInfo cmd = this.getCommand(commandId);
        if (cmd == null) {
            return null;
        }
        List<CommandInfo> queue = this.getQueue(cmd);
        queue.remove(cmd);
        this.commandIndex.remove(cmd.getId());
        this.queueIndex.remove(cmd.getId());
        this.saveToBackup();
        return cmd;
    }

    protected synchronized void sleep(long queueProcessingInterval) {
        try {
            this.wait(queueProcessingInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void saveToBackup() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.backupFilePath));
            PriorityQueueVO queueVO = new PriorityQueueVO();
            queueVO.commandIndex = this.commandIndex;
            queueVO.queueIndex = this.queueIndex;
            queueVO.queues = this.queues;
            queueVO.blocked = this.blocked;
            out.writeObject(queueVO);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Server.logSevereMessage("Erro ao salvar a fila de comandos.", e);
        }
    }

    protected synchronized void loadFromBackup() {
        CommandInfoCache.enable();
        try {
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(this.backupFilePath));
            PriorityQueueVO queueVO = (PriorityQueueVO)input.readObject();
            input.close();
            if (queueVO.queues.size() != this.queues.size()) {
                if (queueVO.commandIndex.size() < 1) {
                    Server.logWarningMessage("As prioridades da fila foram alteradas. N\u00e3o h\u00e1 comandos persistidos no backup. Ent\u00e3o, o servi\u00e7o de escalonamente funcionar\u00e1 normalmente.");
                } else {
                    Server.logSevereMessage("As prioridades da fila foram alteradas e n\u00e3o \u00e9 poss\u00edvel recuperar o backup da fila. O servi\u00e7o de escalonamente funcionar\u00e1, mas sem os comandos persistidos.");
                }
                return;
            }
            this.commandIndex = queueVO.commandIndex;
            this.queueIndex = queueVO.queueIndex;
            this.queues = queueVO.queues;
            this.blocked = queueVO.blocked;
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao carregar o estado da fila de comandos.", e);
        }
    }

    private void initQueue() {
        int len = Priority.values().length;
        this.queues = new ArrayList<List<CommandInfo>>(len);
        for (int i = 0; i < len; ++i) {
            this.queues.add(i, new LinkedList());
        }
        this.commandIndex = new HashMap<Object, CommandInfo>();
        this.queueIndex = new HashMap<Object, List<CommandInfo>>();
        this.blocked = false;
    }

    private int normalizePosition(int position) {
        for (List<CommandInfo> q : this.queues) {
            if (position < q.size()) {
                return position;
            }
            position -= q.size();
        }
        throw new AssertionError();
    }

    public synchronized CommandInfo getCommand(Object commandId) {
        return this.commandIndex.get(commandId);
    }

    private List<CommandInfo> getQueue(CommandInfo cmd) {
        return this.queueIndex.get(cmd.getId());
    }

    private List<CommandInfo> getQueue(Priority priority) {
        return this.queues.get(priority.ordinal());
    }

    private List<CommandInfo> getQueue(int position) {
        for (List<CommandInfo> q : this.queues) {
            if (position < q.size()) {
                return q;
            }
            position -= q.size();
        }
        throw new AssertionError();
    }

    private int indexOf(CommandInfo cmd) {
        List<CommandInfo> queue = this.getQueue(cmd);
        int extra = 0;
        for (List<CommandInfo> q : this.queues) {
            if (q == queue) break;
            extra += q.size();
        }
        return queue.indexOf(cmd) + extra;
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

