/**
 * $Id: SSLORBInitializer.java 163065 2015-03-27 18:41:34Z fpina $
 */
package csbase.server.services.sgaservice.ssl;

import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

import csbase.server.Server;

/**
 * Inicializador de ORB para cadastrar o interceptador de SSL.
 *
 * @author Tecgraf/PUC-Rio
 */
public class SSLORBInitializer extends LocalObject implements ORBInitializer {

  /**
   * Identificador.
   */
  private static final long serialVersionUID = 2736327943216909050L;

  /**
   * {@inheritDoc}
   */
  @Override
  public void post_init(ORBInitInfo info) {
    try {
      int slot = info.allocate_slot_id();
      SSLContext inspector = new SSLContext(slot);
      info.register_initial_reference(SSLContext.INITIAL_REFERENCE_ID,
        inspector);

      info.add_server_request_interceptor(new SSLServerInterceptor(inspector));
    }
    catch (Exception e) {
      String message = "Falha ao cadastrad o interceptador SSL do SGA.";
      Server.logSevereMessage(message, e);
      throw new INITIALIZE(message);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void pre_init(ORBInitInfo info) {
  }
}
