package csbase.server.services.schedulerservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.SGASet;

public class BalancedCommandDistribution {
	Map<String, Integer> occupationMap = new HashMap<String, Integer>();
	
	public BalancedCommandDistribution(List<SGASet> servers)
	{
		for(SGASet sga:servers)
		{
			occupationMap.put(sga.getName(), 0);
		}
	}
	
	public SGASet chooseLightest (List<SGASet> servers)
	{
		SGASet choosedServer = getOccupationMininum(servers);
		occupationMap.put(choosedServer.getName(), occupationMap.get(choosedServer.getName())+1);
		return choosedServer;
	}
	
	private SGASet getOccupationMininum(List<SGASet> servers)
	{
		SGASet server = null;
		int occupation = 0;
		for (SGASet s: servers)
		{
			if ((server==null || occupationMap.get(s.getName())<occupation) && s!=null)
			{
				server = s;
				occupation = occupationMap.get(s.getName());
			}
		}
		return server;
	}
}
