/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CapacityType;
import csbase.logic.SGASet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Hashtable;

public class SGASetIOComparator
implements Comparator<SGASet>,
Serializable {
    private long inputFilesLength;
    Hashtable<String, Long> platfBinFilesLengthList;

    public SGASetIOComparator(long inputFilesLength, Hashtable<String, Long> platfBinFilesLengthList) {
        this.inputFilesLength = inputFilesLength;
        this.platfBinFilesLengthList = platfBinFilesLengthList;
    }

    @Override
    public int compare(SGASet sga1, SGASet sga2) {
        long sgaTransfer2;
        float execTime2;
        long sgaTransfer1;
        float execTime1;
        long totalFilesLength1 = this.inputFilesLength + this.platfBinFilesLengthList.get(sga1.getName());
        long totalFilesLength2 = this.inputFilesLength + this.platfBinFilesLengthList.get(sga2.getName());
        float transferTime1 = 0.0f;
        float transferTime2 = 0.0f;
        long sgaWriting1 = sga1.getCapacity(CapacityType.DISK_WRITE);
        long sgaWriting2 = sga2.getCapacity(CapacityType.DISK_WRITE);
        if (sgaWriting1 == -1L) {
            sgaWriting1 = 1L;
        }
        if (sgaWriting2 == -1L) {
            sgaWriting2 = 1L;
        }
        if ((execTime1 = (float)(totalFilesLength1 / sgaWriting1) + (transferTime1 = (sgaTransfer1 = sga1.getCapacity(CapacityType.NET)) == -1L ? (float)totalFilesLength1 : (sgaTransfer1 == -2L ? 0.0f : (float)(totalFilesLength1 / sgaTransfer1)))) < (execTime2 = (float)(totalFilesLength2 / sgaWriting2) + (transferTime2 = (sgaTransfer2 = sga2.getCapacity(CapacityType.NET)) == -1L ? (float)totalFilesLength2 : (sgaTransfer2 == -2L ? 0.0f : (float)(totalFilesLength2 / sgaTransfer2))))) {
            return -1;
        }
        if (execTime1 > execTime2) {
            return 1;
        }
        return 0;
    }
}

