/*
 * $Id:$
 */

package csbase.server.services.filetransferservice;

import java.util.List;

import csbase.exception.ServiceFailureException;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferRequest;

/**
 * Interface para insero de novos protocolos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface FileTransferProtocolStub {

  /**
   * Indica se a conexo  vlida.
   * 
   * @param connection conexo.
   * @return indicativo
   */
  public boolean checkConnection(FileTransferConnection connection);

  /**
   * Cria o job (download) a ser enfileirado com bas na requisio.
   * 
   * @param request a requisio
   * @return a thread
   * @throws ServiceFailureException em caso de erro.
   */
  public FileTransferJob createDownloadJob(final FileTransferRequest request)
    throws ServiceFailureException;

  /**
   * Cria o job (upload) a ser enfileirado com bas na requisio.
   * 
   * @param request a requisio
   * @return a thread
   * @throws ServiceFailureException em caso de erro.
   */
  public FileTransferJob createUploadJob(final FileTransferRequest request)
    throws ServiceFailureException;

  /**
   * Lista o contedo de um diretrio remoto.
   * 
   * @param connection conexo
   * @param remoteDirPath diretrio remoto.
   * @return lista de elementos
   * @throws ServiceFailureException em caso de erro.
   */
  public List<FileTransferElement> listContent(
    final FileTransferConnection connection, final String remoteDirPath)
    throws ServiceFailureException;
}
