package csbase.server.services.opendreamsservice.opendreams.rest.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("jobsession")
@Api(value = "/jobsession", description = "Job Session RESTful service")

public class JobSessionResource {

	/**
	 * Method handling HTTP GET requests on the /jobsession. All job sessions
	 * must be returned in JSON format.
	 *
	 * @return All existing job sessions.
	 */
	@GET
	@ApiOperation(value = "Retrieve job sessions", notes = "List all existing job sessions.")
	@Produces(MediaType.APPLICATION_JSON)
	public String getJobSessions() {
		return "Response";
	}

	/**
	 * Method handling HTTP POST requests on /jobsession. Create a new job
	 * session or return an unsuccessful operation response in case that the job
	 * session already exists (sessionName not unique)
	 *
	 * @return Success or failure. //TODO: Determine the response codes
	 *         associated with the operation outcome.
	 */
	@POST
	@ApiOperation(value = "Create job session", notes = "Try to create a new job session using the given name")
	@Consumes(MediaType.APPLICATION_JSON)
	public String createJobSession(
			@ApiParam(value = "The new session identifier", required = true) @PathParam("sessionName") String sessionName) {
		return "Response";
	}

}