/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.AdministrationEvent;
import csbase.logic.MonitoredServerListener;
import csbase.logic.Permission;
import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.logic.ServerURI;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import csbase.logic.UserInfo;
import csbase.logic.UserPasswordPermission;
import csbase.logic.UserProjectInfo;
import csbase.logic.UserUpdate;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ServerRemoteLocator;
import csbase.remote.TransactionCallbackInterface;
import csbase.server.LocalServerRemoteMonitor;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.administrationservice.CentralAdministrationObserver;
import csbase.server.services.projectservice.ProjectService;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;

public class LocalAdministrationService
extends AdministrationService
implements AdministrationServiceInterface,
MonitoredServerListener {
    private static final long LOCK_SLEEP_TIME = 1000L;
    private static final long MAX_LOCK_TRIES = 50L;
    CentralAdministrationObserver observer;

    LocalAdministrationService() throws ServerException {
    }

    @Override
    public void initService() throws ServerException {
        Server.logInfoMessage("Iniciando servi\u00e7o local de administra\u00e7\u00e3o...");
        LocalServerRemoteMonitor monitor = LocalServerRemoteMonitor.getInstance();
        monitor.addListener(this);
        try {
            this.observer = new CentralAdministrationObserver(this);
            this.observer.install();
        }
        catch (RemoteException e) {
            throw new ServerException("Falha ao ativar AdministrationObserver", e);
        }
    }

    @Override
    public void shutdownService() {
        Server.logInfoMessage("Terminando servi\u00e7o local de administra\u00e7\u00e3o...");
        LocalServerRemoteMonitor monitor = LocalServerRemoteMonitor.getInstance();
        monitor.stop();
    }

    private void removeUserFromOwnProjects(Object id) {
        ProjectService projService = ProjectService.getInstance();
        List<UserProjectInfo> projects = projService.getProjectsFromUser(id);
        if (projects != null) {
            for (UserProjectInfo info : projects) {
                projService.removeProject(info.getProjectId());
            }
        }
    }

    private void localCreateUser(User user) {
        try {
            user = this.userDAO.createUser(user.getUserInfo());
            this.notifyObservers(1, user);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o local do usu\u00e1rio " + user, e);
        }
    }

    private void localModifyUser(User user) {
        try {
            user = this.userDAO.modifyUser(user.getId(), user.getUserInfo());
            this.notifyObservers(2, user);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na altera\u00e7\u00e3o local do usu\u00e1rio " + user, e);
        }
    }

    private void localDeleteUser(User user) {
        try {
            Object id = user.getId();
            this.removeUserFromSharedProjects(id);
            this.removeUserFromOwnProjects(id);
            this.userDAO.deleteUser(id);
            this.notifyObservers(3, user);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na remo\u00e7\u00e3o local do usu\u00e1rio " + user + ": ", e);
        }
    }

    private void localCreateUserGroup(UserGroup userGroup) {
        try {
            userGroup = this.userGroupsDAO.createUserGroup(userGroup.getUserGroupInfo());
            this.notifyObservers(1, userGroup);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o local de UserGroup " + userGroup + ": ", e);
        }
    }

    private void localModifyUserGroup(UserGroup userGroup) {
        try {
            userGroup = this.userGroupsDAO.modifyUserGroup(userGroup.getId(), userGroup.getUserGroupInfo());
            this.notifyObservers(2, userGroup);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na altera\u00e7\u00e3o local de UserGroup " + userGroup + ": ", e);
        }
    }

    private void localDeleteUserGroup(UserGroup userGroup) {
        try {
            this.userGroupsDAO.deleteUserGroup(userGroup.getId());
            this.notifyObservers(3, userGroup);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na remo\u00e7\u00e3o local de UserGroup " + userGroup + ": ", e);
        }
    }

    private void localCreateRole(Role role) {
        try {
            role = this.roleDAO.createRole(role.getRoleInfo());
            this.notifyObservers(1, role);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o local de perfil " + role + ": ", e);
        }
    }

    private void localModifyRole(Role role) {
        try {
            role = this.roleDAO.modifyRole(role.getId(), role.getRoleInfo());
            this.notifyObservers(2, role);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na altera\u00e7\u00e3o local de perfil " + role + ": ", e);
        }
    }

    private void localDeleteRole(Role role) {
        try {
            this.roleDAO.deleteRole(role.getId());
            this.notifyObservers(3, role);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na remo\u00e7\u00e3o local de perfil " + role + ": ", e);
        }
    }

    private void localCreatePermission(Permission permission) {
        try {
            this.permissionDAO.createPermission(permission);
            this.notifyObservers(1, permission);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o local de permiss\u00e3o " + permission + ": ", e);
        }
    }

    private void localModifyPermission(Permission permission) {
        try {
            permission = this.permissionDAO.modifyPermission(permission.getId(), permission);
            this.notifyObservers(2, permission);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na altera\u00e7\u00e3o local de permiss\u00e3o " + permission + ": ", e);
        }
    }

    private void localDeletePermission(Permission permission) {
        try {
            this.permissionDAO.deletePermission(permission.getId());
            this.notifyObservers(3, permission);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na remo\u00e7\u00e3o local de permiss\u00e3o " + permission + ": ", e);
        }
    }

    private void localCreatePlatform(Platform platform) {
        try {
            platform = this.platformDAO.createPlatform(platform.getPlatformInfo());
            this.notifyObservers(1, platform);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na cria\u00e7\u00e3o local de plataforma " + platform + ": ", e);
        }
    }

    private void localModifyPlatform(Platform platform) {
        try {
            platform = this.platformDAO.modifyPlatform(platform.getId(), platform.getPlatformInfo());
            this.notifyObservers(2, platform);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na altera\u00e7\u00e3o local de plataforma " + platform + ": ", e);
        }
    }

    private void localDeletePlatform(Platform platform) {
        try {
            this.platformDAO.deletePlatform(platform.getId());
            this.notifyObservers(3, platform);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na remo\u00e7\u00e3o local de plataforma " + platform + ": ", e);
        }
    }

    public void notifyConnectionLost(ServerURI serverURI) {
        Server.logInfoMessage("A comunica\u00e7\u00e3o com o servidor central foi interrompida");
    }

    public void notifyLoggedIn(ServerURI serverURI) {
    }

    public void notifyLoggedOut(ServerURI serverURI) {
    }

    public void notifyConnectionReestablished(ServerURI serverURI) {
        Server.logInfoMessage("A comunica\u00e7\u00e3o com o servidor central foi restabelecida");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Server.logInfoMessage("Iniciada sincroniza\u00e7\u00e3o de bases com o servidor central.");
                try {
                    LocalAdministrationService.this.observer.setLockMode(true);
                    AdministrationServiceInterface central = ServerRemoteLocator.administrationService;
                    int numTries = 0;
                    while (!central.lock((TransactionCallbackInterface)LocalAdministrationService.this.observer)) {
                        if ((long)(++numTries) > 50L) {
                            Server.logSevereMessage("Falha no lock do servidor central na sincroniza\u00e7\u00e3o de bases.");
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    numTries = 0;
                    while (!LocalAdministrationService.this.lock(LocalAdministrationService.this.observer)) {
                        if ((long)(++numTries) > 50L) {
                            central.unlock((TransactionCallbackInterface)LocalAdministrationService.this.observer);
                            Server.logSevereMessage("Falha no lock do servidor local na sincroniza\u00e7\u00e3o de bases.");
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    List newPlatforms = central.getAllPlatforms();
                    List newPermissions = central.getAllPermissionsWithPasswords();
                    List newRoles = central.getAllRoles();
                    List newUserGroups = central.getAllUserGroups();
                    List userUpdates = central.getAllUserUpdates();
                    Server.logInfoMessage("Sincronizando base de plataformas...");
                    LocalAdministrationService.this.synchronizePlatformDatabase(newPlatforms);
                    Server.logInfoMessage("Sincronizando base de permiss\u00f5es...");
                    LocalAdministrationService.this.synchronizePermissionDatabase(newPermissions);
                    Server.logInfoMessage("Sincronizando base de perfis...");
                    LocalAdministrationService.this.synchronizeRoleDatabase(newRoles);
                    Server.logInfoMessage("Sincronizando base de grupos de usu\u00e1rios...");
                    LocalAdministrationService.this.synchronizeUserGroupDatabase(newUserGroups);
                    Server.logInfoMessage("Sincronizando base de usu\u00e1rios...");
                    LocalAdministrationService.this.synchronizeUserDatabase(userUpdates, central);
                    LocalAdministrationService.this.unlock(LocalAdministrationService.this.observer);
                    central.unlock((TransactionCallbackInterface)LocalAdministrationService.this.observer);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de bases: ", e);
                    return;
                }
                finally {
                    LocalAdministrationService.this.observer.setLockMode(false);
                }
                Server.logInfoMessage("Terminada sincroniza\u00e7\u00e3o de bases com o servidor central.");
            }
        }.start();
    }

    private void synchronizePlatformDatabase(List<Platform> newPlatforms) {
        try {
            HashSet<Object> allPlatformIds = new HashSet<Object>(newPlatforms.size());
            for (int i = 0; i < newPlatforms.size(); ++i) {
                Platform newPlatform = newPlatforms.get(i);
                Object id = newPlatform.getId();
                Platform oldPlatform = this.getPlatform(id);
                if (oldPlatform == null) {
                    this.localCreatePlatform(newPlatform);
                } else if (!newPlatform.equalContents((Object)oldPlatform)) {
                    this.localModifyPlatform(newPlatform);
                }
                allPlatformIds.add(id);
            }
            List<Platform> localPlatforms = this.getAllPlatforms();
            for (int i = 0; i < localPlatforms.size(); ++i) {
                Platform platform = localPlatforms.get(i);
                if (allPlatformIds.contains(platform.getId())) continue;
                this.localDeletePlatform(platform);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de plataformas: ", e);
        }
    }

    private void synchronizePermissionDatabase(List<Permission> newPermissions) {
        try {
            HashSet<Object> allPermissionIds = new HashSet<Object>(newPermissions.size());
            for (int i = 0; i < newPermissions.size(); ++i) {
                Permission oldPermission;
                Permission newPermission = newPermissions.get(i);
                Object id = newPermission.getId();
                if (newPermission instanceof UserPasswordPermission) {
                    UserPasswordPermission upp = (UserPasswordPermission)newPermission;
                    upp.setLocalPassword(upp.getPassword());
                }
                if ((oldPermission = this.getPermission(id)) == null) {
                    this.localCreatePermission(newPermission);
                } else if (!newPermission.equalContents((Object)oldPermission)) {
                    this.localModifyPermission(newPermission);
                }
                allPermissionIds.add(id);
            }
            List<Permission> localPermissions = this.getAllPermissions();
            for (int i = 0; i < localPermissions.size(); ++i) {
                Permission permission = localPermissions.get(i);
                if (allPermissionIds.contains(permission.getId())) continue;
                this.localDeletePermission(permission);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de permiss\u00f5es: ", e);
        }
    }

    private void synchronizeRoleDatabase(List<Role> newRoles) {
        try {
            HashSet<Object> allRoleIds = new HashSet<Object>(newRoles.size());
            for (int i = 0; i < newRoles.size(); ++i) {
                Role newRole = newRoles.get(i);
                Object id = newRole.getId();
                Role oldRole = this.getRole(id);
                if (oldRole == null) {
                    this.localCreateRole(newRole);
                } else if (!newRole.equalContents((Object)oldRole)) {
                    this.localModifyRole(newRole);
                }
                allRoleIds.add(id);
            }
            List<Role> localRoles = this.getAllRoles();
            for (int i = 0; i < localRoles.size(); ++i) {
                Role role = localRoles.get(i);
                if (allRoleIds.contains(role.getId())) continue;
                this.localDeleteRole(role);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de perfis: ", e);
        }
    }

    private void synchronizeUserGroupDatabase(List<UserGroup> newUserGroups) {
        try {
            HashSet<Object> allUserGroupIds = new HashSet<Object>(newUserGroups.size());
            for (int i = 0; i < newUserGroups.size(); ++i) {
                UserGroup newUserGroup = newUserGroups.get(i);
                Object id = newUserGroup.getId();
                UserGroup oldUserGroup = this.getUserGroup(id);
                if (oldUserGroup == null) {
                    this.localCreateUserGroup(newUserGroup);
                } else if (!newUserGroup.equalContents((Object)oldUserGroup)) {
                    this.localModifyUserGroup(newUserGroup);
                }
                allUserGroupIds.add(id);
            }
            List<UserGroup> localUserGroups = this.getAllUserGroups();
            for (int i = 0; i < localUserGroups.size(); ++i) {
                UserGroup userGroup = localUserGroups.get(i);
                if (allUserGroupIds.contains(userGroup.getId())) continue;
                this.localDeleteUserGroup(userGroup);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de UserGroups: ", e);
        }
    }

    private void synchronizeUserDatabase(List<UserUpdate> userUpdates, AdministrationServiceInterface central) {
        try {
            HashSet<Object> allUserIds = new HashSet<Object>(userUpdates.size());
            for (int i = 0; i < userUpdates.size(); ++i) {
                UserUpdate update = userUpdates.get(i);
                Object id = update.getId();
                User localUser = this.getUser(id);
                if (localUser == null) {
                    this.localCreateUser(central.getUser(id));
                } else if (localUser.isAdmin()) {
                    this.localModifyUser(central.getUser(id));
                } else if (localUser.getLastUpdate() != update.getLastUpdate()) {
                    this.localModifyUser(central.getUser(id));
                }
                allUserIds.add(id);
            }
            List<User> localUsers = this.getAllUsers();
            for (int i = 0; i < localUsers.size(); ++i) {
                User user = localUsers.get(i);
                if (allUserIds.contains(user.getId())) continue;
                this.localDeleteUser(user);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na sincroniza\u00e7\u00e3o de usu\u00e1rios: ", e);
        }
    }

    void updateUser(AdministrationEvent event) throws Exception {
        User user = (User)event.item;
        switch (event.type) {
            case 1: {
                this.localCreateUser(user);
                break;
            }
            case 2: {
                this.localModifyUser(user);
                break;
            }
            case 3: {
                this.localDeleteUser(user);
                break;
            }
            default: {
                Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - type=" + event.type);
            }
        }
    }

    void updateUserGroup(AdministrationEvent event) throws Exception {
        UserGroup userGroup = (UserGroup)event.item;
        switch (event.type) {
            case 1: {
                this.localCreateUserGroup(userGroup);
                break;
            }
            case 2: {
                this.localModifyUserGroup(userGroup);
                break;
            }
            case 3: {
                this.localDeleteUserGroup(userGroup);
                break;
            }
            default: {
                Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - type=" + event.type);
            }
        }
    }

    void updateRole(AdministrationEvent event) throws Exception {
        Role role = (Role)event.item;
        switch (event.type) {
            case 1: {
                this.localCreateRole(role);
                break;
            }
            case 2: {
                this.localModifyRole(role);
                break;
            }
            case 3: {
                this.localDeleteRole(role);
                break;
            }
            default: {
                Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - type=" + event.type);
            }
        }
    }

    void updatePermission(AdministrationEvent event) throws Exception {
        Permission permission = (Permission)event.item;
        if (permission instanceof UserPasswordPermission) {
            permission = ServerRemoteLocator.administrationService.getPermissionWithPassword(permission.getId());
        }
        switch (event.type) {
            case 1: {
                this.localCreatePermission(permission);
                break;
            }
            case 2: {
                this.localModifyPermission(permission);
                break;
            }
            case 3: {
                this.localDeletePermission(permission);
                break;
            }
            default: {
                Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - type=" + event.type);
            }
        }
    }

    void updatePlatform(AdministrationEvent event) throws Exception {
        Platform platform = (Platform)event.item;
        switch (event.type) {
            case 1: {
                this.localCreatePlatform(platform);
                break;
            }
            case 2: {
                this.localModifyPlatform(platform);
                break;
            }
            case 3: {
                this.localDeletePlatform(platform);
                break;
            }
            default: {
                Server.logSevereMessage("Evento n\u00e3o reconhecido: " + event + " - type=" + event.type);
            }
        }
    }

    @Override
    public User createUser(UserInfo info) {
        this.checkCreateUserPermission();
        try {
            return ServerRemoteLocator.administrationService.createUser(info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public ImageIcon getPhoto(Object id) {
        try {
            return ServerRemoteLocator.administrationService.getPhoto(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public User modifyUser(Object id, UserInfo info) throws PermissionException, RemoteException {
        this.checkModifyUserPermission(id, info);
        try {
            return ServerRemoteLocator.administrationService.modifyUser(id, info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public void deleteUser(Object id) throws AdministrationDeleteException {
        this.checkDeleteUserPermission();
        this.checkNoProjects(id);
        try {
            ServerRemoteLocator.administrationService.deleteUser(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public UserGroup createUserGroup(UserGroupInfo info) {
        this.checkCreateUserGroupPermission();
        try {
            return ServerRemoteLocator.administrationService.createUserGroup(info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public UserGroup modifyUserGroup(Object id, UserGroupInfo info) {
        this.checkModifyUserGroupPermission();
        try {
            return ServerRemoteLocator.administrationService.modifyUserGroup(id, info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public void deleteUserGroup(Object id) throws AdministrationDeleteException {
        this.checkDeleteUserGroupPermission();
        try {
            ServerRemoteLocator.administrationService.deleteUserGroup(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Role createRole(RoleInfo info) {
        this.checkCreateRolePermission();
        try {
            return ServerRemoteLocator.administrationService.createRole(info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Role modifyRole(Object id, RoleInfo info) {
        this.checkModifyRolePermission();
        try {
            return ServerRemoteLocator.administrationService.modifyRole(id, info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public void deleteRole(Object id) throws AdministrationDeleteException {
        this.checkDeleteRolePermission();
        try {
            ServerRemoteLocator.administrationService.deleteRole(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Permission createPermission(Permission permission) {
        this.checkCreatePermissionPermission();
        try {
            return ServerRemoteLocator.administrationService.createPermission(permission);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Permission modifyPermission(Object id, Permission permission) {
        this.checkModifyPermissionPermission();
        try {
            return ServerRemoteLocator.administrationService.modifyPermission(id, permission);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public void deletePermission(Object id) throws AdministrationDeleteException {
        this.checkDeletePermissionPermission();
        try {
            ServerRemoteLocator.administrationService.deletePermission(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Platform createPlatform(PlatformInfo info) {
        this.checkCreatePlatformPermission();
        try {
            return ServerRemoteLocator.administrationService.createPlatform(info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public Platform modifyPlatform(Object id, PlatformInfo info) {
        this.checkModifyPlatformPermission();
        try {
            return ServerRemoteLocator.administrationService.modifyPlatform(id, info);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }

    @Override
    public void deletePlatform(Object id) {
        this.checkDeletePlatformPermission();
        try {
            ServerRemoteLocator.administrationService.deletePlatform(id);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("LocalAdministrationService.error.conecting.central.server"));
        }
    }
}

