/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice.ftp;

import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectFileType;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.server.Server;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.projectservice.ProjectService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPClient;

class FTPDownloadJob
extends FileTransferJob {
    FTPDownloadJob(FileTransferRequest request) {
        super(request);
    }

    @Override
    protected void transfer() throws Exception {
        ProjectService projectService = ProjectService.getInstance();
        FileTransferRequest request = this.getRequest();
        FileTransferConnection connection = request.getConnection();
        Object projectId = connection.getProjectId();
        String[] localPath = request.getLocalFilePath();
        String remoteFilePath = request.getRemoteFilePath();
        String password = connection.getPassword();
        String userName = connection.getUserName();
        String serverName = connection.getServerName();
        if (!projectService.existsFile(projectId, localPath)) {
            String fileType = ProjectFileType.getFileType((String)"UNKNOWN").getCode();
            String fileName = localPath[localPath.length - 1];
            String[] path = Arrays.copyOf(localPath, localPath.length - 1);
            projectService.createFile(projectId, path, fileName, fileType);
        }
        projectService.setUnderConstruction(projectId, localPath, true);
        FTPClient ftp = new FTPClient();
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            ftp.connect(serverName);
            if (!ftp.login(userName, password)) {
                throw new ServiceFailureException("Invalid login.");
            }
            inStream = ftp.retrieveFileStream(remoteFilePath);
            if (inStream == null) {
                String err = "Null download input stream for: " + remoteFilePath;
                throw new ServiceFailureException(err);
            }
            outStream = projectService.getOutputStream(projectId, localPath);
            int chunkSize = 65536;
            byte[] b = new byte[chunkSize];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(b)) != -1) {
                outStream.write(b, 0, bytesRead);
                request.addTransferredSize((long)bytesRead);
                if (request.getStatus() != FileTransferRequestStatus.INTERRUPTED) continue;
                return;
            }
        }
        catch (Exception e) {
            try {
                if (ftp.isConnected()) {
                    ftp.disconnect();
                }
            }
            catch (Exception e2) {
                Server.logSevereMessage(e.getMessage(), e2);
            }
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
            try {
                projectService.setUnderConstruction(projectId, localPath, false);
            }
            catch (Exception e) {
                Server.logSevereMessage(e.getMessage(), e);
            }
        }
    }
}

