/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectFileType;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.server.Server;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.sftp.StubUserInfo;
import csbase.server.services.projectservice.ProjectService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class SFTPDownloadJob
extends FileTransferJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transfer() throws Exception {
        Session session;
        ProjectService projectService = ProjectService.getInstance();
        FileTransferRequest request = this.getRequest();
        FileTransferConnection connection = request.getConnection();
        Object projectId = connection.getProjectId();
        String[] localPath = request.getLocalFilePath();
        String remoteFilePath = request.getRemoteFilePath();
        String serverName = connection.getServerName();
        String userName = connection.getUserName();
        String password = connection.getPassword();
        JSch jsch = new JSch();
        int port = 22;
        try {
            session = jsch.getSession(userName, serverName, port);
        }
        catch (JSchException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
        StubUserInfo ui = new StubUserInfo(password);
        session.setUserInfo((UserInfo)ui);
        if (projectService.existsFile(projectId, localPath)) {
            String unknown = "UNKNOWN";
            String fileType = ProjectFileType.getFileType((String)unknown).getCode();
            String fileName = localPath[localPath.length - 1];
            String[] path = Arrays.copyOf(localPath, localPath.length - 1);
            projectService.createFile(projectId, path, fileName, fileType);
        }
        projectService.setUnderConstruction(projectId, localPath, true);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            session.connect();
            Channel c = session.openChannel("sftp");
            c.connect();
            ChannelSftp channel = (ChannelSftp)c;
            String[] splittedPath = remoteFilePath.split(File.separator);
            String file = splittedPath[splittedPath.length - 1];
            String dir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(File.separator));
            channel.cd(dir);
            inputStream = channel.get(file, (SftpProgressMonitor)null);
            outputStream = projectService.getOutputStream(projectId, localPath);
            int chunkSize = 65536;
            byte[] b = new byte[chunkSize];
            int bytesRead = 0;
            while ((bytesRead = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, bytesRead);
                request.addTransferredSize((long)bytesRead);
                if (request.getStatus() != FileTransferRequestStatus.INTERRUPTED) continue;
                return;
            }
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Server.logSevereMessage(e.getMessage(), e);
                }
            }
            try {
                projectService.setUnderConstruction(projectId, localPath, false);
            }
            catch (Exception e) {
                Server.logSevereMessage(e.getMessage(), e);
            }
        }
    }

    public SFTPDownloadJob(FileTransferRequest request) {
        super(request);
    }
}

