/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v2_0;

import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.FileParameterValue;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v2_0.InvalidJobTemplateException;
import csbase.server.services.opendreamsservice.opendreams.v2_0.JobTemplateValidator;
import csbase.server.services.opendreamsservice.opendreams.v2_0.LogUtils;
import csbase.server.services.opendreamsservice.opendreams.v2_0.SessionManager;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.SGAService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import tecgraf.javautils.core.filter.IFilter;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;
import tecgraf.openbus.DRMAA.v2_0.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v2_0.InternalException;
import tecgraf.openbus.DRMAA.v2_0.Job;
import tecgraf.openbus.DRMAA.v2_0.JobHelper;
import tecgraf.openbus.DRMAA.v2_0.JobInfo;
import tecgraf.openbus.DRMAA.v2_0.JobOperations;
import tecgraf.openbus.DRMAA.v2_0.JobPOATie;
import tecgraf.openbus.DRMAA.v2_0.JobState;
import tecgraf.openbus.DRMAA.v2_0.JobTemplate;
import tecgraf.openbus.DRMAA.v2_0.TimeoutException;
import tecgraf.openbus.DRMAA.v2_0.UnsupportedOperationException;
import tecgraf.openbus.opendreams.v2_0.FinalizationType;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobInfoImpl;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplate;

public class OpenDreamsJob
implements JobOperations,
Serializable {
    public static final int NO_EXIT_CODE = 256;
    private static final int TERMINATE_SLEEP_TRY = 50;
    private String jobId;
    private String sessionName;
    private String userId;
    private java.lang.Object projectId;
    private OpenDreamsJobTemplate jt;
    private OpenDreamsJobInfo jobInfo;
    private transient Job ref;

    public OpenDreamsJob(String sessionName, OpenDreamsJobTemplate jt) {
        this.sessionName = sessionName;
        this.jt = jt;
        this.jobInfo = new OpenDreamsJobInfoImpl();
    }

    public String jobId() {
        return this.jobId;
    }

    public String sessionName() {
        return this.sessionName;
    }

    public JobTemplate jobTemplate() {
        return this.jt;
    }

    public Job createCorbaObjReference() throws OperationFailureException, ServantNotActive, WrongPolicy {
        System.out.println("Job createCorbaObjReference()");
        POA poa = OpenBusService.getInstance().getRootPOA();
        if (this.ref == null) {
            System.out.println("ref == null");
            JobPOATie tie = new JobPOATie((JobOperations)this, poa);
            Object obj = poa.servant_to_reference((Servant)tie);
            this.ref = JobHelper.narrow((Object)obj);
        }
        System.out.println("Returning Job ref");
        return this.ref;
    }

    public void execute(String userId) throws InvalidJobTemplateException {
        JobTemplateValidator validator = new JobTemplateValidator(userId, this.jt);
        this.projectId = validator.getProjectId();
        this.userId = userId;
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        ProjectService.getInstance().openProject(this.projectId, false);
        CommandSubmission submission = new CommandSubmission(configurator, this.projectId);
        submission.setDescription(this.jt.jobDescription);
        submission.setPriority(Priority.values()[this.jt.priority]);
        submission.setEmailList(this.jt.email);
        submission.setMailAtEnd(this.jt.emailOnTerminated);
        submission.configureSimpleExecution((String)(this.jt.candidateMachines != null && this.jt.candidateMachines.length == 0 ? null : this.jt.candidateMachines[0]));
        int nProp = this.jt.extraProperties.length;
        for (int n = 0; n < nProp; ++n) {
            submission.addExtraInfo(this.jt.extraProperties[n][0], this.jt.extraProperties[n][1]);
        }
        Set<CommandInfo> commandInfos = null;
        try {
            commandInfos = SchedulerService.getInstance().submitCommand(submission);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        String cmdId = commandInfos.toArray(new CommandInfo[0])[0].getId();
        System.out.println("Job " + cmdId + " scheduled to run.");
        this.jobId = cmdId;
        this.jobInfo.jobId = cmdId;
        this.jobInfo.jobOwner = userId;
        this.jobInfo.jobName = this.jt.jobName;
    }

    public void suspend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    public void resume() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    public void hold() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    public void release() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    /*
     * Unable to fully structure code
     */
    public void terminate() throws DrmCommunicationException, DeniedByDrmsException, InternalException {
        System.out.println("Job " + this.jobId + " being terminated.");
        Server.logInfoMessage("Job " + this.jobId + " being terminated.");
        try {
            userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(userId);
            commandPersistenceService = CommandPersistenceService.getInstance();
            commandInfo = commandPersistenceService.getCommandInfo(this.projectId, this.jobId);
            if (commandInfo.getStatus().equals((java.lang.Object)CommandStatus.FINISHED)) {
                Server.logInfoMessage("O comando " + this.jobId + " j\u00c3\u00a1 terminou e n\u00c3\u00a3o pode mais ser cancelado");
            }
            if ((schedulerService = SchedulerService.getInstance()).removeCommand(this.jobId)) {
                return;
            }
            while (true) {
                if ((commandInfo = commandPersistenceService.getCommandInfo(this.projectId, this.jobId)).getStatus().equals((java.lang.Object)CommandStatus.FINISHED)) {
                    return;
                }
                if (!commandInfo.getStatus().equals((java.lang.Object)CommandStatus.EXECUTING)) ** GOTO lbl22
                sgaService = SGAService.getInstance();
                if (sgaService.killCommand(this.jobId)) {
                    return;
                }
                if (!sgaService.getSGASet(commandInfo.getSGAName()).getAlive()) {
                    throw new DrmCommunicationException("O servidor perdeu a conex\u00c3\u00a3o com o SGA " + commandInfo.getSGAName());
                }
lbl22:
                // 3 sources

                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
                continue;
                break;
            }
            catch (PermissionException e) {
                throw new DeniedByDrmsException("O usu\u00c3\u00a1rio " + this.userId + " n\u00c3\u00a3o possui permiss\u00c3\u00a3o para cancelar o job " + this.jobId);
            }
            catch (DeniedByDrmsException e) {
                e.printStackTrace();
                msg = "O usu\u00c3\u00a1rio " + this.userId + " n\u00c3\u00a3o possui permiss\u00c3\u00a3o para cancelar o job " + this.jobId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (DrmCommunicationException e) {
                msg = "Falha na tentativa de alterar o estado de um comando pelo usu\u00c3\u00a1rio " + this.userId + ": " + e.message;
                Server.logWarningMessage(msg);
                throw e;
            }
            catch (Throwable e) {
                msg = "Erro no cancelamento do job " + this.jobId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    public void reap() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    public void onFinish(String userId, CommandNotification cmdEvent) {
        CommandFinalizationInfo finalizationInfo;
        this.jobInfo.jobState = JobState.DONE;
        if (cmdEvent.getFinalizationInfo().getFinalizationType() == CommandFinalizationType.SUCCESS) {
            Map execData;
            CommandSuccessNotification endNotification = (CommandSuccessNotification)cmdEvent;
            System.out.println(endNotification);
            if (endNotification.getCPUTime() != null) {
                this.jobInfo.cpuTime = Integer.valueOf(endNotification.getCPUTime().toString());
            }
            if (endNotification.getElapsedTime() != null) {
                this.jobInfo.wallclockTime = Long.valueOf(endNotification.getElapsedTime().toString());
            }
            if (endNotification.getUserTime() != null) {
                // empty if block
            }
            if ((execData = endNotification.getExecutionData()) != null) {
                this.jobInfo.executionData = new String[execData.size()][2];
                Iterator iterator = execData.entrySet().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Map.Entry data = iterator.next();
                    this.jobInfo.executionData[index] = new String[]{(String)data.getKey(), (String)data.getValue()};
                    ++index;
                }
            }
        }
        if (cmdEvent.getFinalizationInfo().getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
            finalizationInfo = (ExtendedCommandFinalizationInfo)cmdEvent.getFinalizationInfo();
            this.jobInfo.guiltyNodeId = String.valueOf(finalizationInfo.getGuiltyNodeId());
        }
        if ((finalizationInfo = cmdEvent.getFinalizationInfo()) == null) {
            Server.logSevereMessage("A informa\u00c3\u00a7\u00c3\u00a3o de finalizacao do comando " + this.jobId + " n\u00c3\u00a3o existe (null)");
            this.jobInfo.exitStatus = 256;
        } else {
            Integer exitCode = finalizationInfo.getExitCode();
            Server.logInfoMessage("A informa\u00c3\u00a7\u00c3\u00a3o de finalizacao do comando " + this.jobId + " possui exitCode=" + exitCode);
            this.jobInfo.exitStatus = exitCode == null ? 256 : exitCode;
            this.jobInfo.finalizationType = this.getFinalizationType(finalizationInfo.getFinalizationType(), finalizationInfo.getFailureCause());
            this.jobInfo.description = finalizationInfo.getFailureCause() == null ? finalizationInfo.getFinalizationType().getDescription() : finalizationInfo.getFailureCause().getDescription();
        }
        this.jobInfo.terminatingSignal = "";
        this.flush(userId);
    }

    public JobState getState(AnyHolder jobSubState) {
        return this.jobInfo.jobState;
    }

    public JobInfo getInfo() {
        return this.jobInfo;
    }

    public void waitStarted(long timeout) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00c3\u00a7\u00c3\u00a3o n\u00c3\u00a3o suportada.");
    }

    public void waitTerminated(long timeout) throws TimeoutException, DeniedByDrmsException, InternalException {
        SynchronousQueue<Boolean> onJobTerminate = new SynchronousQueue<Boolean>();
        Server.logFineMessage("OpenDreamsJob (" + this.jobId + "): waitTerminated");
        System.out.println("OpenDreamsJob (" + this.jobId + "): waitTerminated");
        try {
            String msg;
            this.userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(this.userId);
            Serializable listenerId = this.setOnJobTerminateListener(onJobTerminate);
            Boolean terminated = onJobTerminate.poll(timeout, TimeUnit.SECONDS);
            MessageService.getInstance().clearServerMessageListener(listenerId);
            if (terminated != null && terminated.booleanValue()) {
                return;
            }
            try {
                throw new TimeoutException("O job n\u00c3\u00a3o terminou dentro do timeout especificado.");
            }
            catch (DeniedByDrmsException e) {
                e.printStackTrace();
                msg = "Erro de autentica\u00c3\u00a7\u00c3\u00a3o no CSBASE do usu\u00c3\u00a1rio " + this.userId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                msg = "Timeout excedido na espera por finaliza\u00c3\u00a7\u00c3\u00a3o do job " + this.jobId;
                Server.logSevereMessage(msg, e);
                throw e;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                msg = "Erro na espera por finaliza\u00c3\u00a7\u00c3\u00a3o do job " + this.jobId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
            catch (Throwable e) {
                msg = "Erro na espera por finaliza\u00c3\u00a7\u00c3\u00a3o do job " + this.jobId;
                Server.logSevereMessage(msg, e);
                throw new InternalException(LogUtils.formatMessage(e, msg));
            }
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    private Serializable setOnJobTerminateListener(final SynchronousQueue<Boolean> terminated) {
        return MessageService.getInstance().setServerMessageListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    System.out.println(OpenDreamsJob.this.jobId + " onJobTerminateListener: onMessageReceived " + cmdId);
                    if (!OpenDreamsJob.this.jobId.equals(cmdId)) continue;
                    boolean handled = terminated.offer(true);
                    System.out.println("Job " + cmdId + " offer accepted: " + handled);
                }
            }
        }, (IFilter<Message>)new BodyTypeFilter(CommandNotification.class));
    }

    public void flush(String userId) {
        try {
            if (this.jt.outputPath != null && !this.jt.outputPath.isEmpty()) {
                String projectOwner = this.jt.projectOwner.isEmpty() ? userId : this.jt.projectOwner;
                java.lang.Object projectId = ProjectService.getInstance().getProjectId(projectOwner, this.jt.projectName);
                CommandInfo info = CommandPersistenceService.getInstance().getCommandInfo(projectId, this.jobId);
                try {
                    Set files = info.getConfigurator().getStandardOutputFiles();
                    this.dump(projectId, files, this.jt.outputPath);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Erro na recupera\u00c3\u00a7\u00c3\u00a3o do configurador do comando.", e);
                }
            }
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na recupera\u00c3\u00a7\u00c3\u00a3o do log de sa\u00c3\u00adda do comando.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dump(java.lang.Object projectId, Set<FileParameterValue> stdOutputFiles, String outputFile) {
        String[] outputFilePath;
        ProjectService projectService = ProjectService.getInstance();
        if (projectService.existsFile(projectId, outputFilePath = FileUtils.splitPath((String)outputFile))) {
            projectService.removeFile(projectId, outputFilePath);
        }
        String[] outputDirPath = FileUtils.splitPath((String)FileUtils.getFilePath((String)outputFile));
        String newFileName = FileUtils.getFileName((String)outputFile);
        projectService.createFile(projectId, outputDirPath, newFileName, "TEXT");
        ClientProjectFile cpf = projectService.getChild(projectId, outputDirPath, newFileName);
        OutputStream fileTo = null;
        try {
            fileTo = projectService.getOutputStream(projectId, outputFilePath);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileTo));
            for (FileParameterValue stdOutputFile : stdOutputFiles) {
                String[] stdOutputFilePath = stdOutputFile.getPathAsArray();
                InputStream fileFrom = null;
                try {
                    if (stdOutputFiles.size() > 1) {
                        printWriter.printf("\n---- %s ----\n", stdOutputFile.getPath());
                    }
                    if (!projectService.existsFile(projectId, stdOutputFilePath)) continue;
                    fileFrom = projectService.getInputStream(projectId, stdOutputFilePath);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileFrom));
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        printWriter.println(line);
                        line = bufferedReader.readLine();
                    }
                    printWriter.flush();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro na grava\u00c3\u00a7\u00c3\u00a3o do arquivo " + stdOutputFile.getPath() + " em " + cpf.getStringPath(), e);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro na recupera\u00c3\u00a7\u00c3\u00a3o do inputstream do arquivo " + stdOutputFile.getPath(), e);
                }
                finally {
                    try {
                        if (fileFrom == null) continue;
                        fileFrom.close();
                    }
                    catch (IOException e) {
                        Server.logSevereMessage("Erro no fechamento do inputStream do arquivo " + stdOutputFile.getPath(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na recupera\u00c3\u00a7\u00c3\u00a3o do outputsream do arquivo de sa\u00c3\u00adda " + cpf.getStringPath(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTo != null) {
                try {
                    fileTo.close();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro no fechamento do outputsream do arquivo de sa\u00c3\u00adda " + cpf.getStringPath(), e);
                }
            }
        }
        return true;
    }

    private FinalizationType getFinalizationType(CommandFinalizationType type, FailureFinalizationType cause) {
        switch (type) {
            case END: {
                return FinalizationType.EXIT_CODE_IGNORED;
            }
            case SUCCESS: {
                return FinalizationType.EXIT_CODE_SUCCESS;
            }
            case EXECUTION_ERROR: {
                return FinalizationType.EXIT_CODE_ERROR;
            }
            case NO_EXIT_CODE: {
                return FinalizationType.EXIT_CODE_FAILED;
            }
            case FAILED: {
                switch (cause) {
                    case UNKNOWN: {
                        return FinalizationType.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return FinalizationType.COMMAND_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return FinalizationType.SGA_EXECUTION_ERROR;
                    }
                    case CSFS_SERVICE_UNAVAILABLE: {
                        return FinalizationType.CSFS_SERVICE_UNAVAILABLE;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return FinalizationType.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: {
                        return FinalizationType.NO_SGA_AVAILABLE_TO_ROOT_COMMAND;
                    }
                    case SGA_IS_NOT_AVAILABLE: {
                        return FinalizationType.SGA_IS_NOT_AVAILABLE;
                    }
                    case PROJECT_NOT_FOUND: {
                        return FinalizationType.PROJECT_NOT_FOUND;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return FinalizationType.USER_WITHOUT_PERMISSION_FOR_EXECUTION;
                    }
                }
            }
            case KILLED: {
                return FinalizationType.KILLED;
            }
            case LOST: {
                return FinalizationType.LOST;
            }
        }
        return FinalizationType.UNDEFINED;
    }
}

