/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.FileParameterValue;
import csbase.server.Server;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.BalancedCommandDistribution;
import csbase.server.services.schedulerservice.SGASetIOComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.sgafilters.SGAFilterByCommandRequirements;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;

public class IOCapacityPolicy
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        BalancedCommandDistribution bdc = new BalancedCommandDistribution(servers);
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        for (CommandInfo cmd : commands) {
            List<SGASet> sgas;
            List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(cmd, servers);
            if (filteresSGAs == null || (sgas = this.getSortedSGASetByIOCapacity(cmd, filteresSGAs)) == null || sgas.size() == 0) continue;
            SGASet choosedServer = bdc.chooseLightest(sgas);
            allocation.put(cmd, choosedServer);
        }
        return allocation;
    }

    private List<SGASet> getSortedSGASetByIOCapacity(CommandInfo command, List<SGASet> servers) {
        AlgorithmConfigurator algorithmConfigurator;
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        try {
            algorithmConfigurator = command.getConfigurator();
        }
        catch (RemoteException e) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel obter o configurador do comando " + command.getId(), e);
            return null;
        }
        long inputFilesLength = this.getInputFilesLength(algorithmConfigurator, command.getId());
        Hashtable<String, Long> platfBinFilesLengthList = this.getExecFilesLength(algorithmConfigurator, servers);
        Collections.sort(sgasSets, new SGASetIOComparator(inputFilesLength, platfBinFilesLengthList));
        return sgasSets;
    }

    private long getInputFilesLength(AlgorithmConfigurator algorithmConfigurator, String commandId) {
        Set inputFiles = algorithmConfigurator.getInputFiles();
        Iterator inputFileIterator = inputFiles.iterator();
        long filesLength = 0L;
        ProjectService projectService = ProjectService.getInstance();
        for (int i = 0; i < inputFiles.size(); ++i) {
            String[] path = FileUtils.splitPath((String)((FileParameterValue)inputFileIterator.next()).getPath());
            if (!projectService.existsFile(commandId, path)) continue;
            filesLength += projectService.fileSize(commandId, path);
        }
        return filesLength /= 1024L;
    }

    private Hashtable<String, Long> getExecFilesLength(AlgorithmConfigurator algoConfigurator, List<SGASet> servers) {
        Hashtable<String, Long> platformsList = new Hashtable<String, Long>();
        AlgorithmVersionInfo algoVersionInfo = algoConfigurator.getAlgorithmVersion();
        for (int i = 0; i < servers.size(); ++i) {
            SGASet sgaSet = servers.get(i);
            if (sgaSet == null || platformsList.containsKey(sgaSet.getPlatformId())) continue;
            long filesLength = 0L;
            String binDirPath = algoVersionInfo.getDirPath() + File.separator + algoVersionInfo.getBinDirName() + File.separator + sgaSet.getPlatformId();
            File binDir = new File(binDirPath);
            File[] binFiles = binDir.listFiles();
            for (int j = 0; j < binFiles.length; ++j) {
                filesLength += binFiles[j].length();
            }
            platformsList.put(sgaSet.getPlatformId(), new Long(filesLength /= 1024L));
        }
        return platformsList;
    }
}

