/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import csbase.remote.ClientRemoteLocator;
import csbase.remote.HttpServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.servlet.AbstractServlet;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadServlet
extends AbstractServlet {
    private static final String CSV_CONTENT_TYPE = "application/zip";
    private static final String TEXT_CONTENT_TYPE = "text/plain";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.setProperty("java.awt.headless", "true");
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.messageError(response, "Arquivo de propriedades System.properties n\u00e3o foi encontrado.", null);
            return;
        }
        try {
            HttpServiceInterface httpService;
            String reqParameters = request.getPathInfo();
            String[] params = reqParameters.split("/", 3);
            if (params == null) {
                return;
            }
            String accessCode = params[1];
            String filePath = null;
            try {
                String[] path = params[2].split("/");
                if (path != null && path.length >= 3) {
                    String pathDecoded = "";
                    filePath = "";
                    int i = 1;
                    while (i < path.length - 1) {
                        pathDecoded = URLDecoder.decode(path[i], "UTF-8");
                        filePath = String.valueOf(filePath) + pathDecoded + "/";
                        ++i;
                    }
                    pathDecoded = URLDecoder.decode(path[path.length - 1], "UTF-8");
                    filePath = String.valueOf(filePath) + pathDecoded;
                }
            }
            catch (Exception e) {
                filePath = null;
            }
            if ((httpService = (ClientRemoteLocator.httpService = (ClientRemoteLocator.server = (ServerEntryPoint)Naming.lookup(String.valueOf(this.getRMIpath()) + "Server")).fetchHttpService())) == null) {
                this.messageError(response, "Problema na comunicacao com o servidor", null);
                return;
            }
            String absolutePath = httpService.getFilePath(accessCode, filePath);
            if (absolutePath == null) {
                this.messageError(response, "Acesso Negado", null);
                return;
            }
            switch (httpService.getDownloadType(accessCode)) {
                case 2: {
                    this.sendFile(httpService.getFileType(accessCode, filePath), response, new URL(absolutePath).openStream());
                    break;
                }
                case 1: {
                    this.sendFile(httpService.getFileType(accessCode, filePath), response, new FileInputStream(absolutePath));
                    break;
                }
                case 3: {
                    response.setContentType(TEXT_CONTENT_TYPE);
                    PrintWriter pwtxt = response.getWriter();
                    pwtxt.println(httpService.getText(accessCode));
                    break;
                }
                case 5: {
                    response.setContentType(CSV_CONTENT_TYPE);
                    PrintWriter pwcsv = response.getWriter();
                    pwcsv.println(httpService.getText(accessCode));
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
        catch (ConnectException e) {
            this.messageError(response, "Conex\u00e3o recusada pelo servidor RMI", e);
        }
        catch (FileNotFoundException e) {
            this.messageError(response, "Erro na leitura do arquivo", e);
        }
        catch (NotBoundException e) {
            this.messageError(response, "Problema na comunicacao com o servidor", e);
        }
        catch (Exception e) {
            this.messageError(response, "Ocorreu uma exce\u00e7\u00e3o.", e);
        }
    }

    private void messageError(HttpServletResponse response, String message, Exception ex) {
        try {
            String localMessage = message;
            if (ex != null) {
                localMessage = String.valueOf(localMessage) + ": " + ex.getLocalizedMessage();
            }
            response.sendError(500, localMessage);
            if (ex != null) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendFile(String mimeType, HttpServletResponse response, InputStream fin) throws IOException {
        int i;
        String mType = mimeType;
        if (mType == null) {
            mType = "application/octet-stream";
        }
        response.setContentType(mType);
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream in = new BufferedInputStream(fin);
        byte[] b = new byte[1024];
        while ((i = ((InputStream)in).read(b)) != -1) {
            out.write(b, 0, i);
        }
        fin.close();
        out.flush();
        out.close();
    }
}

