/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import csbase.servlet.AbstractServlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InitServlet
extends AbstractServlet {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file;charset=iso-8859-1";
    private static final String HTML_MIME_TYPE = "text/html;charset=iso-8859-1";
    private static final String PARAM_PAGE = "page";
    private static final String DEFAULT_PAGE = "index.jnlp";
    private static final String PARAM_SERVER_HOST_NAME = "server_host_name";
    private static final String PARAM_SERVER_PORT_RMI = "server_port_rmi";
    private static final String PARAM_CLIENT_PORT_RMI = "client_port_rmi";
    private static final String PARAM_SERVER_HOST_ADDR = "server_host_addr";
    private static final String PARAM_SERVER_PORT_HTTP = "server_port_http";
    private static final String PARAM_CLIENT_ADDR = "client_addr";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.showErrorPage(response, "Arquivo de propriedades System.properties n\u00e3o foi encontrado.");
            return;
        }
        PrintWriter out = response.getWriter();
        try {
            Map<String, String> processedParams = this.processParams(request);
            String baseFile = this.readBaseFile(request);
            Set<String> requiredParams = this.collectRequiredParams(baseFile);
            Set<String> missingParams = this.checkMissingParams(requiredParams, processedParams);
            if (!missingParams.isEmpty()) {
                this.showErrorPage(response, this.getErrorPage(missingParams));
                return;
            }
            try {
                String translatedFile = this.translateFile(baseFile, request, requiredParams, processedParams);
                response.setContentType(JNLP_MIME_TYPE);
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "private, no-store, no-cache, must-revalidate");
                out.println(translatedFile);
                out.println("<!-- " + Calendar.getInstance().getTime().toString() + " -->");
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                this.showErrorPage(response, this.getErrorPage(ex));
                throw new ServletException((Throwable)ex);
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private Set<String> checkMissingParams(Set<String> requiredParams, Map<String, String> processedParams) {
        HashSet<String> missingParams = new HashSet<String>(requiredParams);
        missingParams.removeAll(processedParams.keySet());
        for (Map.Entry<String, String> entry : processedParams.entrySet()) {
            String paramValue = entry.getValue();
            if (paramValue != null && !paramValue.isEmpty()) continue;
            missingParams.add(entry.getKey());
        }
        return missingParams;
    }

    private Map<String, String> processParams(HttpServletRequest request) {
        Hashtable<String, String> processedParams = new Hashtable<String, String>();
        String serverPortHttp = Integer.toString(request.getServerPort());
        String clientAddress = request.getRemoteAddr();
        processedParams.put(PARAM_SERVER_PORT_HTTP, serverPortHttp);
        processedParams.put(PARAM_CLIENT_ADDR, clientAddress);
        processedParams.put(PARAM_SERVER_HOST_ADDR, this.getServerAddress());
        processedParams.put(PARAM_SERVER_HOST_NAME, this.getServerName());
        processedParams.put(PARAM_SERVER_PORT_RMI, this.getServerRMIport());
        processedParams.put(PARAM_CLIENT_PORT_RMI, this.getClientRMIport());
        return processedParams;
    }

    private String processParam(String key, HttpServletRequest request, String defaultValue) {
        String value;
        if (request != null) {
            value = request.getParameter(key);
            if (value == null || value.isEmpty()) {
                value = defaultValue;
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    private String translateFile(String baseFile, HttpServletRequest request, Set<String> requiredParams, Map<String, String> processedParams) {
        String translatedFile = baseFile;
        for (String param : requiredParams) {
            translatedFile = this.replaceParam(param, translatedFile, processedParams);
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(PARAM_PAGE) || processedParams.containsKey(key)) continue;
            String value = request.getParameter(key);
            translatedFile = this.appendParam(key, value, translatedFile);
        }
        return translatedFile;
    }

    private void showErrorPage(HttpServletResponse response, String htmlContent) {
        try {
            PrintWriter writer = response.getWriter();
            response.setContentType(HTML_MIME_TYPE);
            writer.println(htmlContent);
        }
        catch (IOException e) {
            System.err.println("Erro exibindo p\u00e1gina de erro do InitServlet");
            e.printStackTrace();
        }
    }

    private String getErrorPage(Exception ex) {
        StringBuilder output = this.startErrorMessage();
        output.append("<p>").append(ex.toString()).append("</p>\n");
        StackTraceElement[] stackLines = ex.getStackTrace();
        int i = 0;
        while (i < stackLines.length) {
            output.append("&nbsp;&nbsp;&nbsp;").append(stackLines[i]).append("<br/>\n");
            ++i;
        }
        this.finishErrorMessage(output);
        return output.toString();
    }

    private String getErrorPage(Set<String> errors) {
        StringBuilder output = this.startErrorMessage();
        output.append("Par\u00e2metros obrigat\u00f3rios n\u00e3o foram definidos via URL nem no arquivo ");
        output.append("System.properties");
        output.append('\n');
        output.append("<ul>\n");
        for (String error : errors) {
            output.append("<li> ");
            String name = this.paramMatchesProperty(error);
            if (name != null) {
                output.append(name);
            } else {
                output.append(error);
            }
            output.append('\n');
        }
        output.append("</ul>\n");
        this.finishErrorMessage(output);
        return output.toString();
    }

    private String paramMatchesProperty(String param) {
        if (param.equalsIgnoreCase(PARAM_SERVER_HOST_ADDR)) {
            return "Server.hostAddr";
        }
        if (param.equalsIgnoreCase(PARAM_SERVER_HOST_NAME)) {
            return "Server.hostName";
        }
        if (param.equalsIgnoreCase(PARAM_SERVER_PORT_RMI)) {
            return "Server.registryPort";
        }
        if (param.equalsIgnoreCase(PARAM_CLIENT_PORT_RMI)) {
            return "Client.port.rmi";
        }
        return null;
    }

    private StringBuilder startErrorMessage() {
        StringBuilder msg = new StringBuilder("<html>\n");
        msg.append("<head><title>Erro</title></head>\n");
        msg.append("<body>\n");
        msg.append("<h2>Erro</h2>\n");
        msg.append("Por favor, entre em contato com o suporte do sistema e forne\u00e7a a seguinte mensagem: <hr/>\n");
        msg.append(Calendar.getInstance().getTime().toString());
        msg.append("<br><br>\n");
        return msg;
    }

    private void finishErrorMessage(StringBuilder msg) {
        msg.append("<hr/></body>\n");
        msg.append("</html>");
    }

    String getBaseFileUrl(HttpServletRequest request) {
        String serverPort = Integer.toString(request.getServerPort());
        String fileURL = "http://" + request.getServerName() + ':' + serverPort + request.getRequestURI();
        String fileName = this.processParam(PARAM_PAGE, request, DEFAULT_PAGE);
        int lastSlashPos = fileURL.lastIndexOf(47);
        return String.valueOf(fileURL.substring(0, lastSlashPos + 1)) + fileName;
    }

    private String readBaseFile(HttpServletRequest request) throws IOException {
        URL url = new URL(this.getBaseFileUrl(request));
        BufferedReader br = null;
        StringBuilder buffer = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append(line).append('\n');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        String fileContent = buffer.toString();
        return fileContent;
    }

    private Set<String> collectRequiredParams(String fileContent) {
        HashSet<String> requiredParams = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\$(\\w+)\\$");
        Matcher matcher = pattern.matcher(fileContent);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (paramName == null || paramName.isEmpty()) continue;
            requiredParams.add(paramName);
        }
        return requiredParams;
    }

    private String replaceParam(String key, String text, Map<String, String> processedParams) {
        String value = null;
        value = processedParams.get(key);
        if (value == null || value.isEmpty()) {
            throw new IllegalStateException("par\u00e2metro " + key + " n\u00e3o encontrado");
        }
        String customFile = text.replaceAll("\\$" + key + "\\$", value);
        return customFile;
    }

    String appendParam(String key, String value, String text) {
        int appendPos = text.toLowerCase().indexOf("</application-desc>");
        if (appendPos == -1) {
            throw new IllegalArgumentException("text n\u00e3o possui </application-desc>");
        }
        String appendText = "  <argument>--" + key + ' ' + value + "</argument>\n  ";
        StringBuilder buffer = new StringBuilder(text.substring(0, appendPos));
        buffer.append(appendText);
        buffer.append(text.substring(appendPos, text.length()));
        return buffer.toString();
    }
}

